# Convert a joe-kuo file to a c header file

import sys

# Read
if len(sys.argv)<2:
	raise IndexError, "Need file name."
	
f=file(sys.argv[1], 'r')
first=True
dl=[]
sl=[]
al=[]
ml=[]
i0l=[]
while True:
	# Read line
	line=f.readline()
	if len(line)==0:
		break
	
	# Skip first line (column names)
	if first:
		first=False
		continue
	
	# Split into parts
	d=int(line[0:8])
	s=int(line[8:16])
	a=int(line[16:24])
	
	tmp=line[24:]
	m=[]
	for ii in range(s):
		before, dummy, after = tmp.partition(" ")
		m.append(int(before))
		tmp=after
	
	# Build output
	dl.append(d)
	sl.append(s)
	al.append(a)
	i0l.append(len(ml))
	ml.extend(m)
f.close()

# Write
fo=file("data.h", 'w')

fo.write("/* dimension */\n")

fo.write("/* s - with dummy entry for dim=1 */\n")
fo.write("unsigned int stab[] = { 0, \n")
for ii in range(len(sl)):
	fo.write(f"{sl[ii]}")
	if ii<len(sl)-1:
		fo.write(",")
	fo.write(" ")
	if ii%10==9:
		fo.write("\n")
	first
fo.write("};\n\n");

fo.write("/* a - with dummy entry for dim=1 */\n")
fo.write("unsigned int atab[] = { 0, \n")
for ii in range(len(al)):
	fo.write(f"{al[ii]}")
	if ii<len(al)-1:
		fo.write(",")
	fo.write(" ")
	if ii%10==9:
		fo.write("\n")
	first
fo.write("};\n\n");

fo.write("/* i0 - with dummy entry for dim=1 */\n")
fo.write("unsigned int i0tab[] = { 0, \n")
for ii in range(len(i0l)):
	fo.write(f"{i0l[ii]}")
	if ii<len(i0l)-1:
		fo.write(",")
	fo.write(" ")
	if ii%10==9:
		fo.write("\n")
	first
fo.write("};\n\n");

fo.write("/* m */\n")
fo.write("unsigned int mtab[] = { \n")
for ii in range(len(ml)):
	fo.write(f"{ml[ii]}")
	if ii<len(ml)-1:
		fo.write(",")
	fo.write(" ")
	if ii%10==9:
		fo.write("\n")
	first
fo.write("};\n\n");

fo.close()

