* SUBROUTINE EILD22             ALL SYSTEMS                 99/12/01
C PORTABILITY : ALL SYSTEMS
C 94/12/01 LU : ORIGINAL VERSION
*
* PURPOSE :
*  INITIATION OF VARIABLES FOR NONLINEAR MINIMAX APPROXIMATION.
*  LINEARLY CONSTRAINED DENSE VERSION.
*
* PARAMETERS :
*  IO  N  NUMBER OF VARIABLES.
*  IO  NA  NUMBER OF PARTIAL FUNCTIONS.
*  IO  NB  NUMBER OF BOX CONSTRAINTS.
*  IO  NC  NUMBER OF GENERAL LINEAR CONSTRAINTS.
*  RO  X(N)  VECTOR OF VARIABLES.
*  IO  IX(NF)  VECTOR CONTAINING TYPES OF BOUNDS.
*  RO  XL(NF)  VECTOR CONTAINING LOWER BOUNDS FOR VARIABLES.
*  RO  XU(NF)  VECTOR CONTAINING UPPER BOUNDS FOR VARIABLES.
*  IO  IC(NC)  VECTOR CONTAINING TYPES OF CONSTRAINTS.
*  RO  CL(NC)  VECTOR CONTAINING LOWER BOUNDS FOR CONSTRAINT FUNCTIONS.
*  RO  CU(NC)  VECTOR CONTAINING UPPER BOUNDS FOR CONSTRAINT FUNCTIONS.
*  RO  CG(NF*NC) MATRIX WHOSE COLUMNS ARE NORMALS OF THE LINEAR
*         CONSTRAINTS.
*  RO  FMIN  LOWER BOUND FOR VALUE OF THE OBJECTIVE FUNCTION.
*  RO  XMAX  MAXIMUM STEPSIZE.
*  IO  NEXT  NUMBER OF THE TEST PROBLEM.
*  IO  IEXT  TYPE OF OBJECTIVE FUNCTION. IEXT<0-MAXIMUM OF VALUES.
*         IEXT=0-MAXIMUM OF ABSOLUTE VALUES.
*  IO  IERR  ERROR INDICATOR.
*
      SUBROUTINE EILD22(N,NA,NB,NC,X,IX,XL,XU,IC,CL,CU,CG,FMIN,XMAX,
     & NEXT,IEXT,IERR)
      INTEGER N,NA,NC,IX(N),IC(NC),NEXT,IEXT,IERR
      REAL*8 X(N),XL(N),XU(N),CL(NC),CU(NC),CG(N*NC),FMIN,XMAX
      INTEGER I,J,K,L
      REAL*8 A
      REAL*8 Y(163),PI
      COMMON /EMPR22/ Y
      PARAMETER (PI=3.14159265358979323846D 0)
      FMIN=-1.0D 60
      XMAX= 1.0D 3
      IEXT=-1
      IERR= 0
      NB=0
      GOTO (10,20,30,40,80,50,100,190,200,60,70,90,130,150,170),NEXT
   10 IF (N.GE.2.AND.NA.GE.3) THEN
      N=2
      NA=3
      NC=1
      X(1)=1.0D 0
      X(2)=2.0D 0
      IC(1)=1
      CL(1)=0.5D 0
      CG(1)=1.0D 0
      CG(2)=1.0D 0
      ELSE
      IERR=1
      ENDIF
      RETURN
   20 IF (N.GE.2.AND.NA.GE.3) THEN
      N=2
      NA=3
      NC=1
      X(1)=-2.0D 0
      X(2)=-1.0D 0
      IC(1)=2
      CU(1)=-2.5D 0
      CG(1)= 3.0D 0
      CG(2)= 1.0D 0
      ELSE
      IERR=1
      ENDIF
      RETURN
   30 IF (N.GE.2.AND.NA.GE.3) THEN
      N=2
      NA=3
      NB=N
      NC=1
      X(1)=-1.0D 0
      X(2)= 1.0D-2
      IX(1)=0
      IX(2)=1
      XL(2)=1.0D-2
      IC(1)=1
      CL(1)=-5.0D-1
      CG(1)= 5.0D-2
      CG(2)=-1.0D 0
      ELSE
      IERR=1
      ENDIF
      RETURN
   40 IF (N.GE.2.AND.NA.GE.3) THEN
      N=2
      NA=3
      NB=N
      NC=1
      X(1)=-1.0D 0
      X(2)= 3.0D 0
      IX(1)=0
      IX(2)=1
      XL(2)=1.0D-2
      IC(1)=1
      CL(1)= 1.0D 0
      CG(1)=-9.0D-1
      CG(2)= 1.0D 0
      ELSE
      IERR=1
      ENDIF
      RETURN
   80 IF (N.GE.6.AND.NA.GE.3) THEN
      N=6
      NA=3
      X(1)=-1.0D 0
      X(2)= 0.0D 0
      X(3)= 0.0D 0
      X(4)=-1.0D 0
      X(5)= 1.0D 0
      X(6)= 1.0D 0
      NC=5*NA
      DO 82 I=1,NC
      CU(I)=1.0D 0
      IC(I)=2
   82 CONTINUE
      DO 83 I=1,N*NC
      CG(I)=0.0D 0
   83 CONTINUE
      K=1
      DO 85 I=1,NA
      L=2*(I-1)
      DO 84 J=1,5
      CG(K+L)=SIN(2.0D 0*PI*DBLE(J-1)/5.0D 0)
      CG(K+L+1)=COS(2.0D 0*PI*DBLE(J-1)/5.0D 0)
      K=K+N
   84 CONTINUE
   85 CONTINUE
      ELSE
      IERR=1
      ENDIF
      RETURN
   50 IF (N.GE.7.AND.NA.GE.163) THEN
      N=7
      NA=163
      NB=N
      DO 51 I=1,N
      X(I)=DBLE(I)*0.5D 0
      IX(I)=0
   51 CONTINUE
      XL(1)=0.4D 0
	  IX(1)=1
      IX(7)=5
      DO 52 I=1,NA
      Y(I)=2.0D 0*PI*SIN(PI*(8.5D 0+DBLE(I)*0.5D 0)/180.0D 0)
   52 CONTINUE
      NC=7
      DO 53 I=1,6
      CL(I)=0.4D 0
      IC(I)=1
   53 CONTINUE
      CL(7)=1.0D 0
      CU(7)=1.0D 0
      IC(7)=5
      DO 54 I=1,N*NC
      CG(I)=0.0D 0
   54 CONTINUE
      K=0
      DO 55 I=1,6
      CG(K+I)= -1.0D 0
      CG(K+I+1)=1.0D 0
      K=K+N
   55 CONTINUE
      CG(46)=-1.0D 0
      CG(48)= 1.0D 0
      IEXT=0
      FMIN=0.0D 0
      ELSE
      IERR=1
      ENDIF
      RETURN
  100 IF (N.GE.8.AND.NA.GE.8) THEN
      N=8
      NA=8
      NB=N
      DO 101 I=1,N
      X(I)=0.125D 0
      XL(I)= 1.0D-8
      IX(I)=1
  101 CONTINUE
      DO 102 I=1,40
      Y(I)=1.0D 0
      Y(I+40)=0.1D 0
  102 CONTINUE
      Y(9)= 2.0D 0
      Y(10)=0.8D 0
      Y(12)=0.5D 0
      Y(18)=1.2D 0
      Y(19)=0.8D 0
      Y(20)=1.2D 0
      Y(21)=1.6D 0
      Y(22)=2.0D 0
      Y(23)=0.6D 0
      Y(24)=0.1D 0
      Y(25)=2.0D 0
      Y(26)=0.1D 0
      Y(27)=0.6D 0
      Y(28)=2.0D 0
      Y(32)=2.0D 0
      Y(33)=1.2D 0
      Y(34)=1.2D 0
      Y(35)=0.8D 0
      Y(37)=1.2D 0
      Y(38)=0.1D 0
      Y(39)=3.0D 0
      Y(40)=4.0D 0
      Y(41)=3.0D 0
      Y(42)=1.0D 0
      Y(45)=5.0D 0
      Y(48)=6.0D 0
      Y(50)=1.0D 1
      Y(53)=5.0D 0
      Y(58)=9.0D 0
      Y(59)=1.0D 1
      Y(61)=4.0D 0
      Y(63)=7.0D 0
      Y(68)=1.0D 1
      Y(70)=3.0D 0
      Y(80)=1.1D 1
      Y(81)=0.5D 0
      Y(82)=1.2D 0
      Y(83)=0.8D 0
      Y(84)=2.0D 0
      Y(85)=1.5D 0
      NC=1
      CL(1)=1.0D 0
      CU(1)=1.0D 0
      IC(1)=5
      DO 103 I=1,N
      CG(I)=1.0D 0
  103 CONTINUE
      ELSE
      IERR=1
      ENDIF
      RETURN
  190 IF (N.GE.10.AND.NA.GE.6) THEN
      N=10
      NA=6
      X(1)= 2.0D 0
      X(2)= 3.0D 0
      X(3)= 5.0D 0
      X(4)= 5.0D 0
      X(5)= 1.0D 0
      X(6)= 2.0D 0
      X(7)= 7.0D 0
      X(8)= 3.0D 0
      X(9)= 6.0D 0
      X(10)=1.0D 1
      NC=3
      CU(1)=1.05D 2
      CU(2)=0.00D 0
      CU(3)=1.20D 1
      IC(1)=2
      IC(2)=2
      IC(3)=2
      DO 191 I=1,N*NC
      CG(I)=0.0D 0
  191 CONTINUE
      CG(1)=  4.0D 0
      CG(2)=  5.0D 0
      CG(7)= -3.0D 0
      CG(8)=  9.0D 0
      CG(11)= 1.0D 1
      CG(12)=-8.0D 0
      CG(17)=-1.7D 1
      CG(18)= 2.0D 0
      CG(21)=-8.0D 0
      CG(22)= 2.0D 0
      CG(29)= 5.0D 0
      CG(30)=-2.0D 0
      ELSE
      IERR=1
      ENDIF
      RETURN
  200 IF (N.GE.20.AND.NA.GE.14) THEN
      N=20
      NA=14
      X(1)= 2.0D 0
      X(2)= 3.0D 0
      X(3)= 5.0D 0
      X(4)= 5.0D 0
      X(5)= 1.0D 0
      X(6)= 2.0D 0
      X(7)= 7.0D 0
      X(8)= 3.0D 0
      X(9)= 6.0D 0
      X(10)=1.0D 1
      X(11)=2.0D 0
      X(12)=2.0D 0
      X(13)=6.0D 0
      X(14)=1.5D 1
      X(15)=1.0D 0
      X(16)=2.0D 0
      X(17)=1.0D 0
      X(18)=2.0D 0
      X(19)=1.0D 0
      X(20)=3.0D 0
      NC=4
      CU(1)=1.05D 2
      CU(2)=0.00D 0
      CU(3)=1.20D 1
      CU(4)=0.00D 0
      IC(1)=2
      IC(2)=2
      IC(3)=2
      IC(4)=2
      DO 201 I=1,N*NC
      CG(I)=0.0D 0
  201 CONTINUE
      CG(1)=  4.0D 0
      CG(2)=  5.0D 0
      CG(7)= -3.0D 0
      CG(8)=  9.0D 0
      CG(21)= 1.0D 1
      CG(22)=-8.0D 0
      CG(27)=-1.7D 1
      CG(28)= 2.0D 0
      CG(41)=-8.0D 0
      CG(42)= 2.0D 0
      CG(49)= 5.0D 0
      CG(50)=-2.0D 0
      CG(61)= 1.0D 0
      CG(62)= 1.0D 0
      CG(71)= 4.0D 0
      CG(72)=-2.1D 1
      ELSE
      IERR=1
      ENDIF
      RETURN
   60 IF (N.GE.20.AND.NA.GE.38) THEN
      N=20
      NA=38
      NB=N
      DO 61 I=1,N
      X(I)=1.0D 2
      IX(I)=0
      IF (I.LE.10) IX(I)=1
      XL(I)=0.5D 0
   61 CONTINUE
      NC=0
      IEXT=0
      FMIN=0.0D 0
      ELSE
      IERR=1
      ENDIF
      RETURN
   70 IF (N.GE.9.AND.NA.GE.124) THEN
      N=9
      NA=124
      NB=N
      K=(N-1)/2
C      X(1)=1.8D-2
C      X(2)=1.9D-2
C      X(3)=2.0D-2
C      X(4)=2.1D-2
C      X(5)=0.8D 0
C      X(6)=0.9D 0
C      X(7)=1.0D 0
C      X(8)=1.1D 0
C      X(9)=-1.4D 1
      X(1)= 0.398D-1
      X(2)= 0.968D-4
      X(3)= 0.103D-3
      X(4)= 0.389D-1
      X(5)= 0.101D 1
      X(6)= 0.968D 0
      X(7)= 0.103D 1
      X(8)= 0.988D 0
      X(9)=-0.116D 2
      DO 71 I=1,N-1
      XL(I)=0.0D 0
      IX(I)=1
   71 CONTINUE
      IX(N)=0
      L=(NA-2)/2
      A=(1.012577D 0-0.987423D 0)/DBLE(L-1)
      Y(1)=0.967320D 0
      DO 72 I=2,L+1
      Y(I)=0.987423D 0+DBLE(I-2)*A
      Y(I+L)=Y(I)
   72 CONTINUE
      Y(NA)=1.032680D 0
      NC=K
      DO 73 I=1,N*NC
      CG(I)=0.0D 0
   73 CONTINUE
      L=0
      DO 74 I=1,NC
      CG(L+I)=1.0D 4
      CG(L+I+K)=-1.0D 0
      CL(I)=0.0D 0
      IC(I)=1
      L=L+N
   74 CONTINUE
      IEXT=0
      FMIN=0.0D 0
      ELSE
      IERR=1
      ENDIF
      RETURN
   90 IF (N.GE.10.AND.NA.GE.9) THEN
      N=10
      NA=9
      NB=N
      X(1)=1745.0D 0
      X(2)=1200.0D 1
      X(3)=1100.0D-1
      X(4)=3048.0D 0
      X(5)=1974.0D 0
      X(6)=8920.0D-2
      X(7)=9280.0D-2
      X(8)=8000.0D-3
      X(9)=3600.0D-3
      X(10)=145.0D 0
      XL(1)= 1.0D-5
      XL(2)= 1.0D-5
      XL(3)= 1.0D-5
      XL(4)= 1.0D-5
      XL(5)= 1.0D-5
      XL(6)= 8.5D 1
      XL(7)= 9.0D 1
      XL(8)= 3.0D 0
      XL(9)= 1.2D 0
      XL(10)=1.4D 2
      XU(1)= 2.0D 3
      XU(2)= 1.6D 4
      XU(3)= 1.2D 2
      XU(4)= 5.0D 3
      XU(5)= 2.0D 3
      XU(6)= 9.3D 1
      XU(7)= 9.5D 1
      XU(8)= 1.2D 1
      XU(9)= 4.0D 0
      XU(10)=1.6D 2
      DO 91 I=1,N
      IX(I)=3
   91 CONTINUE
      NC=5
      CU(1)=35.82D 0
      CL(2)=35.82D 0
      CL(3)=133.0D 0
      CU(4)=133.0D 0
      CL(5)=0.0D 0
      CU(5)=0.0D 0
      IC(1)=2
      IC(2)=1
      IC(3)=1
      IC(4)=2
      IC(5)=5
      DO 92 I=1,N*NC
      CG(I)=0.0D 0
   92 CONTINUE
      CG(9)=  0.90D 0
      CG(10)= 2.22D-1
      CG(19)= 1.00D 0/0.90D 0
      CG(20)= 2.22D-1
      CG(27)= 3.00D 0
      CG(30)=-0.99D 0
      CG(37)= 3.00D 0
      CG(40)=-1.00D 0/0.99D 0
      CG(41)=-1.00D 0
      CG(44)= 1.22D 0
      CG(45)=-1.00D 0
      ELSE
      IERR=1
      ENDIF
      RETURN
  130 IF (N.GE.7.AND.NA.GE.15) THEN
      N=7
      NA=13
      NB=N
      X(1)=17.45D 2
      X(2)= 1.10D 2
      X(3)=30.48D 2
      X(4)= 8.90D 1
      X(5)= 9.20D 1
      X(6)= 8.00D 0
      X(7)=14.50D 1
      XL(1)=1.00D 0
      XL(2)=1.00D 0
      XL(3)=1.00D 0
      XL(4)=8.50D 1
      XL(5)=9.00D 1
      XL(6)=3.00D 0
      XL(7)=1.45D 2
      XU(1)=2.00D 3
      XU(2)=1.20D 2
      XU(3)=5.00D 3
      XU(4)=9.30D 1
      XU(5)=9.50D 1
      XU(6)=1.20D 1
      XU(7)=1.62D 2
      DO 131 I=1,N
      IX(I)=3
  131 CONTINUE
      Y(1)=  1.71500000D 0
      Y(2)=  0.03500000D 0
      Y(3)=  4.05650000D 0
      Y(4)=  10.0000000D 0
      Y(5)=  3000.00000D 0
      Y(6)= -0.06300000D 0
      Y(7)=  0.59553571D-2
      Y(8)=  0.88392857D 0
      Y(9)= -0.11756250D 0
      Y(10)= 1.10880000D 0
      Y(11)= 0.13035330D 0
      Y(12)=-0.00660330D 0
      Y(13)= 0.66173269D-3
      Y(14)= 0.17239878D-1
      Y(15)=-0.56595559D-2
      Y(16)=-0.19120592D-1
      Y(17)= 0.56850750D 2
      Y(18)= 1.08702000D 0
      Y(19)= 0.32175000D 0
      Y(20)=-0.03762000D 0
      Y(21)= 0.00619800D 0
      Y(22)= 0.24623121D 4
      Y(23)=-0.25125634D 2
      Y(24)= 0.16118996D 3
      Y(25)= 5000.00000D 0
      Y(26)=-0.48951000D 6
      Y(27)= 0.44333333D 2
      Y(28)= 0.33000000D 0
      Y(29)= 0.02255600D 0
      Y(30)=-0.00759500D 0
      Y(31)= 0.00061000D 0
      Y(32)=-0.00050000D 0
      Y(33)= 0.81967200D 0
      Y(34)= 0.81967200D 0
      Y(35)= 24500.0000D 0
      Y(36)=-250.000000D 0
      Y(37)= 0.10204082D-1
      Y(38)= 0.12244898D-4
      Y(39)= 0.00006250D 0
      Y(40)= 0.00006250D 0
      Y(41)=-0.00007625D 0
      Y(42)= 1.22000000D 0
      Y(43)= 1.00000000D 0
      Y(44)=-1.00000000D 0
      NC=2
      L=0
      DO 133 I=1,NC
      CU(I)=1.0D 0
      IC(I)=2
      DO 132 J=1,N
      CG(L+J)=0.0D 0
  132 CONTINUE
      L=L+N
  133 CONTINUE
      CG(5)= Y(29)
      CG(7)= Y(30)
      CG(8)= Y(32)
      CG(10)=Y(31)
      ELSE
      IERR=1
      ENDIF
      RETURN
  150 IF (N.GE.8.AND.NA.GE.7) THEN
      N=8
      NA=4
      NB=N
      X(1)=5.00D 3
      X(2)=5.00D 3
      X(3)=5.00D 3
      X(4)=2.00D 2
      X(5)=3.50D 2
      X(6)=1.50D 2
      X(7)=2.25D 2
      X(8)=4.25D 2
      DO 151 I=1,N
      XL(I)=1.0D 1
      XU(I)=1.0D 3
      IX(I)=3
  151 CONTINUE
      XL(1)=1.0D 2
      XL(2)=1.0D 3
      XL(3)=1.0D 3
      XU(1)=1.0D 4
      XU(2)=1.0D 4
      XU(3)=1.0D 4
      NC=3
      L=0
      DO 153 I=1,NC
      CU(I)=1.0D 0
      IC(I)=2
      DO 152 J=1,N
      CG(L+J)=0.0D 0
  152 CONTINUE
      L=L+N
  153 CONTINUE
      CG(4)=  2.5D-3
      CG(6)=  2.5D-3
      CG(12)=-2.5D-3
      CG(13)= 2.5D-3
      CG(15)= 2.5D-3
      CG(21)=-1.0D-2
      CG(24)= 1.0D-2
      ELSE
      IERR=1
      ENDIF
      RETURN
  170 IF (N.GE.16.AND.NA.GE.20) THEN
      N=16
      NA=19
      NB=N
      X(1)= 0.80D 0
      X(2)= 0.83D 0
      X(3)= 0.85D 0
      X(4)= 0.87D 0
      X(5)= 0.90D 0
      X(6)= 0.10D 0
      X(7)= 0.12D 0
      X(8)= 0.19D 0
      X(9)= 0.25D 0
      X(10)=0.29D 0
      X(11)=5.12D 2
      X(12)=1.31D 1
      X(13)=7.18D 1
      X(14)=6.40D 2
      X(15)=6.50D 2
      X(16)=5.70D 0
      XL(1)= 1.0D-1
      XL(2)= 1.0D-1
      XL(3)= 1.0D-1
      XL(4)= 1.0D-1
      XL(5)= 9.0D-1
      XL(6)= 1.0D-4
      XL(7)= 1.0D-1
      XL(8)= 1.0D-1
      XL(9)= 1.0D-1
      XL(10)=1.0D-1
      XL(11)=1.0D 0
      XL(12)=1.0D-6
      XL(13)=1.0D 0
      XL(14)=5.0D 2
      XL(15)=5.0D 2
      XL(16)=1.0D-6
      XU(1)= 9.0D-1
      XU(2)= 9.0D-1
      XU(3)= 9.0D-1
      XU(4)= 9.0D-1
      XU(5)= 1.0D 0
      XU(6)= 1.0D-1
      XU(7)= 9.0D-1
      XU(8)= 9.0D-1
      XU(9)= 9.0D-1
      XU(10)=9.0D-1
      XU(11)=1.0D 4
      XU(12)=5.0D 3
      XU(13)=5.0D 3
      XU(14)=1.0D 4
      XU(15)=1.0D 4
      XU(16)=5.0D 3
      DO 171 I=1,N
      IX(I)=3
  171 CONTINUE
      NC=1
      CU(1)=1.0D 0
      IC(1)=2
      DO 172 I=1,N
      CG(I)=0.0D 0
  172 CONTINUE
      CG(11)= 2.0D-3
      CG(12)=-2.0D-3
      ELSE
      IERR=1
      ENDIF
      RETURN
      END
* SUBROUTINE TAFU22             ALL SYSTEMS                 99/12/01
C PORTABILITY : ALL SYSTEMS
C 94/12/01 LU : ORIGINAL VERSION
*
* PURPOSE :
*  VALUES OF PARTIAL FUNCTIONS IN THE MINIMAX CRITERION.
*
* PARAMETERS :
*  II  N  NUMBER OF VARIABLES.
*  II  KA  INDEX OF THE PARTIAL FUNCTION.
*  RI  X(N)  VECTOR OF VARIABLES.
*  RO  FA  VALUE OF THE PARTIAL FUNCTION AT THE
*          SELECTED POINT.
*  II  NEXT  NUMBER OF THE TEST PROBLEM.
*
      SUBROUTINE TAFU22(N,KA,X,FA,NEXT)
      INTEGER N,KA,NEXT
      REAL*8 X(N),FA
      REAL*8 A,B,C,P,Q,R,S,T
      INTEGER I,J,K
      REAL*8 Y(163),PI
      COMMON /EMPR22/ Y
      PARAMETER (PI=3.14159265358979323846D 0)
      GOTO (10,10,30,30,80,50,100,190,200,60,70,90,130,150,170),NEXT
   10 GOTO (11,12,13),KA
   11 FA=X(1)**2+X(2)**2+X(1)*X(2)-1.0D 0
      RETURN
   12 FA= SIN(X(1))
      RETURN
   13 FA=-COS(X(2))
      RETURN
   30 GOTO (31,32,33),KA
   31 FA=-EXP(X(1)-X(2))
      RETURN
   32 FA= SINH(X(1)-1.0D 0)-1.0D 0
      RETURN
   33 FA=-LOG(X(2))-1.0D 0
      RETURN
   80 GO TO (81,82,83) KA
   81 FA=-SQRT((X(1)-X(3))**2+(X(2)-X(4))**2)
      RETURN
   82 FA=-SQRT((X(3)-X(5))**2+(X(4)-X(6))**2)
      RETURN
   83 FA=-SQRT((X(5)-X(1))**2+(X(6)-X(2))**2)
      RETURN
   50 A=0.0D 0
      DO 51 I=1,N
      A=A+COS(Y(KA)*X(I))
   51 CONTINUE
      FA=(1.0D 0+2.0D 0*A)/1.5D 1
      RETURN
  100 FA=0.0D 0
      K=0
      DO 102 I=1,5
      A=0.0D 0
      P=0.0D 0
      DO 101 J=1,N
      A=A+Y(K+J)*X(J)**(1.0D 0-Y(I+80))
      P=P+Y(K+J+40)*X(J)
  101 CONTINUE
      FA=FA+Y(K+KA)*P/(X(KA)**Y(I+80)*A)-Y(K+KA+40)
      K=K+N
  102 CONTINUE
      RETURN
  190 FA=X(1)**2+X(2)**2+X(1)*X(2)-1.4D 1*X(1)-1.6D 1*X(2)+
     &(X(3)-1.0D 1)**2+4.0D 0*(X(4)-5.0D 0)**2+(X(5)-3.0D 0)**2+
     &2.0D 0*(X(6)-1.0D 0)**2+5.0D 0*X(7)**2+7.0D 0*(X(8)-
     &1.1D 1)**2+2.0D 0*(X(9)-1.0D 1)**2+(X(10)-7.0D 0)**2+4.5D 1
      GO TO (191,192,193,194,195,196),KA
  191 CONTINUE
      RETURN
  192 FA=FA+1.0D 1*(3.0D 0*(X(1)-2.0D 0)**2+4.0D 0*(X(2)-
     &3.0D 0)**2+2.0D 0*X(3)**2-7.0D 0*X(4)-1.2D 2)
      RETURN
  193 FA=FA+1.0D 1*(5.0D 0*X(1)**2+8.0D 0*X(2)+(X(3)-6.0D 0)**2-
     &2.0D 0*X(4)-4.0D 1)
      RETURN
  194 FA=FA+1.0D 1*(0.5D 0*(X(1)-8.0D 0)**2+2.0D 0*(X(2)-
     &4.0D 0)**2+3.0D 0*X(5)**2-X(6)-3.0D 1)
      RETURN
  195 FA=FA+1.0D 1*(X(1)**2+2.0D 0*(X(2)-2.0D 0)**2-
     &2.0D 0*X(1)*X(2)+1.4D 1*X(5)-6.0D 0*X(6))
      RETURN
  196 FA=FA+1.0D 1*(6.0D 0*X(2)-3.0D 0*X(1)+1.2D 1*(X(9)-
     &8.0D 0)**2-7.0D 0*X(10))
      RETURN
  200 FA=X(1)**2+X(2)**2+X(1)*X(2)-1.4D 1*X(1)-1.6D 1*X(2)+(X(3)-
     &1.0D 1)**2+4.0D 0*(X(4)-5.0D 0)**2+(X(5)-3.0D 0)**2+2.0D 0*
     &(X(6)-1.0D 0)**2+5.0D 0*X(7)**2+7.0D 0*(X(8)-1.1D 1)**2+
     &2.0D 0*(X(9)-1.0D 1)**2+(X(10)-7.0D 0)**2+(X(11)-9.0D 0)**2+
     &1.0D 1*(X(12)-1.0D 0)**2+5.0D 0*(X(13)-7.0D 0)**2+4.0D 0*
     &(X(14)-1.4D 1)**2+2.7D 1*(X(15)-1.0D 0)**2+X(16)**4+(X(17)-
     &2.0D 0)**2+1.3D 1*(X(18)-2.0D 0)**2+(X(19)-3.D 0)**2+X(20)**2+
     &9.5D 1
      GO TO (191,192,193,194,195,196,202,203,204,205,206,207,208,209),KA
  202 FA=FA+1.0D 1*(X(1)**2+1.5D 1*X(11)-8.0D 0*X(12)-2.8D 1)
      RETURN
  203 FA=FA+1.0D 1*(4.0D 0*X(1)+9.0D 0*X(2)+5.0D 0*X(13)**2-9.0D 0*
     &X(14)-8.7D 1)
      RETURN
  204 FA=FA+1.0D 1*(3.0D 0*X(1)+4.0D 0*X(2)+3.0D 0*(X(13)-
     16.0D 0)**2-1.4D 1*X(14)-1.0D 1)
      RETURN
  205 FA=FA+1.0D 1*(1.4D 1*X(1)**2+3.5D 1*X(15)-7.9D 1*X(16)-
     &9.2D 1)
      RETURN
  206 FA=FA+1.0D 1*(1.5D 1*X(2)**2+1.1D 1*X(15)-6.1D 1*X(16)-
     &5.4D 1)
      RETURN
  207 FA=FA+1.0D 1*(5.0D 0*X(1)**2+2.0D 0*X(2)+9.0D 0*X(17)**4-
     &X(18)-6.8D 1)
      RETURN
  208 FA=FA+1.0D 1*(X(1)**2-X(2)+1.9D 1*X(19)-2.0D 1*X(20)+1.9D 1)
      RETURN
  209 FA=FA+1.0D 1*(7.0D 0*X(1)**2+5.0D 0*X(2)**2+X(19)**2-3.0D 1*
     &X(20))
      RETURN
   60 FA=-1.0D 0
      DO 61 I=1,N
      FA=FA+X(I)
   61 CONTINUE
      IF (MOD(KA,2).EQ.0) THEN
      I=(KA+2)/2
      FA=FA+X(I)*(X(I)-1.0D 0)
      ELSE
      I=(KA+1)/2
      FA=FA+X(I)*(2.0D 0*X(I)-1.0D 0)
      ENDIF
      RETURN
   70 K=(N-1)/2
      A=Y(KA)
      S=1.0D 0
      IF (KA.GT.62.AND.KA.LT.124) S=-S
      P=-8.0D 0*LOG(A)
      A=A*A
      DO 71 I=1,K
      B=X(I+K)**2-A
      P=P+LOG(B*B+A*X(I)**2)
   71 CONTINUE
      FA=(0.5D 0*P-X(N))*S
      IF (KA.EQ.1.OR.KA.EQ.124) FA=FA+3.0164D 0
      RETURN
   90 P=5.0D 2
      A=0.99D 0
      FA=5.04D 0*X(1)+0.35D-1*X(2)+1.00D 1*X(3)+3.36D 0*X(5)-
     & 0.63D-1*X(4)*X(7)
      GO TO (91,92,93,94,95,96,97,98,99),KA
   91 CONTINUE
      RETURN
   92 FA=FA+P*(1.12D 0*X(1)+X(1)*X(8)*(1.3167D-1-6.67D-3*X(8))-
     & X(4)/A)
      RETURN
   93 FA=FA-P*(1.12D 0*X(1)+X(1)*X(8)*(1.3167D-1-6.67D-3*X(8))-
     & X(4)*A)
      RETURN
   94 FA=FA+P*(57.425D 0+X(8)*(1.098D 0-0.038D 0*X(8))+
     & 0.325D 0*X(6)-X(7)/A)
      RETURN
   95 FA=FA-P*(57.425D 0+X(8)*(1.098D 0-0.038D 0*X(8))+
     & 0.325D 0*X(6)-X(7)*A)
      RETURN
   96 FA=FA+P*(9.8D 4*X(3)/(X(4)*X(9)+1.0D 3*X(3))-X(6))
      RETURN
   97 FA=FA-P*(9.8D 4*X(3)/(X(4)*X(9)+1.0D 3*X(3))-X(6))
      RETURN
   98 FA=FA+P*((X(2)+X(5))/X(1)-X(8))
      RETURN
   99 FA=FA-P*((X(2)+X(5))/X(1)-X(8))
      RETURN
  130 P=1.0D 5
      FA=Y(1)*X(1)+Y(2)*X(1)*X(6)+Y(3)*X(3)+Y(4)*X(2)+Y(5)+
     & Y(6)*X(3)*X(5)
      GO TO (131,132,133,134,135,136,137,138,105,106,107,108,109),KA
  131 CONTINUE
      RETURN
  132 FA=FA+P*(Y(7)*X(6)**2+Y(8)*X(3)/X(1)+Y(9)*X(6)-1.0D 0)
      RETURN
  133 FA=FA+P*((Y(10)+Y(11)*X(6)+Y(12)*X(6)**2)*X(1)/X(3)-1.0D 0)
      RETURN
  134 FA=FA+P*(Y(13)*X(6)**2+Y(14)*X(5)+Y(15)*X(4)+Y(16)*X(6)-1.0D 0)
      RETURN
  135 FA=FA+P*((Y(17)+Y(18)*X(6)+Y(19)*X(4)+Y(20)*X(6)**2)/X(5)-1.0D 0)
      RETURN
  136 FA=FA+P*(Y(21)*X(7)+(Y(22)/X(4)+Y(23))*X(2)/X(3)-1.0D 0)
      RETURN
  137 FA=FA+P*((Y(24)+(Y(25)+Y(26)/X(4))*X(2)/X(3))/X(7)-1.0D 0)
      RETURN
  138 FA=FA+P*((Y(27)+Y(28)*X(7))/X(5)-1.0D 0)
      RETURN
  105 FA=FA+P*((Y(33)*X(1)+Y(34))/X(3)-1.0D 0)
      RETURN
  106 FA=FA+P*((Y(35)/X(4)+Y(36))*X(2)/X(3)-1.0D 0)
      RETURN
  107 FA=FA+P*((Y(37)+Y(38)*X(3)/X(2))*X(4)-1.0D 0)
      RETURN
  108 FA=FA+P*(Y(39)*X(1)*X(6)+Y(40)*X(1)+Y(41)*X(3)-1.0D 0)
      RETURN
  109 FA=FA+P*((Y(42)*X(3)+Y(43))/X(1)+Y(44)*X(6)-1.0D 0)
      RETURN
  150 P=1.0D 5
      FA=X(1)+X(2)+X(3)
      GO TO (151,152,153,154),KA
  151 CONTINUE
      RETURN
  152 FA=FA+P*((833.33252D 0*X(4)/X(1)+1.0D 2-
     & 83333.333D 0/X(1))/X(6)-1.0D 0)
      RETURN
  153 FA=FA+P*((1.25D 3*(X(5)-X(4))/X(2)+X(4))/X(7)-1.0D 0)
      RETURN
  154 FA=FA+P*(((1.25D 6-2.5D 3*X(5))/X(3)+X(5))/X(8)-1.0D 0)
      RETURN
  170 P=1.0D 3
      FA=1.262626D 0*(X(12)+X(13)+X(14)+X(15)+X(16))-
     & 1.231060D 0*(X(1)*X(12)+X(2)*X(13)+X(3)*X(14)+X(4)*X(15)+
     & X(5)*X(16))
      GO TO (171,172,173,174,175,176,177,178,179,116,117,118,128,
     & 129,146,147,148,149,159),KA
  171 CONTINUE
      RETURN
  172 FA=FA+P*(X(1)*(9.75D-1+(3.475D-2-9.75D-3*X(1))/X(6))-1.0D 0)
      RETURN
  173 FA=FA+P*(X(2)*(9.75D-1+(3.475D-2-9.75D-3*X(2))/X(7))-1.0D 0)
      RETURN
  174 FA=FA+P*(X(3)*(9.75D-1+(3.475D-2-9.75D-3*X(3))/X(8))-1.0D 0)
      RETURN
  175 FA=FA+P*(X(4)*(9.75D-1+(3.475D-2-9.75D-3*X(4))/X(9))-1.0D 0)
      RETURN
  176 FA=FA+P*(X(5)*(9.75D-1+(3.475D-2-9.75D-3*X(5))/X(10))-1.0D 0)
      RETURN
  177 FA=FA+P*((X(6)+(X(1)-X(6))*X(12)/X(11))/X(7)-1.0D 0)
      RETURN
  178 FA=FA+P*(((X(7)+2.0D-3*(X(7)-X(1))*X(12))/X(8)+
     & 2.0D-3*X(13)*(X(2)/X(8)-1.0D 0))-1.0D 0)
      RETURN
  179 FA=FA+P*(X(8)+X(9)+2.0D-3*X(13)*(X(8)-X(2))+
     & 2.0D-3*X(14)*(X(3)-X(9))-1.0D 0)
      RETURN
  116 FA=FA+P*((X(9)+((X(4)-X(8))*X(15)+
     & 5.0D 2*(X(10)-X(9)))/X(14))/X(3)-1.0D 0)
      RETURN
  117 FA=FA+P*((X(10)/X(4)+(X(5)/X(4)-1.0D 0)*X(16)/X(15)+
     & 5.0D 2*(1.0D 0-X(10)/X(4))/X(15))-1.0D 0)
      RETURN
  118 FA=FA+P*(9.0D-1/X(4)+2.0D-3*X(16)*(1.0D 0-X(5)/X(4))-1.0D 0)
      RETURN
  128 FA=FA+P*(X(12)/X(11)-1.0D 0)
      RETURN
  129 FA=FA+P*(X(4)/X(5)-1.0D 0)
      RETURN
  146 FA=FA+P*(X(3)/X(4)-1.0D 0)
      RETURN
  147 FA=FA+P*(X(2)/X(3)-1.0D 0)
      RETURN
  148 FA=FA+P*(X(1)/X(2)-1.0D 0)
      RETURN
  149 FA=FA+P*(X(9)/X(10)-1.0D 0)
      RETURN
  159 FA=FA+P*X(8)/X(9)-P
      RETURN
      END
* SUBROUTINE TAGU22             ALL SYSTEMS                 99/12/01
C PORTABILITY : ALL SYSTEMS
C 94/12/01 LU : ORIGINAL VERSION
*
* PURPOSE :
*  GRADIENTS OF PARTIAL FUNCTIONS IN THE MINIMAX CRITERION.
*
* PARAMETERS :
*  II  N  NUMBER OF VARIABLES.
*  II  KA  INDEX OF THE PARTIAL FUNCTION.
*  RI  X(N)  VECTOR OF VARIABLES.
*  RO  GA(N)  GRADIENT OF THE PARTIAL FUNCTION AT THE
*          SELECTED POINT.
*  II  NEXT  NUMBER OF THE TEST PROBLEM.
*
      SUBROUTINE TAGU22(N,KA,X,GA,NEXT)
      INTEGER N,KA,NEXT
      REAL*8 X(N),GA(N)
      INTEGER I,J,K
      REAL*8 A,B,C,P,Q,R,S,T,Y1,Y2,Y3,Y4
      REAL*8 Y(163),PI
      COMMON /EMPR22/ Y
      PARAMETER (PI=3.14159265358979323846D 0)
      GOTO (10,10,30,30,80,50,100,190,200,60,70,90,130,150,170),NEXT
   10 GOTO (11,12,13),KA
   11 GA(1)=2.0D 0*X(1)+X(2)
      GA(2)=2.0D 0*X(2)+X(1)
      RETURN
   12 GA(1)=COS(X(1))
      GA(2)=0.0D 0
      RETURN
   13 GA(1)=0.0D 0
      GA(2)=SIN(X(2))
      RETURN
   30 GOTO (31,32,33),KA
   31 GA(1)=-EXP(X(1)-X(2))
      GA(2)= EXP(X(1)-X(2))
      RETURN
   32 GA(1)=COSH(X(1)-1.0D 0)
      GA(2)=0.0D 0
      RETURN
   33 GA(1)= 0.0D 0
      GA(2)=-1.0D 0/X(2)
      RETURN
   80 GO TO (81,82,83) KA
   81 A=SQRT((X(1)-X(3))**2+(X(2)-X(4))**2)
      GA(1)=-(X(1)-X(3))/A
      GA(2)=-(X(2)-X(4))/A
      GA(3)=-GA(1)
      GA(4)=-GA(2)
      GA(5)=0.0D 0
      GA(6)=0.0D 0
      RETURN
   82 A=SQRT((X(3)-X(5))**2+(X(4)-X(6))**2)
      GA(1)=0.0D 0
      GA(2)=0.0D 0
      GA(3)=-(X(3)-X(5))/A
      GA(4)=-(X(4)-X(6))/A
      GA(5)=-GA(3)
      GA(6)=-GA(4)
      RETURN
   83 A=SQRT((X(5)-X(1))**2+(X(6)-X(2))**2)
      GA(1)= (X(5)-X(1))/A
      GA(2)= (X(6)-X(2))/A
      GA(3)=0.0D 0
      GA(4)=0.0D 0
      GA(5)=-GA(1)
      GA(6)=-GA(2)
      RETURN
   50 DO 51 I=1,N
      GA(I)=-2.0D 0*Y(KA)*SIN(Y(KA)*X(I))/1.5D 1
   51 CONTINUE
      RETURN
  100 DO 189 I=1,N
      GA(I)=0.0D 0
  189 CONTINUE
      K=0
      DO 103 I=1,5
      A=0.0D 0
      P=0.0D 0
      DO 101 J=1,N
      A=A+Y(K+J)*X(J)**(1.0D 0-Y(I+80))
      P=P+Y(K+J+40)*X(J)
  101 CONTINUE
      B=Y(K+KA)/(X(KA)**Y(I+80)*A)
      DO 102 J=1,N
      C=Y(K+J)*(1.0D 0-Y(I+80))/(X(J)**Y(I+80)*A)
      GA(J)=GA(J)+B*(Y(K+J+40)-C*P)
  102 CONTINUE
      GA(KA)=GA(KA)-B*Y(I+80)*P/X(KA)
      K=K+N
  103 CONTINUE
      RETURN
  190 GA(1)=2.0D 0*X(1)+X(2)-1.4D 1
      GA(2)=2.0D 0*X(2)+X(1)-1.6D 1
      GA(3)=2.0D 0*(X(3)-1.0D 1)
      GA(4)=8.0D 0*(X(4)-5.0D 0)
      GA(5)=2.0D 0*(X(5)-3.0D 0)
      GA(6)=4.0D 0*(X(6)-1.0D 0)
      GA(7)=1.0D 1*X(7)
      GA(8)=1.4D 1*(X(8)-1.1D 1)
      GA(9)=4.0D 0*(X(9)-1.0D 1)
      GA(10)=2.0D 0*(X(10)-7.0D 0)
      GO TO (191,192,193,194,195,196),KA
  191 CONTINUE
      RETURN
  192 GA(1)=GA(1)+6.0D 1*(X(1)-2.0D 0)
      GA(2)=GA(2)+8.0D 1*(X(2)-3.0D 0)
      GA(3)=GA(3)+4.0D 1*X(3)
      GA(4)=GA(4)-7.0D 1
      RETURN
  193 GA(1)=GA(1)+1.0D 2*X(1)
      GA(2)=GA(2)+8.0D 1
      GA(3)=GA(3)+2.0D 1*(X(3)-6.0D 0)
      GA(4)=GA(4)-2.0D 1
      RETURN
  194 GA(1)=GA(1)+1.0D 1*(X(1)-8.0D 0)
      GA(2)=GA(2)+4.0D 1*(X(2)-4.0D 0)
      GA(5)=GA(5)+6.0D 1*X(5)
      GA(6)=GA(6)-1.0D 1
      RETURN
  195 GA(1)=GA(1)+2.0D 1*X(1)-2.0D 1*X(2)
      GA(2)=GA(2)+4.0D 1*(X(2)-2.0D 0)-2.0D 1*X(1)
      GA(5)=GA(5)+1.4D 2
      GA(6)=GA(6)-6.0D 1
      RETURN
  196 GA(1)=GA(1)-3.0D 1
      GA(2)=GA(2)+6.0D 1
      GA(9)=GA(9)+2.4D 2*(X(9)-8.0D 0)
      GA(10)=GA(10)-7.0D 1
      RETURN
  200 GA(1)=2.0D 0*X(1)+X(2)-1.4D 1
      GA(2)=2.0D 0*X(2)+X(1)-1.6D 1
      GA(3)=2.0D 0*(X(3)-1.0D 1)
      GA(4)=8.0D 0*(X(4)-5.0D 0)
      GA(5)=2.0D 0*(X(5)-3.0D 0)
      GA(6)=4.0D0*(X(6)-1.0D 0)
      GA(7)=1.0D 1*X(7)
      GA(8)=1.4D 1*(X(8)-1.1D 1)
      GA(9)=4.0D 0*(X(9)-1.0D 1)
      GA(10)=2.0D 0*(X(10)-7.0D0)
      GA(11)=2.0D 0*(X(11)-9.0D0)
      GA(12)=2.0D 1*(X(12)-1.0D 0)
      GA(13)=1.0D 1*(X(13)-7.0D 0)
      GA(14)=8.0D 0*(X(14)-1.4D 1)
      GA(15)=5.4D 1*(X(15)-1.0D 0)
      GA(16)=4.0D 0*X(16)**3
      GA(17)=2.0D 0*(X(17)-2.0D 0)
      GA(18)=2.6D 1*(X(18)-2.0D 0)
      GA(19)=2.0D 0*(X(19)-3.0D 0)
      GA(20)=2.0D 0*X(20)
      GO TO (191,192,193,194,195,196,202,203,204,205,206,207,208,209),KA
  202 GA(1)=GA(1)+2.0D 1*X(1)
      GA(11)=GA(11)+1.5D 2
      GA(12)=GA(12)-8.0D 1
      RETURN
  203 GA(1)=GA(1)+4.0D 1
      GA(2)=GA(2)+9.0D 1
      GA(13)=GA(13)+1.0D 2*X(13)
      GA(14)=GA(14)-9.0D 1
      RETURN
  204 GA(1)=GA(1)+3.0D 1
      GA(2)=GA(2)+4.0D 1
      GA(13)=GA(13)+6.0D 1*(X(13)-6.0D 0)
      GA(14)=GA(14)-1.4D 2
      RETURN
  205 GA(1)=GA(1)+2.8D 2*X(1)
      GA(15)=GA(15)+3.5D 2
      GA(16)=GA(16)-7.9D 2
      RETURN
  206 GA(2)=GA(2)+3.0D 2*X(2)
      GA(15)=GA(15)+1.1D 2
      GA(16)=GA(16)-6.1D 2
      RETURN
  207 GA(1)=GA(1)+1.0D 2*X(1)
      GA(2)=GA(2)+2.0D 1
      GA(17)=GA(17)+3.6D 2*X(17)**3
      GA(18)=GA(18)-1.0D 1
      RETURN
  208 GA(1)=GA(1)+2.0D 1*X(1)
      GA(2)=GA(2)-1.0D 1
      GA(19)=GA(19)+1.9D 2
      GA(20)=GA(20)-2.0D 2
      RETURN
  209 GA(1)=GA(1)+1.4D 2*X(1)
      GA(2)=GA(2)+1.0D 2*X(2)
      GA(19)=GA(19)+2.0D 1*X(19)
      GA(20)=GA(20)-3.0D 2
      RETURN
   60 DO 61 I=1,N
      GA(I)=1.0D 0
   61 CONTINUE
      IF (MOD(KA,2).EQ.0) THEN
      I=(KA+2)/2
      GA(I)=GA(I)+2.0D 0*X(I)-1.0D 0
      ELSE
      I=(KA+1)/2
      GA(I)=GA(I)+4.0D 0*X(I)-1.0D 0
      ENDIF
      RETURN
   70 K=(N-1)/2
      A=Y(KA)**2
      S=1.0D 0
      IF (KA.GT.62.AND.KA.LT.124) S=-S
      DO 71 I=1,K
      B=X(I+K)**2-A
      P=S*(B*B+A*X(I)**2)
      GA(I)=A*X(I)/P
      GA(I+K)=2.0D 0*X(I+K)*B/P
   71 CONTINUE
      GA(N)=-S
      RETURN
   90 P=5.0D 2
      A=0.99D 0
      GA(1)= 5.04D 0
      GA(2)= 0.35D-1
      GA(3)= 1.00D 1
      GA(4)=-0.63D-1*X(7)
      GA(5)= 3.36D 0
      GA(6)= 0.00D 0
      GA(7)=-0.63D-1*X(4)
      GA(8)= 0.00D 0
      GA(9)= 0.00D 0
      GA(10)=0.00D 0
      GO TO (91,92,93,94,95,96,97,98,99),KA
   91 CONTINUE
      RETURN
   92 GA(1)=GA(1)+P*(1.12D 0+X(8)*(1.3167D-1-6.67D-3*X(8)))
      GA(4)=GA(4)-P/A
      GA(8)=GA(8)+P*X(1)*(1.3167D-1-1.334D-2*X(8))
      RETURN
   93 GA(1)=GA(1)-P*(1.12D 0+X(8)*(1.3167D-1-6.67D-3*X(8)))
      GA(4)=GA(4)+P*A
      GA(8)=GA(8)-P*X(1)*(1.3167D-1-1.334D-2*X(8))
      RETURN
   94 GA(6)=GA(6)+P*0.325D 0
      GA(7)=GA(7)-P/A
      GA(8)=GA(8)+P*(1.098D 0-0.076D 0*X(8))
      RETURN
   95 GA(6)=GA(6)-P*0.325D 0
      GA(7)=GA(7)+P*A
      GA(8)=GA(8)-P*(1.098D 0-0.076D 0*X(8))
      RETURN
   96 C=(X(4)*X(9)+1.0D 3*X(3))**2
      GA(3)=GA(3)+9.8D 4*P*X(4)*X(9)/C
      GA(4)=GA(4)-9.8D 4*P*X(3)*X(9)/C
      GA(6)=GA(6)-P
      GA(9)=GA(9)-9.8D 4*P*X(3)*X(4)/C
      RETURN
   97 C=(X(4)*X(9)+1.0D 3*X(3))**2
      GA(3)=GA(3)-9.8D 4*P*X(4)*X(9)/C
      GA(4)=GA(4)+9.8D 4*P*X(3)*X(9)/C
      GA(6)=GA(6)+P
      GA(9)=GA(9)+9.8D 4*P*X(3)*X(4)/C
      RETURN
   98 GA(1)=GA(1)-P*(X(2)+X(5))/X(1)**2
      GA(2)=GA(2)+P/X(1)
      GA(5)=GA(5)+P/X(1)
      GA(8)=GA(8)-P
      RETURN
   99 GA(1)=GA(1)+P*(X(2)+X(5))/X(1)**2
      GA(2)=GA(2)-P/X(1)
      GA(5)=GA(5)-P/X(1)
      GA(8)=GA(8)+P
      RETURN
  130 P=1.0D 5
      GA(1)=Y(1)+Y(2)*X(6)
      GA(2)=Y(4)
      GA(3)=Y(3)+Y(6)*X(5)
      GA(4)=0.0D 0
      GA(5)=Y(6)*X(3)
      GA(6)=Y(2)*X(1)
      GA(7)=0.0D 0
      GO TO (131,132,133,134,135,136,137,138,105,106,107,108,109),KA
  131 CONTINUE
      RETURN
  132 GA(1)=GA(1)-P*Y(8)*X(3)/X(1)**2
      GA(3)=GA(3)+P*Y(8)/X(1)
      GA(6)=GA(6)+P*(2.0D 0*Y(7)*X(6)+Y(9))
      RETURN
  133 GA(1)=GA(1)+P*(Y(10)+Y(11)*X(6)+Y(12)*X(6)**2)/X(3)
      GA(3)=GA(3)-P*(Y(10)+Y(11)*X(6)+Y(12)*X(6)**2)*X(1)/X(3)**2
      GA(6)=GA(6)+P*(Y(11)+2.0D 0*Y(12)*X(6))*X(1)/X(3)
      RETURN
  134 GA(4)=GA(4)+P*Y(15)
      GA(5)=GA(5)+P*Y(14)
      GA(6)=GA(6)+P*(2.0D 0*Y(13)*X(6)+Y(16))
      RETURN
  135 GA(4)=GA(4)+P*Y(19)/X(5)
      GA(5)=GA(5)-P*(Y(17)+Y(18)*X(6)+Y(19)*X(4)+Y(20)*X(6)**2)/X(5)**2
      GA(6)=GA(6)+P*(Y(18)+2.0D 0*Y(20)*X(6))/X(5)
      RETURN
  136 GA(2)=GA(2)+P*(Y(22)/X(4)+Y(23))/X(3)
      GA(3)=GA(3)-P*(Y(22)/X(4)+Y(23))*X(2)/X(3)**2
      GA(4)=GA(4)-P*Y(22)*X(2)/(X(3)*X(4)**2)
      GA(7)=GA(7)+P*Y(21)
      RETURN
  137 GA(2)=GA(2)+P*(Y(25)+Y(26)/X(4))/(X(3)*X(7))
      GA(3)=GA(3)-P*(Y(25)+Y(26)/X(4))*X(2)/(X(3)**2*X(7))
      GA(4)=GA(4)-P*Y(26)*X(2)/(X(3)*X(4)**2*X(7))
      GA(7)=GA(7)-P*(Y(24)+(Y(25)+Y(26)/X(4))*X(2)/X(3))/X(7)**2
      RETURN
  138 GA(5)=GA(5)-P*(Y(27)+Y(28)*X(7))/X(5)**2
      GA(7)=GA(7)+P*Y(28)/X(5)
      RETURN
  105 GA(1)=GA(1)+P*Y(33)/X(3)
      GA(3)=GA(3)-P*(Y(33)*X(1)+Y(34))/X(3)**2
      RETURN
  106 GA(2)=GA(2)+P*(Y(35)/X(4)+Y(36))/X(3)
      GA(3)=GA(3)-P*(Y(35)/X(4)+Y(36))*X(2)/X(3)**2
      GA(4)=GA(4)-P*Y(35)*X(2)/(X(3)*X(4)**2)
      RETURN
  107 GA(2)=GA(2)-P*Y(38)*X(3)*X(4)/X(2)**2
      GA(3)=GA(3)+P*Y(38)*X(4)/X(2)
      GA(4)=GA(4)+P*(Y(37)+Y(38)*X(3)/X(2))
      RETURN
  108 GA(1)=GA(1)+P*(Y(39)*X(6)+Y(40))
      GA(3)=GA(3)+P*Y(41)
      GA(6)=GA(6)+P*Y(39)*X(1)
      RETURN
  109 GA(1)=GA(1)-P*(Y(42)*X(3)+Y(43))/X(1)**2
      GA(3)=GA(3)+P*Y(42)/X(1)
      GA(6)=GA(6)+P*Y(44)
      RETURN
  150 P=1.0D 5
      GA(1)=1.0D 0
      GA(2)=1.0D 0
      GA(3)=1.0D 0
      GA(4)=0.0D 0
      GA(5)=0.0D 0
      GA(6)=0.0D 0
      GA(7)=0.0D 0
      GA(8)=0.0D 0
      GO TO (151,152,153,154),KA
  151 CONTINUE
      RETURN
  152 GA(1)=GA(1)-P*(833.33252D 0*X(4)-83333.333D 0)/(X(1)**2*X(6))
      GA(4)=GA(4)+P*833.33252D 0/(X(1)*X(6))
      GA(6)=GA(6)-P*(833.33252D 0*X(4)/X(1)+1.0D 2-
     & 83333.333D 0/X(1))/X(6)**2
      RETURN
  153 GA(2)=GA(2)-P*1.25D 3*(X(5)-X(4))/(X(2)**2*X(7))
      GA(4)=GA(4)+P*(1.0D 0-1.25D 3/X(2))/X(7)
      GA(5)=GA(5)+P*1.25D 3/(X(2)*X(7))
      GA(7)=GA(7)-P*(1.25D 3*(X(5)-X(4))/X(2)+X(4))/X(7)**2
      RETURN
  154 GA(3)=GA(3)-P*(1.25D 6-2.5D 3*X(5))/(X(3)**2*X(8))
      GA(5)=GA(5)+P*(1.0D 0-2.5D 3/X(3))/X(8)
      GA(8)=GA(8)-P*((1.25D 6-2.5D 3*X(5))/X(3)+X(5))/X(8)**2
      RETURN
  170 P=1.0D 3
      GA(1)=-1.231060D 0*X(12)
      GA(2)=-1.231060D 0*X(13)
      GA(3)=-1.231060D 0*X(14)
      GA(4)=-1.231060D 0*X(15)
      GA(5)=-1.231060D 0*X(16)
      GA(6)= 0.0D 0
      GA(7)= 0.0D 0
      GA(8)= 0.0D 0
      GA(9)= 0.0D 0
      GA(10)=0.0D 0
      GA(11)=0.0D 0
      GA(12)=1.262626D 0-1.231060D 0*X(1)
      GA(13)=1.262626D 0-1.231060D 0*X(2)
      GA(14)=1.262626D 0-1.231060D 0*X(3)
      GA(15)=1.262626D 0-1.231060D 0*X(4)
      GA(16)=1.262626D 0-1.231060D 0*X(5)
      GO TO (171,172,173,174,175,176,177,178,179,116,117,118,128,
     & 129,146,147,148,149,159),KA
  171 CONTINUE
      RETURN
  172 GA(1)=GA(1)+P*(9.75D-1+(3.475D-2-1.95D-2*X(1))/X(6))
      GA(6)=GA(6)-P*X(1)*(3.475D-2-9.75D-3*X(1))/X(6)**2
      RETURN
  173 GA(2)=GA(2)+P*(9.75D-1+(3.475D-2-1.95D-2*X(2))/X(7))
      GA(7)=GA(7)-P*X(2)*(3.475D-2-9.75D-3*X(2))/X(7)**2
      RETURN
  174 GA(3)=GA(3)+P*(9.75D-1+(3.475D-2-1.95D-2*X(3))/X(8))
      GA(8)=GA(8)-P*X(3)*(3.475D-2-9.75D-3*X(3))/X(8)**2
      RETURN
  175 GA(4)=GA(4)+P*(9.75D-1+(3.475D-2-1.95D-2*X(4))/X(9))
      GA(9)=GA(9)-P*X(4)*(3.475D-2-9.75D-3*X(4))/X(9)**2
      RETURN
  176 GA(5)=GA(5)+P*(9.75D-1+(3.475D-2-1.95D-2*X(5))/X(10))
      GA(10)=GA(10)-P*X(5)*(3.475D-2-9.75D-3*X(5))/X(10)**2
      RETURN
  177 GA(1)=GA(1)+P*X(12)/(X(7)*X(11))
      GA(6)=GA(6)+P*(1.0D 0-X(12)/X(11))/X(7)
      GA(7)=GA(7)-P*(X(6)+(X(1)-X(6))*X(12)/X(11))/X(7)**2
      GA(11)=GA(11)-P*(X(1)-X(6))*X(12)/(X(7)*X(11)**2)
      GA(12)=GA(12)+P*(X(1)-X(6))/(X(11)*X(7))
      RETURN
  178 GA(1)=GA(1)-P*2.0D-3*X(12)/X(8)
      GA(2)=GA(2)+P*2.0D-3*X(13)/X(8)
      GA(7)=GA(7)+P*(1.0D 0+2.0D-3*X(12))/X(8)
      GA(8)=GA(8)-P*(X(7)+2.0D-3*((X(7)-X(1))*X(12)+
     & X(2)*X(13)))/X(8)**2
      GA(12)=GA(12)+P*2.0D-3*(X(7)-X(1))/X(8)
      GA(13)=GA(13)+P*2.0D-3*(X(2)/X(8)-1.0D 0)
      RETURN
  179 GA(2)=GA(2)-P*2.0D-3*X(13)
      GA(3)=GA(3)+P*2.0D-3*X(14)
      GA(8)=GA(8)+P*(1.0D 0+2.0D-3*X(13))
      GA(9)=GA(9)+P*(1.0D 0-2.0D-3*X(14))
      GA(13)=GA(13)+P*2.0D-3*(X(8)-X(2))
      GA(14)=GA(14)+P*2.0D-3*(X(3)-X(9))
      RETURN
  116 GA(3)=GA(3)-P*(X(9)+((X(4)-X(8))*X(15)+
     & 5.0D 2*(X(10)-X(9)))/X(14))/X(3)**2
      GA(4)=GA(4)+P*X(15)/(X(3)*X(14))
      GA(8)=GA(8)-P*X(15)/(X(3)*X(14))
      GA(9)=GA(9)+P*(1.0D 0-5.0D 2/X(14))/X(3)
      GA(10)=GA(10)+P*5.0D 2/(X(3)*X(14))
      GA(14)=GA(14)-P*((X(4)-X(8))*X(15)+
     & 5.0D 2*(X(10)-X(9)))/(X(3)*X(14)**2)
      GA(15)=GA(15)+P*(X(4)-X(8))/(X(3)*X(14))
      RETURN
  117 GA(4)=GA(4)-P*(X(10)+(X(5)*X(16)-5.0D 2*X(10))/X(15))/X(4)**2
      GA(5)=GA(5)+P*X(16)/(X(4)*X(15))
      GA(10)=GA(10)+P*(1.0D 0-5.0D 2/X(15))/X(4)
      GA(15)=GA(15)-P*(5.0D 2-X(16)+(X(5)*X(16)-
     & 5.0D 2*X(10))/X(4))/X(15)**2
      GA(16)=GA(16)+P*(X(5)/X(4)-1.0D 0)/X(15)
      RETURN
  118 GA(4)=GA(4)-P*(9.0D-1-2.0D-3*X(5)*X(16))/X(4)**2
      GA(5)=GA(5)-P*2.0D-3*X(16)/X(4)
      GA(16)=GA(16)+P*2.0D-3*(1.0D 0-X(5)/X(4))
      RETURN
  128 GA(11)=GA(11)-P*X(12)/X(11)**2
      GA(12)=GA(12)+P/X(11)
      RETURN
  129 GA(4)=GA(4)+P/X(5)
      GA(5)=GA(5)-P*X(4)/X(5)**2
      RETURN
  146 GA(3)=GA(3)+P/X(4)
      GA(4)=GA(4)-P*X(3)/X(4)**2
      RETURN
  147 GA(2)=GA(2)+P/X(3)
      GA(3)=GA(3)-P*X(2)/X(3)**2
      RETURN
  148 GA(1)=GA(1)+P/X(2)
      GA(2)=GA(2)-P*X(1)/X(2)**2
      RETURN
  149 GA(9)=GA(9)+P/X(10)
      GA(10)=GA(10)-P*X(9)/X(10)**2
      RETURN
  159 GA(8)=GA(8)+P/X(9)
      GA(9)=GA(9)-P*X(8)/X(9)**2
      RETURN
      END
* SUBROUTINE TAHD22             ALL SYSTEMS                 99/12/01
C PORTABILITY : ALL SYSTEMS
C 95/12/01 LU : ORIGINAL VERSION
*
* PURPOSE :
*  HESSIAN MATRICES OF PARTIAL FUNCTIONS IN THE MINIMAX CRITERION.
*  DENSE VERSION.
*
* PARAMETERS :
*  II  N  NUMBER OF VARIABLES.
*  II  KA  INDEX OF THE PARTIAL FUNCTION.
*  RI  X(N)  VECTOR OF VARIABLES.
*  RO  HA(N*(N+1)/2)  GRADIENT OF THE PARTIAL FUNCTION
*         AT THE SELECTED POINT.
*  II  NEXT  NUMBER OF THE TEST PROBLEM.
*
      SUBROUTINE TAHD22(N,KA,X,HA,NEXT)
      INTEGER N,KA,NEXT,I,J,K,KK,L,LL
      REAL*8 X(N),HA(N*(N+1)/2)
      REAL*8 A,B,C,P,Q,R,S
      REAL*8 Y(163),PI
      COMMON /EMPR22/ Y
      PARAMETER (PI=3.14159265358979323846D 0)
      GOTO (10,10,30,30,80,50,100,190,200,60,70,90,130,150,170),NEXT
   10 GOTO (11,12,13),KA
   11 HA(1)=2.0D 0
      HA(2)=1.0D 0
      HA(3)=2.0D 0
      RETURN
   12 HA(1)=-SIN(X(1))
      HA(2)=0.0D 0
      HA(3)=0.0D 0
      RETURN
   13 HA(1)=0.0D 0
      HA(2)=0.0D 0
      HA(3)= COS(X(2))
      RETURN
   30 GOTO (31,32,33),KA
   31 HA(1)=-EXP(X(1)-X(2))
      HA(2)= EXP(X(1)-X(2))
      HA(3)=-EXP(X(1)-X(2))
      RETURN
   32 HA(1)=SINH(X(1)-1.0D 0)
      HA(2)=0.0D 0
      HA(3)=0.0D 0
      RETURN
   33 HA(1)=0.0D 0
      HA(2)=0.0D 0
      HA(3)=1.0D 0/X(2)**2
      RETURN
   80 DO 81 I=1,N*(N+1)/2
      HA(I)=0.0D 0
   81 CONTINUE
      GO TO (82,83,84) KA
   82 A=SQRT((X(1)-X(3))**2+(X(2)-X(4))**2)
      B=(X(1)-X(3))/A
      C=(X(2)-X(4))/A
      HA( 1)=-1.0D 0/A+B*B/A
      HA( 2)= B*C/A
      HA( 3)=-1.0D 0/A+C*C/A
      HA( 4)=-HA(1)
      HA( 5)=-HA(2)
      HA( 6)= HA(1)
      HA( 7)=-HA(2)
      HA( 8)=-HA(3)
      HA( 9)= HA(3)
      HA(10)= HA(3)
      RETURN
   83 A=SQRT((X(3)-X(5))**2+(X(4)-X(6))**2)
      B=(X(3)-X(5))/A
      C=(X(4)-X(6))/A
      HA( 6)=-1.0D 0/A+B*B/A
      HA( 9)= B*C/A
      HA(10)=-1.0D 0/A+C*C/A
      HA(13)=-HA( 6)
      HA(14)=-HA( 9)
      HA(15)= HA( 6)
      HA(18)=-HA( 9)
      HA(19)=-HA(10)
      HA(20)= HA( 9)
      HA(21)= HA(10)
      RETURN
   84 A=SQRT((X(5)-X(1))**2+(X(6)-X(2))**2)
      B=(X(5)-X(1))/A
      C=(X(6)-X(2))/A
      HA( 1)=-1.0D 0/A+B*B/A
      HA( 2)= B*C/A
      HA( 3)=-1.0D 0/A+C*C/A
      HA(11)=-HA(1)
      HA(12)=-HA(2)
      HA(15)= HA(1)
      HA(16)=-HA(2)
      HA(17)=-HA(3)
      HA(20)= HA(2)
      HA(21)= HA(3)
      RETURN
   50 DO 51 I=1,N*(N+1)/2
      HA(I)=0.0D 0
   51 CONTINUE
      DO 52 I=1,N
      J=I*(I+1)/2
      HA(J)=-2.0D 0*Y(KA)*Y(KA)*COS(Y(KA)*X(I))/1.5D 1
   52 CONTINUE
      RETURN
  100 DO 101 I=1,N*(N+1)/2
      HA(I)=0.0D 0
  101 CONTINUE
      K=0
      DO 105 I=1,5
      A=0.0D 0
      P=0.0D 0
      DO 102 J=1,N
      A=A+Y(K+J)*X(J)**(1.0D 0-Y(I+80))
      P=P+Y(K+J+40)*X(J)
  102 CONTINUE
      B=Y(K+KA)/(X(KA)**Y(I+80)*A)
      C=B*Y(I+80)/X(KA)
      KK=0
      DO 104 J=1,N
      Q=Y(K+J)*(1.0D 0-Y(I+80))/(X(J)**Y(I+80)*A)
      DO 103 L=1,J
      R=Y(K+L)*(1.0D 0-Y(I+80))/(X(L)**Y(I+80)*A)
      KK=KK+1
      HA(KK)=HA(KK)+B*(2.0D 0*P*Q*R-Q*Y(K+L+40)-R*Y(K+J+40))
      IF (J.EQ.L ) HA(KK)=HA(KK)+C*Q*P
      IF (L.EQ.KA) HA(KK)=HA(KK)-C*(Y(K+J+40)-Q*P)
      IF (J.EQ.KA) HA(KK)=HA(KK)-C*(Y(K+L+40)-R*P)
  103 CONTINUE
  104 CONTINUE
      KK=KA*(KA+1)/2
      Q=Y(K+KA)*(1.0D 0-Y(I+80))/(X(KA)**Y(I+80)*A)
      HA(KK)=HA(KK)+C*P*(1.0D 0+Y(I+80))/X(KA)
      K=K+N
  105 CONTINUE
      RETURN
  190 DO 191 I=1,N*(N+1)/2
      HA(I)=0.0D 0
  191 CONTINUE
      HA(1)=2.0D 0
      HA(2)=1.0D 0
      HA(3)=2.0D 0
      HA(6)=2.0D 0
      HA(10)=8.0D 0
      HA(15)=2.0D 0
      HA(21)=4.0D 0
      HA(28)=1.0D 1
      HA(36)=1.4D 1
      HA(45)=4.0D 0
      HA(55)=2.0D 0
      GO TO (197,192,193,194,195,196),KA
  192 HA(1)=HA(1)+6.0D 1
      HA(3)=HA(3)+8.0D 1
      HA(6)=HA(6)+4.0D 1
      RETURN
  193 HA(1)=HA(1)+1.0D 2
      HA(6)=HA(6)+2.0D 1
      RETURN
  194 HA(1)=HA(1)+1.0D 1
      HA(3)=HA(3)+4.0D 1
      HA(15)=HA(15)+6.0D 1
      RETURN
  195 HA(1)=HA(1)+1.0D 1
      HA(2)=HA(2)-2.0D 1
      HA(3)=HA(3)+4.0D 1
      RETURN
  196 HA(45)=HA(45)+2.4D 2
  197 RETURN
  200 DO 201 I=1,N*(N+1)/2
      HA(I)=0.0D 0
  201 CONTINUE
      HA(1)=2.0D 0
      HA(2)=1.0D 0
      HA(3)=2.0D 0
      HA(6)=2.0D 0
      HA(10)=8.0D 0
      HA(15)=2.0D 0
      HA(21)=4.0D 0
      HA(28)=1.0D 1
      HA(36)=1.4D 1
      HA(45)=4.0D 0
      HA(55)=2.0D 0
      HA(66)=2.0D 0
      HA(78)=2.0D 1
      HA(91)=1.0D 1
      HA(105)=8.0D 0
      HA(120)=5.4D 1
      HA(136)=1.2D 1*X(16)**2
      HA(153)=2.0D 0
      HA(171)=2.6D 1
      HA(190)=2.0D 0
      HA(210)=2.0D 0
      GO TO (197,192,193,194,195,196,202,203,204,205,206,207,208,209),KA
  202 HA(1)=HA(1)+2.0D 1
      RETURN
  203 HA(91)=HA(91)+1.0D 2
      RETURN
  204 HA(91)=HA(91)+6.0D 1
      RETURN
  205 HA(1)=HA(1)+2.8D 2
      RETURN
  206 HA(3)=HA(3)+3.0D 2
      RETURN
  207 HA(1)=HA(1)+1.0D 2
      HA(153)=HA(153)+10.8D 2*X(17)**2
      RETURN
  208 HA(1)=HA(1)+2.0D 1
      RETURN
  209 HA(1)=HA(1)+1.4D 2
      HA(3)=HA(3)+1.0D 2
      HA(190)=HA(190)+2.0D 1
      RETURN
   60 DO 61 I=1,N*(N+1)/2
      HA(I)=0.0D 0
   61 CONTINUE
      IF (MOD(KA,2).EQ.0) THEN
      I=(KA+2)/2
      J=I*(I+1)/2
      HA(J)=HA(J)+2.0D 0
      ELSE
      I=(KA+1)/2
      J=I*(I+1)/2
      HA(J)=HA(J)+4.0D 0
      ENDIF
      RETURN
   70 DO 71 I=1,N*(N+1)/2
      HA(I)=0.0D 0
   71 CONTINUE
      K=(N-1)/2
      KK=K*(K+1)/2
      A=Y(KA)**2
      L=0
      LL=KK
      S=1.0D 0
      IF (KA.GT.62.AND.KA.LT.124) S=-S
      DO 72 I=1,K
      L=L+I
      B=X(I+K)**2-A
      C=A*X(I)**2
      P=B*B+C
      Q=B*B-C
      R=S*P*P
      HA(L)=A*Q/R
      HA(L+LL)=-4.0D 0*A*B*X(I)*X(I+K)/R
      LL=LL+K
      HA(L+LL)=2.0D 0*S*B/P-4.0D 0*Q*X(I+K)**2/R
   72 CONTINUE
      RETURN
   90 P=5.0D 2
      A=0.99D 0
      DO 89 I=1,N*(N+1)/2
      HA(I)=0.0D 0
   89 CONTINUE
      HA(25)=-0.63D-1
      GO TO (91,92,93,94,95,96,97,98,99),KA
   91 CONTINUE
      RETURN
   92 HA(29)= P*(1.3167D-1-1.334D-2*X(8))
      HA(36)=-P*X(1)*1.334D-2
      RETURN
   93 HA(29)=-P*(1.3167D-1-1.334D-2*X(8))
      HA(36)= P*X(1)*1.334D-2
      RETURN
   94 HA(36)=-0.76D-1*P
      RETURN
   95 HA(36)= 0.76D-1*P
      RETURN
   96 C=(X(4)*X(9)+1.0D 3*X(3))**3
      Q=(X(4)*X(9)-1.0D 3*X(3))
      HA( 6)=-1.96D 8*P*X(4)*X(9)/C
      HA( 9)=-9.80D 4*P*X(9)*Q/C
      HA(10)= 1.96D 5*P*X(3)*X(9)**2/C
      HA(39)=-9.80D 4*P*X(4)*Q/C
      HA(40)= 9.80D 4*P*X(3)*Q/C
      HA(45)= 1.96D 5*P*X(3)*X(4)**2/C
      RETURN
   97 C=(X(4)*X(9)+1.0D 3*X(3))**3
      Q=(X(4)*X(9)-1.0D 3*X(3))
      HA( 6)= 1.96D 8*P*X(4)*X(9)/C
      HA( 9)= 9.80D 4*P*X(9)*Q/C
      HA(10)=-1.96D 5*P*X(3)*X(9)**2/C
      HA(39)= 9.80D 4*P*X(4)*Q/C
      HA(40)=-9.80D 4*P*X(3)*Q/C
      HA(45)=-1.96D 5*P*X(3)*X(4)**2/C
      RETURN
   98 HA( 1)= 2.0D 0*P*(X(2)+X(5))/X(1)**3
      HA( 2)=-P/X(1)**2
      HA(11)=-P/X(1)**2
      RETURN
   99 HA( 1)=-2.0D 0*P*(X(2)+X(5))/X(1)**3
      HA( 2)= P/X(1)**2
      HA(11)= P/X(1)**2
      RETURN
  130 P=1.0D 5
      DO 131 I=1,N*(N+1)/2
      HA(I)=0.0D 0
  131 CONTINUE
      HA(13)=Y(6)
      HA(16)=Y(2)
      GO TO (152,132,133,134,135,136,137,138,139,106,107,108,109),KA
  132 HA( 1)= 2.0D 0*P*Y(8)*X(3)/X(1)**3
      HA( 4)=-P*Y(8)/X(1)**2
      HA(21)= 2.0D 0*P*Y(7)
      RETURN
  133 HA( 4)=-P*(Y(10)+Y(11)*X(6)+Y(12)*X(6)**2)/X(3)**2
      HA( 6)= 2.0D 0*P*(Y(10)+Y(11)*X(6)+Y(12)*X(6)**2)*X(1)/X(3)**3
      HA(16)= HA(16)+P*(Y(11)+2.0D 0*Y(12)*X(6))/X(3)
      HA(18)=-P*(Y(11)+2.0D 0*Y(12)*X(6))*X(1)/X(3)**2
      HA(21)= 2.0D 0*P*Y(12)*X(1)/X(3)
      RETURN
  134 HA(21)= 2.0D 0*P*Y(13)
      RETURN
  135 HA(14)=-P*Y(19)/X(5)**2
      HA(15)= 2.0D 0*P*(Y(17)+Y(18)*X(6)+Y(19)*X(4)+
     & Y(20)*X(6)**2)/X(5)**3
      HA(20)=-P*(Y(18)+2.0D 0*Y(20)*X(6))/X(5)**2
      HA(21)= 2.0D 0*P*Y(20)/X(5)
      RETURN
  136 HA( 5)=-P*(Y(22)/X(4)+Y(23))/X(3)**2
      HA( 6)= 2.0D 0*P*(Y(22)/X(4)+Y(23))*X(2)/X(3)**3
      HA( 8)=-P*Y(22)/(X(3)*X(4)**2)
      HA( 9)= P*Y(22)*X(2)/(X(3)*X(4))**2
      HA(10)= 2.0D 0*P*Y(22)*X(2)/(X(3)*X(4)**3)
      RETURN
  137 HA( 5)=-P*(Y(25)+Y(26)/X(4))/(X(3)**2*X(7))
      HA( 6)= 2.0D 0*P*(Y(25)+Y(26)/X(4))*X(2)/(X(3)**3*X(7))
      HA( 8)=-P*Y(26)/(X(3)*X(4)**2*X(7))
      HA( 9)= P*Y(26)*X(2)/((X(3)*X(4))**2*X(7))
      HA(10)= 2.0D 0*P*Y(26)*X(2)/(X(3)*X(4)**3*X(7))
      HA(23)=-P*(Y(25)+Y(26)/X(4))/(X(3)*X(7)**2)
      HA(24)= P*(Y(25)+Y(26)/X(4))*X(2)/(X(3)*X(7))**2
      HA(25)= P*Y(26)*X(2)/(X(3)*(X(4)*X(7))**2)
      HA(28)= 2.0D 0*P*(Y(24)+(Y(25)+Y(26)/X(4))*X(2)/X(3))/X(7)**3
      RETURN
  138 HA(15)= 2.0D 0*P*(Y(27)+Y(28)*X(7))/X(5)**3
      HA(26)=-P*Y(28)/X(5)**2
      RETURN
  139 HA( 4)=-P*Y(33)/X(3)**2
      HA( 6)= 2.0D 0*P*(Y(33)*X(1)+Y(34))/X(3)**3
      RETURN
  106 HA( 5)=-P*(Y(35)/X(4)+Y(36))/X(3)**2
      HA( 6)= 2.0D 0*P*(Y(35)/X(4)+Y(36))*X(2)/X(3)**3
      HA( 8)=-P*Y(35)/(X(3)*X(4)**2)
      HA( 9)= P*Y(35)*X(2)/(X(3)*X(4))**2
      HA(10)= 2.0D 0*P*Y(35)*X(2)/(X(3)*X(4)**3)
      RETURN
  107 HA( 3)= 2.0D 0*P*Y(38)*X(3)*X(4)/X(2)**3
      HA( 5)=-P*Y(38)*X(4)/X(2)**2
      HA( 8)=-P*Y(38)*X(3)/X(2)**2
      HA( 9)= P*Y(38)/X(2)
      RETURN
  108 HA(16)=HA(16)+P*Y(39)
      RETURN
  109 HA( 1)= 2.0D 0*P*(Y(42)*X(3)+Y(43))/X(1)**3
      HA( 4)=-P*Y(42)/X(1)**2
      RETURN
  150 P=1.0D 5
      DO 151 I=1,N*(N+1)/2
      HA(I)=0.0D 0
  151 CONTINUE
      GO TO (152,153,154,155),KA
  152 CONTINUE
      RETURN
  153 HA( 1)= 2.0D 0*P*(833.33252D 0*X(4)-
     & 83333.333D 0)/(X(1)**3*X(6))
      HA( 7)=-P*833.33252D 0/(X(1)**2*X(6))
      HA(16)= P*(833.33252D 0*X(4)-83333.333D 0)/(X(1)**2*X(6)**2)
      HA(19)=-P*833.33252D 0/(X(1)*X(6)**2)
      HA(21)= 2.0D 0*P*(833.33252D 0*X(4)/X(1)+1.0D 2-
     & 83333.333D 0/X(1))/X(6)**3
      RETURN
  154 HA( 3)= P*2.50D 3*(X(5)-X(4))/(X(2)**3*X(7))
      HA( 8)= P*1.25D 3/(X(2)**2*X(7))
      HA(12)=-P*1.25D 3/(X(2)**2*X(7))
      HA(23)= P*1.25D 3*(X(5)-X(4))/(X(2)**2*X(7)**2)
      HA(25)=-P*(1.0D 0-1.25D 3/X(2))/X(7)**2
      HA(26)=-P*1.25D 3/(X(2)*X(7)**2)
      HA(28)=2.0D 0*P*(1.25D 3*(X(5)-X(4))/X(2)+X(4))/X(7)**3
      RETURN
  155 HA( 6)= 2.0D 0*P*(1.25D 6-2.5D 3*X(5))/(X(3)**3*X(8))
      HA(13)= P*2.5D 3/(X(3)**2*X(8))
      HA(31)= P*(1.25D 6-2.5D 3*X(5))/(X(3)**2*X(8)**2)
      HA(33)=-P*(1.00D 0-2.5D 3/X(3))/X(8)**2
      HA(36)= 2.0D 0*P*((1.25D 6-2.5D 3*X(5))/X(3)+X(5))/X(8)**3
      RETURN
  170 P=1.0D 3
      DO 171 I=1,N*(N+1)/2
      HA(I)=0.0D 0
  171 CONTINUE
      HA( 67)=-1.231060D 0
      HA( 80)=-1.231060D 0
      HA( 94)=-1.231060D 0
      HA(109)=-1.231060D 0
      HA(125)=-1.231060D 0
      GO TO (152,172,173,174,175,176,177,178,179,116,117,118,128,
     & 129,146,147,148,149,159),KA
  172 HA( 1)=-P*1.95D-2/X(6)
      HA(16)=-P*(3.475D-2-1.95D-2*X(1))/X(6)**2
      HA(21)= 2.0D 0*P*X(1)*(3.475D-2-9.75D-3*X(1))/X(6)**3
      RETURN
  173 HA( 3)=-P*1.95D-2/X(7)
      HA(23)=-P*(3.475D-2-1.95D-2*X(2))/X(7)**2
      HA(28)= 2.0D 0*P*X(2)*(3.475D-2-9.75D-3*X(2))/X(7)**3
      RETURN
  174 HA( 6)=-P*1.95D-2/X(8)
      HA(31)=-P*(3.475D-2-1.95D-2*X(3))/X(8)**2
      HA(36)= 2.0D 0*P*X(3)*(3.475D-2-9.75D-3*X(3))/X(8)**3
      RETURN
  175 HA(10)=-P*1.95D-2/X(9)
      HA(40)=-P*(3.475D-2-1.95D-2*X(4))/X(9)**2
      HA(45)= 2.0D 0*P*X(4)*(3.475D-2-9.75D-3*X(4))/X(9)**3
      RETURN
  176 HA(15)=-P*1.95D-2/X(10)
      HA(50)=-P*(3.475D-2-1.95D-2*X(5))/X(10)**2
      HA(55)= 2.0D 0*P*X(5)*(3.475D-2-9.75D-3*X(5))/X(10)**3
      RETURN
  177 HA(22)=-P*X(12)/(X(11)*X(7)**2)
      HA(27)=-P*(1.0D 0-X(12)/X(11))/X(7)**2
      HA(28)= 2.0D 0*P*(X(6)+(X(1)-X(6))*X(12)/X(11))/X(7)**3
      HA(56)=-P*X(12)/(X(7)*X(11)**2)
      HA(61)= P*X(12)/(X(7)*X(11)**2)
      HA(62)= P*(X(1)-X(6))*X(12)/(X(11)*X(7))**2
      HA(66)= 2.0D 0*P*(X(1)-X(6))*X(12)/(X(7)*X(11)**3)
      HA(67)= HA(67)+P/(X(11)*X(7))
      HA(72)=-P/(X(11)*X(7))
      HA(73)=-P*(X(1)-X(6))/(X(11)*X(7)**2)
      HA(77)=-P*(X(1)-X(6))/(X(7)*X(11)**2)
      RETURN
  178 HA(29)= 2.0D-3*P*X(12)/X(8)**2
      HA(30)=-2.0D-3*P*X(13)/X(8)**2
      HA(35)=-P*(1.0D 0+2.0D-3*X(12))/X(8)**2
      HA(36)= 2.0D 0*P*(X(7)+2.0D-3*((X(7)-X(1))*X(12)+
     & X(2)*X(13)))/X(8)**3
      HA(67)= HA(67)-2.0D-3*P/X(8)
      HA(73)= 2.0D-3*P/X(8)
      HA(74)=-2.0D-3*P*(X(7)-X(1))/X(8)**2
      HA(80)= HA(80)+2.0D-3*P/X(8)
      HA(86)=-2.0D-3*P*X(2)/X(8)**2
      RETURN
  179 HA( 80)= HA(80)-P*2.0D-3
      HA( 86)= P*2.0D-3
      HA( 94)= HA(94)+P*2.0D-3
      HA(100)=-P*2.0D-3
      RETURN
  116 HA(  6)= 2.0D 0*P*(X(9)+((X(4)-X(8))*X(15)+5.0D 2*
     & (X(10)-X(9)))/X(14))/X(3)**3
      HA(  9)=-P*X(15)/(X(14)*X(3)**2)
      HA( 31)= P*X(15)/(X(14)*X(3)**2)
      HA( 39)=-P*(1.0D 0-5.0D 2/X(14))/X(3)**2
      HA( 48)=-5.0D 2*P/(X(14)*X(3)**2)
      HA( 94)= HA( 94)+P*((X(4)-X(8))*X(15)+5.0D 2*
     & (X(10)-X(9)))/(X(14)*X(3))**2
      HA( 95)=-P*X(15)/(X(3)*X(14)**2)
      HA( 99)= P*X(15)/(X(3)*X(14)**2)
      HA(100)= 5.0D 2*P/(X(3)*X(14)**2)
      HA(101)=-5.0D 2*P/(X(3)*X(14)**2)
      HA(105)= 2.0D 0*P*((X(4)-X(8))*X(15)+5.0D 2*
     & (X(10)-X(9)))/(X(3)*X(14)**3)
      HA(108)=-P*(X(4)-X(8))/(X(14)*X(3)**2)
      HA(109)= HA(109)+P/(X(3)*X(14))
      HA(113)=-P/(X(3)*X(14))
      HA(119)=-P*(X(4)-X(8))/(X(3)*X(14)**2)
      RETURN
  117 HA( 10)= 2.0D 0*P*(X(10)+(X(5)*X(16)-5.0D 2*
     & X(10))/X(15))/X(4)**3
      HA( 14)=-P*X(16)/(X(15)*X(4)**2)
      HA( 49)=-P*(1.0D 0-5.0D 2/X(15))/X(4)**2
      HA(109)= HA(109)+P*(X(5)*X(16)-5.0D 2*X(10))/(X(15)*X(4))**2
      HA(110)=-P*X(16)/(X(4)*X(15)**2)
      HA(115)= 5.0D 2*P/(X(4)*X(15)**2)
      HA(120)= 2.0D 0*P*(5.0D 2-X(16)+(X(5)*X(16)-5.0D 2*
     & X(10))/X(4))/X(15)**3
      HA(124)=-P*X( 5)/(X(15)*X(4)**2)
      HA(125)= HA(125)+P/(X(4)*X(15))
      HA(135)=-P*(X(5)/X(4)-1.0D 0)/X(15)**2
      RETURN
  118 HA( 10)= 2.0D 0*P*(9.0D-1-2.0D-3*X(5)*X(16))/X(4)**3
      HA( 14)= P*(2.0D-3*X(16))/X(4)**2
      HA(124)= P*(2.0D-3*X( 5))/X(4)**2
      HA(125)=HA(125)-P*2.0D-3/X(4)
      RETURN
  128 HA(66)= 2.0D 0*P*X(12)/X(11)**3
      HA(77)=-P/X(11)**2
      RETURN
  129 HA(14)=-P/X(5)**2
      HA(15)= 2.0D 0*P*X(4)/X(5)**3
      RETURN
  146 HA( 9)=-P/X(4)**2
      HA(10)= 2.0D 0*P*X(3)/X(4)**3
      RETURN
  147 HA( 5)=-P/X(3)**2
      HA( 6)= 2.0D 0*P*X(2)/X(3)**3
      RETURN
  148 HA( 2)=-P/X(2)**2
      HA( 3)= 2.0D 0*P*X(1)/X(2)**3
      RETURN
  149 HA(54)=-P/X(10)**2
      HA(55)= 2.0D 0*P*X(9)/X(10)**3
      RETURN
  159 HA(44)=-P/X(9)**2
      HA(45)= 2.0D 0*P*X(8)/X(9)**3
      RETURN
      END
