#---!/usr/bin/env python
# -*- coding: UTF-8 -*-
from setuptools import setup, Extension
import platform
import os, sys, shutil, glob

# Detect platform, set up include directories and preprocessor macros, modify options (disable warnings)
if platform.system()=='Windows':
	import numpy as np
	define_macros=[('WINDOWS', None)]
	include_dirs=[np.get_include()]
	f2clib=["vcf2c"]
	cxxlib=[]
	extra_compile_args = []
else:
	import numpy as np
	define_macros=[('LINUX', None)]
	include_dirs=[np.get_include()]
	f2clib=["f2c"]
	cxxlib=["stdc++"]
	extra_compile_args = []
	
# 	# Get rid of warnings and other options
# 	cfg_vars = distutils.sysconfig.get_config_vars()
# 	for key, value in cfg_vars.items():
# 		if type(value) == str:
# 			processedValue = value
# 			
# 			processedValue = processedValue.replace("-Wstrict-prototypes", "")
# 			processedValue = processedValue.replace("-Wall", "")
# 			processedValue = processedValue.replace("-Werror=format-security", "")
# 			processedValue = processedValue.replace("-Wformat", "")
# 			processedValue = processedValue.replace("-Wunused-result", "")
# 			processedValue = processedValue.replace("-D_FORTIFY_SOURCE=2", "")
# 			
# 			cfg_vars[key] = processedValue
# 			
# 			#if value!=processedValue:
# 			#	print key, ":", value


# Build libf2c
if platform.system()=='Windows':
	libf2cpath=os.path.join("src", "libf2c")
else:
	libf2cpath=os.path.join("src", "libf2c")
	
if not os.path.exists(os.path.join(libf2cpath, "vcf2c.lib")):
	libf2cOK=False
	wd=os.getcwd()
	
	if platform.system()=='Windows':
		# Windows AMD64
		os.chdir("src")
		os.chdir("libf2c")
			
		if os.system("nmake -f makefile.vc"):
			print("Failed to compile libf2c.")
		else:
			print("Compiled libf2c successfully.")
			libf2cOK=True
	else:
		os.chdir("src")
		os.chdir("libf2c")
			
		if os.system("make -f makefile.u"):
			print("Failed to compile libf2c.")
		else:
			print("Compiled libf2c successfully.")
			libf2cOK=True
	
	os.chdir(wd)
else:
	libf2cOK=True


# Extensions
ext_modules=[
	Extension(
		'pyopus.simulator._rawfile', 
		['src/rawfile/rawfile.c'], 
		include_dirs=include_dirs, 
		define_macros=define_macros, 
	), 
	Extension(
		'pyopus.simulator._hspice_read', 
		['src/hspicefile/hspice_read.c'], 
		include_dirs=include_dirs, 
		define_macros=define_macros, 
	), 
	Extension( 
		'pyopus.misc._ghalton', 
		["src/ghalton/Halton_wrap.cpp", "src/ghalton/Halton.cpp"], 
		include_dirs=include_dirs, 
		define_macros=define_macros, 
	),
	Extension( 
		'pyopus.misc._sobol', 
		["src/sobol/sobol.c"], 
		include_dirs=include_dirs, 
		define_macros=define_macros, 
		libraries = cxxlib, 
	),
	Extension( 
		'pyopus.problems._mads', 
		["src/mads/mads.c", "src/mads/mdo.cpp",
		 "src/mads/styrene/bb.cpp", 
		 "src/mads/styrene/burner.cpp",
		 "src/mads/styrene/cashflow.cpp",
		 "src/mads/styrene/chemical.cpp",
		 "src/mads/styrene/column.cpp",
		 "src/mads/styrene/combrx.cpp",
		 "src/mads/styrene/flash.cpp",
		 "src/mads/styrene/heatx.cpp",
		 "src/mads/styrene/mix.cpp",
		 "src/mads/styrene/pfr.cpp",
		 "src/mads/styrene/profitability.cpp", 
		 "src/mads/styrene/pump.cpp", 
		 "src/mads/styrene/reaction.cpp", 
		 "src/mads/styrene/servor.cpp", 
		 "src/mads/styrene/split.cpp", 
		 "src/mads/styrene/stream.cpp", 
		 "src/mads/styrene/thermolib.cpp"
		], 
		include_dirs=include_dirs, 
		define_macros=define_macros, 
		libraries = cxxlib, 
	),
	Extension( 
		'pyopus.problems._cec13', 
		["src/cec13/test_func.cpp", 
		 "src/cec13/cec13.cpp",
		], 
		include_dirs=include_dirs, 
		define_macros=define_macros, 
		libraries = cxxlib, 
	), 
]

if libf2cOK:
	# TODO: compile .f files to .c using f2c
	# Currently all .f files are precompiled with f2c. 
	
	# f2c is included via a proxy f2c.h file because adding libf2c to the include path triggers infinite include 
	# recursion under MSVC. 
	
	# Add FORTRAN modules built with f2c
	ext_modules.extend([
		Extension( 
			'pyopus.problems._mwbm', 
			["src/mwbm/mwbm.c", "src/mwbm/dfovec.c", "src/mwbm/dfoxs.c"], 
			include_dirs=include_dirs, 
			define_macros=define_macros, 
			libraries = f2clib,
			library_dirs = [libf2cpath], 
		extra_compile_args=extra_compile_args, 
		), 
		Extension( 
			'pyopus.problems._lvu', 
			["src/lvu/lvu.c", "src/lvu/test28.c"], 
			include_dirs=include_dirs, 
			define_macros=define_macros, 
			libraries = f2clib,
			library_dirs = [libf2cpath], 
			extra_compile_args=extra_compile_args, 
		), 
		Extension( 
			'pyopus.problems._lvns', 
			["src/lvns/lvns.c", "src/lvns/lvlcmm.c", "src/lvns/lvumm.c", "src/lvns/lvuns.c"], 
			include_dirs=include_dirs, 
			define_macros=define_macros, 
			libraries = f2clib,
			library_dirs = [libf2cpath], 
			extra_compile_args=extra_compile_args, 
		),
		Extension( 
			'pyopus.problems._karmitsa', 
			["src/karmitsa/karmitsa.c", "src/karmitsa/tnsboc.c", "src/karmitsa/tnsiec.c", "src/karmitsa/tnsunc.c"], 
			include_dirs=include_dirs, 
			define_macros=define_macros, 
			libraries = f2clib,
			library_dirs = [libf2cpath], 
			extra_compile_args=extra_compile_args, 
		), 
	])
else:
	print("FORTRAN modules _mwbm, _lvu, _lvns. and _karmitsa will not be built.")


# Settings
setup(
	packages=[
		'pyopus', 
		'pyopus.design',
		'pyopus.gui', 
		'pyopus.evaluator', 
		'pyopus.misc', 
		'pyopus.optimizer',
		'pyopus.parallel', 
		'pyopus.problems', 
		'pyopus.simulator',
		'pyopus.netlister', 
		'pyopus.plotter'
	],
	ext_modules=ext_modules
)
