from PyQt5.QtWidgets import *
from PyQt5.QtGui import *
from PyQt5.QtCore import *

from .tasks import taskTypeList, taskTitle

__all__ = [ 'QPCreateTaskDialog' ]

from pprint import pprint

class QPCreateTaskDialog(QDialog):
	def __init__(self, parent=None, *args):
		QDialog.__init__(self, parent, *args)
		
		self.setWindowTitle("Select task type")
		
		vb=QVBoxLayout(self)
		
		vb.addWidget(QLabel("What kind of task do you want to create?", self))
		
		first=True
		self.rblist=[]
		for taskType, taskVariant, taskName in taskTypeList:
			b=QRadioButton(taskName)
			vb.addWidget(b)
			if first:
				b.setChecked(True)
			self.rblist.append(b)
				
			first=False
		
		vb.addStretch(1)
		
		buttonBox=QDialogButtonBox(
			QDialogButtonBox.Ok |
			QDialogButtonBox.Cancel
		)
		vb.addWidget(buttonBox)
		
		buttonBox.accepted.connect(self.accept)
		buttonBox.rejected.connect(self.reject)
	
	def getTaskType(self):
		for ii in range(len(self.rblist)):
			if self.rblist[ii].isChecked():
				return taskTypeList[ii][0], taskTypeList[ii][1]
		return None
		
if __name__=='__main__':
	import sys
	
	app = QApplication(sys.argv)
	
	w=QPCreateTaskDialog()
	
	w.show()
	
	ret=w.exec()==QDialog.Accepted
	
	print(ret)
	print(w.getTaskType())
	
