from PyQt5.QtWidgets import *
from PyQt5.QtGui import *
from PyQt5.QtCore import *

from editgroup import *
from table import *
from values import simulators, blankHead
from delegates import QPComboBoxDelegate

from cbdnew import newCBDTask as newTask

__all__ = [ 'QPEditTasks' ]

# TODO: wizard for new task creation

taskTranslator = {
	"cbd": "Design/evaluation across corners", 
	"monte": "Monte Carlo analysis"
}

class QPTasksTableModel(QPTableModel):
	def __init__(self, data, parent=None, *args):
		QPTableModel.__init__(
			self, data, 
			header=[ "Task name", "Task type" ],
			editable=[True, False], 
			dfl=blankHead, 
			parent=None, *args
		)
	
	# For display role the text is used, but otherwise codes are stored
	# Need to override these two because we are accessing stuff deeper in the data structure
	def data(self, index, role):
		if not index.isValid():
			return None
		elif role == Qt.DisplayRole or role == Qt.EditRole:
			row=index.row()
			col=index.column()
			if col==0:
				return QVariant(self.mylist[row][0])
			elif col==1:
				if role == Qt.DisplayRole:
					return QVariant(taskTranslator[self.mylist[row][1]["type"]])
				else:
					return None
			else:
				return None
		else:
			return None
	
	def setData(self, index, value, role):
		row=index.row()
		col=index.column()
		if col==0 and self.mylist[row][0]!=value :
			self.mylist[row][0]=value 
		else:
			return False
		
		self.dataChanged.emit(index, index)
		return True
	
	
class QPEditTasks(QPEditGroup):
	def __init__(self, data=None, parent=None, *args):
		QPEditGroup.__init__(
			self, QPTasksTableModel, data=data, 
			parent=parent, *args
		)
		
		self.newTask=QPushButton("New design/evaluation across corners", self)
		
		layout = QVBoxLayout(self)
		
		layout.setSpacing(4)
		# Layout should set the minimum and maximum size of the widget
		layout.setSizeConstraint(QLayout.SetMinAndMaxSize);
		
		self.tab=QPTable(
			self.model, 
			canCreate=False, canMove=False, 
			buttons=False, parent=self
		)
		
		hl=QHBoxLayout()
		hl.addWidget(self.newTask)
		hl.addStretch(1)
		layout.addLayout(hl)
		layout.addWidget(QLabel("Design tasks", self))
		layout.addWidget(self.tab)
		
		# Add a stretch at the bottom so that when member widgets shrink they are ordered at the top
		layout.addStretch(1)
		self.setLayout(layout)
		
		self.newTask.clicked.connect(self.createTask)
		
		# Register model/view pairs
		self.registerModelView(self.model, self.tab)
		
	@pyqtSlot(bool)
	def createTask(self, checked):
		task=newTask(self.rootData)
		
		if task is not None:
			self.tab.extendData([task])
	
