from copy import deepcopy
from . import values
from pprint import pprint

__all__ = [ "convertProject", "convertConfig", "convertPostprocessing" ]

def convertProject(data):
	converted=False
	
	if data['info']['version']=="1.0":
		# Collect analysis names
		names=set()
		for name, anDict in data["analyses"]:
			names.add(name)
		
		# Generate blank analysis name
		if "blank" not in names:
			blankName="blank"
		else:
			ii=0
			while True:
				blankName = f"blank{ii}"
				if blankName not in names:
					break
				ii+=1
		
		# Choose first head name
		if len(data["heads"])>0:
			hName=data["heads"][0][0]
		else:
			hName=""
		
		# Add blank analysis
		an=deepcopy(values.blankAnalysis)
		an[0]=blankName
		an[1]["head"]=hName
		data["analyses"].append(
			an
		)
		
		# Convert measure definitions (None -> blank analysis)
		for name, measDict in data["measures"]:
			if len(measDict["analysis"].strip())<1:
				measDict["analysis"]=blankName
		
		# Convert statistical parameters (remove lo, hi entries)
		for row in data['statpar']:
			del row[2]
			del row[1]
		
		# Change version to 2.0
		data['info']['version']="1.1"
		
		converted=True
		
	if data['info']['version']=="1.1":
		return "OK", converted
	
	return (f"Failed at format verion {data['info']['version']}."), False
	
def convertConfig(cfg):
	converted=False
	
	if cfg["version"]=="1.0":
		cfg["version"]="1.1"
		
		converted=True
		
	if cfg["version"]=="1.1":
		return "OK", converted
	
	return (f"Failed at format version {cfg['version']}."), False
	
def convertPostprocessing(pp):
	converted=False
	
	if pp["version"]=="1.0":
		pp["version"]="1.1"
		
		# Reorganize plots
		plt=pp['plots']
		pp['plots']={
			'plotlist': plt, 
			'styles': deepcopy(values.blankPostprocessing['plots']['styles'])
		}
		
		converted=True
		
	if pp["version"]=="1.1":
		return "OK", converted
	
	return (f"Failed at format version {pp['version']}."), False
	
