from .dumptools import statMeanValues, QPDumpError

from copy import deepcopy

__all__ = [ 'newCBDTask', 'blankCBDTask' ]

blankCBDTask={
	'type': 'cbd', 
	'description': "", 
	'requirements': [], 
	'designpar': [],
	'corners': [], 
	'settings': {
		'aggregatorsettings': [],
		'evaluatorsettings': [],
		'failurepenalty': '1e6',
		'forwardsolution': True,
		'maxiter': '',
		'stoptol': '1e-5',
		'initialstep': '0.25', 
		'method': 'noneFull',
		'optimizersettings': [],
		'relevantcorners': True,
		'stopsatisfied': True,
		'tradeoffmultiplier': '0',
	}, 
	'output': {
		'aggregatordebug': '0',
		'evaluatordebug': '0',
		'optimizerdebug': '0',
		'keepfiles': False, 
		'saveallresults': False,
		'savewaveforms': 'verification',
		'simulatordebug': '0',
		'taskdebug': '1'
	}, 
	'mpi': {
		'processors': '',
		'mirror': True, 
		'persistent': True, 
		'vmdebug': '0', 
		'cosdebug': '0'  
	},
}

def newCBDTask(root, variant='eval'):
	task=deepcopy([ "New_task_evaluate", blankCBDTask ])
	
	# Copy measures as requirements
	tmp=[]
	for row in root['measures']:
		tmp.append([True, row[0], row[1]['lower'], row[1]['upper'], row[1]['norm'], ''])
		
	task[1]['requirements']=tmp
	
	# Copy design parameters
	tmp=[]
	for row in root['designpar']:
		tmp.append([row[0], row[1], row[2], row[3]])
		
	task[1]['designpar']=tmp
	
	# Create nominal corner
	
	tmp=[]
	for row in root['oppar']:
		tmp.append([row[0], row[1]])
	
	
	# Extract statistical parameter mean values
	try:
		statMean, statNames = statMeanValues(root)
	except QPDumpError as e:
		raise QPDumpError(str(e)+"\nNew CBD task cannot be created because an error occurred during evaluation of statistical parameter mean values.")
	
	for name in statNames:
		tmp.append([name, str(statMean[name])])
	
	tmpheads=[]
	for head in root['heads']:
		tmpheads.append([ head[0] ])
		
	corner=[ 
		'nominal', {
			'heads': tmpheads, 
			'modules': [], 
			'params': tmp, 
		}
	]
	
	task[1]['corners'].append(corner)
	
	if variant=='local':
		task[0]="New_task_local"
		task[1]['settings']['method']='QPMADS'
	elif variant=='global':
		task[0]="New_task_global"
		task[1]['settings']['method']='ParallelSADE'
		
	return task
