# -*- coding: UTF-8 -*-
"""
PyOPUS is a library for simulation-based optimization of arbitrary systems. 
It was developed with circuit optimization in mind. The library is the basis 
for the PyOPUS GUI that provides a simple way for setting up design automation 
tasks. In the GUI you can also view the the results and plot the 
waveforms generated by the simulator. 
"""

from .misc.identify import locationID 

__all__ = [ 'PyOpusError' ]

try:
	from ._version import __version__
except:
	__version__ = "unknown"

# print(f"PyOPUS library, version {__version__} @ {locationID()}, (c)2008-2025 Arpad Buermen")


class PyOpusError(Exception):
	def __init__(self, message, *args):
		super(PyOpusError, self).__init__(message, *args)
