* Mismatch model of NMOS and PMOS, Spice Opus
*   w, l, m    ... MOS parameters
*   vtmm, u0mm ... normalized mismatch (+1 means +1 sigma)

.subckt submodn drain gate source bulk param: w l m=1 vtmm=0 u0mm=0
.param sqrtarea=sqrt(w*l*m)
.param vvt=vtmm*(5e-3*1e-6/sqrtarea/sqrt(2))
.param vu0r=u0mm*(1.04e-2*1e-6/sqrtarea/sqrt(2))
* This simple model may exhibit discontinuity or even exceed limits on channel length
*vgmm (gate gate_int) dc={vvt}
*m0 (drain gate_int source bulk) nmosmod w={w*(1+vu0r)} l={l} m={m} ad={w*0.18u} as={w*0.18u} pd={2*(w+0.18u)} ps={2*(w+0.18u)} nrs={0.18u/w} nrd={0.18u/w}
* This one is better
m0 (drain gate source bulk) nmosmod w={w} l={l} m={m} ad={w*0.18u} as={w*0.18u} pd={2*(w+0.18u)} ps={2*(w+0.18u)} nrs={0.18u/w} nrd={0.18u/w} vth0_absdelta={vvt} u0_reldelta={vu0r}
.ends

.subckt submodp drain gate source bulk param: w l m=1 vtmm=0 u0mm=0
.param sqrtarea=sqrt(w*l*m)
.param vvt=vtmm*(5.49e-3*1e-6/sqrtarea/sqrt(2))
.param vu0r=u0mm*(0.99e-2*1e-6/sqrtarea/sqrt(2))
* This simple model may exhibit discontinuity or even exceed limits on channel length
*vgmm (gate gate_int) dc={vvt}
*m0 (drain gate_int source bulk) pmosmod w={w*(1+vu0r)} l={l} m={m} ad={w*0.18u} as={w*0.18u} pd={2*(w+0.18u)} ps={2*(w+0.18u)} nrs={0.18u/w} nrd={0.18u/w}
* This one is better
m0 (drain gate source bulk) pmosmod w={w*(1+vu0r)} l={l} m={m} ad={w*0.18u} as={w*0.18u} pd={2*(w+0.18u)} ps={2*(w+0.18u)} nrs={0.18u/w} nrd={0.18u/w} vth0_absdelta={vvt} u0_reldelta={vu0r}
.ends

* cmrr 8.74552e+01 builtin BSIM3 MM model
* cmrr 8.77702e+01 subcircuit MM model
