* SUBROUTINE TIUD28                ALL SYSTEMS                92/12/01
C PORTABILITY : ALL SYSTEMS
C 92/12/01 LU : ORIGINAL VERSION
*
* PURPOSE :
*  INITIAL VALUES OF VARIABLES FOR DENSE UNCONSTRAINED MINIMIZATION.
*
* PARAMETERS :
*  II  N  NUMBER OF VARIABLES.
*  RO  X(N)  VECTOR OF VARIABLES.
*  RO  FMIN  LOWER BOUND FOR THE OBJECTIVE FUNCTION.
*  RO  XMAX  MAXIMUM STEPSIZE.
*  II  NEXT  NUMBER OF THE TEST PROBLEM.
*  IO  IERR  ERROR INDICATOR.
*
      SUBROUTINE TIUD28(N,X,FMIN,XMAX,NEXT,IERR)
      INTEGER N,NA,NEXT,IERR
      REAL*8 X(N),FMIN,XMAX
      REAL*8 P,Q,ALF,BET,GAM,F,S,S1,T,Z(1000)
      INTEGER I,J,K,M,N1
      REAL*8 Y(20),PAR
      COMMON /EMPR28/ Y,PAR,NA,M
      REAL*8 ETA9
      PARAMETER (ETA9=1.0D 120)
      FMIN=0.0D 0
      XMAX=1.0D 3
      IERR=0
      NA=N
      GO TO (10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,
     &  170,180,190,200,210,220,230,250,310,320,330,350,370,390,400,
     &  450,460,470,480,490,500,510,520,530,540,550,560,570,580,590,
     &  600,610,620,630,720,740,750,760,780,790,810,830,840,860,870,
     &  880,900,910,920,930,940,950,960,970,980,990,800,240,410,420,
     &  650,660,670,680,690,340,360,380,430,440,270,280,290,300,710,
     &  820),NEXT
   10 IF (N.LT.2) GO TO 999
      N=N-MOD(N,2)
      DO 11 I=1,N
        IF(MOD(I,2).EQ.1) THEN
          X(I)=-1.2D 0
        ELSE
          X(I)=1.0D 0
        ENDIF
   11 CONTINUE
      RETURN
   20 IF (N.LT.4) GO TO 999
      N=N-MOD(N,2)
      DO 21 I=1,N
        IF(MOD(I,2).EQ.1) THEN
          X(I)=-2.0D 0
          IF(I.LE.4) X(I)=-3.0D 0
        ELSE
          X(I)=0.0D 0
          IF(I.LE.4) X(I)=-1.0D 0
        ENDIF
   21 CONTINUE
      RETURN
   30 IF (N.LT.4) GO TO 999
      N=N-MOD(N,2)
      DO 31 I=1,N
        IF(MOD(I,4).EQ.1) THEN
          X(I)=3.0D 0
        ELSEIF(MOD(I,4).EQ.2) THEN
          X(I)=-1.0D 0
        ELSEIF(MOD(I,4).EQ.3) THEN
          X(I)=0.0D 0
        ELSE
          X(I)=1.0D 0
        ENDIF
   31 CONTINUE
      RETURN
   40 IF (N.LT.4) GO TO 999
      N=N-MOD(N,2)
      DO 41 I=1,N
        X(I)=2.0D 0
   41 CONTINUE
      X(1)=1.0D 0
      RETURN
   50 IF (N.LT.3) GO TO 999
      DO 51 I=1,N
        X(I)=-1.0D 0
   51 CONTINUE
      RETURN
   60 IF (N.LT.7) GO TO 999
      DO 61 I=1,N
        X(I)=-1.0D 0
   61 CONTINUE
      RETURN
   70 IF (N.LT.4) GO TO 999
      N=N-MOD(N,2)
      DO 71 I=1,N
        X(I)=-1.0D 0
   71 CONTINUE
      RETURN
   80 IF (N.LT.6) GO TO 999
      DO 81 I=1,N
        X(I)=1.0D 0/DBLE(N)
   81 CONTINUE
      RETURN
   90 IF (N.LT.6) GO TO 999
      DO 91 I=1,N
        X(I)=1.0D 0/DBLE(N)
   91 CONTINUE
      FMIN=-ETA9
      RETURN
  100 IF (N.LT.6) GO TO 999
      DO 101 I=1,N
        X(I)=1.0D 0
  101 CONTINUE
      FMIN=-ETA9
      RETURN
  110 IF (N.LT.5) GO TO 999
      N=N-MOD(N,5)
      DO 111 I=0,N-5,5
        X(I+1)=-1.0D 0
        X(I+2)=-1.0D 0
        X(I+3)=2.0D 0
        X(I+4)=-1.0D 0
        X(I+5)=-1.0D 0
  111 CONTINUE
      X(1)=-2.0D 0
      X(2)=2.0D 0
      XMAX=1.0D 0
      RETURN
  120 IF (N.LT.2) GO TO 999
      N=N-MOD(N,2)
      DO 121 I=2,N,2
        X(I-1)=0.0D 0
        X(I)=-1.0D 0
  121 CONTINUE
      XMAX=1.0D 1
      RETURN
  130 IF (N.LT.2) GO TO 999
      N=N-MOD(N,2)
      DO 131 I=2,N,2
        X(I-1)=-1.0D 0
        X(I)=1.0D 0
  131 CONTINUE
      XMAX=1.0D 1
      RETURN
  140 IF (N.LT.3) GO TO 999
      P=1.0D 0/DBLE(N+1)
      DO 141 I=1,N
        Q=P*DBLE(I)
        X(I)=Q*(1.0D 0-Q)
  141 CONTINUE
      RETURN
  150 IF (N.LT.3) GO TO 999
      P=1.0D 0/DBLE(N+1)
      DO 151 I=1,N
        X(I)=DBLE(I)*DBLE(N+1-I)*P**2
  151 CONTINUE
      FMIN=-ETA9
      RETURN
  160 IF (N.LT.3) GO TO 999
      DO 161 I=1,N
        X(I)=1.0D 0
  161 CONTINUE
      FMIN=-ETA9
      RETURN
  170 IF (N.LT.3) GO TO 999
      P=1.0D 0/DBLE(N+1)
      DO 171 I=1,N
        X(I)=DBLE(I)*DBLE(N+1-I)*P**2
  171 CONTINUE
      FMIN=-ETA9
      RETURN
  180 IF (N.LT.3) GO TO 999
      P=1.0D 0/DBLE(N+1)
      DO 181 I=1,N
        X(I)=DBLE(I)*DBLE(N+1-I)*P**2
  181 CONTINUE
      FMIN=-ETA9
      RETURN
  190 IF (N.LT.3) GO TO 999
      P=EXP(2.0D 0)/DBLE(N+1)
      DO 191 I=1,N
        X(I)=(P*DBLE(I)+1.0D 0)/3.0D 0
  191 CONTINUE
      FMIN=-ETA9
      RETURN
  200 IF (N.LT.3) GO TO 999
      P=1.0D 0/DBLE(N+1)
      DO 201 I=1,N
        X(I)=P*DBLE(I)
  201 CONTINUE
      FMIN=-ETA9
      RETURN
  210 IF (N.LT.3) GO TO 999
      P=1.0D 0/DBLE(N+1)
      DO 211 I=1,N
        X(I)=P*DBLE(I)+1.0D 0
  211 CONTINUE
      FMIN=-ETA9
      RETURN
  220 IF (N.LT.3) GO TO 999
      P=1.0D 0/DBLE(N+1)
      DO 221 I=1,N
        X(I)=DBLE(I)*DBLE(N+1-I)*P**2
  221 CONTINUE
      FMIN=-ETA9
      RETURN
  230 IF (N.LT.3) GO TO 999
      DO 231 I=1,N
        X(I)=0.5D 0
  231 CONTINUE
      RETURN
  250 IF (N.LT.3) GO TO 999
      P=1.0D 0/DBLE(N+1)
      DO 251 I=1,N
        X(I)=DBLE(I)*P
  251 CONTINUE
      XMAX=1.0D 0
      RETURN
  310 IF(N.GE.2) THEN
      N=N-MOD(N,2)
      NA=N
      DO 311 I=1,N
      IF(MOD(I,2).EQ.1) THEN
      X(I)=-1.2D 0
      ELSE
      X(I)=1.0D 0
      ENDIF
  311 CONTINUE
      ELSE
      IERR=1
      ENDIF
      RETURN
  320 IF(N.GE.4) THEN
      N=N-MOD(N,4)
      NA=N
      DO 321 I=1,N
      IF (MOD(I,4).EQ.1) THEN
      X(I)=3.0D 0
      ELSE IF(MOD(I,4).EQ.2) THEN
      X(I)=-1.0D 0
      ELSEIF(MOD(I,4).EQ.3) THEN
      X(I)=0.0D 0
      ELSE
      X(I)=1.0D 0
      ENDIF
  321 CONTINUE
      ELSE
      IERR=1
      ENDIF
      RETURN
  330 IF(N.GE.2) THEN
      NA=N+1
      DO 331 I=1,N
      X(I)=DBLE(I)
  331 CONTINUE
      ELSE
      IERR=1
      ENDIF
      RETURN
  350 IF(N.GE.2) THEN
      NA=N+2
      DO 351 I=1,N
      X(I)=1.0D 0-DBLE(I)/DBLE(N)
  351 CONTINUE
      XMAX=1.0D 2
      ELSE
      IERR=1
      ENDIF
      RETURN
  370 IF(N.GE.2) THEN
      DO 371 I=1,N
      X(I)=0.5D 0
  371 CONTINUE
      ELSE
      IERR=1
      ENDIF
      RETURN
  390 IF(N.GE.2) THEN
      DO 391 I=1,N
      X(I)=DBLE(I)/DBLE(N+1)
      X(I)=X(I)*(X(I)-1.0D 0)
  391 CONTINUE
      ELSE
      IERR=1
      ENDIF
      RETURN
  400 IF(N.GE.2) THEN
      DO 401 I=1,N
      X(I)=-1.0D 0
  401 CONTINUE
      ELSE
      IERR=1
      ENDIF
  450 IF (N.LT.3) GO TO 999
      DO 451 I=1,N
        X(I)=-1.0D 0
  451 CONTINUE
      RETURN
  460 IF (N.LT.6) GO TO 999
      DO 461 I=1,N
        X(I)=-1.0D 0
  461 CONTINUE
      RETURN
  470 IF (N.LT.2) GO TO 999
      DO 471 I=1,N-1
        X(I)=0.5D 0
  471 CONTINUE
      X(N)=-2.0D 0
      NA=2*(N-1)
      RETURN
  480 IF (N.LT.4) GO TO 999
      N=N-MOD(N,4)
      DO 481 I=1,N
        X(I)=SIN(DBLE(I))**2
  481 CONTINUE
      NA=5*N
      RETURN
  490 IF (N.LT.4) GO TO 999
      N=N-MOD(N,2)
      DO 491 I=1,N
        X(I)=5.0D 0
  491 CONTINUE
      NA=3*(N-2)
      RETURN
  500 IF (N.LT.2) GO TO 999
      DO 501 I=1,N
        X(I)=0.2D 0
  501 CONTINUE
      NA=2*(N-1)
      RETURN
  510 CONTINUE
      IF (N.LT.2) GO TO 999
      N=N-MOD(N,2)
      DO 511 I=1,N
        IF(MOD(I,2).EQ.1) THEN
          X(I)=-0.8D 0
        ELSE
          X(I)=-0.8D 0
        ENDIF
  511 CONTINUE
      NA=2*(N-1)
      RETURN
  520 CONTINUE
      IF (N.LT.5) GO TO 999
      IF (MOD(N-5,3).NE.0) N=N-MOD(N-5,3)
      DO 521 I=1,N
        X(I)=-1.0D 0
  521 CONTINUE
      NA=6*((N-5)/3+1)
      RETURN
  530 CONTINUE
      IF (N.LT.5) GO TO 999
      IF (MOD(N-5,3).NE.0) N=N-MOD(N-5,3)
      DO 531 I=1,N
        X(I)=-1.0D 0
  531 CONTINUE
      NA=7*((N-5)/3+1)
      RETURN
  540 CONTINUE
      IF (N.LT.4) GO TO 999
      DO 541 I=1,N
        IF (MOD(I,4).EQ.1) THEN
          X(I)=-0.8D 0
        ELSE IF (MOD(I,4).EQ.2) THEN
          X(I)= 1.2D 0
        ELSE IF (MOD(I,4).EQ.3) THEN
          X(I)=-1.2D 0
        ELSE
          X(I)= 0.8D 0
        ENDIF
  541 CONTINUE
      Y(1)=14.4D 0
      Y(2)=6.8D 0
      Y(3)=4.2D 0
      Y(4)=3.2D 0
  542 IF (MOD(N-4,2).NE.0) N=N-MOD(N-4,2)
      NA=4*((N-4)/2+1)
      RETURN
  550 CONTINUE
      IF (N.LT.4) GO TO 999
      DO 551 I=1,N
        IF (MOD(I,4).EQ.1) THEN
          X(I)=-0.8D 0
        ELSE IF (MOD(I,4).EQ.2) THEN
          X(I)= 1.2D 0
        ELSE IF (MOD(I,4).EQ.3) THEN
          X(I)=-1.2D 0
        ELSE
          X(I)= 0.8D 0
        ENDIF
  551 CONTINUE
      Y(1)=35.8D 0
      Y(2)=11.2D 0
      Y(3)=6.2D 0
      Y(4)=4.4D 0
      GO TO 542
  560 CONTINUE
      IF (N.LT.4) GO TO 999
      DO 561 I=1,N
        IF (MOD(I,4).EQ.1) THEN
          X(I)=-0.8D 0
        ELSE IF (MOD(I,4).EQ.2) THEN
          X(I)= 1.2D 0
        ELSE IF (MOD(I,4).EQ.3) THEN
          X(I)=-1.2D 0
        ELSE
          X(I)= 0.8D 0
        ENDIF
  561 CONTINUE
      Y(1)=30.6D 0
      Y(2)=72.2D 0
      Y(3)=124.4D 0
      Y(4)=187.4D 0
      GO TO 542
  570 IF (N.LT.4) GO TO 999
      N=N-MOD(N,2)
      NA=N
      DO 571 I=1,N
        IF (MOD(I,8).EQ.1) X(I)=1.0D-1
        IF (MOD(I,8).EQ.2.OR.MOD(I,8).EQ.0) X(I)=2.0D-1
        IF (MOD(I,8).EQ.3.OR.MOD(I,8).EQ.7) X(I)=3.0D-1
        IF (MOD(I,8).EQ.4.OR.MOD(I,8).EQ.6) X(I)=4.0D-1
        IF (MOD(I,8).EQ.5) X(I)=5.0D-1
  571 CONTINUE
      RETURN
  580 IF (N.LT.3) GO TO 999
      DO 581 I=1,N
        X(I)=1.2D 1
  581 CONTINUE
      XMAX=1.0D 1
      RETURN
  590 IF (N.LT.7) GO TO 999
      DO 591 I=1,N
        X(I)=-1.0D 0
  591 CONTINUE
      RETURN
  600 IF (N.LT.3) GO TO 999
      DO 601 I=1,N
        X(I)=DBLE(I)/DBLE(N+1)
        X(I)=X(I)*(X(I)-1.0D 0)
  601 CONTINUE
      RETURN
  610 CONTINUE
      IF (N.LT.5) GO TO 999
      IF (MOD(N-5,3).NE.0) N=N-MOD(N-5,3)
      DO 611 I=1,N
        X(I)=-1.0D 0
  611 CONTINUE
      NA=7*((N-5)/3+1)
      RETURN
  620 IF (N.LT.3) GO TO 999
      DO 621 I=1,N
        IF(MOD(I,2).EQ.1) THEN
          X(I)=-1.2D 0
        ELSE
          X(I)= 1.0D 0
        ENDIF
  621 CONTINUE
      NA=2*(N-1)
      RETURN
  630 IF (N.LT.7) GO TO 999
      DO 631 I=1,N
        X(I)=5.0D 0
  631 CONTINUE
      Y(1)=SIN(1.0D 0)
      NA=13*(N-6)
      RETURN
  720 IF(N.GE.5) THEN
      N=N-MOD(N,2)
      NA=N
      DO 721 I=1,N
      IF (MOD(I,8).EQ.1) X(I)=1.0D-1
      IF (MOD(I,8).EQ.2.OR.MOD(I,8).EQ.0) X(I)=2.0D-1
      IF (MOD(I,8).EQ.3.OR.MOD(I,8).EQ.7) X(I)=3.0D-1
      IF (MOD(I,8).EQ.4.OR.MOD(I,8).EQ.6) X(I)=4.0D-1
      IF (MOD(I,8).EQ.5) X(I)=5.0D-1
  721 CONTINUE
      ELSE
      IERR=1
      ENDIF
      RETURN
  740 IF(N.GE.3) THEN
      DO 741 I=1,N
      X(I)=0.0D 0
  741 CONTINUE
      ELSE
      IERR=1
      ENDIF
      RETURN
  750 IF(N.GE.3) THEN
      IF (MOD(N,2).NE.1) N=N-1
      NA=N
      DO 751 I=1,N
      X(I)=1.0D 0
  751 CONTINUE
      ELSE
      IERR=1
      ENDIF
      RETURN
  760 IF(N.GE.3) THEN
      DO 761 I=1,N
      X(I)=-1.0D 0
  761 CONTINUE
      ELSE
      IERR=1
      ENDIF
      RETURN
  780 IF(N.GE.5) THEN
      DO 781 I=1,N
      X(I)=-2.0D 0
  781 CONTINUE
      ELSE
      IERR=1
      ENDIF
      RETURN
  790 IF(N.GE.7) THEN
      DO 791 I=1,N
      X(I)=-3.0D 0
  791 CONTINUE
      XMAX=1.0D 1
      ELSE
      IERR=1
      ENDIF
      RETURN
  810 IF(N.GE.2) THEN
      N=N-MOD(N,2)
      NA=N
      DO 811 I=1,N
      IF(MOD(I,2).EQ.1) THEN
      X(I)=9.0D 1
      ELSE
      X(I)=6.0D 1
      ENDIF
  811 CONTINUE
      ELSE
      IERR=1
      ENDIF
      RETURN
  830 IF(N.GE.4) THEN
      N=N-MOD(N,4)
      NA=N
      DO 831 I=1,N
      IF (MOD(I,4).EQ.1) THEN
      X(I)=1.0D 0
      ELSE IF(MOD(I,4).EQ.2) THEN
      X(I)=2.0D 0
      ELSEIF(MOD(I,4).EQ.3) THEN
      X(I)=2.0D 0
      ELSE
      X(I)=2.0D 0
      ENDIF
  831 CONTINUE
      XMAX=1.0D 1
      ELSE
      IERR=1
      ENDIF
      RETURN
  840 IF(N.GE.3) THEN
      DO 841 I=1,N
      X(I)=-1.0D 0
  841 CONTINUE
      ELSE
      IERR=1
      ENDIF
      RETURN
  860 IF(N.GE.2) THEN
      N=N-MOD(N,2)
      NA=N
      DO 861 I=1,N
      IF (MOD(I,2).EQ.1) THEN
      X(I)=0.0D 0
      ELSE
      X(I)=1.0D 0
      ENDIF
  861 CONTINUE
      ELSE
      IERR=1
      ENDIF
      RETURN
  870 IF (N.GE.4) THEN
      N=N-MOD(N,4)
      NA=N
      DO 871 I=2,N,2
      X(I-1)=-3.0D 0
      X(I)=-1.0D 0
  871 CONTINUE
      ELSE
      IERR=1
      ENDIF
      RETURN
  880 IF (N.GE.3) THEN
      DO 881 I=1,N
      X(I)=1.5D 0
  881 CONTINUE
      XMAX=1.0D 0
      ELSE
        IERR=1
      ENDIF
      RETURN
  900 IF(N.GE.3) THEN
      DO 901 I=1,N
      X(I)=1.0D 1
  901 CONTINUE
      ELSE
      IERR=1
      ENDIF
      RETURN
  910 IF (N.GE.3) THEN
      DO 911 I=1,N
      X(I)=1.0D 0
  911 CONTINUE
      PAR=1.0D 1
      ELSE
        IERR=1
      ENDIF
      RETURN
  920 IF (N.GE.5) THEN
      PAR=5.0D 2/DBLE(N+2)
      DO 921 I=1,N
      X(I)=((DBLE(I)+0.5D 0)/DBLE(N+2)-0.5D 0)**2
  921 CONTINUE
      ELSE
        IERR=1
      ENDIF
      RETURN
  930 IF (N.GE.10) THEN
      N=N-MOD(N,2)
      M=N/2
      PAR=5.0D 2
      NA=N
      DO 931 I=1,M
      X(I)=(DBLE(I)/DBLE(M+1)-0.5D 0)**2
  931 CONTINUE
      DO 932 I=M+1,N
      K=I-M
      X(I)=DBLE(K)/DBLE(M+1)-0.5D 0
  932 CONTINUE
      ELSE
        IERR=1
      ENDIF
      RETURN
  940 IF (N.GE.16) THEN
      M=INT(SQRT(DBLE(N)))
      PAR=6.8D 0/DBLE(M+1)**2
      N=M*M
      K=0
      DO 942 J=1,M
      DO 941 I=1,M
      K=K+1
      X(K)=0.0D 0
  941 CONTINUE
  942 CONTINUE
      NA=N
      ELSE
      IERR=1
      ENDIF
      RETURN
  950 IF (N.GE.16) THEN
      M=INT(SQRT(DBLE(N)))
      PAR=1.0D 0/DBLE(M+1)**2
      N=M*M
      K=0
      DO 952 J=1,M
      DO 951 I=1,M
      K=K+1
      X(K)=-1.0D 0
  951 CONTINUE
  952 CONTINUE
      NA=N
      ELSE
      IERR=1
      ENDIF
      RETURN
  960 IF (N.GE.16) THEN
      M=INT(SQRT(DBLE(N)))
      PAR=1.0D 0/DBLE(M+1)**2
      N=M*M
      K=0
      DO 962 J=1,M
      DO 961 I=1,M
      K=K+1
      X(K)=0.0D 0
  961 CONTINUE
  962 CONTINUE
      NA=N
      ELSE
      IERR=1
      ENDIF
      RETURN
  970 IF (N.GE.16) THEN
      M=INT(SQRT(DBLE(N)))
      PAR=5.0D 1/DBLE(M+1)
      N=M*M
      K=0
      DO 972 J=1,M
      DO 971 I=1,M
      K=K+1
      X(K)=1.0D 0-DBLE(I)*DBLE(J)/DBLE(M+1)**2
  971 CONTINUE
  972 CONTINUE
      NA=N
      ELSE
      IERR=1
      ENDIF
      RETURN
  980 IF (N.GE.16) THEN
      M=INT(SQRT(DBLE(N)))
      PAR=1.0D 0/DBLE(M+1)
      N=M*M
      K=0
      DO 982 J=1,M
      DO 981 I=1,M
      K=K+1
      X(K)=0.0D 0
  981 CONTINUE
  982 CONTINUE
      NA=N
      ELSE
      IERR=1
      ENDIF
      RETURN
  990 IF (N.GE.16) THEN
      M=INT(SQRT(DBLE(N)))
      N=M*M
      PAR=500.0D 0/DBLE(M+2)**4
      K=0
      DO 992 J=1,M
      DO 991 I=1,M
      K=K+1
      X(K)=0.0D 0
  991 CONTINUE
  992 CONTINUE
      NA=N
      ELSE
        IERR=1
      ENDIF
      RETURN
  800 IF (N.GE.16) THEN
      M=INT(SQRT(DBLE(N)))
      N=M*M
      PAR=500.0D 0
      K=0
      DO 802 J=1,M
      DO 801 I=1,M
      K=K+1
      X(K)=0.0D 0
  801 CONTINUE
  802 CONTINUE
      NA=N
      ELSE
        IERR=1
      ENDIF
      RETURN
  240 IF(N.GE.2) THEN
      DO 241 I=1,N
      IF (MOD(I,2).EQ.1) THEN
      X(I)=1.0D 0
      ELSE
      X(I)=3.0D 0
      ENDIF
  241 CONTINUE
      ELSE
      IERR=1
      ENDIF
      RETURN
  410 N1=N-1
      DO 411 I=1,N1
        X(I)=-1.2D 0
  411 CONTINUE
      X(N)=-1.0D 0
      RETURN
  420 DO 421 I=1,N
        X(I)=2.0D 0
  421 CONTINUE
      RETURN
  650 DO 651 I=1,N
        X(I)=1.5D 0
  651 CONTINUE
      RETURN
  660 DO 661 I=1,N
        X(I)=0.0D 0
  661 CONTINUE
      RETURN
  670 DO 671 I=1,N
        X(I)=-1.0D 0
  671 CONTINUE
      RETURN
  680 DO 681 I=1,N
        X(I)=-1.0D 0
  681 CONTINUE
      RETURN
  690 DO 691 I=1,N
        X(I)=0.5D 0
  691 CONTINUE
      RETURN
  340 DO 341 I=1,N
        X(I)=0.5D 0
  341 CONTINUE
      RETURN
  360 DO 361 I=1,N
        X(I)=1.0D 0
  361 CONTINUE
      RETURN
  380 DO 381 I=1,N
        X(I)=-1.0D 0
  381 CONTINUE
      RETURN
  430 ALF=5
      BET=14
      GAM=3
      DO 431 I=1,N
        X(I)=0.0D 0
  431 CONTINUE
      DO 433 I=1,N
      F=DBLE(BET*N)*X(I)+(DBLE(I)-DBLE(N)/2.0D 0)**GAM
      DO 432 J=1,N
        IF(J.NE.I) THEN
        T=SQRT(X(J)**2+DBLE(I)/DBLE(J))
        S1=LOG(T)
        F=F+T*(SIN(S1)**ALF+COS(S1)**ALF)
      ENDIF
  432 CONTINUE
        Z(I)=-F
  433 CONTINUE
      S=DBLE(BET*N)/DBLE(BET**2*N**2-(ALF+1)**2*(N-1)**2)
      DO 434 I=1,N
        X(I)=S*Z(I)
  434 CONTINUE
      RETURN
  440 DO 441 I=1,N
        X(I)=1.0D 0
  441 CONTINUE
      RETURN
  270 DO 271 I=1,N
        X(I)=1.0D 0
  271 CONTINUE
      RETURN
  280 DO 281 I=1,N
        X(I)=1.0D 0
  281 CONTINUE
      RETURN
  290 DO 291 I=1,N
        X(I)=1.0D 0
  291 CONTINUE
      RETURN
  300 T=DBLE(2)/DBLE(N+2)
      N1=N/2
      DO 301 I=1,N1
        S=DBLE(I)*T
        X(I)=S*(1.0D 0-S)
        X(N1+I)=X(I)
  301 CONTINUE
      RETURN
  710 N1=INT(SQRT(DBLE(N)))
      N=N1*N1
      NA=N
      DO 711 I=1,N
        X(I)=1.0D 0
  711 CONTINUE
      RETURN
  820 N1=INT(SQRT(DBLE(N)))
      N=N1*N1
      NA=N
      DO 821 I=1,N
        X(I)=1.0D 0
  821 CONTINUE
      RETURN
  999 IERR=1
      RETURN
      END
* SUBROUTINE TFFU28                ALL SYSTEMS                92/12/01
C PORTABILITY : ALL SYSTEMS
C 92/12/01 LU : ORIGINAL VERSION
*
* PURPOSE :
*  VALUES OF MODEL FUNCTIONS FOR UNCONSTRAINED MINIMIZATION.
*  UNIVERSAL VERSION.
*
* PARAMETERS :
*  II  N  NUMBER OF VARIABLES.
*  RI  X(N)  VECTOR OF VARIABLES.
*  RO  F  VALUE OF THE MODEL FUNCTION.
*  II  NEXT  NUMBER OF THE TEST PROBLEM.
*
      SUBROUTINE TFFU28(N,X,F,NEXT)
      INTEGER N,NA,NEXT
      REAL*8 X(N),F
      REAL*8 FA
      REAL*8 A,B,C,D,E,P,Q,R,U,V,W,ALFA,A1,A2,A3,A4,EX,D1S,D2S,H,PI
      REAL*8 AL,AL1,AL2,ALF,BE,BE1,BE2,BET,CA,CB,FF,GA,GAM,H2,S,
     & S1,S2,S3,T,T1
      INTEGER I,J,K,L,M,IA,IB,IC,I1,I2,J1,J2,KA,LA,N1,ND
      REAL*8 Y(20),PAR
      COMMON /EMPR28/ Y,PAR,NA,M
      PI=3.14159265358979323846D 0
      F=0.0D 0
      GO TO (10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,
     &  170,180,190,200,210,220,230,250,310,320,330,350,370,390,400,
     &  450,460,470,480,490,500,510,520,530,540,550,560,570,580,590,
     &  600,610,620,630,720,740,750,760,780,790,810,830,840,860,870,
     &  880,900,910,920,930,940,950,960,970,980,990,800,240,410,420,
     &  650,660,670,680,690,340,360,380,430,440,270,280,290,300,710,
     &  820),NEXT
   10 DO 11 J=2,N
      A=X(J-1)**2-X(J)
      B=X(J-1)-1.0D 0
      F=F+1.0D 2*A**2+B**2
   11 CONTINUE
      RETURN
   20 DO 21 J=2,N-2,2
      A=X(J-1)**2-X(J)
      B=X(J-1)-1.0D 0
      C=X(J+1)**2-X(J+2)
      D=X(J+1)-1.0D 0
      U=X(J)+X(J+2)-2.0D 0
      V=X(J)-X(J+2)
      F=F+1.0D 2*A**2+B**2+9.0D 1*C**2+D**2+
     &  1.0D 1*U**2+0.1D 0*V**2
   21 CONTINUE
      RETURN
   30 DO 31 J=2,N-2,2
      A=X(J-1)+1.0D 1*X(J)
      B=X(J+1)-X(J+2)
      C=X(J)-2.0D 0*X(J+1)
      D=X(J-1)-X(J+2)
      F=F+A**2+5.0D 0*B**2+C**4+1.0D 1*D**4
   31 CONTINUE
      RETURN
   40 DO 41 J=2,N-2,2
      A=EXP(X(J-1))
      B=A-X(J)
      D=X(J)-X(J+1)
      P=X(J+1)-X(J+2)
      Q=SIN(P)/COS(P)
      U=X(J-1)
      V=X(J+2)-1.0D 0
      F=F+B**4+1.0D 2*D**6+Q**4+U**8+V**2
   41 CONTINUE
      RETURN
   50 P=7.0D 0/3.0D 0
      DO 51 J=1,N
      A=(3.0D 0-2.0D 0*X(J))*X(J)+1.0D 0
      IF (J.GT.1) A=A-X(J-1)
      IF (J.LT.N) A=A-X(J+1)
      F=F+ABS(A)**P
   51 CONTINUE
      RETURN
   60 P=7.0D 0/3.0D 0
      DO 63 J=1,N
      A=(2.0D 0+5.0D 0*X(J)**2)*X(J)+1.0D 0
      DO 61 I=MAX(1,J-5),MIN(N,J+1)
      IF (I.NE.J) A=A+X(I)*(1.0D 0+X(I))
   61 CONTINUE
      F=F+ABS(A)**P
   63 CONTINUE
      RETURN
   70 P=7.0D 0/3.0D 0
      K=N/2
      DO 71 J=1,N
      A=(3.0D 0-2.0D 0*X(J))*X(J)+1.0D 0
      IF (J.GT.1) A=A-X(J-1)
      IF (J.LT.N) A=A-X(J+1)
      F=F+ABS(A)**P
      IF (J.LE.K) THEN
      A=X(J)+X(J+K)
      F=F+ABS(A)**P
      ENDIF
   71 CONTINUE
      RETURN
   80 K=N/2
      DO 83 J=1,N
      P=0.0D 0
      DO 81 I=J-2,J+2
      IF (I.LT.1.OR.I.GT.N) GO TO 81
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      P=P+A*SIN(X(I))+B*COS(X(I))
   81 CONTINUE
      IF (J.GT.K) THEN
      I=J-K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      P=P+A*SIN(X(I))+B*COS(X(I))
      ELSE
      I=J+K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      P=P+A*SIN(X(I))+B*COS(X(I))
      ENDIF
      F=F+(DBLE(N+J)-P)**2/DBLE(N)
   83 CONTINUE
      RETURN
   90 K=N/2
      Q=1.0D 0/DBLE(N)
      DO 92 J=1,N
      P=0.0D 0
      DO 91 I=J-2,J+2
      IF (I.LT.1.OR.I.GT.N) GO TO 91
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      P=P+A*SIN(X(I))+B*COS(X(I))
   91 CONTINUE
      IF (J.GT.K) THEN
      I=J-K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      P=P+A*SIN(X(I))+B*COS(X(I))
      ELSE
      I=J+K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      P=P+A*SIN(X(I))+B*COS(X(I))
      ENDIF
      F=F+(P+DBLE(J)*(1.0D 0-COS(X(J))))*Q
   92 CONTINUE
      RETURN
  100 K=N/2
      DO 102 J=1,N
      P=0.0D 0
      Q=1.0D 0+DBLE(J)/1.0D 1
      DO 101 I=J-2,J+2
      IF (I.LT.1.OR.I.GT.N) GO TO 101
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=1.0D 0+DBLE(I)/1.0D 1
      C=DBLE(I+J)/1.0D 1
      P=P+A*SIN(Q*X(J)+B*X(I)+C)
  101 CONTINUE
      IF (J.GT.K) THEN
      I=J-K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=1.0D 0+DBLE(I)/1.0D 1
      C=DBLE(I+J)/1.0D 1
      P=P+A*SIN(Q*X(J)+B*X(I)+C)
      ELSE
      I=J+K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=1.0D 0+DBLE(I)/1.0D 1
      C=DBLE(I+J)/1.0D 1
      P=P+A*SIN(Q*X(J)+B*X(I)+C)
      ENDIF
      F=F+P
  102 CONTINUE
      F=F/DBLE(N)
      RETURN
  110 P=-0.2008D-2
      Q=-0.1900D-2
      R=-0.0261D-2
      DO 112 I=0,N-5,5
      A=1.0D 0
      B=0.0D 0
      DO 111 J=1,5
      A=A*X(I+J)
      B=B+X(I+J)**2
  111 CONTINUE
      A=EXP(A)
      B=B-1.0D 1-P
      C=X(I+2)*X(I+3)-5.0D 0*X(I+4)*X(I+5)-Q
      D=X(I+1)**3+X(I+2)**3+1.0D 0-R
      F=F+A+1.0D 1*(B**2+C**2+D**2)
  112 CONTINUE
      RETURN
  120 C=0.0D 0
      DO 121 J=2,N,2
      A=X(J-1)-3.0D 0
      B=X(J-1)-X(J)
      C=C+A
      F=F+1.0D-4*A**2-B+EXP(2.0D 1*B)
  121 CONTINUE
      F=F+C**2
      RETURN
  130 DO 131 J=2,N,2
      A=X(J)**2
      IF (A.EQ.0.0D 0) A=1.0D-60
      B=X(J-1)**2
      IF (B.EQ.0.0D 0) B=1.0D-60
      C=A+1.0D 0
      D=B+1.0D 0
      F=F+B**C+A**D
  131 CONTINUE
      RETURN
  140 P=1.0D 0/DBLE(N+1)
      Q=0.5D 0*P**2
      DO 141 J=1,N
      A=2.0D 0*X(J)+Q*(X(J)+DBLE(J)*P+1.0D 0)**3
      IF(J.GT.1) A=A-X(J-1)
      IF(J.LT.N) A=A-X(J+1)
      F=F+A**2
  141 CONTINUE
      RETURN
  150 P=1.0D 0/DBLE(N+1)
      Q=2.0D 0/P
      R=2.0D 0*P
      DO 151 J=2,N
      A=X(J-1)-X(J)
      F=F+Q*X(J-1)*A
      IF (ABS(A).LE.1.0D-6) THEN
      F=F+R*EXP(X(J))*(1.0D 0+A/2.0D 0*(1.0D 0+A/3.0D 0*(1.0D 0+
     &  A/4.0D 0)))
      ELSE
      B=EXP(X(J-1))-EXP(X(J))
      F=F+R*B/A
      ENDIF
  151 CONTINUE
      F=F+Q*X(N)**2+R*(EXP(X(1))-1.0D 0)/X(1)
     &             +R*(EXP(X(N))-1.0D 0)/X(N)
      RETURN
  160 DO 161 J=1,N
      A=DBLE(J)*(1.0D 0-COS(X(J)))
      IF(J.GT.1) A=A+DBLE(J)*SIN(X(J-1))
      IF(J.LT.N) A=A-DBLE(J)*SIN(X(J+1))
      F=F+A
  161 CONTINUE
      RETURN
  170 P=1.0D 0/DBLE(N+1)
      DO 171 J=1,N
      IF (J.EQ.1) THEN
      F=F+0.25D 0*X(J)**2/P+1.25D-1*X(J+1)**2/P+
     & P*(EXP(X(J))-1.0D 0)
      ELSE IF (J.EQ.N) THEN
      F=F+0.25D 0*X(J)**2/P+1.25D-1*X(J-1)**2/P+
     & P*(EXP(X(J))-1.0D 0)
      ELSE
      F=F+1.25D-1*(X(J+1)-X(J-1))**2/P+P*(EXP(X(J))-1.0D 0)
      ENDIF
  171 CONTINUE
      RETURN
  180 P=1.0D 0/DBLE(N+1)
      DO 181 J=1,N
      Q=DBLE(J)*P
      IF (J.EQ.1) THEN
      F=F+0.5D 0*X(J)**2/P+0.25D 0*X(J+1)**2/P-
     & P*(X(J)**2+2.0D 0*X(J)*Q)
      ELSE IF (J.EQ.N) THEN
      F=F+0.5D 0*X(J)**2/P+0.25D 0*X(J-1)**2/P-
     & P*(X(J)**2+2.0D 0*X(J)*Q)
      ELSE
      F=F+2.5D-1*(X(J+1)-X(J-1))**2/P-P*(X(J)**2+
     & 2.0D 0*X(J)*Q)
      ENDIF
  181 CONTINUE
      RETURN
  190 P=1.0D 0/DBLE(N+1)
      DO 191 J=1,N
      Q=EXP(2.0D 0*DBLE(J)*P)
      IF (J.EQ.1) THEN
      R=1.0D 0/3.0D 0
      F=F+0.5D 0*(X(J)-R)**2/P+7.0D 0*R**2+
     & 2.5D-1*(X(J+1)-R)**2/P+P*(X(J)**2+2.0D 0*X(J)*Q)
      ELSE IF (J.EQ.N) THEN
      R=EXP(2.0D 0)/3.0D 0
      F=F+0.5D 0*(X(J)-R)**2/P+7.0D 0*R**2+
     & 2.5D-1*(X(J-1)-R)**2/P+P*(X(J)**2+2.0D 0*X(J)*Q)
      ELSE
      F=F+2.5D-1*(X(J+1)-X(J-1))**2/P+P*(X(J)**2+
     & 2.0D 0*X(J)*Q)
      ENDIF
  191 CONTINUE
      RETURN
  200 P=1.0D 0/DBLE(N+1)
      DO 201 J=1,N
      A=EXP(-2.0D 0*X(J)**2)
      IF (J.EQ.1) THEN
      F=F+(0.5D 0*X(J)**2/P-P)+
     & (2.5D-1*X(J+1)**2/P-P)*A
      ELSE IF (J.EQ.N) THEN
      F=F+(0.5D 0*X(J)**2/P-P)*EXP(-2.0D 0)+
     & (2.5D-1*X(J-1)**2/P-P)*A
      ELSE
      F=F+(2.5D-1*(X(J+1)-X(J-1))**2/P-P)*A
      ENDIF
  201 CONTINUE
      RETURN
  210 P=1.0D 0/DBLE(N+1)
      DO 211 J=1,N
      IF (J.EQ.1) THEN
      A=0.5D 0*(X(J+1)-1.0D 0)/P
      B=(X(J)-1.0D 0)/P
      U=ATAN(A)
      V=ATAN(B)
      F=F+P*(X(J)**2+A*U-LOG(SQRT(1.0D 0+A**2)))+
     &   0.5D 0*P*(1.0D 0+B*V-LOG(SQRT(1.0D 0+B**2)))
      ELSE IF (J.EQ.N) THEN
      A=0.5D 0*(2.0D 0-X(J-1))/P
      B=(2.0D 0-X(J))/P
      U=ATAN(A)
      V=ATAN(B)
      F=F+P*(X(J)**2+A*U-LOG(SQRT(1.0D 0+A**2)))+
     &   0.5D 0*P*(4.0D 0+B*V-LOG(SQRT(1.0D 0+B**2)))
      ELSE
      A=0.5D 0*(X(J+1)-X(J-1))/P
      U=ATAN(A)
      F=F+P*(X(J)**2+A*U-LOG(SQRT(1.0D 0+A**2)))
      ENDIF
  211 CONTINUE
      RETURN
  220 P=1.0D 0/DBLE(N+1)
      DO 221 J=1,N
      IF (J.EQ.1) THEN
      A= 0.5D 0*X(J+1)/P
      B= X(J)/P
      F=F+P*(1.0D 2*(X(J)-A**2)**2+(1.0D 0-A)**2)+
     &   0.5D 0*P*(1.0D 2*B**4+(1.0D 0-B)**2)
      ELSE IF (J.EQ.N) THEN
      A=-0.5D 0*X(J-1)/P
      B=-X(J)/P
      F=F+P*(1.0D 2*(X(J)-A**2)**2+(1.0D 0-A)**2)+
     &   0.5D 0*P*(1.0D 2*B**4+(1.0D 0-B)**2)
      ELSE
      A=0.5D 0*(X(J+1)-X(J-1))/P
      F=F+P*(1.0D 2*(X(J)-A**2)**2+(1.0D 0-A)**2)
      ENDIF
  221 CONTINUE
      RETURN
  230 A1=-1.0D 0
      A2=0.0D 0
      A3=0.0D 0
      D1S=EXP(1.0D-2)
      D2S=1.0D 0
      DO 231 J=1,N
      A1=A1+DBLE(N-J+1)*X(J)**2
  231 CONTINUE
      A=4.0D 0*A1
      DO 232 J=1,N
      S1=EXP(X(J)/1.0D 2)
      IF (J.GT.1) THEN
      S3=S1+S2-D2S*(D1S-1.0D 0)
      A2=A2+S3**2
      A3=A3+(S1-1.0D 0/D1S)**2
      ENDIF
      S2=S1
      D2S=D1S*D2S
  232 CONTINUE
      F=1.0D-5*(A2+A3)+A1**2+(X(1)-2.0D-1)**2
      RETURN
  250 A=1.0D 0
      B=0.0D 0
      C=0.0D 0
      D=0.0D 0
      F=0.0D 0
      U=EXP(X(N))
      V=EXP(X(N-1))
      DO 251 J=1,N
      IF (J.LE.N/2) F=F+(X(J)-1.0D 0)**2
      IF (J.LE.N-2) THEN
      B=B+(X(J)+2.0D 0*X(J+1)+1.0D 1*X(J+2)-1.0D 0)**2
      C=C+(2.0D 0*X(J)+X(J+1)-3.0D 0)**2
      ENDIF
      D=D+X(J)**2-DBLE(N)
  251 CONTINUE
      F=F+A*(1.0D 0+U*B+B*C+V*C)+D**2
      RETURN
  310 DO 311 KA=1,NA
      IF(MOD(KA,2).EQ.1) THEN
      FA=1.0D 1*(X(KA+1)-X(KA)**2)
      ELSE
      FA=1.0D 0-X(KA-1)
      ENDIF
      F=F+FA**2
  311 CONTINUE
      F=0.5D 0*F
      RETURN
  320 DO 321 KA=1,NA
      IF(MOD(KA,4).EQ.1) THEN
      FA=X(KA)+1.0D 1*X(KA+1)
      ELSEIF(MOD(KA,4).EQ.2) THEN
      FA=2.23606797749979D 0*(X(KA+1)-X(KA+2))
      ELSEIF(MOD(KA,4).EQ.3) THEN
      A=X(KA-1)-2.0D 0*X(KA)
      FA=A**2
      ELSE
      FA=3.16227766016838D 0*(X(KA-3)-X(KA))**2
      ENDIF
      F=F+FA**2
  321 CONTINUE
      F=0.5D 0*F
      RETURN
  330 DO 333 KA=1,NA
      IF(KA.LE.N) THEN
      FA=(X(KA)-1.0D 0)/3.16227766016838D 0**5
      ELSE
      FA=-0.25D 0
      DO 331 J=1,N
      FA=FA+X(J)**2
  331 CONTINUE
      ENDIF
      F=F+FA**2
  333 CONTINUE
      F=0.5D 0*F
      RETURN
  350 DO 354 KA=1,NA
      IF(KA.LE.N) THEN
      FA=X(KA)-1.0D 0
      ELSE
      FA=0.0D 0
      DO 351 J=1,N
      FA=FA+DBLE(J)*(X(J)-1.0D 0)
  351 CONTINUE
      IF(KA.EQ.N+1) THEN
      ELSE IF(KA.EQ.N+2) THEN
      FA=FA**2
      ENDIF
      ENDIF
      F=F+FA**2
  354 CONTINUE
      F=0.5D 0*F
      RETURN
  370 DO 376 KA=1,NA
      IF(KA.LT.N) THEN
      A=0.0D 0
      DO 371 J=1,N
      A=A+X(J)
  371 CONTINUE
      FA=X(KA)+A-DBLE(N+1)
      ELSE
      A=1.0D 0
      DO 373 J=1,N
      A=A*X(J)
  373 CONTINUE
      FA=A-1.0D 0
      ENDIF
      F=F+FA**2
  376 CONTINUE
      F=0.5D 0*F
      RETURN
  390 DO 393 KA=1,NA
      U=1.0D 0/DBLE(N+1)
      V=DBLE(KA)*U
      A=0.0D 0
      B=0.0D 0
      DO 391 J=1,N
      W=DBLE(J)*U
      IF(J.LE.KA) THEN
      A=A+W*(X(J)+W+1.0D 0)**3
      ELSE
      B=B+(1.0D 0-W)*(X(J)+W+1.0D 0)**3
      ENDIF
  391 CONTINUE
      FA=X(KA)+U*((1.0D 0-V)*A+V*B)/2.0D 0
      F=F+FA**2
  393 CONTINUE
      F=0.5D 0*F
      RETURN
  400 DO 401 KA=1,NA
      FA=(3.0D 0-2.0D 0*X(KA))*X(KA)+1.0D 0
      IF(KA.GT.1) FA=FA-X(KA-1)
      IF(KA.LT.N) FA=FA-2.0D 0*X(KA+1)
      F=F+FA**2
  401 CONTINUE
      F=0.5D 0*F
      RETURN
  450 DO 451 KA=1,NA
      I=KA
      FA=(3.0D 0-2.0D 0*X(I))*X(I)+1.0D 0
      IF (I.GT.1) FA=FA-X(I-1)
      IF (I.LT.N) FA=FA-X(I+1)
      F=F+FA**2
  451 CONTINUE
      F=0.5D 0*F
      RETURN
  460 DO 463 KA=1,NA
      I=KA
      FA=(2.0D 0+5.0D 0*X(I)**2)*X(I)+1.0D 0
      DO 461 J=MAX(1,I-5),MIN(N,I+1)
      IF (I.NE.J) FA=FA+X(J)*(1.0D 0+X(J))
  461 CONTINUE
      F=F+FA**2
  463 CONTINUE
      F=0.5D 0*F
      RETURN
  470 DO 471 KA=1,NA
      I=(KA+1)/2
      IF (MOD(KA,2).EQ.1) THEN
      FA=X(I)+X(I+1)*((5.0D 0-X(I+1))*X(I+1)-2.0D 0)-1.3D 1
      ELSE
      FA=X(I)+X(I+1)*((1.0D 0+X(I+1))*X(I+1)-1.4D 1)-2.9D 1
      ENDIF
      F=F+FA**2
  471 CONTINUE
      F=0.5D 0*F
      RETURN
  480 DO 481 KA=1,NA
      I=MOD(KA,N/2)+1
      J=I+N/2
      M=5*N
      IF (KA.LE.M/2) THEN
      IA=1
      ELSE
      IA=2
      ENDIF
      IB=5-KA/(M/4)
      IC=MOD(KA,5)+1
      FA=(X(I)**IA-X(J)**IB)**IC
      F=F+FA**2
  481 CONTINUE
      F=0.5D 0*F
      RETURN
  490 DO 491 KA=1,NA
      I=2*((KA+5)/6)-1
      IF (MOD(KA,6).EQ.1) THEN
      FA=X(I)+3.0D 0*X(I+1)*(X(I+2)-1.0D 0)+X(I+3)**2-1.0D 0
      ELSEIF (MOD(KA,6).EQ.2) THEN
      FA=(X(I)+X(I+1))**2+(X(I+2)-1.0D 0)**2-X(I+3)-3.0D 0
      ELSEIF (MOD(KA,6).EQ.3) THEN
      FA=X(I)*X(I+1)-X(I+2)*X(I+3)
      ELSEIF (MOD(KA,6).EQ.4) THEN
      FA=2.0D 0*X(I)*X(I+2)+X(I+1)*X(I+3)-3.0D 0
      ELSEIF (MOD(KA,6).EQ.5) THEN
      FA=(X(I)+X(I+1)+X(I+2)+X(I+3))**2+(X(I)-1.0D 0)**2
      ELSE
      FA=X(I)*X(I+1)*X(I+2)*X(I+3)+(X(I+3)-1.0D 0)**2-1.0D 0
      ENDIF
      F=F+FA**2
  491 CONTINUE
      F=0.5D 0*F
      RETURN
  500 DO 501 KA=1,NA
      I=(KA+1)/2
      J=MOD(KA,2)
      IF (J.EQ.0) THEN
      FA=6.0D 0-EXP(2.0D 0*X(I))-EXP(2.0D 0*X(I+1))
      ELSEIF (I.EQ.1) THEN
      FA=4.0D 0-EXP(X(I))-EXP(X(I+1))
      ELSEIF (I.EQ.N) THEN
      FA=8.0D 0-EXP(3.0D 0*X(I-1))-EXP(3.0D 0*X(I))
      ELSE
      FA=8.0D 0-EXP(3.0D 0*X(I-1))-EXP(3.0D 0*X(I))+
     & 4.0D 0-EXP(X(I))-EXP(X(I+1))
      ENDIF
      F=F+FA**2
  501 CONTINUE
      F=0.5D 0*F
      RETURN
  510 DO 511 KA=1,NA
      I=(KA+1)/2
      IF (MOD(KA,2).EQ.1) THEN
      FA=1.0D 1*(2.0D 0*X(I)/(1.0D 0+X(I)**2)-X(I+1))
      ELSE
      FA=X(I)-1.0D 0
      ENDIF
      F=F+FA**2
  511 CONTINUE
      F=0.5D 0*F
      RETURN
  520 DO 521 KA=1,NA
      I=3*((KA+5)/6)-2
      IF (MOD(KA,6).EQ.1) THEN
      FA=1.0D 1*(X(I)**2-X(I+1))
      ELSEIF (MOD(KA,6).EQ.2) THEN
      FA=X(I+2)-1.0D 0
      ELSEIF (MOD(KA,6).EQ.3) THEN
      FA=(X(I+3)-1.0D 0)**2
      ELSEIF (MOD(KA,6).EQ.4) THEN
      FA=(X(I+4)-1.0D 0)**3
      ELSEIF (MOD(KA,6).EQ.5) THEN
      FA=X(I)**2*X(I+3)+SIN(X(I+3)-X(I+4))-1.0D 1
      ELSE
      FA=X(I+1)+(X(I+2)**2*X(I+3))**2-2.0D 1
      ENDIF
      F=F+FA**2
  521 CONTINUE
      F=0.5D 0*F
      RETURN
  530 DO 531 KA=1,NA
      I=3*((KA+6)/7)-2
      IF (MOD(KA,7).EQ.1) THEN
      FA=1.0D 1*(X(I)**2-X(I+1))
      ELSEIF (MOD(KA,7).EQ.2) THEN
      FA=1.0D 1*(X(I+1)**2-X(I+2))
      ELSEIF (MOD(KA,7).EQ.3) THEN
      FA=(X(I+2)-X(I+3))**2
      ELSEIF (MOD(KA,7).EQ.4) THEN
      FA=(X(I+3)-X(I+4))**2
      ELSEIF (MOD(KA,7).EQ.5) THEN
      FA=X(I)+X(I+1)**2+X(I+2)-3.0D 1
      ELSEIF (MOD(KA,7).EQ.6) THEN
      FA=X(I+1)-X(I+2)**2+X(I+3)-1.0D 1
      ELSE
      FA=X(I)*X(I+4)-1.0D 1
      ENDIF
      F=F+FA**2
  531 CONTINUE
      F=0.5D 0*F
      RETURN
  540 DO 546 KA=1,NA
      I=2*((KA+3)/4)-2
      L=MOD((KA-1),4)+1
      FA=-Y(L)
      DO 542 K=1,3
      A=DBLE(K*K)/DBLE(L)
      DO 541 J=1,4
      IF (X(I+J).EQ.0) X(I+J)=1.0D-16
      A=A*SIGN(1.0D 0,X(I+J))*ABS(X(I+J))**(DBLE(J)/DBLE(K*L))
  541 CONTINUE
      FA=FA+A
  542 CONTINUE
      F=F+FA**2
  546 CONTINUE
      F=0.5D 0*F
      RETURN
  550 DO 556 KA=1,NA
      I=2*((KA+3)/4)-2
      L=MOD((KA-1),4)+1
      FA=-Y(L)
      DO 552 K=1,3
      A=0.0D 0
      DO 551 J=1,4
      A=A+X(I+J)*(DBLE(J)/DBLE(K*L))
  551 CONTINUE
      FA=FA+EXP(A)*DBLE(K*K)/DBLE(L)
  552 CONTINUE
      F=F+FA**2
  556 CONTINUE
      F=0.5D 0*F
      RETURN
  560 DO 563 KA=1,NA
      I=2*((KA+3)/4)-2
      L=MOD((KA-1),4)+1
      FA=-Y(L)
      DO 561 J=1,4
      FA=FA+DBLE((1-2*MOD(J,2))*L*J*J)*SIN(X(I+J))+
     & DBLE(L*L*J)*COS(X(I+J))
  561 CONTINUE
      F=F+FA**2
  563 CONTINUE
      F=0.5D 0*F
      RETURN
  570 DO 571 KA=1,NA
      ALFA=0.5D 0
      IF (KA.EQ.1) THEN
      FA=ALFA-(1.0D 0-ALFA)*X(3)-X(1)*(1.0D 0+4.0D 0*X(2))
      ELSEIF(KA.EQ.2) THEN
      FA=-(2.0D 0-ALFA)*X(4)-X(2)*(1.0D 0+4.0D 0*X(1))
      ELSEIF(KA.EQ.N-1) THEN
      FA=ALFA*X(N-3)-X(N-1)*(1.0D 0+4.0D 0*X(N))
      ELSEIF (KA.EQ.N) THEN
      FA=ALFA*X(N-2)-(2.0D 0-ALFA)-X(N)*(1.0D 0+4.0D 0*X(N-1))
      ELSEIF (MOD(KA,2).EQ.1) THEN
      FA=ALFA*X(KA-2)-(1.0D 0-ALFA)*X(KA+2)-
     & X(KA)*(1.0D 0+4.0D 0*X(KA+1))
      ELSE
      FA=ALFA*X(KA-2)-(2.0D 0-ALFA)*X(KA+2)-
     & X(KA)*(1.0D 0+4.0D 0*X(KA-1))
      ENDIF
      F=F+FA**2
  571 CONTINUE
      F=0.5D 0*F
      RETURN
  580 DO 581 KA=1,NA
      IF (KA.LT.2) THEN
      FA=4.0D 0*(X(KA)-X(KA+1)**2)
      ELSEIF (KA.LT.N) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)
      ELSE
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))
      ENDIF
      F=F+FA**2
  581 CONTINUE
      F=0.5D 0*F
      RETURN
  590 DO 591 KA=1,NA
      IF (KA.EQ.1) THEN
      FA=-2.0D 0*X(KA)**2+3.0D 0*X(KA)-2.0D 0*X(KA+1)+
     & 3.0D 0*X(N-4)-X(N-3)-X(N-2)+0.5D 0*X(N-1)-X(N)+1.0D 0
      ELSEIF (KA.LE.N-1) THEN
      FA=-2.0D 0*X(KA)**2+3.0D 0*X(KA)-X(KA-1)-2.0D 0*X(KA+1)+
     & 3.0D 0*X(N-4)-X(N-3)-X(N-2)+0.5D 0*X(N-1)-X(N)+1.0D 0
      ELSE
      FA=-2.0D 0*X(N)**2+3.0D 0*X(N)-X(N-1)+
     & 3.0D 0*X(N-4)-X(N-3)-X(N-2)+0.5D 0*X(N-1)-X(N)+1.0D 0
      ENDIF
      F=F+FA**2
  591 CONTINUE
      F=0.5D 0*F
      RETURN
  600 DO 601 KA=1,NA
      U=1.0D 0/DBLE(N+1)
      V=DBLE(KA)*U
      FA=2.0D 0*X(KA)+0.5D 0*U*U*(X(KA)+V+1.0D 0)**3+1.0D 0
      IF(KA.GT.1) FA=FA-X(KA-1)
      IF(KA.LT.N) FA=FA-X(KA+1)
      F=F+FA**2
  601 CONTINUE
      F=0.5D 0*F
      RETURN
  610 DO 611 KA=1,NA
      I=3*((KA+6)/7)-2
      IF (MOD(KA,7).EQ.1) THEN
      FA=1.0D 1*(X(I)**2-X(I+1))
      ELSEIF (MOD(KA,7).EQ.2) THEN
      FA=X(I+1)+X(I+2)-2.0D 0
      ELSEIF (MOD(KA,7).EQ.3) THEN
      FA=X(I+3)-1.0D 0
      ELSEIF (MOD(KA,7).EQ.4) THEN
      FA=X(I+4)-1.0D 0
      ELSEIF (MOD(KA,7).EQ.5) THEN
      FA=X(I)+3.0D 0*X(I+1)
      ELSEIF (MOD(KA,7).EQ.6) THEN
      FA=X(I+2)+X(I+3)-2.0D 0*X(I+4)
      ELSE
      FA=1.0D 1*(X(I+1)**2-X(I+4))
      ENDIF
      F=F+FA**2
  611 CONTINUE
      F=0.5D 0*F
      RETURN
  620 DO 621 KA=1,NA
      I=KA/2
      IF (KA.EQ.1) THEN
      FA=X(KA)-1.0D 0
      ELSE IF (MOD(KA,2).EQ.0) THEN
      FA=1.0D 1*(X(I)**2-X(I+1))
      ELSE
      A=2.0D 0*EXP(-(X(I)-X(I+1))**2)
      B=EXP(-2.0D 0*(X(I+1)-X(I+2))**2)
      FA=A+B
      ENDIF
      F=F+FA**2
  621 CONTINUE
      F=0.5D 0*F
      RETURN
  630 DO 633 KA=1,NA
      IA=MIN(MAX(MOD(KA,13)-2,1),7)
      IB=(KA+12)/13
      I=IA+IB-1
      IF (IA.EQ.7) THEN
      J=IB
      ELSE
      J=IA+IB
      ENDIF
      C=3.0D 0*DBLE(IA)/1.0D 1
      A=0.0D 0
      B=EXP(SIN(C)*X(J))
      D=X(J)-SIN(X(I))-1.0D 0+Y(1)
      E=1.0D 0+COS(C)
      DO 631 L=0,6
      IF (IB+L.NE.I.AND.IB+L.NE.J) A=A+SIN(X(IB+L))-Y(1)
  631 CONTINUE
      FA=E*D**2+5.0D 0*(X(I)-1.0D 0)*B+0.5D 0*A
      F=F+FA**2
  633 CONTINUE
      F=0.5D 0*F
      RETURN
  720 DO 721 KA=1,NA
      A1=0.414214D 0
      IF (KA.EQ.1) THEN
      FA=X(1)-(1.0D 0-X(1))*X(3)-A1*(1.0D 0+4.0D 0*X(2))
      ELSEIF (KA.EQ.2) THEN
      FA=-(1.0D 0-X(1))*X(4)-A1*(1.0D 0+4.0D 0*X(2))
      ELSEIF (KA.EQ.3) THEN
      FA=A1*X(1)-(1.0D 0-X(1))*X(5)-X(3)*(1.0D 0+4.0D 0*X(2))
      ELSEIF (KA.LE.N-2) THEN
      FA=X(1)*X(KA-2)-(1.0D 0-X(1))*X(KA+2)-
     & X(KA)*(1.0D 0+4.0D 0*X(KA-1))
      ELSEIF (KA.EQ.N-1) THEN
      FA=X(1)*X(N-3)-X(N-1)*(1.0D 0+4.0D 0*X(N-2))
      ELSE
      FA=X(1)*X(N-2)-(1.0D 0-X(1))-X(N)*(1.0D 0+4.0D 0*X(N-1))
      ENDIF
      F=F+FA**2
  721 CONTINUE
      F=0.5D 0*F
      RETURN
  740 DO 741 KA=1,NA
      IF (KA.LT.2) THEN
      FA=3.0D 0*X(KA)**3+2.0D 0*X(KA+1)-5.0D 0+
     & SIN(X(KA)-X(KA+1))*SIN(X(KA)+X(KA+1))
      ELSEIF (KA.LT.N) THEN
      FA=3.0D 0*X(KA)**3+2.0D 0*X(KA+1)-5.0D 0+
     & SIN(X(KA)-X(KA+1))*SIN(X(KA)+X(KA+1))+4.0D 0*X(KA)-
     & X(KA-1)*EXP(X(KA-1)-X(KA))-3.0D 0
      ELSE
      FA=4.0D 0*X(KA)-X(KA-1)*EXP(X(KA-1)-X(KA))-3.0D 0
      ENDIF
      F=F+FA**2
  741 CONTINUE
      F=0.5D 0*F
      RETURN
  750 DO 751 KA=1,NA
      IF (MOD(KA,2).EQ.1) THEN
      FA=0.0D 0
      IF (KA.NE.1) FA=FA-6.0D 0*(X(KA-2)-X(KA))**3+1.0D 1-
     & 4.0D 0*X(KA-1)-2.0D 0*SIN(X(KA-2)-X(KA-1)-X(KA))*
     & SIN(X(KA-2)+X(KA-1)-X(KA))
      IF (KA.NE.N) FA=FA+3.0D 0*(X(KA)-X(KA+2))**3-5.0D 0+
     & 2.0D 0*X(KA+1)+SIN(X(KA)-X(KA+1)-X(KA+2))*
     & SIN(X(KA)+X(KA+1)-X(KA+2))
      ELSE
      EX=EXP(X(KA-1)-X(KA)-X(KA+1))
      FA=4.0D 0*X(KA)-(X(KA-1)-X(KA+1))*EX-3.0D 0
      ENDIF
      F=F+FA**2
  751 CONTINUE
      F=0.5D 0*F
      RETURN
  760 DO 761 KA=1,NA
      H=2.0D 0
      IF (KA.EQ.1) THEN
      FA=((3.0D 0-H*X(1))*X(1)-2.0D 0*X(2)+1.0D 0)**2
      ELSEIF (KA.LE.N-1) THEN
      FA=((3.0D 0-H*X(KA))*X(KA)-X(KA-1)-2.0D 0*X(KA+1)+1.0D 0)**2
      ELSE
      FA=((3.0D 0-H*X(N))*X(N)-X(N-1)+1.0D 0)**2
      ENDIF
      F=F+FA**2
  761 CONTINUE
      F=0.5D 0*F
      RETURN
  780 DO 781 KA=1,NA
      IF (KA.LT.2) THEN
      FA=4.0D 0*(X(KA)-X(KA+1)**2)+X(KA+1)-X(KA+2)**2
      ELSEIF (KA.LT.3) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA+1)-X(KA+2)**2
      ELSEIF (KA.LT.N-1) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2-X(KA-2)+X(KA+1)-
     & X(KA+2)**2
      ELSEIF (KA.LT.N) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2-X(KA-2)
      ELSE
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))
     & +X(KA-1)**2-X(KA-2)
      ENDIF
      F=F+FA**2
  781 CONTINUE
      F=0.5D 0*F
      RETURN
  790 DO 791 KA=1,NA
      IF (KA.LT.2) THEN
      FA=4.0D 0*(X(KA)-X(KA+1)**2)+X(KA+1)-X(KA+2)**2+
     & X(KA+2)-X(KA+3)**2
      ELSEIF (KA.LT.3) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2+X(KA+1)-X(KA+2)**2+
     & X(KA+2)-X(KA+3)**2
      ELSEIF (KA.LT.4) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2-X(KA-2)+
     & X(KA+1)-X(KA+2)**2+X(KA-2)**2+X(KA+2)-X(KA+3)**2
      ELSEIF (KA.LT.N-2) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2-X(KA-2)+
     & X(KA+1)-X(KA+2)**2+X(KA-2)**2-X(KA-3)+X(KA+2)-X(KA+3)**2
      ELSEIF (KA.LT.N-1) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2-X(KA-2)+
     & X(KA+1)-X(KA+2)**2+X(KA-2)**2-X(KA-3)+X(KA+2)
      ELSEIF (KA.LT.N) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2-X(KA-2)+
     & X(KA+1)+X(KA-2)**2-X(KA-3)
      ELSE
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))
     & +X(KA-1)**2-X(KA-2)+X(KA-2)**2-X(KA-3)
      ENDIF
      F=F+FA**2
  791 CONTINUE
      F=0.5D 0*F
      RETURN
  810 DO 811 KA=1,NA
      IF(MOD(KA,2).EQ.1) THEN
      FA=X(KA)+((5.0D 0-X(KA+1))*X(KA+1)-2.0D 0)*X(KA+1)-1.3D 1
      ELSE
      FA=X(KA-1)+((X(KA)+1.0D 0)*X(KA)-1.4D 1)*X(KA)-2.9D 1
      ENDIF
      F=F+FA**2
  811 CONTINUE
      F=0.5D 0*F
      RETURN
  830 DO 831 KA=1,NA
      IF(MOD(KA,4).EQ.1) THEN
      A=EXP(X(KA))-X(KA+1)
      FA=A**2
      ELSEIF (MOD(KA,4).EQ.2) THEN
      FA=1.0D 1*(X(KA)-X(KA+1))**3
      A=3.0D 1*(X(KA)-X(KA+1))**2*FA
      ELSEIF (MOD(KA,4).EQ.3) THEN
      A=X(KA)-X(KA+1)
      FA=(SIN(A)/COS(A))**2
      ELSE
      FA=X(KA)-1.0D 0
      ENDIF
      F=F+FA**2
  831 CONTINUE
      F=0.5D 0*F
      RETURN
  840 DO 841 KA=1,NA
      IF(KA.LT.2) THEN
      FA=X(KA)*(0.5D 0*X(KA)-3.0D 0)-1.0D 0+2.0D 0*X(KA+1)
      ELSEIF (KA.LT.N) THEN
      FA=X(KA-1)+X(KA)*(0.5D 0*X(KA)-3.0D 0)-1.0D 0+2.0D 0*X(KA+1)
      ELSE
      FA=X(KA-1)+X(KA)*(0.5D 0*X(KA)-3.0D 0)-1.0D 0
      ENDIF
      F=F+FA**2
  841 CONTINUE
      F=0.5D 0*F
      RETURN
  860 DO 861 KA=1,NA
      IF(MOD(KA,2).EQ.1) THEN
      FA=1.0D 4*X(KA)*X(KA+1)-1.0D 0
      ELSE
      FA=EXP(-X(KA-1))+EXP(-X(KA))-1.0001D 0
      ENDIF
      F=F+FA**2
  861 CONTINUE
      F=0.5D 0*F
      RETURN
  870 DO 871 KA=1,NA
      IF(MOD(KA,4).EQ.1) THEN
      FA=-2.0D 2*X(KA)*(X(KA+1)-X(KA)**2)-(1.0D 0-X(KA))
      ELSEIF(MOD(KA,4).EQ.2) THEN
      FA=2.0D 2*(X(KA)-X(KA-1)**2)+2.02D 1*(X(KA)-1.0D 0)+
     &  1.98D 1*(X(KA+2)-1.0D 0)
      ELSEIF(MOD(KA,4).EQ.3) THEN
      FA=-1.8D 2*X(KA)*(X(KA+1)-X(KA)**2)-(1.0D 0-X(KA))
      ELSE
      FA=1.8D 2*(X(KA)-X(KA-1)**2)+2.02D 1*(X(KA)-1.0D 0)+
     & 1.98D 1*(X(KA-2)-1.0D 0)
      ENDIF
      F=F+FA**2
  871 CONTINUE
      F=0.5D 0*F
      RETURN
  880 DO 881 KA=1,NA
      IF (KA.LT.2) THEN
      A=EXP(COS(DBLE(KA)*(X(KA)+X(KA+1))))
      B=A*DBLE(KA)*SIN(DBLE(KA)*(X(KA)+X(KA+1)))
      FA=X(KA)-A
      ELSEIF (KA.LT.N) THEN
      A=EXP(COS(DBLE(KA)*(X(KA-1)+X(KA)+X(KA+1))))
      B=A*SIN(DBLE(KA)*(X(KA-1)+X(KA)+X(KA+1)))*DBLE(KA)
      FA=X(KA)-A
      ELSE
      A=EXP(COS(DBLE(KA)*(X(KA-1)+X(KA))))
      B=A*SIN(DBLE(KA)*(X(KA-1)+X(KA)))*DBLE(KA)
      FA=X(KA)-A
      ENDIF
      F=F+FA**2
  881 CONTINUE
      F=0.5D 0*F
      RETURN
  900 DO 901 KA=1,NA
      IF(KA.EQ.1) THEN
      FA=3.0D 0*X(KA)*(X(KA+1)-2.0D 0*X(KA))+0.25D 0*X(KA+1)**2
      ELSEIF(KA.EQ.N) THEN
      FA=3.0D 0*X(KA)*(2.0D 1-2.0D 0*X(KA)+X(KA-1))+
     & 0.25D 0*(2.0D 1-X(KA-1))**2
      ELSE
      FA=3.0D 0*X(KA)*(X(KA+1)-2.0D 0*X(KA)+X(KA-1))+
     & 0.25D 0*(X(KA+1)-X(KA-1))**2
      ENDIF
      F=F+FA**2
  901 CONTINUE
      F=0.5D 0*F
      RETURN
  910 DO 911 KA=1,NA
      H=1.0D 0/DBLE(N+1)
      IF (KA.LT.2) THEN
      FA=2.0D 0*X(KA)+PAR*H**2*SINH(PAR*X(KA))-X(KA+1)
      ELSE IF (KA.LT.N) THEN
      FA=2.0D 0*X(KA)+PAR*H**2*SINH(PAR*X(KA))-X(KA-1)-X(KA+1)
      ELSE
      FA=2.0D 0*X(KA)+PAR*H**2*SINH(PAR*X(KA))-X(KA-1)-1.0D 0
      ENDIF
      F=F+FA**2
  911 CONTINUE
      F=0.5D 0*F
      RETURN
  920 DO 921 KA=1,NA
      FA=6.0D 0*X(KA)
      A1=0.0D 0
      A2=0.0D 0
      A3=0.0D 0
      IF (KA.GT.1) THEN
      FA=FA-4.0D 0*X(KA-1)
      A1=A1-X(KA-1)
      A2=A2+X(KA-1)
      A3=A3+2.0D 0*X(KA-1)
      ENDIF
      IF (KA.GT.2) THEN
      FA=FA+X(KA-2)
      A3=A3-X(KA-2)
      ENDIF
      IF (KA.LT.N-1) THEN
      FA=FA+X(KA+2)
      A3=A3+X(KA+2)
      ENDIF
      IF (KA.LT.N) THEN
      FA=FA-4.0D 0*X(KA+1)
      A1=A1+X(KA+1)
      A2=A2+X(KA+1)
      A3=A3-2.0D 0*X(KA+1)
      ENDIF
      IF (KA.GE.N-1) THEN
      FA=FA+1.0D 0
      A3=A3+1.0D 0
      ENDIF
      IF (KA.GE.N) THEN
      FA=FA-4.0D 0
      A1=A1+1.0D 0
      A2=A2+1.0D 0
      A3=A3-2.0D 0
      ENDIF
      FA=FA-0.5D 0*PAR*(A1*A2-X(KA)*A3)
      F=F+FA**2
  921 CONTINUE
      F=0.5D 0*F
      RETURN
  930 DO 931 KA=1,NA
      H=1.0D 0/DBLE(M+1)
      IF(KA.LE.M) THEN
      J=KA+M
      FA=6.0D 0*X(KA)
      A1=0.0D 0
      A2=0.0D 0
      IF (KA.EQ.1) THEN
      A1=A1+1.0D 0
      ENDIF
      IF (KA.GT.1) THEN
      FA=FA-4.0D 0*X(KA-1)
      A1=A1-X(J-1)
      A2=A2+2.0D 0*X(KA-1)
      ENDIF
      IF (KA.GT.2) THEN
      FA=FA+X(KA-2)
      A2=A2-X(KA-2)
      ENDIF
      IF (KA.LT.M-1) THEN
      FA=FA+X(KA+2)
      A2=A2+X(KA+2)
      ENDIF
      IF (KA.LT.M) THEN
      FA=FA-4.0D 0*X(KA+1)
      A1=A1+X(J+1)
      A2=A2-2.0D 0*X(KA+1)
      ENDIF
      IF (KA.EQ.M) THEN
      A1=A1+1.0D 0
      ENDIF
      FA=FA+0.5D 0*PAR*H*(X(KA)*A2+X(J)*A1*H**2)
      ELSE
      J=KA-M
      FA=-2.0D 0*X(KA)
      A1=0.0D 0
      A2=0.0D 0
      IF (J.EQ.1) THEN
      A2=A2+1.0D 0
      ENDIF
      IF (J.GT.1) THEN
      FA=FA+X(KA-1)
      A1=A1-X(J-1)
      A2=A2-X(KA-1)
      ENDIF
      IF (J.LT.M) THEN
      FA=FA+X(KA+1)
      A1=A1+X(J+1)
      A2=A2+X(KA+1)
      ENDIF
      IF (J.EQ.M) THEN
      A2=A2+1.0D 0
      ENDIF
      FA=FA+0.5D 0*PAR*H*(X(KA)*A1+X(J)*A2)
      ENDIF
      F=F+FA**2
  931 CONTINUE
      F=0.5D 0*F
      RETURN
  940 DO 941 KA=1,NA
      FA=4.0D 0*X(KA)-PAR*EXP(X(KA))
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      IF(I.GT.1) FA=FA-X(KA-1)
      IF(I.LT.M) FA=FA-X(KA+1)
      IF(J.GT.1) FA=FA-X(KA-M)
      IF(J.LT.M) FA=FA-X(KA+M)
      F=F+FA**2
  941 CONTINUE
      F=0.5D 0*F
      RETURN
  950 DO 951 KA=1,NA
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      FA=4.0D 0*X(KA)+PAR*X(KA)**3/(1.0D 0+PAR*DBLE(I)**2+
     & PAR*DBLE(J)**2)
      IF(I.EQ.1) FA=FA-1.0D 0
      IF(I.GT.1) FA=FA-X(KA-1)
      IF(I.LT.M) FA=FA-X(KA+1)
      IF(I.EQ.M) FA=FA-2.0D 0+EXP(DBLE(J)/DBLE(M+1))
      IF(J.EQ.1) FA=FA-1.0D 0
      IF(J.GT.1) FA=FA-X(KA-M)
      IF(J.LT.M) FA=FA-X(KA+M)
      IF(J.EQ.M) FA=FA-2.0D 0+EXP(DBLE(I)/DBLE(M+1))
      F=F+FA**2
  951 CONTINUE
      F=0.5D 0*F
      RETURN
  960 DO 961 KA=1,NA
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      A1=DBLE(I)/DBLE(M+1)
      A2=DBLE(J)/DBLE(M+1)
      FA=4.0D 0*X(KA)-PAR*SIN(2.0D 0*PI*X(KA))-
     & 1.0D 4*((A1-0.25D 0)**2+(A2-0.75D 0)**2)*PAR
      IF(I.EQ.1) FA=FA-X(KA+1)-PAR*SIN(PI*X(KA+1)*DBLE(M+1))
      IF(I.GT.1.AND.I.LT.M) FA=FA-X(KA+1)-X(KA-1)-
     & PAR*SIN(PI*(X(KA+1)-X(KA-1))*DBLE(M+1))
      IF(I.EQ.M) FA=FA-X(KA-1)+PAR*SIN(PI*X(KA-1)*DBLE(M+1))
      IF(J.EQ.1) FA=FA-X(KA+M)-PAR*SIN(PI*X(KA+M)*DBLE(M+1))
      IF(J.GT.1.AND.J.LT.M) FA=FA-X(KA+M)-X(KA-M)-
     & PAR*SIN(PI*(X(KA+M)-X(KA-M))*DBLE(M+1))
      IF(J.EQ.M) FA=FA-X(KA-M)+PAR*SIN(PI*X(KA-M)*DBLE(M+1))
      F=F+FA**2
  961 CONTINUE
      F=0.5D 0*F
      RETURN
  970 DO 971 KA=1,NA
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      FA=8.0D 0*X(KA)**2
      IF(I.EQ.1) FA=FA-2.0D 0*X(KA)*(X(KA+1)+1.0D 0)-
     & 0.5D 0*(X(KA+1)-1.0D 0)**2-
     & 1.5D 0*X(KA)**2*(X(KA+1)-1.0D 0)*PAR
      IF(I.GT.1.AND.I.LT.M) FA=FA-2.0D 0*X(KA)*(X(KA+1)+X(KA-1))-
     & 0.5D 0*(X(KA+1)-X(KA-1))**2-
     & 1.5D 0*X(KA)**2*(X(KA+1)-X(KA-1))*PAR
      IF(I.EQ.M) FA=FA-2.0D 0*X(KA)*X(KA-1)-
     & 0.5D 0*X(KA-1)**2+
     & 1.5D 0*X(KA)**2*X(KA-1)*PAR
      IF(J.EQ.1) FA=FA-2.0D 0*X(KA)*(X(KA+M)+1.0D 0)-
     & 0.5D 0*(X(KA+M)-1.0D 0)**2
      IF(J.GT.1.AND.J.LT.M) FA=FA-2.0D 0*X(KA)*(X(KA+M)+X(KA-M))-
     & 0.5D 0*(X(KA+M)-X(KA-M))**2
      IF(J.EQ.M) FA=FA-2.0D 0*X(KA)*X(KA-M)-
     & 0.5D 0*X(KA-M)**2
      IF (I.EQ.1.AND.J.EQ.1) FA=FA-PAR/DBLE(M+1)
      F=F+FA**2
  971 CONTINUE
      F=0.5D 0*F
      RETURN
  980 DO 981 KA=1,NA
      A3=0.0D 0
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      A1=PAR*DBLE(I)
      A2=PAR*DBLE(J)
      FA=4.0D 0*X(KA)-2.0D 3*A1*A2*(1.0D 0-A1)*(1.0D 0-A2)*PAR**2
      IF(I.GT.1) THEN
      FA=FA-X(KA-1)
      A3=A3-X(KA-1)
      ENDIF
      IF(I.LT.M) THEN
      FA=FA-X(KA+1)
      A3=A3+X(KA+1)
      ENDIF
      IF(J.GT.1) THEN
      FA=FA-X(KA-M)
      A3=A3-X(KA-M)
      ENDIF
      IF(J.LT.M) THEN
      FA=FA-X(KA+M)
      A3=A3+X(KA+M)
      ENDIF
      FA=FA+2.0D 1*PAR*A3*X(KA)
      F=F+FA**2
  981 CONTINUE
      F=0.5D 0*F
      RETURN
  990 DO 991 KA=1,NA
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      FA=2.0D 1*X(KA)-PAR*MAX(0.0D 0,X(KA))-
     & SIGN(PAR,(DBLE(I)/DBLE(M+2)-0.5D 0))
      IF (J.GT.2) THEN
        FA=FA+X(KA-M-M)
      ENDIF
      IF (J.GT.1) THEN
        IF (I.GT.1) THEN
          FA=FA+2.0D 0*X(KA-M-1)
        ENDIF
        FA=FA-8.0D 0*X(KA-M)
        IF (I.LT.M) THEN
          FA=FA+2.0D 0*X(KA-M+1)
        ENDIF
      ENDIF
      IF (I.GT.1) THEN
        IF (I.GT.2) THEN
          FA=FA+X(KA-2)
        ENDIF
        FA=FA-8.0D 0*X(KA-1)
      ENDIF
      IF (I.LT.M) THEN
        FA=FA-8.0D 0*X(KA+1)
        IF (I.LT.M-1) THEN
          FA=FA+X(KA+2)
        ENDIF
      ENDIF
      IF (J.LT.M) THEN
        IF (I.GT.1) THEN
          FA=FA+2.0D 0*X(KA+M-1)
        ENDIF
        FA=FA-8.0D 0*X(KA+M)
        IF (I.LT.M) THEN
          FA=FA+2.0D 0*X(KA+M+1)
        ENDIF
      ENDIF
      IF (J.LT.M-1) THEN
        FA=FA+X(KA+M+M)
      ENDIF
      F=F+FA**2
  991 CONTINUE
      F=0.5D 0*F
      RETURN
  800 DO 802 KA=1,NA
      H=0.5D 0/DBLE(M+2)
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      FA=2.0D 1*X(KA)
      A1=0.0D 0
      A2=0.0D 0
      A3=0.0D 0
      A4=0.0D 0
      IF (J.GT.2) THEN
        FA=FA+X(KA-M-M)
        A4=A4+X(KA-M-M)
      ENDIF
      IF (J.GT.1) THEN
        IF (I.GT.1) THEN
          FA=FA+2.0D 0*X(KA-M-1)
          A3=A3+X(KA-M-1)
          A4=A4+X(KA-M-1)
        ENDIF
        FA=FA-8.0D 0*X(KA-M)
        A1=A1-X(KA-M)
        A4=A4-4.0D 0*X(KA-M)
        IF (I.LT.M) THEN
          FA=FA+2.0D 0*X(KA-M+1)
          A3=A3-X(KA-M+1)
          A4=A4+X(KA-M+1)
        ENDIF
      ENDIF
      IF (I.GT.1) THEN
        IF (I.GT.2) THEN
          FA=FA+X(KA-2)
          A3=A3+X(KA-2)
        ENDIF
        FA=FA-8.0D 0*X(KA-1)
        A2=A2-X(KA-1)
        A3=A3-4.0D 0*X(KA-1)
      ENDIF
      IF (I.LT.M) THEN
        FA=FA-8.0D 0*X(KA+1)
        A2=A2+X(KA+1)
        A3=A3+4.0D 0*X(KA+1)
        IF (I.LT.M-1) THEN
          FA=FA+X(KA+2)
          A3=A3-X(KA+2)
        ENDIF
      ENDIF
      IF (J.LT.M) THEN
        IF (I.GT.1) THEN
          FA=FA+2.0D 0*X(KA+M-1)
          A3=A3+X(KA+M-1)
          A4=A4-X(KA+M-1)
        ENDIF
        FA=FA-8.0D 0*X(KA+M)
        A1=A1+X(KA+M)
        A4=A4+4.0D 0*X(KA+M)
        IF (I.LT.M) THEN
          FA=FA+2.0D 0*X(KA+M+1)
          A3=A3-X(KA+M+1)
          A4=A4-X(KA+M+1)
        ENDIF
      ENDIF
      IF (J.LT.M-1) THEN
        FA=FA+X(KA+M+M)
        A4=A4-X(KA+M+M)
      ENDIF
      IF (J.EQ.M) THEN
        IF (I.GT.1) THEN
          FA=FA-H-H
          A3=A3-H
          A4=A4+H
        ENDIF
        FA=FA+8.0D 0*H
        A1=A1-H
        A4=A4-4.0D 0*H
        IF (I.LT.M) THEN
          FA=FA-2.0D 0*H
          A3=A3+H
          A4=A4+H
        ENDIF
        FA=FA+H
        A4=A4-H
      ENDIF
      IF (J.EQ.M-1) THEN
        FA=FA-H
        A4=A4+H
      ENDIF
      FA=FA+0.25D 0*PAR*(A1*A3-A2*A4)
      F=F+FA**2
  802 CONTINUE
      F=0.5D 0*F
      RETURN
  240 DO 243 KA=1,NA
      W=0.0D 0
      DO 241 I=1,N-1
      W=W+(DBLE(KA)/DBLE(KA+I))*X(I)
  241 CONTINUE
      FA=X(KA)-(1.0D 0+(0.4D 0/DBLE(N))*X(KA)*(0.5D 0+W+
     & 0.5D 0*(DBLE(KA)/DBLE(KA+N))*X(N)))
      F=F+FA**2
  243 CONTINUE
      F=0.5D 0*F
      RETURN
  410 DO 411 KA=1,NA
      IF(KA.EQ.1) THEN
        FA=1.0D 0-X(1)
      ELSE
        FA=10.0D 0*DBLE(KA-1)*(X(KA)-X(KA-1))**2
      ENDIF
      F=F+FA**2
  411 CONTINUE
      F=0.5D 0*F
      RETURN
  420 DO 421 KA=1,NA
      IF(KA.EQ.N) THEN
        FA=X(KA)-0.1D 0*X(1)**2
      ELSE
        FA=X(KA)-0.1D 0*X(KA+1)**2
      ENDIF
      F=F+FA**2
  421 CONTINUE
      F=0.5D 0*F
      RETURN
  650 DO 653 KA=1,NA
      S=0.0D 0
      DO 651 J=1,N
        S=S+X(J)**3
  651 CONTINUE
      FA=X(KA)-1.0D 0/DBLE(2*N)*(S+DBLE(KA))
      F=F+FA**2
  653 CONTINUE
      F=0.5D 0*F
      RETURN
  660 DO 661 KA=1,NA
      S=(1.0D 0/DBLE(N+1))**2*EXP(X(KA))
      IF(N.EQ.1) THEN
        FA=-2.0D 0*X(KA)-S
      ELSE IF(KA.EQ.1) THEN
        FA=-2.0D 0*X(KA)+X(KA+1)-S
      ELSE IF(KA.EQ.N) THEN
        FA=X(KA-1)-2.0D 0*X(KA)-S
      ELSE
        FA=X(KA-1)-2.0D 0*X(KA)+X(KA+1)-S
      ENDIF
      F=F+FA**2
  661 CONTINUE
      F=0.5D 0*F
      RETURN
  670 DO 671 KA=1,NA
      S=0.1D 0
      IF(N.EQ.1) THEN
        FA=(3.0D 0-S*X(KA))*X(KA)+1.0D 0
      ELSE IF(KA.EQ.1) THEN
        FA=(3.0D 0-S*X(KA))*X(KA)+1.0D 0-2.0D 0*X(KA+1)
      ELSE IF(KA.EQ.N) THEN
        FA=(3.0D 0-S*X(KA))*X(KA)+1.0D 0-X(KA-1)
      ELSE
        FA=(3.0D 0-S*X(KA))*X(KA)+1.0D 0-X(KA-1)-2.0D 0*X(KA+1)
      ENDIF
      F=F+FA**2
  671 CONTINUE
      F=0.5D 0*F
      RETURN
  680 DO 683 KA=1,NA
      S1=1.0D 0
      S2=1.0D 0
      S3=1.0D 0
      J1=3
      J2=3
      IF(KA-J1.GT.1) THEN
        I1=KA-J1
      ELSE
        I1=1
      ENDIF
      IF(KA+J2.LT.N) THEN
        I2=KA+J2
      ELSE
        I2=N
      ENDIF
      S=0.0D 0
      DO 681 J=I1,I2
        IF(J.NE.KA) S=S+X(J)+X(J)**2
  681 CONTINUE
      FA=(S1+S2*X(KA)**2)*X(KA)+1.D 0-S3*S
      F=F+FA**2
  683 CONTINUE
      F=0.5D 0*F
      RETURN
  690 DO 691 KA=1,NA
      IF(KA.EQ.1) THEN
        FA=X(1)**2-1.0D 0
      ELSE
        FA=X(KA-1)**2+LOG(X(KA))-1.0D 0
      ENDIF
      F=F+FA**2
  691 CONTINUE
      F=0.5D 0*F
      RETURN
  340 DO 341 KA=1,NA
      IF(KA.EQ.1) THEN
        FA=X(1)
      ELSE
        FA=COS(X(KA-1))+X(KA)-1.0D 0
      ENDIF
      F=F+FA**2
  341 CONTINUE
      F=0.5D 0*F
      RETURN
  360 DO 361 KA=1,NA
      S=(1.0D 0/DBLE(N+1))**2
      IF(N.EQ.1) THEN
        FA=2.0D 0*X(KA)-1.0D 0+S*(X(KA)+SIN(X(KA)))
      ELSE IF(KA.EQ.1) THEN
        FA=2.0D 0*X(KA)-X(KA+1)+S*(X(KA)+SIN(X(KA)))
      ELSE IF(KA.EQ.N) THEN
        FA=-X(KA-1)+2.0D 0*X(KA)-1.0D 0+S*(X(KA)+SIN(X(KA)))
      ELSE
        FA=-X(KA-1)+2.0D 0*X(KA)-X(KA+1)+S*(X(KA)+SIN(X(KA)))
      ENDIF
      F=F+FA**2
  361 CONTINUE
      F=0.5D 0*F
      RETURN
  380 DO 383 KA=1,NA
      IF(KA-5.GT.1) THEN
        I1=KA-5
      ELSE
        I1=1
      ENDIF
      IF(KA+1.LT.N) THEN
        I2=KA+1
      ELSE
        I2=N
      ENDIF
      S=0.0D 0
      DO 381 J=I1,I2
        IF(J.NE.KA) S=S+X(J)*(1.0D 0+X(J))
  381 CONTINUE
      FA=X(KA)*(2.0D 0+5.0D 0*X(KA)**2)+1.0D 0-S
      F=F+FA**2
  383 CONTINUE
      F=0.5D 0*F
      RETURN
  430 DO 433 KA=1,NA
      ALF=5
      BET=14
      GAM=3
      FA=DBLE(BET*N)*X(KA)+(DBLE(KA)-DBLE(N)/2.0D 0)**GAM
      DO 431 J=1,N
        IF(J.NE.KA) THEN
        T=SQRT(X(J)**2+DBLE(KA)/DBLE(J))
        S1=LOG(T)
        FA=FA+T*(SIN(S1)**ALF+COS(S1)**ALF)
      ENDIF
  431 CONTINUE
      F=F+FA**2
  433 CONTINUE
      F=0.5D 0*F
      RETURN
  440 DO 445 KA=1,NA
      C=0.5D 0
      H=1.0D 0/DBLE(N)
      FA=(1.0D 0-C*H/4.0D 0)
      DO 441 J=1,N
        S=C*H*DBLE(KA)/DBLE(2*(KA+J))
        IF(J.EQ.N) S=S/2.0D 0
        FA=FA-S*X(J)
  441 CONTINUE
      FA=-1.0D 0+X(KA)*FA
      F=F+FA**2
  445 CONTINUE
      F=0.5D 0*F
      RETURN
  270 DO 271 KA=1,NA
      H=1.0D 0/DBLE(N+1)
      T=2.0D 0*H**2
      IF(KA.EQ.1) THEN
      FA=2.0D 0*X(KA)-X(KA+1)-T*X(KA)**2-H*X(KA+1)
      ELSE IF(1.LT.KA.AND.KA.LT.N) THEN
      FA=-X(KA-1)+2.0D 0*X(KA)-X(KA+1)-T*X(KA)**2-H*(X(KA+1)-X(KA-1))
      ELSE IF(KA.EQ.N) THEN
      FA=-X(KA-1)+2.0D 0*X(KA)-0.5D 0-T*X(KA)**2-H*(0.5D 0-X(KA-1))
      ENDIF
      F=F+FA**2
  271 CONTINUE
      F=0.5D 0*F
      RETURN
  280 DO 288 KA=1,NA
      S=0.5D 0
      H=1.0D 0/DBLE(N+1)
      T=H**2/S
      T1=2.0D 0*H
      AL=0.0D 0
      BE=0.5D 0
      S1=0.0D 0
      DO 281 J=1,KA
        IF(J.EQ.1) THEN
           S1=S1+DBLE(J)*(X(J)**2+(X(J+1)-AL)/T1)
        ENDIF
        IF(1.LT.J.AND.J.LT.N) THEN
           S1=S1+DBLE(J)*(X(J)**2+(X(J+1)-X(J-1))/T1)
        ENDIF
        IF(J.EQ.N) THEN
           S1=S1+DBLE(J)*(X(J)**2+(BE-X(J-1))/T1)
        ENDIF
  281 CONTINUE
      S1=(1.0D 0-DBLE(KA)*H)*S1
      IF(KA.EQ.N) GO TO 283
      S2=0.0D 0
      DO 282 J=KA+1,N
        IF(J.LT.N) THEN
           S2=S2+(1.0D 0-DBLE(J)*H)*(X(J)**2+(X(J+1)-X(J-1))/T1)
        ELSE
           S2=S2+(1.0D 0-DBLE(J)*H)*(X(J)**2+(BE-X(J-1))/T1)
        ENDIF
  282 CONTINUE
      S1=S1+DBLE(KA)*S2
  283 FA=X(KA)-0.5D 0*DBLE(KA)*H-T*S1
      F=F+FA**2
  288 CONTINUE
      F=0.5D 0*F
      RETURN
  290 DO 291 KA=1,NA
      A=-9.0D-3
      B=1.0D-3
      AL=0.0D 0
      BE=25.0D 0
      GA=20.0D 0
      CA=0.3D 0
      CB=0.3D 0
      H=(B-A)/DBLE(N+1)
      T=A+DBLE(KA)*H
      H=H**2
      S=DBLE(KA)/DBLE(N+1)
      U=AL*(1.0D 0-S)+BE*S+X(KA)
      FF=CB*EXP(GA*(U-BE))-CA*EXP(GA*(AL-U))
      IF(T.LE.0) THEN
        FF=FF+CA
      ELSE
        FF=FF-CB
      ENDIF
      IF(N.EQ.1) THEN
        FA=-AL+2.0D 0*X(KA)-BE+H*FF
      ELSEIF(KA.EQ.1) THEN
        FA=-AL+2.0D 0*X(KA)-X(KA+1)+H*FF
      ELSEIF(KA.LT.N) THEN
        FA=-X(KA-1)+2.0D 0*X(KA)-X(KA+1)+H*FF
      ELSE
        FA=-X(KA-1)+2.0D 0*X(KA)-BE+H*FF
      ENDIF
      F=F+FA**2
  291 CONTINUE
      F=0.5D 0*F
      RETURN
  300 DO 301 KA=1,NA
      AL1=0.0D 0
      AL2=0.0D 0
      BE1=0.0D 0
      BE2=0.0D 0
      N1=N/2
      H=1.0D 0/DBLE(N1+1)
      T=DBLE(KA)*H
      IF(KA.EQ.1) THEN
        S1=2.0D 0*X(KA)-X(KA+1)
        B=AL1
      ELSE IF(KA.EQ.N1+1) THEN
        S1=2.0D 0*X(KA)-X(KA+1)
        B=AL2
      ELSE IF(KA.EQ.N1) THEN
        S1=-X(KA-1)+2.0D 0*X(KA)
        B=BE1
      ELSE IF(KA.EQ.N) THEN
        S1=-X(KA-1)+2.0D 0*X(KA)
        B=BE2
      ELSE
        S1=-X(KA-1)+2.0D 0*X(KA)-X(KA+1)
        B=0.0D 0
      ENDIF
      IF(KA.LE.N1) THEN
        S2=X(KA)**2+X(KA)+0.1D 0*X(N1+KA)**2-1.2D 0
      ELSE
        S2=0.2D 0*X(KA-N1)**2+X(KA)**2+2.0D 0*X(KA)-0.6D 0
      ENDIF
      FA=S1+H**2*S2-B
      F=F+FA**2
  301 CONTINUE
      F=0.5D 0*F
      RETURN
  710 DO 711 KA=1,NA
      ND=INT(SQRT(DBLE(N)))
      L=MOD(KA,ND)
      IF(L.EQ.0) THEN
         K=KA/ND
         L=ND
      ELSE
         K=INT(KA/ND)+1
      ENDIF
      LA=1.0D 0
      H=1.0D 0/DBLE(ND+1)
      H2=LA*H*H
      IF(L.EQ.1.AND.K.EQ.1) THEN
         FA=4.0D 0*X(1)-X(2)-X(ND+1)+H2*EXP(X(1))
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.K.EQ.1) THEN
         FA=4.0D 0*X(L)-X(L-1)-X(L+1)-X(L+ND)+H2*EXP(X(L))
      ENDIF
      IF(L.EQ.ND.AND.K.EQ.1) THEN
         FA=4.0D 0*X(ND)-X(ND-1)-X(ND+ND)+H2*EXP(X(ND))
      ENDIF
      IF(L.EQ.1.AND.1.LT.K.AND.K.LT.ND) THEN
         FA=4.0D 0*X(KA)-X(KA+1)-X(KA-ND)-X(KA+ND)+H2*EXP(X(KA))
      ENDIF
      IF(L.EQ.ND.AND.1.LT.K.AND.K.LT.ND) THEN
         FA=4.0D 0*X(KA)-X(KA-ND)-X(KA-1)-X(KA+ND)+H2*EXP(X(KA))
      ENDIF
      IF(L.EQ.1.AND.K.EQ.ND) THEN
         FA=4.0D 0*X(KA)-X(KA+1)-X(KA-ND)+H2*EXP(X(KA))
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.K.EQ.ND) THEN
         FA=4.0D 0*X(KA)-X(KA-1)-X(KA+1)-X(KA-ND)+H2*EXP(X(KA))
      ENDIF
      IF(L.EQ.ND.AND.K.EQ.ND) THEN
        FA=4.0D 0*X(KA)-X(KA-1)-X(KA-ND)+H2*EXP(X(KA))
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.1.LT.K.AND.K.LT.ND) THEN
      FA=4.0D 0*X(KA)-X(KA-1)-X(KA+1)-X(KA-ND)-X(KA+ND)+H2*EXP(X(KA))
      ENDIF
      F=F+FA**2
  711 CONTINUE
      F=0.5D 0*F
      RETURN
  820 DO 821 KA=1,NA
      ND=INT(SQRT(DBLE(N)))
      L=MOD(KA,ND)
      IF(L.EQ.0) THEN
         K=KA/ND
         L=ND
      ELSE
         K=INT(KA/ND)+1
      ENDIF
      H=1.0D 0/DBLE(ND+1)
      H2=H*H
      IF(L.EQ.1.AND.K.EQ.1) THEN
         FA=4.0D 0*X(1)-X(2)-X(ND+1)+H2*X(1)**2-24.0D 0/(H+1.0D 0)**2
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.K.EQ.1) THEN
         FA=4.0D 0*X(L)-X(L-1)-X(L+1)-X(L+ND)+H2*X(L)**2
     *-12.0D 0/(DBLE(L)*H+1.0D 0)**2
      ENDIF
      IF(L.EQ.ND.AND.K.EQ.1) THEN
         FA=4.0D 0*X(ND)-X(ND-1)-X(ND+ND)+H2*X(ND)**2
     *-12.0D 0/(DBLE(ND)*H+1.0D 0)**2-12.0D 0/(H+2.0D 0)**2
      ENDIF
      IF(L.EQ.1.AND.1.LT.K.AND.K.LT.ND) THEN
         FA=4.0D 0*X(KA)-X(KA+1)-X(KA-ND)-X(KA+ND)+H2*X(KA)**2
     *-12.0D 0/(DBLE(K)*H+1.0D 0)**2
      ENDIF
      IF(L.EQ.ND.AND.1.LT.K.AND.K.LT.ND) THEN
         FA=4.0D 0*X(KA)-X(KA-ND)-X(KA-1)-X(KA+ND)+H2*X(KA)**2
     *-12.0D 0/(DBLE(K)*H+2.0D 0)**2
      ENDIF
      IF(L.EQ.1.AND.K.EQ.ND) THEN
         FA=4.0D 0*X(KA)-X(KA+1)-X(KA-ND)+H2*X(KA)**2
     *-12.0D 0/(DBLE(ND)*H+1.0D 0)**2-12.0D 0/(H+2.0D 0)**2
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.K.EQ.ND) THEN
         FA=4.0D 0*X(KA)-X(KA-1)-X(KA+1)-X(KA-ND)+H2*X(KA)**2
     *-12.0D 0/(DBLE(L)*H+2.0D 0)**2
      ENDIF
      IF(L.EQ.ND.AND.K.EQ.ND) THEN
        FA=4.0D 0*X(KA)-X(KA-1)-X(KA-ND)+H2*X(KA)**2
     *-24.0D 0/(DBLE(ND)*H+2.0D 0)**2
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.1.LT.K.AND.K.LT.ND) THEN
         FA=4.0D 0*X(KA)-X(KA-1)-X(KA+1)-X(KA-ND)-X(KA+ND)+H2*X(KA)**2
      ENDIF
      F=F+FA**2
  821 CONTINUE
      F=0.5D 0*F
      RETURN
      END
* SUBROUTINE TFGU28                ALL SYSTEMS                92/12/01
C PORTABILITY : ALL SYSTEMS
C 92/12/01 LU : ORIGINAL VERSION
*
* PURPOSE :
*  GRADIENTS OF MODEL FUNCTIONS FOR UNCONSTRAINED MINIMIZATION.
*  UNIVERSAL VERSION.
*
* PARAMETERS :
*  II  N  NUMBER OF VARIABLES.
*  RI  X(N)  VECTOR OF VARIABLES.
*  RI  G(N)  GRADIENG OF THE MODEL FUNCTION.
*  II  NEXT  NUMBER OF THE TEST PROBLEM.
*
      SUBROUTINE TFGU28(N,X,G,NEXT)
      INTEGER N,NA,NEXT
      REAL*8 X(N),G(N)
      REAL*8 FA
      REAL*8 A,B,C,D,E,P,Q,R,U,V,W,ALFA,SX(1000)
      REAL*8 A1,A2,A3,A4,EX,D1S,D2S,H,PI
      REAL*8 GA1(2),GA2(2),GA3(6),GA4(6)
      REAL*8 AL,AL1,AL2,ALF,BE,BE1,BE2,BET,CA,CB,FF,FG,GA,GAM,H2,S,
     & S1,S2,S3,T,T1
      INTEGER I,J,K,L,M,IA,IB,IC,I1,I2,J1,J2,KA,LA,N1,ND
      REAL*8 Y(20),PAR
      COMMON /EMPR28/ Y,PAR,NA,M
      PI=3.14159265358979323846D 0
      CALL UXVSET(N,0.0D 0,G)
      GO TO (10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,
     &  170,180,190,200,210,220,230,250,310,320,330,350,370,390,400,
     &  450,460,470,480,490,500,510,520,530,540,550,560,570,580,590,
     &  600,610,620,630,720,740,750,760,780,790,810,830,840,860,870,
     &  880,900,910,920,930,940,950,960,970,980,990,800,240,410,420,
     &  650,660,670,680,690,340,360,380,430,440,270,280,290,300,710,
     &  820),NEXT
   10 DO 11 J=2,N
      A=X(J-1)**2-X(J)
      B=X(J-1)-1.0D 0
      G(J-1)=G(J-1)+4.0D 2*X(J-1)*A+2.0D 0*B
      G(J)=G(J)-2.0D 2*A
   11 CONTINUE
      RETURN
   20 DO 21 J=2,N-2,2
      A=X(J-1)**2-X(J)
      B=X(J-1)-1.0D 0
      C=X(J+1)**2-X(J+2)
      D=X(J+1)-1.0D 0
      U=X(J)+X(J+2)-2.0D 0
      V=X(J)-X(J+2)
      G(J-1)=G(J-1)+4.0D 2*X(J-1)*A+2.0D 0*B
      G(J)=G(J)-2.0D 2*A+2.0D 1*U+0.2D 0*V
      G(J+1)=G(J+1)+3.6D 2*X(J+1)*C+2.0D 0*D
      G(J+2)=G(J+2)-1.8D 2*C+2.0D 1*U-0.2D 0*V
   21 CONTINUE
      RETURN
   30 DO 31 J=2,N-2,2
      A=X(J-1)+1.0D 1*X(J)
      B=X(J+1)-X(J+2)
      C=X(J)-2.0D 0*X(J+1)
      D=X(J-1)-X(J+2)
      G(J-1)=G(J-1)+2.0D 0*A+4.0D 1*D**3
      G(J)=G(J)+2.0D 1*A+4.0D 0*C**3
      G(J+1)=G(J+1)-8.0D 0*C**3+1.0D 1*B
      G(J+2)=G(J+2)-4.0D 1*D**3-1.0D 1*B
   31 CONTINUE
      RETURN
   40 DO 41 J=2,N-2,2
      A=EXP(X(J-1))
      B=A-X(J)
      D=X(J)-X(J+1)
      P=X(J+1)-X(J+2)
      C=COS(P)
      Q=SIN(P)/COS(P)
      U=X(J-1)
      V=X(J+2)-1.0D 0
      B=4.0D 0*B**3
      D=6.0D 2*D**5
      Q=4.0D 0*Q**3/C**2
      G(J-1)=G(J-1)+A*B+8.0D 0*U**7
      G(J)=G(J)+D-B
      G(J+1)=G(J+1)+Q-D
      G(J+2)=G(J+2)+2.0D 0*V-Q
   41 CONTINUE
      RETURN
   50 P=7.0D 0/3.0D 0
      DO 51 J=1,N
      A=(3.0D 0-2.0D 0*X(J))*X(J)+1.0D 0
      IF (J.GT.1) A=A-X(J-1)
      IF (J.LT.N) A=A-X(J+1)
      B=P*ABS(A)**(P-1.0D 0)*SIGN(1.0D 0,A)
      G(J)=G(J)+B*(3.0D 0-4.0D 0*X(J))
      IF (J.GT.1) G(J-1)=G(J-1)-B
      IF (J.LT.N) G(J+1)=G(J+1)-B
   51 CONTINUE
      RETURN
   60 P=7.0D 0/3.0D 0
      DO 63 J=1,N
      A=(2.0D 0+5.0D 0*X(J)**2)*X(J)+1.0D 0
      DO 61 I=MAX(1,J-5),MIN(N,J+1)
      IF (I.NE.J) A=A+X(I)*(1.0D 0+X(I))
   61 CONTINUE
      B=P*ABS(A)**(P-1.0D 0)*SIGN(1.0D 0,A)
      G(J)=G(J)+B*(2.0D 0+1.5D 1*X(J)**2)
      DO 62 I=MAX(1,J-5),MIN(N,J+1)
      IF (I.NE.J) G(I)=G(I)+B*(1.0D 0+2.0D 0*X(I))
   62 CONTINUE
   63 CONTINUE
      RETURN
   70 P=7.0D 0/3.0D 0
      K=N/2
      DO 71 J=1,N
      A=(3.0D 0-2.0D 0*X(J))*X(J)+1.0D 0
      IF (J.GT.1) A=A-X(J-1)
      IF (J.LT.N) A=A-X(J+1)
      B=P*ABS(A)**(P-1.0D 0)*SIGN(1.0D 0,A)
      G(J)=G(J)+B*(3.0D 0-4.0D 0*X(J))
      IF (J.GT.1) G(J-1)=G(J-1)-B
      IF (J.LT.N) G(J+1)=G(J+1)-B
      IF (J.LE.K) THEN
      A=X(J)+X(J+K)
      B=P*ABS(A)**(P-1.0D 0)*SIGN(1.0D 0,A)
      G(J)=G(J)+B
      G(J+K)=G(J+K)+B
      ENDIF
   71 CONTINUE
      RETURN
   80 K=N/2
      DO 83 J=1,N
      P=0.0D 0
      DO 81 I=J-2,J+2
      IF (I.LT.1.OR.I.GT.N) GO TO 81
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      P=P+A*SIN(X(I))+B*COS(X(I))
   81 CONTINUE
      IF (J.GT.K) THEN
      I=J-K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      P=P+A*SIN(X(I))+B*COS(X(I))
      ELSE
      I=J+K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      P=P+A*SIN(X(I))+B*COS(X(I))
      ENDIF
      P=2.0D 0*(DBLE(N+J)-P)/DBLE(N)
      DO 82 I=J-2,J+2
      IF (I.LT.1.OR.I.GT.N) GO TO 82
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      G(I)=G(I)-P*(A*COS(X(I))-B*SIN(X(I)))
   82 CONTINUE
      IF (J.GT.K) THEN
      I=J-K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      G(I)=G(I)-P*(A*COS(X(I))-B*SIN(X(I)))
      ELSE
      I=J+K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      G(I)=G(I)-P*(A*COS(X(I))-B*SIN(X(I)))
      ENDIF
   83 CONTINUE
      RETURN
   90 K=N/2
      Q=1.0D 0/DBLE(N)
      DO 92 J=1,N
      P=0.0D 0
      DO 91 I=J-2,J+2
      IF (I.LT.1.OR.I.GT.N) GO TO 91
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      P=P+A*SIN(X(I))+B*COS(X(I))
      G(I)=G(I)+Q*(A*COS(X(I))-B*SIN(X(I)))
   91 CONTINUE
      IF (J.GT.K) THEN
      I=J-K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      P=P+A*SIN(X(I))+B*COS(X(I))
      G(I)=G(I)+Q*(A*COS(X(I))-B*SIN(X(I)))
      ELSE
      I=J+K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      P=P+A*SIN(X(I))+B*COS(X(I))
      G(I)=G(I)+Q*(A*COS(X(I))-B*SIN(X(I)))
      ENDIF
      G(J)=G(J)+Q*DBLE(J)*SIN(X(J))
   92 CONTINUE
      RETURN
  100 K=N/2
      DO 102 J=1,N
      P=0.0D 0
      Q=1.0D 0+DBLE(J)/1.0D 1
      DO 101 I=J-2,J+2
      IF (I.LT.1.OR.I.GT.N) GO TO 101
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=1.0D 0+DBLE(I)/1.0D 1
      C=DBLE(I+J)/1.0D 1
      P=P+A*SIN(Q*X(J)+B*X(I)+C)
      R=A*COS(Q*X(J)+B*X(I)+C)/DBLE(N)
      G(J)=G(J)+R*Q
      G(I)=G(I)+R*B
  101 CONTINUE
      IF (J.GT.K) THEN
      I=J-K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=1.0D 0+DBLE(I)/1.0D 1
      C=DBLE(I+J)/1.0D 1
      P=P+A*SIN(Q*X(J)+B*X(I)+C)
      R=A*COS(Q*X(J)+B*X(I)+C)/DBLE(N)
      G(J)=G(J)+R*Q
      G(I)=G(I)+R*B
      ELSE
      I=J+K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=1.0D 0+DBLE(I)/1.0D 1
      C=DBLE(I+J)/1.0D 1
      P=P+A*SIN(Q*X(J)+B*X(I)+C)
      R=A*COS(Q*X(J)+B*X(I)+C)/DBLE(N)
      G(J)=G(J)+R*Q
      G(I)=G(I)+R*B
      ENDIF
  102 CONTINUE
      RETURN
  110 P=-0.2008D-2
      Q=-0.1900D-2
      R=-0.0261D-2
      DO 112 I=0,N-5,5
      A=1.0D 0
      B=0.0D 0
      DO 111 J=1,5
      A=A*X(I+J)
      B=B+X(I+J)**2
  111 CONTINUE
      W=EXP(A)
      A=A*W
      B=B-1.0D 1-P
      C=X(I+2)*X(I+3)-5.0D 0*X(I+4)*X(I+5)-Q
      D=X(I+1)**3+X(I+2)**3+1.0D 0-R
      G(I+1)=G(I+1)+A/X(I+1)+2.0D 1*(2.0D 0*B*X(I+1)+
     &  3.0D 0*D*X(I+1)**2)
      G(I+2)=G(I+2)+A/X(I+2)+2.0D 1*(2.0D 0*B*X(I+2)+
     &  C*X(I+3)+3.0D 0*D*X(I+2)**2)
      G(I+3)=G(I+3)+A/X(I+3)+2.0D 1*(2.0D 0*B*X(I+3)+C*X(I+2))
      G(I+4)=G(I+4)+A/X(I+4)+2.0D 1*(2.0D 0*B*X(I+4)-
     &  5.0D 0*C*X(I+5))
      G(I+5)=G(I+5)+A/X(I+5)+2.0D 1*(2.0D 0*B*X(I+5)-5.0D 0*C*X(I+4))
  112 CONTINUE
      RETURN
  120 C=0.0D 0
      DO 121 J=2,N,2
      A=X(J-1)-3.0D 0
      B=X(J-1)-X(J)
      C=C+A
      G(J-1)=G(J-1)+2.0D-4*A-1.0D 0+2.0D 1*EXP(2.0D 1*B)
      G(J)=G(J)+1.0D 0-2.0D 1*EXP(2.0D 1*B)
  121 CONTINUE
      DO 122 J=2,N,2
      G(J-1)=G(J-1)+2.0D 0*C
  122 CONTINUE
      RETURN
  130 DO 131 J=2,N,2
      A=X(J)**2
      IF (A.EQ.0.0D 0) A=1.0D-60
      B=X(J-1)**2
      IF (B.EQ.0.0D 0) B=1.0D-60
      C=A+1.0D 0
      D=B+1.0D 0
      P=0.0D 0
      IF (A.GT.P) P=LOG(A)
      Q=0.0D 0
      IF (B.GT.Q) Q=LOG(B)
      G(J-1)=G(J-1)+2.0D 0*X(J-1)*(C*B**A+P*A**D)
      G(J)=G(J)+2.0D 0*X(J)*(D*A**B+Q*B**C)
  131 CONTINUE
      RETURN
  140 P=1.0D 0/DBLE(N+1)
      Q=0.5D 0*P**2
      DO 141 J=1,N
      A=2.0D 0*X(J)+Q*(X(J)+DBLE(J)*P+1.0D 0)**3
      IF(J.GT.1) A=A-X(J-1)
      IF(J.LT.N) A=A-X(J+1)
      G(J)=G(J)+A*(4.0D 0+6.0D 0*Q*(X(J)+DBLE(J)*P+1.0D 0)**2.0D 0)
      IF(J.GT.1) G(J-1)=G(J-1)-2.0D 0*A
      IF(J.LT.N) G(J+1)=G(J+1)-2.0D 0*A
  141 CONTINUE
      RETURN
  150 P=1.0D 0/DBLE(N+1)
      Q=2.0D 0/P
      R=2.0D 0*P
      DO 151 J=2,N
      A=X(J-1)-X(J)
      G(J-1)=G(J-1)+Q*(2.0D 0*X(J-1)-X(J))
      G(J)=G(J)-Q*X(J-1)
      IF (ABS(A).LE.1.0D-6) THEN
      G(J-1)=G(J-1)+R*EXP(X(J))*(1.0D 0/2.0D 0+A*(1.0D 0/3.0D 0+
     &  A/8.0D 0))
      G(J)=G(J)+R*EXP(X(J))*(1.0D 0/2.0D 0+A*(1.0D 0/6.0D 0+
     &  A/24.0D 0))
      ELSE
      B=EXP(X(J-1))-EXP(X(J))
      G(J-1)=G(J-1)+R*(EXP(X(J-1))*A-B)/A**2
      G(J)=G(J)-R*(EXP(X(J))*A-B)/A**2
      ENDIF
  151 CONTINUE
      G(1)=G(1)+R*(EXP(X(1))*(X(1)-1.0D 0)+1.0D 0)/X(1)**2
      G(N)=G(N)+2.0D 0*Q*X(N)
     &         +R*(EXP(X(N))*(X(N)-1.0D 0)+1.0D 0)/X(N)**2
      RETURN
  160 DO 161 J=1,N
      A=DBLE(J)*(1.0D 0-COS(X(J)))
      IF(J.GT.1) A=A+DBLE(J)*SIN(X(J-1))
      IF(J.LT.N) A=A-DBLE(J)*SIN(X(J+1))
      A=DBLE(J)*SIN(X(J))
      G(J)=G(J)+A
      IF(J.GT.1) G(J-1)=G(J-1)+DBLE(J)*COS(X(J-1))
      IF(J.LT.N) G(J+1)=G(J+1)-DBLE(J)*COS(X(J+1))
  161 CONTINUE
      RETURN
  170 P=1.0D 0/DBLE(N+1)
      DO 171 J=1,N
      IF (J.EQ.1) THEN
      G(J)=G(J)+0.5D 0*X(J)/P+P*EXP(X(J))
      G(J+1)=G(J+1)+0.25D 0*X(J+1)/P
      ELSE IF (J.EQ.N) THEN
      G(J)=G(J)+0.5D 0*X(J)/P+P*EXP(X(J))
      G(J-1)=G(J-1)+0.25D 0*X(J-1)/P
      ELSE
      A=0.25D 0*(X(J+1)-X(J-1))/P
      G(J)=G(J)+P*EXP(X(J))
      G(J-1)=G(J-1)-A
      G(J+1)=G(J+1)+A
      ENDIF
  171 CONTINUE
      RETURN
  180 P=1.0D 0/DBLE(N+1)
      DO 181 J=1,N
      Q=DBLE(J)*P
      IF (J.EQ.1) THEN
      G(J)=G(J)+X(J)/P-2.0D 0*P*(X(J)+Q)
      G(J+1)=G(J+1)+0.5D 0*X(J+1)/P
      ELSE IF (J.EQ.N) THEN
      G(J)=G(J)+X(J)/P-2.0D 0*P*(X(J)+Q)
      G(J-1)=G(J-1)+0.5D 0*X(J-1)/P
      ELSE
      A=0.5D 0*(X(J+1)-X(J-1))/P
      G(J)=G(J)-2.0D 0*P*(X(J)+Q)
      G(J-1)=G(J-1)-A
      G(J+1)=G(J+1)+A
      ENDIF
  181 CONTINUE
      RETURN
  190 P=1.0D 0/DBLE(N+1)
      DO 191 J=1,N
      Q=EXP(2.0D 0*DBLE(J)*P)
      IF (J.EQ.1) THEN
      R=1.0D 0/3.0D 0
      A=0.5D 0*(X(J+1)-R)/P
      G(J)=G(J)+2.0D 0*P*(X(J)+Q)+(X(J)-R)/P
      G(J+1)=G(J+1)+A
      ELSE IF (J.EQ.N) THEN
      R=EXP(2.0D 0)/3.0D 0
      A=0.5D 0*(X(J-1)-R)/P
      G(J)=G(J)+2.0D 0*P*(X(J)+Q)+(X(J)-R)/P
      G(J-1)=G(J-1)+A
      ELSE
      A=0.5D 0*(X(J+1)-X(J-1))/P
      G(J)=G(J)+2.0D 0*P*(X(J)+Q)
      G(J-1)=G(J-1)-A
      G(J+1)=G(J+1)+A
      ENDIF
  191 CONTINUE
      RETURN
  200 P=1.0D 0/DBLE(N+1)
      DO 201 J=1,N
      A=EXP(-2.0D 0*X(J)**2)
      IF (J.EQ.1) THEN
      B=0.5D 0*X(J+1)/P
      G(J)=G(J)+X(J)/P-4.0D 0*X(J)*A*P*(B**2-1.0D 0)
      G(J+1)=G(J+1)+A*B
      ELSE IF (J.EQ.N) THEN
      B=0.5D 0*X(J-1)/P
      G(J)=G(J)+X(J)/P*EXP(-2.0D 0)-4.0D 0*X(J)*A*P*(B**2-1.0D 0)
      G(J-1)=G(J-1)+A*B
      ELSE
      B=0.5D 0*(X(J+1)-X(J-1))/P
      G(J)=G(J)-4.0D 0*X(J)*A*P*(B**2-1.0D 0)
      G(J-1)=G(J-1)-A*B
      G(J+1)=G(J+1)+A*B
      ENDIF
  201 CONTINUE
      RETURN
  210 P=1.0D 0/DBLE(N+1)
      DO 211 J=1,N
      IF (J.EQ.1) THEN
      A=0.5D 0*(X(J+1)-1.0D 0)/P
      B=(X(J)-1.0D 0)/P
      U=ATAN(A)
      V=ATAN(B)
      G(J)=G(J)+2.0D 0*P*X(J)+0.5D 0*V
      G(J+1)=G(J+1)+0.5D 0*U
      ELSE IF (J.EQ.N) THEN
      A=0.5D 0*(2.0D 0-X(J-1))/P
      B=(2.0D 0-X(J))/P
      U=ATAN(A)
      V=ATAN(B)
      G(J)=G(J)+2.0D 0*P*X(J)-0.5D 0*V
      G(J-1)=G(J-1)-0.5D 0*U
      ELSE
      A=0.5D 0*(X(J+1)-X(J-1))/P
      U=ATAN(A)
      G(J)=G(J)+2.0D 0*P*X(J)
      G(J-1)=G(J-1)-0.5D 0*U
      G(J+1)=G(J+1)+0.5D 0*U
      ENDIF
  211 CONTINUE
      RETURN
  220 P=1.0D 0/DBLE(N+1)
      DO 221 J=1,N
      IF (J.EQ.1) THEN
      A= 0.5D 0*X(J+1)/P
      B= X(J)/P
      G(J)=G(J)+2.0D 2*P*(X(J)-A**2)+2.0D 2*B**3-(1.0D 0-B)
      G(J+1)=G(J+1)-2.0D 2*(X(J)-A**2)*A-(1.0D 0-A)
      ELSE IF (J.EQ.N) THEN
      A=-0.5D 0*X(J-1)/P
      B=-X(J)/P
      G(J)=G(J)+2.0D 2*P*(X(J)-A**2)-2.0D 2*B**3+(1.0D 0-B)
      G(J-1)=G(J-1)+2.0D 2*(X(J)-A**2)*A+(1.0D 0-A)
      ELSE
      A=0.5D 0*(X(J+1)-X(J-1))/P
      G(J)=G(J)+2.0D 2*P*(X(J)-A**2)
      G(J-1)=G(J-1)+2.0D 2*(X(J)-A**2)*A+(1.0D 0-A)
      G(J+1)=G(J+1)-2.0D 2*(X(J)-A**2)*A-(1.0D 0-A)
      ENDIF
  221 CONTINUE
      RETURN
  230 A1=-1.0D 0
      D1S=EXP(1.0D-2)
      D2S=1.0D 0
      DO 231 J=1,N
      A1=A1+DBLE(N-J+1)*X(J)**2
  231 CONTINUE
      A=4.0D 0*A1
      DO 232 J=1,N
      G(J)=A*DBLE(N-J+1)*X(J)
      S1=EXP(X(J)/1.0D 2)
      IF (J.GT.1) THEN
      S3=S1+S2-D2S*(D1S-1.0D 0)
      G(J)=G(J)+1.0D-5*S1*(S3+S1-1.0D 0/D1S)/5.0D 1
      G(J-1)=G(J-1)+1.0D-5*S2*S3/5.0D 1
      ENDIF
      S2=S1
      D2S=D1S*D2S
  232 CONTINUE
      G(1)=G(1)+2.0D 0*(X(1)-2.0D-1)
      RETURN
  250 A=1.0D 0
      B=0.0D 0
      C=0.0D 0
      D=0.0D 0
      U=EXP(X(N))
      V=EXP(X(N-1))
      DO 251 J=1,N
      IF (J.LE.N-2) THEN
      B=B+(X(J)+2.0D 0*X(J+1)+1.0D 1*X(J+2)-1.0D 0)**2
      C=C+(2.0D 0*X(J)+X(J+1)-3.0D 0)**2
      ENDIF
      D=D+X(J)**2-DBLE(N)
  251 CONTINUE
      DO 252 J=1,N
      IF (J.LE.N/2) G(J)=G(J)+2.0D 0*(X(J)-1.0D 0)
      IF (J.LE.N-2) THEN
      P=A*(U+C)*(X(J)+2.0D 0*X(J+1)+1.0D 1*X(J+2)-1.0D 0)
      Q=A*(V+B)*(2.0D 0*X(J)+X(J+1)-3.0D 0)
      G(J)=G(J)+2.0D 0*P+4.0D 0*Q
      G(J+1)=G(J+1)+4.0D 0*P+2.0D 0*Q
      G(J+2)=G(J+2)+2.0D 1*P
      ENDIF
      G(J)=G(J)+4.0D 0*D*X(J)
  252 CONTINUE
      G(N-1)=G(N-1)+A*V*C
      G(N)=G(N)+A*U*B
      RETURN
  310 DO 311 KA=1,NA
      IF(MOD(KA,2).EQ.1) THEN
      FA=1.0D 1*(X(KA+1)-X(KA)**2)
      G(KA)=G(KA)-2.0D 1*X(KA)*FA
      G(KA+1)=G(KA+1)+1.0D 1*FA
      ELSE
      FA=1.0D 0-X(KA-1)
      G(KA-1)=G(KA-1)-FA
      ENDIF
  311 CONTINUE
      RETURN
  320 DO 321 KA=1,NA
      IF(MOD(KA,4).EQ.1) THEN
      FA=X(KA)+1.0D 1*X(KA+1)
      G(KA)=G(KA)+FA
      G(KA+1)=G(KA+1)+1.0D 1*FA
      ELSEIF(MOD(KA,4).EQ.2) THEN
      FA=2.23606797749979D 0*(X(KA+1)-X(KA+2))
      G(KA+1)=G(KA+1)+2.23606797749979D 0*FA
      G(KA+2)=G(KA+2)-2.23606797749979D 0*FA
      ELSEIF(MOD(KA,4).EQ.3) THEN
      A=X(KA-1)-2.0D 0*X(KA)
      FA=A**2
      G(KA-1)=G(KA-1)+2.0D 0*A*FA
      G(KA)=G(KA)-4.0D 0*A*FA
      ELSE
      FA=3.16227766016838D 0*(X(KA-3)-X(KA))**2
      A=2.0D 0*(X(KA-3)-X(KA))
      G(KA-3)=G(KA-3)+3.16227766016838D 0*A*FA
      G(KA)=G(KA)-3.16227766016838D 0*A*FA
      ENDIF
  321 CONTINUE
      RETURN
  330 DO 333 KA=1,NA
      IF(KA.LE.N) THEN
      FA=(X(KA)-1.0D 0)/3.16227766016838D 0**5
      G(KA)=G(KA)+1.0D 0/3.16227766016838D 0**5*FA
      ELSE
      FA=-0.25D 0
      DO 331 J=1,N
      FA=FA+X(J)**2
  331 CONTINUE
      DO 332 J=1,N
      G(J)=G(J)+2.0D 0*X(J)*FA
  332 CONTINUE
      ENDIF
  333 CONTINUE
      RETURN
  350 DO 354 KA=1,NA
      IF(KA.LE.N) THEN
      FA=X(KA)-1.0D 0
      G(KA)=G(KA)+FA
      ELSE
      FA=0.0D 0
      DO 351 J=1,N
      FA=FA+DBLE(J)*(X(J)-1.0D 0)
  351 CONTINUE
      IF(KA.EQ.N+1) THEN
      DO 352 J=1,N
      G(J)=G(J)+DBLE(J)*FA
  352 CONTINUE
      ELSE IF(KA.EQ.N+2) THEN
      DO 353 J=1,N
      G(J)=G(J)+2.0D 0*DBLE(J)*FA**3
  353 CONTINUE
      FA=FA**2
      ENDIF
      ENDIF
  354 CONTINUE
      RETURN
  370 DO 376 KA=1,NA
      IF(KA.LT.N) THEN
      A=0.0D 0
      DO 371 J=1,N
      A=A+X(J)
  371 CONTINUE
      FA=X(KA)+A-DBLE(N+1)
      DO 372 J=1,N
      G(J)=G(J)+FA
  372 CONTINUE
      G(KA)=G(KA)+FA
      ELSE
      A=1.0D 0
      DO 373 J=1,N
      A=A*X(J)
  373 CONTINUE
      FA=A-1.0D 0
      I=0
      DO 374 J=1,N
      B=X(J)
      IF(B.EQ.0.0D 0.AND.I.EQ.0) I=J
      IF(I.NE.J) A=A*B
  374 CONTINUE
      IF(I.EQ.0) THEN
      DO 375 J=1,N
      G(J)=G(J)+A/X(J)*FA
  375 CONTINUE
      ELSE
      G(I)=G(I)+A*FA
      ENDIF
      ENDIF
  376 CONTINUE
      RETURN
  390 DO 393 KA=1,NA
      U=1.0D 0/DBLE(N+1)
      V=DBLE(KA)*U
      A=0.0D 0
      B=0.0D 0
      DO 391 J=1,N
      W=DBLE(J)*U
      IF(J.LE.KA) THEN
      A=A+W*(X(J)+W+1.0D 0)**3
      ELSE
      B=B+(1.0D 0-W)*(X(J)+W+1.0D 0)**3
      ENDIF
  391 CONTINUE
      FA=X(KA)+U*((1.0D 0-V)*A+V*B)/2.0D 0
      DO 392 J=1,N
      W=DBLE(J)*U
      A=(X(J)+W+1.0D 0)**2
      IF(J.LE.KA) THEN
      G(J)=G(J)+1.5D 0*U*(1.0D 0-V)*W*A*FA
      ELSE
      G(J)=G(J)+1.5D 0*U*(1.0D 0-W)*V*A*FA
      ENDIF
  392 CONTINUE
      G(KA)=G(KA)+FA
  393 CONTINUE
      RETURN
  400 DO 401 KA=1,NA
      FA=(3.0D 0-2.0D 0*X(KA))*X(KA)+1.0D 0
      IF(KA.GT.1) FA=FA-X(KA-1)
      IF(KA.LT.N) FA=FA-2.0D 0*X(KA+1)
      G(KA)=G(KA)+(3.0D 0-4.0D 0*X(KA))*FA
      IF(KA.GT.1) G(KA-1)=G(KA-1)-FA
      IF(KA.LT.N) G(KA+1)=G(KA+1)-2.0D 0*FA
  401 CONTINUE
      RETURN
  450 DO 451 KA=1,NA
      I=KA
      FA=(3.0D 0-2.0D 0*X(I))*X(I)+1.0D 0
      IF (I.GT.1) FA=FA-X(I-1)
      IF (I.LT.N) FA=FA-X(I+1)
      G(I)=G(I)+(3.0D 0-4.0D 0*X(I))*FA
      IF (I.GT.1) G(I-1)=G(I-1)-FA
      IF (I.LT.N) G(I+1)=G(I+1)-FA
  451 CONTINUE
      RETURN
  460 DO 463 KA=1,NA
      I=KA
      FA=(2.0D 0+5.0D 0*X(I)**2)*X(I)+1.0D 0
      DO 461 J=MAX(1,I-5),MIN(N,I+1)
      IF (I.NE.J) FA=FA+X(J)*(1.0D 0+X(J))
  461 CONTINUE
      DO 462 J=MAX(1,I-5),MIN(N,I+1)
      IF (I.NE.J) G(J)=G(J)+(1.0D 0+2.0D 0*X(J))*FA
  462 CONTINUE
      G(I)=G(I)+(2.0D 0+1.5D 1*X(I)**2)*FA
  463 CONTINUE
      RETURN
  470 DO 471 KA=1,NA
      I=(KA+1)/2
      IF (MOD(KA,2).EQ.1) THEN
      FA=X(I)+X(I+1)*((5.0D 0-X(I+1))*X(I+1)-2.0D 0)-1.3D 1
      G(I)=G(I)+FA
      G(I+1)=G(I+1)+(1.0D 1*X(I+1)-3.0D 0*X(I+1)**2-2.0D 0)*FA
      ELSE
      FA=X(I)+X(I+1)*((1.0D 0+X(I+1))*X(I+1)-1.4D 1)-2.9D 1
      G(I)=G(I)+FA
      G(I+1)=G(I+1)+(2.0D 0*X(I+1)+3.0D 0*X(I+1)**2-1.4D 1)*FA
      ENDIF
  471 CONTINUE
      RETURN
  480 DO 481 KA=1,NA
      I=MOD(KA,N/2)+1
      J=I+N/2
      M=5*N
      IF (KA.LE.M/2) THEN
      IA=1
      ELSE
      IA=2
      ENDIF
      IB=5-KA/(M/4)
      IC=MOD(KA,5)+1
      FA=(X(I)**IA-X(J)**IB)**IC
      A=DBLE(IA)
      B=DBLE(IB)
      C=DBLE(IC)
      D=X(I)**IA-X(J)**IB
      IF (D.NE.0.0D 0) THEN
      E=C*D**(IC-1)
      IF (X(I).EQ.0.0D 0.AND.IA.LE.1) THEN
      ELSE
      G(I)=G(I)+E*A*X(I)**(IA-1)*FA
      ENDIF
      IF (X(J).EQ.0.0D 0.AND.IB.LE.1) THEN
      ELSE
      G(J)=G(J)-E*B*X(J)**(IB-1)*FA
      ENDIF
      ENDIF
  481 CONTINUE
      RETURN
  490 DO 491 KA=1,NA
      I=2*((KA+5)/6)-1
      IF (MOD(KA,6).EQ.1) THEN
      FA=X(I)+3.0D 0*X(I+1)*(X(I+2)-1.0D 0)+X(I+3)**2-1.0D 0
      G(I)=G(I)+FA
      G(I+1)=G(I+1)+3.0D 0*(X(I+2)-1.0D 0)*FA
      G(I+2)=G(I+2)+3.0D 0*X(I+1)*FA
      G(I+3)=G(I+3)+2.0D 0*X(I+3)*FA
      ELSEIF (MOD(KA,6).EQ.2) THEN
      FA=(X(I)+X(I+1))**2+(X(I+2)-1.0D 0)**2-X(I+3)-3.0D 0
      G(I)=G(I)+2.0D 0*(X(I)+X(I+1))*FA
      G(I+1)=G(I+1)+2.0D 0*(X(I)+X(I+1))*FA
      G(I+2)=G(I+2)+2.0D 0*(X(I+2)-1.0D 0)*FA
      G(I+3)=G(I+3)-FA
      ELSEIF (MOD(KA,6).EQ.3) THEN
      FA=X(I)*X(I+1)-X(I+2)*X(I+3)
      G(I)=G(I)+X(I+1)*FA
      G(I+1)=G(I+1)+X(I)*FA
      G(I+2)=G(I+2)-X(I+3)*FA
      G(I+3)=G(I+3)-X(I+2)*FA
      ELSEIF (MOD(KA,6).EQ.4) THEN
      FA=2.0D 0*X(I)*X(I+2)+X(I+1)*X(I+3)-3.0D 0
      G(I)=G(I)+2.0D 0*X(I+2)*FA
      G(I+1)=G(I+1)+X(I+3)*FA
      G(I+2)=G(I+2)+2.0D 0*X(I)*FA
      G(I+3)=G(I+3)+X(I+1)*FA
      ELSEIF (MOD(KA,6).EQ.5) THEN
      FA=(X(I)+X(I+1)+X(I+2)+X(I+3))**2+(X(I)-1.0D 0)**2
      G(I)=G(I)+(2.0D 0*(X(I)+X(I+1)+X(I+2)+X(I+3))+
     & 2.0D 0*(X(I)-1.0D 0))*FA
      G(I+1)=G(I+1)+2.0D 0*(X(I)+X(I+1)+X(I+2)+X(I+3))*FA
      G(I+2)=G(I+2)+2.0D 0*(X(I)+X(I+1)+X(I+2)+X(I+3))*FA
      G(I+3)=G(I+3)+2.0D 0*(X(I)+X(I+1)+X(I+2)+X(I+3))*FA
      ELSE
      FA=X(I)*X(I+1)*X(I+2)*X(I+3)+(X(I+3)-1.0D 0)**2-1.0D 0
      G(I)=G(I)+X(I+1)*X(I+2)*X(I+3)*FA
      G(I+1)=G(I+1)+X(I)*X(I+2)*X(I+3)*FA
      G(I+2)=G(I+2)+X(I)*X(I+1)*X(I+3)*FA
      G(I+3)=G(I+3)+(X(I)*X(I+1)*X(I+2)+2.0D 0*(X(I+3)-1.0D 0))*FA
      ENDIF
  491 CONTINUE
      RETURN
  500 DO 501 KA=1,NA
      I=(KA+1)/2
      J=MOD(KA,2)
      IF (J.EQ.0) THEN
      FA=6.0D 0-EXP(2.0D 0*X(I))-EXP(2.0D 0*X(I+1))
      G(I)=G(I)-2.0D 0*EXP(2.0D 0*X(I))*FA
      G(I+1)=G(I+1)-2.0D 0*EXP(2.0D 0*X(I+1))*FA
      ELSEIF (I.EQ.1) THEN
      FA=4.0D 0-EXP(X(I))-EXP(X(I+1))
      G(I)=G(I)-EXP(X(I))*FA
      G(I+1)=G(I+1)-EXP(X(I+1))*FA
      ELSEIF (I.EQ.N) THEN
      FA=8.0D 0-EXP(3.0D 0*X(I-1))-EXP(3.0D 0*X(I))
      G(I-1)=G(I-1)-3.0D 0*EXP(3.0D 0*X(I-1))*FA
      G(I)=G(I)-3.0D 0*EXP(3.0D 0*X(I))*FA
      ELSE
      FA=8.0D 0-EXP(3.0D 0*X(I-1))-EXP(3.0D 0*X(I))+
     & 4.0D 0-EXP(X(I))-EXP(X(I+1))
      G(I-1)=G(I-1)-3.0D 0*EXP(3.0D 0*X(I-1))*FA
      G(I)=G(I)-(3.0D 0*EXP(3.0D 0*X(I))+EXP(X(I)))*FA
      G(I+1)=G(I+1)-EXP(X(I+1))*FA
      ENDIF
  501 CONTINUE
      RETURN
  510 DO 511 KA=1,NA
      I=(KA+1)/2
      IF (MOD(KA,2).EQ.1) THEN
      FA=1.0D 1*(2.0D 0*X(I)/(1.0D 0+X(I)**2)-X(I+1))
      G(I)=G(I)+2.0D 1*(1.0D 0-X(I)**2)/(1.0D 0+X(I)**2)**2*FA
      G(I+1)=G(I+1)-1.0D 1*FA
      ELSE
      FA=X(I)-1.0D 0
      G(I)=G(I)+FA
      ENDIF
  511 CONTINUE
      RETURN
  520 DO 521 KA=1,NA
      I=3*((KA+5)/6)-2
      IF (MOD(KA,6).EQ.1) THEN
      FA=1.0D 1*(X(I)**2-X(I+1))
      G(I)=G(I)+2.0D 1*X(I)*FA
      G(I+1)=G(I+1)-1.0D 1*FA
      ELSEIF (MOD(KA,6).EQ.2) THEN
      FA=X(I+2)-1.0D 0
      G(I+2)=G(I+2)+FA
      ELSEIF (MOD(KA,6).EQ.3) THEN
      FA=(X(I+3)-1.0D 0)**2
      G(I+3)=G(I+3)+2.0D 0*(X(I+3)-1.0D 0)*FA
      ELSEIF (MOD(KA,6).EQ.4) THEN
      FA=(X(I+4)-1.0D 0)**3
      G(I+4)=G(I+4)+3.0D 0*(X(I+4)-1.0D 0)**2*FA
      ELSEIF (MOD(KA,6).EQ.5) THEN
      FA=X(I)**2*X(I+3)+SIN(X(I+3)-X(I+4))-1.0D 1
      G(I)=G(I)+2.0D 0*X(I)*X(I+3)*FA
      G(I+3)=G(I+3)+(X(I)**2+COS(X(I+3)-X(I+4)))*FA
      G(I+4)=G(I+4)-COS(X(I+3)-X(I+4))*FA
      ELSE
      FA=X(I+1)+(X(I+2)**2*X(I+3))**2-2.0D 1
      G(I+1)=G(I+1)+FA
      G(I+2)=G(I+2)+4.0D 0*X(I+2)*(X(I+2)*X(I+3))**2*FA
      G(I+3)=G(I+3)+2.0D 0*X(I+2)**4*X(I+3)*FA
      ENDIF
  521 CONTINUE
      RETURN
  530 DO 531 KA=1,NA
      I=3*((KA+6)/7)-2
      IF (MOD(KA,7).EQ.1) THEN
      FA=1.0D 1*(X(I)**2-X(I+1))
      G(I)=G(I)+2.0D 1*X(I)*FA
      G(I+1)=G(I+1)-1.0D 1*FA
      ELSEIF (MOD(KA,7).EQ.2) THEN
      FA=1.0D 1*(X(I+1)**2-X(I+2))
      G(I+1)=G(I+1)+2.0D 1*X(I+1)*FA
      G(I+2)=G(I+2)-1.0D 1*FA
      ELSEIF (MOD(KA,7).EQ.3) THEN
      FA=(X(I+2)-X(I+3))**2
      G(I+2)=G(I+2)+2.0D 0*(X(I+2)-X(I+3))*FA
      G(I+3)=G(I+3)-2.0D 0*(X(I+2)-X(I+3))*FA
      ELSEIF (MOD(KA,7).EQ.4) THEN
      FA=(X(I+3)-X(I+4))**2
      G(I+3)=G(I+3)+2.0D 0*(X(I+3)-X(I+4))*FA
      G(I+4)=G(I+4)-2.0D 0*(X(I+3)-X(I+4))*FA
      ELSEIF (MOD(KA,7).EQ.5) THEN
      FA=X(I)+X(I+1)**2+X(I+2)-3.0D 1
      G(I)=G(I)+FA
      G(I+1)=G(I+1)+2.0D 0*X(I+1)*FA
      G(I+2)=G(I+2)+FA
      ELSEIF (MOD(KA,7).EQ.6) THEN
      FA=X(I+1)-X(I+2)**2+X(I+3)-1.0D 1
      G(I+1)=G(I+1)+FA
      G(I+2)=G(I+2)-2.0D 0*X(I+2)*FA
      G(I+3)=G(I+3)+FA
      ELSE
      FA=X(I)*X(I+4)-1.0D 1
      G(I)=G(I)+X(I+4)*FA
      G(I+4)=G(I+4)+X(I)*FA
      ENDIF
  531 CONTINUE
      RETURN
  540 DO 546 KA=1,NA
      I=2*((KA+3)/4)-2
      L=MOD((KA-1),4)+1
      FA=-Y(L)
      DO 542 K=1,3
      A=DBLE(K*K)/DBLE(L)
      DO 541 J=1,4
      IF (X(I+J).EQ.0) X(I+J)=1.0D-16
      A=A*SIGN(1.0D 0,X(I+J))*ABS(X(I+J))**(DBLE(J)/DBLE(K*L))
  541 CONTINUE
      FA=FA+A
  542 CONTINUE
      DO 545 K=1,3
      A=DBLE(K*K)/DBLE(L)
      DO 543 J=1,4
      A=A*SIGN(1.0D 0,X(I+J))*ABS(X(I+J))**(DBLE(J)/DBLE(K*L))
  543 CONTINUE
      DO 544 J=1,4
      G(I+J)=G(I+J)+(DBLE(J)/DBLE(K*L))*A/X(I+J)*FA
  544 CONTINUE
  545 CONTINUE
  546 CONTINUE
      RETURN
  550 DO 556 KA=1,NA
      I=2*((KA+3)/4)-2
      L=MOD((KA-1),4)+1
      FA=-Y(L)
      DO 552 K=1,3
      A=0.0D 0
      DO 551 J=1,4
      A=A+X(I+J)*(DBLE(J)/DBLE(K*L))
  551 CONTINUE
      FA=FA+EXP(A)*DBLE(K*K)/DBLE(L)
  552 CONTINUE
      DO 555 K=1,3
      A=0.0D 0
      DO 553 J=1,4
      A=A+X(I+J)*(DBLE(J)/DBLE(K*L))
  553 CONTINUE
      A=EXP(A)*DBLE(K*K)/DBLE(L)
      DO 554 J=1,4
      G(I+J)=G(I+J)+A*(DBLE(J)/DBLE(K*L))*FA
  554 CONTINUE
  555 CONTINUE
  556 CONTINUE
      RETURN
  560 DO 563 KA=1,NA
      I=2*((KA+3)/4)-2
      L=MOD((KA-1),4)+1
      FA=-Y(L)
      DO 561 J=1,4
      FA=FA+DBLE((1-2*MOD(J,2))*L*J*J)*SIN(X(I+J))+
     & DBLE(L*L*J)*COS(X(I+J))
  561 CONTINUE
      DO 562 J=1,4
      G(I+J)=G(I+J)+(DBLE((1-2*MOD(J,2))*L*J*J)*COS(X(I+J))-
     & DBLE(L*L*J)*SIN(X(I+J)))*FA
  562 CONTINUE
  563 CONTINUE
      RETURN
  570 DO 571 KA=1,NA
      ALFA=0.5D 0
      IF (KA.EQ.1) THEN
      FA=ALFA-(1.0D 0-ALFA)*X(3)-X(1)*(1.0D 0+4.0D 0*X(2))
      G(1)=G(1)-(1.0D 0+4.0D 0*X(2))*FA
      G(2)=G(2)-4.0D 0*X(1)*FA
      G(3)=G(3)+(ALFA-1.0D 0)*FA
      ELSEIF(KA.EQ.2) THEN
      FA=-(2.0D 0-ALFA)*X(4)-X(2)*(1.0D 0+4.0D 0*X(1))
      G(1)=G(1)-4.0D 0*X(2)*FA
      G(2)=G(2)-(1.0D 0+4.0D 0*X(1))*FA
      G(4)=G(4)+(ALFA-2.0D 0)*FA
      ELSEIF(KA.EQ.N-1) THEN
      FA=ALFA*X(N-3)-X(N-1)*(1.0D 0+4.0D 0*X(N))
      G(N-3)=G(N-3)+ALFA*FA
      G(N-1)=G(N-1)-(1.0D 0+4.0D 0*X(N))*FA
      G(N)=G(N)-4.0D 0*X(N-1)*FA
      ELSEIF (KA.EQ.N) THEN
      FA=ALFA*X(N-2)-(2.0D 0-ALFA)-X(N)*(1.0D 0+4.0D 0*X(N-1))
      G(N-2)=G(N-2)+ALFA*FA
      G(N-1)=G(N-1)-4.0D 0*X(N)*FA
      G(N)=G(N)-(1.0D 0+4.0D 0*X(N-1))*FA
      ELSEIF (MOD(KA,2).EQ.1) THEN
      FA=ALFA*X(KA-2)-(1.0D 0-ALFA)*X(KA+2)-
     & X(KA)*(1.0D 0+4.0D 0*X(KA+1))
      G(KA-2)=G(KA-2)+ALFA*FA
      G(KA)=G(KA)-(1.0D 0+4.0D 0*X(KA+1))*FA
      G(KA+1)=G(KA+1)-4.0D 0*X(KA)*FA
      G(KA+2)=G(KA+2)+(ALFA-1.0D 0)*FA
      ELSE
      FA=ALFA*X(KA-2)-(2.0D 0-ALFA)*X(KA+2)-
     & X(KA)*(1.0D 0+4.0D 0*X(KA-1))
      G(KA-2)=G(KA-2)+ALFA*FA
      G(KA-1)=G(KA-1)-4.0D 0*X(KA)*FA
      G(KA)=G(KA)-(1.0D 0+4.0D 0*X(KA-1))*FA
      G(KA+2)=G(KA+2)+(ALFA-2.0D 0)*FA
      ENDIF
  571 CONTINUE
      RETURN
  580 DO 581 KA=1,NA
      IF (KA.LT.2) THEN
      FA=4.0D 0*(X(KA)-X(KA+1)**2)
      G(KA)=G(KA)+4.0D 0*FA
      G(KA+1)=G(KA+1)-8.0D 0*X(KA+1)*FA
      ELSEIF (KA.LT.N) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)
      G(KA-1)=G(KA-1)-8.0D 0*X(KA)*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+6.0D 0)*FA
      G(KA+1)=G(KA+1)-8.0D 0*X(KA+1)*FA
      ELSE
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))
      G(KA-1)=G(KA-1)-8.0D 0*X(KA)*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+2.0D 0)*FA
      ENDIF
  581 CONTINUE
      RETURN
  590 DO 591 KA=1,NA
      IF (KA.EQ.1) THEN
      FA=-2.0D 0*X(KA)**2+3.0D 0*X(KA)-2.0D 0*X(KA+1)+
     & 3.0D 0*X(N-4)-X(N-3)-X(N-2)+0.5D 0*X(N-1)-X(N)+1.0D 0
      G(N-4)=G(N-4)+3.0D 0*FA
      G(N-3)=G(N-3)-FA
      G(N-2)=G(N-2)-FA
      G(N-1)=G(N-1)+0.50D 0*FA
      G(N)=G(N)-FA
      G(KA)=G(KA)-(4.0D 0*X(KA)-3.0D 0)*FA
      G(KA+1)=G(KA+1)-2.0D 0*FA
      ELSEIF (KA.LE.N-1) THEN
      FA=-2.0D 0*X(KA)**2+3.0D 0*X(KA)-X(KA-1)-2.0D 0*X(KA+1)+
     & 3.0D 0*X(N-4)-X(N-3)-X(N-2)+0.5D 0*X(N-1)-X(N)+1.0D 0
      G(N-4)=G(N-4)+3.0D 0*FA
      G(N-3)=G(N-3)-FA
      G(N-2)=G(N-2)-FA
      G(N-1)=G(N-1)+0.50D 0*FA
      G(N)=G(N)-FA
      G(KA-1)=G(KA-1)-FA
      G(KA)=G(KA)-(4.0D 0*X(KA)-3.0D 0)*FA
      G(KA+1)=G(KA+1)-2.0D 0*FA
      ELSE
      FA=-2.0D 0*X(N)**2+3.0D 0*X(N)-X(N-1)+
     & 3.0D 0*X(N-4)-X(N-3)-X(N-2)+0.5D 0*X(N-1)-X(N)+1.0D 0
      G(N-4)=G(N-4)+3.0D 0*FA
      G(N-3)=G(N-3)-FA
      G(N-2)=G(N-2)-FA
      G(N-1)=G(N-1)-0.50D 0*FA
      G(N)=G(N)-(4.0D 0*X(N)-2.0D 0)*FA
      ENDIF
  591 CONTINUE
      RETURN
  600 DO 601 KA=1,NA
      U=1.0D 0/DBLE(N+1)
      V=DBLE(KA)*U
      FA=2.0D 0*X(KA)+0.5D 0*U*U*(X(KA)+V+1.0D 0)**3+1.0D 0
      IF(KA.GT.1) FA=FA-X(KA-1)
      IF(KA.LT.N) FA=FA-X(KA+1)
      G(KA)=G(KA)+(2.0D 0+1.5D 0*U**2*(X(KA)+V+1.0D 0)**2)*FA
      IF(KA.GT.1) G(KA-1)=G(KA-1)-FA
      IF(KA.LT.N) G(KA+1)=G(KA+1)-FA
  601 CONTINUE
      RETURN
  610 DO 611 KA=1,NA
      I=3*((KA+6)/7)-2
      IF (MOD(KA,7).EQ.1) THEN
      FA=1.0D 1*(X(I)**2-X(I+1))
      G(I)=G(I)+2.0D 1*X(I)*FA
      G(I+1)=G(I+1)-1.0D 1*FA
      ELSEIF (MOD(KA,7).EQ.2) THEN
      FA=X(I+1)+X(I+2)-2.0D 0
      G(I+1)=G(I+1)+FA
      G(I+2)=G(I+2)+FA
      ELSEIF (MOD(KA,7).EQ.3) THEN
      FA=X(I+3)-1.0D 0
      G(I+3)=G(I+3)+FA
      ELSEIF (MOD(KA,7).EQ.4) THEN
      FA=X(I+4)-1.0D 0
      G(I+4)=G(I+4)+FA
      ELSEIF (MOD(KA,7).EQ.5) THEN
      FA=X(I)+3.0D 0*X(I+1)
      G(I)=G(I)+FA
      G(I+1)=G(I+1)+3.0D 0*FA
      ELSEIF (MOD(KA,7).EQ.6) THEN
      FA=X(I+2)+X(I+3)-2.0D 0*X(I+4)
      G(I+2)=G(I+2)+FA
      G(I+3)=G(I+3)+FA
      G(I+4)=G(I+4)-2.0D 0*FA
      ELSE
      FA=1.0D 1*(X(I+1)**2-X(I+4))
      G(I+1)=G(I+1)+2.0D 1*X(I+1)*FA
      G(I+4)=G(I+4)-1.0D 1*FA
      ENDIF
  611 CONTINUE
      RETURN
  620 DO 621 KA=1,NA
      I=KA/2
      IF (KA.EQ.1) THEN
      FA=X(KA)-1.0D 0
      G(KA)=G(KA)+FA
      ELSE IF (MOD(KA,2).EQ.0) THEN
      FA=1.0D 1*(X(I)**2-X(I+1))
      G(I)=G(I)+2.0D 1*X(I)*FA
      G(I+1)=G(I+1)-1.0D 1*FA
      ELSE
      A=2.0D 0*EXP(-(X(I)-X(I+1))**2)
      B=EXP(-2.0D 0*(X(I+1)-X(I+2))**2)
      FA=A+B
      G(I)=G(I)-2.0D 0*(X(I)-X(I+1))*A*FA
      G(I+1)=G(I+1)+(2.0D 0*(X(I)-X(I+1))*A-4.0D 0*(X(I+1)-X(I+2))*B)*FA
      G(I+2)=G(I+2)+4.0D 0*(X(I+1)-X(I+2))*B*FA
      ENDIF
  621 CONTINUE
      RETURN
  630 DO 633 KA=1,NA
      IA=MIN(MAX(MOD(KA,13)-2,1),7)
      IB=(KA+12)/13
      I=IA+IB-1
      IF (IA.EQ.7) THEN
      J=IB
      ELSE
      J=IA+IB
      ENDIF
      C=3.0D 0*DBLE(IA)/1.0D 1
      A=0.0D 0
      B=EXP(SIN(C)*X(J))
      D=X(J)-SIN(X(I))-1.0D 0+Y(1)
      E=1.0D 0+COS(C)
      DO 631 L=0,6
      IF (IB+L.NE.I.AND.IB+L.NE.J) A=A+SIN(X(IB+L))-Y(1)
  631 CONTINUE
      FA=E*D**2+5.0D 0*(X(I)-1.0D 0)*B+0.5D 0*A
      G(I)=G(I)-(2.0D 0*D*E*COS(X(I))-5.0D 0*B)*FA
      G(J)=G(J)+(2.0D 0*D*E+5.0D 0*(X(I)-1.0D 0)*B*SIN(C))*FA
      DO 632 L=0,6
      IF (IB+L.NE.I.AND.IB+L.NE.J)
     & G(IB+L)=G(IB+L)+0.5D 0*COS(X(IB+L))*FA
  632 CONTINUE
  633 CONTINUE
      RETURN
  720 DO 721 KA=1,NA
      A1=0.414214D 0
      IF (KA.EQ.1) THEN
      FA=X(1)-(1.0D 0-X(1))*X(3)-A1*(1.0D 0+4.0D 0*X(2))
      G(1)=G(1)+(1.0D 0+X(3))*FA
      G(2)=G(2)-4.0D 0*A1*FA
      G(3)=G(3)-(1.0D 0-X(1))*FA
      ELSEIF (KA.EQ.2) THEN
      FA=-(1.0D 0-X(1))*X(4)-A1*(1.0D 0+4.0D 0*X(2))
      G(1)=G(1)+X(4)*FA
      G(2)=G(2)-4.0D 0*A1*FA
      G(4)=G(4)-(1.0D 0-X(1))*FA
      ELSEIF (KA.EQ.3) THEN
      FA=A1*X(1)-(1.0D 0-X(1))*X(5)-X(3)*(1.0D 0+4.0D 0*X(2))
      G(1)=G(1)+(A1+X(5))*FA
      G(2)=G(2)-4.0D 0*X(3)*FA
      G(3)=G(3)-(1.0D 0+4.0D 0*X(2))*FA
      G(5)=G(5)-(1.0D 0-X(1))*FA
      ELSEIF (KA.LE.N-2) THEN
      FA=X(1)*X(KA-2)-(1.0D 0-X(1))*X(KA+2)-
     & X(KA)*(1.0D 0+4.0D 0*X(KA-1))
      G(1)=G(1)+(X(KA-2)+X(KA+2))*FA
      G(KA-2)=G(KA-2)+X(1)*FA
      G(KA-1)=G(KA-1)-4.0D 0*X(KA)*FA
      G(KA)=G(KA)-(1.0D 0+4.0D 0*X(KA-1))*FA
      G(KA+2)=G(KA+2)-(1.0D 0-X(1))*FA
      ELSEIF (KA.EQ.N-1) THEN
      FA=X(1)*X(N-3)-X(N-1)*(1.0D 0+4.0D 0*X(N-2))
      G(1)=G(1)+X(N-3)*FA
      G(N-3)=G(N-3)+X(1)*FA
      G(N-2)=G(N-2)-4.0D 0*X(N-1)*FA
      G(N-1)=G(N-1)-(1.0D 0+4.0D 0*X(N-2))*FA
      ELSE
      FA=X(1)*X(N-2)-(1.0D 0-X(1))-X(N)*(1.0D 0+4.0D 0*X(N-1))
      G(1)=G(1)+(X(N-2)+1.0D 0)*FA
      G(N-2)=G(N-2)+X(1)*FA
      G(N-1)=G(N-1)-4.0D 0*X(N)*FA
      G(N)=G(N)-(1.0D 0+4.0D 0*X(N-1))*FA
      ENDIF
  721 CONTINUE
      RETURN
  740 DO 741 KA=1,NA
      IF (KA.LT.2) THEN
      FA=3.0D 0*X(KA)**3+2.0D 0*X(KA+1)-5.0D 0+
     & SIN(X(KA)-X(KA+1))*SIN(X(KA)+X(KA+1))
      D1S=COS(X(KA)-X(KA+1))*SIN(X(KA)+X(KA+1))
      D2S=SIN(X(KA)-X(KA+1))*COS(X(KA)+X(KA+1))
      G(KA)=G(KA)+(9.0D 0*X(KA)**2+D1S+D2S)*FA
      G(KA+1)=G(KA+1)+(2.0D 0-D1S+D2S)*FA
      ELSEIF (KA.LT.N) THEN
      FA=3.0D 0*X(KA)**3+2.0D 0*X(KA+1)-5.0D 0+
     & SIN(X(KA)-X(KA+1))*SIN(X(KA)+X(KA+1))+4.0D 0*X(KA)-
     & X(KA-1)*EXP(X(KA-1)-X(KA))-3.0D 0
      D1S=COS(X(KA)-X(KA+1))*SIN(X(KA)+X(KA+1))
      D2S=SIN(X(KA)-X(KA+1))*COS(X(KA)+X(KA+1))
      EX=EXP(X(KA-1)-X(KA))
      G(KA-1)=G(KA-1)-(EX+X(KA-1)*EX)*FA
      G(KA)=G(KA)+(9.0D 0*X(KA)**2+D1S+D2S+4.0D 0+X(KA-1)*EX)*FA
      G(KA+1)=G(KA+1)+(2.0D 0-D1S+D2S)*FA
      ELSE
      FA=4.0D 0*X(KA)-X(KA-1)*EXP(X(KA-1)-X(KA))-3.0D 0
      EX=EXP(X(KA-1)-X(KA))
      G(KA-1)=G(KA-1)-(EX+X(KA-1)*EX)*FA
      G(KA)=G(KA)+(4.0D 0+X(KA-1)*EX)*FA
      ENDIF
  741 CONTINUE
      RETURN
  750 DO 751 KA=1,NA
      IF (MOD(KA,2).EQ.1) THEN
      FA=0.0D 0
      IF (KA.NE.1) FA=FA-6.0D 0*(X(KA-2)-X(KA))**3+1.0D 1-
     & 4.0D 0*X(KA-1)-2.0D 0*SIN(X(KA-2)-X(KA-1)-X(KA))*
     & SIN(X(KA-2)+X(KA-1)-X(KA))
      IF (KA.NE.N) FA=FA+3.0D 0*(X(KA)-X(KA+2))**3-5.0D 0+
     & 2.0D 0*X(KA+1)+SIN(X(KA)-X(KA+1)-X(KA+2))*
     & SIN(X(KA)+X(KA+1)-X(KA+2))
      IF (KA.NE.1) THEN
      D1S=COS(X(KA-2)-X(KA-1)-X(KA))*SIN(X(KA-2)+X(KA-1)-X(KA))
      D2S=SIN(X(KA-2)-X(KA-1)-X(KA))*COS(X(KA-2)+X(KA-1)-X(KA))
      G(KA-2)=G(KA-2)-(18.0D 0*(X(KA-2)-X(KA))**2+2.0D 0*(D1S+D2S))*FA
      G(KA-1)=G(KA-1)-(4.0D 0-2.0D 0*(D1S-D2S))*FA
      G(KA)=G(KA)+(18.0D 0*(X(KA-2)-X(KA))**2+2.0D 0*(D1S+D2S))*FA
      ENDIF
      IF (KA.NE.N) THEN
      D1S=COS(X(KA)-X(KA+1)-X(KA+2))*SIN(X(KA)+X(KA+1)-X(KA+2))
      D2S=SIN(X(KA)-X(KA+1)-X(KA+2))*COS(X(KA)+X(KA+1)-X(KA+2))
      G(KA)=G(KA)+(9.0D 0*(X(KA)-X(KA+2))**2+D1S+D2S)*FA
      G(KA+1)=G(KA+1)+(2.0D 0-D1S+D2S)*FA
      G(KA+2)=G(KA+2)-(9.0D 0*(X(KA)-X(KA+2))**2+D1S+D2S)*FA
      ENDIF
      ELSE
      EX=EXP(X(KA-1)-X(KA)-X(KA+1))
      FA=4.0D 0*X(KA)-(X(KA-1)-X(KA+1))*EX-3.0D 0
      W=X(KA-1)-X(KA+1)
      G(KA-1)=G(KA-1)-(EX+W*EX)*FA
      G(KA)=G(KA)+(4.0D 0+W*EX)*FA
      G(KA+1)=G(KA+1)+(EX+W*EX)*FA
      ENDIF
  751 CONTINUE
      RETURN
  760 DO 761 KA=1,NA
      H=2.0D 0
      IF (KA.EQ.1) THEN
      FA=((3.0D 0-H*X(1))*X(1)-2.0D 0*X(2)+1.0D 0)**2
      G(1)=G(1)+2.0D 0*((3.0D 0-H*X(1))*X(1)-2.0D 0*X(2)+1.0D 0)*
     & (3.0D 0-2.0D 0*H*X(1))*FA
      G(2)=G(2)-4.0D 0*((3.0D 0-H*X(1))*X(1)-2.0D 0*X(2)+1.0D 0)*FA
      ELSEIF (KA.LE.N-1) THEN
      FA=((3.0D 0-H*X(KA))*X(KA)-X(KA-1)-2.0D 0*X(KA+1)+1.0D 0)**2
      G(KA-1)=G(KA-1)-2.0D 0*
     & ((3.0D 0-H*X(KA))*X(KA)-X(KA-1)-2.0D 0*X(KA+1)+1.0D 0)*FA
      G(KA)=G(KA)+2.0D 0*
     & ((3.0D 0-H*X(KA))*X(KA)-X(KA-1)-2.0D 0*X(KA+1)+1.0D 0)*
     & (3.0D 0-2.0D 0*H*X(KA))*FA
      G(KA+1)=G(KA+1)-4.0D 0*
     & ((3.0D 0-H*X(KA))*X(KA)-X(KA-1)-2.0D 0*X(KA+1)+1.0D 0)*FA
      ELSE
      FA=((3.0D 0-H*X(N))*X(N)-X(N-1)+1.0D 0)**2
      G(N-1)=G(N-1)-2.0D 0*((3.0D 0-H*X(N))*X(N)-X(N-1)+1.0D 0)*FA
      G(N)=G(N)+2.0D 0*((3.0D 0-H*X(N))*X(N)-X(N-1)+1.0D 0)*
     & (3.0D 0-2.0D 0*H*X(N))*FA
      ENDIF
  761 CONTINUE
      RETURN
  780 DO 781 KA=1,NA
      IF (KA.LT.2) THEN
      FA=4.0D 0*(X(KA)-X(KA+1)**2)+X(KA+1)-X(KA+2)**2
      G(KA)=G(KA)+4.0D 0*FA
      G(KA+1)=G(KA+1)-(8.0D 0*X(KA+1)-1.0D 0)*FA
      G(KA+2)=G(KA+2)-2.0D 0*X(KA+2)*FA
      ELSEIF (KA.LT.3) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA+1)-X(KA+2)**2
      G(KA-1)=G(KA-1)-8.0D 0*X(KA)*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+6.0D 0)*FA
      G(KA+1)=G(KA+1)-(8.0D 0*X(KA+1)-1.0D 0)*FA
      G(KA+2)=G(KA+2)-2.0D 0*X(KA+2)*FA
      ELSEIF (KA.LT.N-1) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2-X(KA-2)+X(KA+1)-
     & X(KA+2)**2
      G(KA-2)=G(KA-2)-FA
      G(KA-1)=G(KA-1)-(8.0D 0*X(KA)-2.0D 0*X(KA-1))*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+6.0D 0)*FA
      G(KA+1)=G(KA+1)-(8.0D 0*X(KA+1)-1.0D 0)*FA
      G(KA+2)=G(KA+2)-2.0D 0*X(KA+2)*FA
      ELSEIF (KA.LT.N) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2-X(KA-2)
      G(KA-2)=G(KA-2)-FA
      G(KA-1)=G(KA-1)-(8.0D 0*X(KA)-2.0D 0*X(KA-1))*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+6.0D 0)*FA
      G(KA+1)=G(KA+1)-8.0D 0*X(KA+1)*FA
      ELSE
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))
     & +X(KA-1)**2-X(KA-2)
      G(KA-2)=G(KA-2)-FA
      G(KA-1)=G(KA-1)-(8.0D 0*X(KA)-2.0D 0*X(KA-1))*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+2.0D 0)*FA
      ENDIF
  781 CONTINUE
      RETURN
  790 DO 791 KA=1,NA
      IF (KA.LT.2) THEN
      FA=4.0D 0*(X(KA)-X(KA+1)**2)+X(KA+1)-X(KA+2)**2+
     & X(KA+2)-X(KA+3)**2
      G(KA)=G(KA)+4.0D 0*FA
      G(KA+1)=G(KA+1)-(8.0D 0*X(KA+1)-1.0D 0)*FA
      G(KA+2)=G(KA+2)-(2.0D 0*X(KA+2)-1.0D 0)*FA
      G(KA+3)=G(KA+3)-2.0D 0*X(KA+3)*FA
      ELSEIF (KA.LT.3) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2+X(KA+1)-X(KA+2)**2+
     & X(KA+2)-X(KA+3)**2
      G(KA-1)=G(KA-1)-(8.0D 0*X(KA)-2.0D 0*X(KA-1))*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+6.0D 0)*FA
      G(KA+1)=G(KA+1)-(8.0D 0*X(KA+1)-1.0D 0)*FA
      G(KA+2)=G(KA+2)-(2.0D 0*X(KA+2)-1.0D 0)*FA
      G(KA+3)=G(KA+3)-2.0D 0*X(KA+3)*FA
      ELSEIF (KA.LT.4) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2-X(KA-2)+
     & X(KA+1)-X(KA+2)**2+X(KA-2)**2+X(KA+2)-X(KA+3)**2
      G(KA-2)=G(KA-2)+(2.0D 0*X(KA-2)-1.0D 0)*FA
      G(KA-1)=G(KA-1)-(8.0D 0*X(KA)-2.0D 0*X(KA-1))*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+6.0D 0)*FA
      G(KA+1)=G(KA+1)-(8.0D 0*X(KA+1)-1.0D 0)*FA
      G(KA+2)=G(KA+2)-(2.0D 0*X(KA+2)-1.0D 0)*FA
      G(KA+3)=G(KA+3)-2.0D 0*X(KA+3)*FA
      ELSEIF (KA.LT.N-2) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2-X(KA-2)+
     & X(KA+1)-X(KA+2)**2+X(KA-2)**2-X(KA-3)+X(KA+2)-X(KA+3)**2
      G(KA-3)=G(KA-3)-FA
      G(KA-2)=G(KA-2)+(2.0D 0*X(KA-2)-1.0D 0)*FA
      G(KA-1)=G(KA-1)-(8.0D 0*X(KA)-2.0D 0*X(KA-1))*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+6.0D 0)*FA
      G(KA+1)=G(KA+1)-(8.0D 0*X(KA+1)-1.0D 0)*FA
      G(KA+2)=G(KA+2)-(2.0D 0*X(KA+2)-1.0D 0)*FA
      G(KA+3)=G(KA+3)-2.0D 0*X(KA+3)*FA
      ELSEIF (KA.LT.N-1) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2-X(KA-2)+
     & X(KA+1)-X(KA+2)**2+X(KA-2)**2-X(KA-3)+X(KA+2)
      G(KA-3)=G(KA-3)-FA
      G(KA-2)=G(KA-2)+(2.0D 0*X(KA-2)-1.0D 0)*FA
      G(KA-1)=G(KA-1)-(8.0D 0*X(KA)-2.0D 0*X(KA-1))*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+6.0D 0)*FA
      G(KA+1)=G(KA+1)-(8.0D 0*X(KA+1)-1.0D 0)*FA
      G(KA+2)=G(KA+2)-(2.0D 0*X(KA+2)-1.0D 0)*FA
      ELSEIF (KA.LT.N) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2-X(KA-2)+
     & X(KA+1)+X(KA-2)**2-X(KA-3)
      G(KA-3)=G(KA-3)-FA
      G(KA-2)=G(KA-2)+(2.0D 0*X(KA-2)-1.0D 0)*FA
      G(KA-1)=G(KA-1)-(8.0D 0*X(KA)-2.0D 0*X(KA-1))*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+6.0D 0)*FA
      G(KA+1)=G(KA+1)-(8.0D 0*X(KA+1)-1.0D 0)*FA
      ELSE
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))
     & +X(KA-1)**2-X(KA-2)+X(KA-2)**2-X(KA-3)
      G(KA-3)=G(KA-3)-FA
      G(KA-2)=G(KA-2)+(2.0D 0*X(KA-2)-1.0D 0)*FA
      G(KA-1)=G(KA-1)-(8.0D 0*X(KA)-2.0D 0*X(KA-1))*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+2.0D 0)*FA
      ENDIF
  791 CONTINUE
      RETURN
  810 DO 811 KA=1,NA
      IF(MOD(KA,2).EQ.1) THEN
      FA=X(KA)+((5.0D 0-X(KA+1))*X(KA+1)-2.0D 0)*X(KA+1)-1.3D 1
      G(KA)=G(KA)+FA
      G(KA+1)=G(KA+1)+(10.0D 0*X(KA+1)-3.0D 0*X(KA+1)**2-2.0D 0)*FA
      ELSE
      FA=X(KA-1)+((X(KA)+1.0D 0)*X(KA)-1.4D 1)*X(KA)-2.9D 1
      G(KA-1)=G(KA-1)+FA
      G(KA)=G(KA)+(3.0D 0*X(KA)**2+2.0D 0*X(KA)-1.4D 1)*FA
      ENDIF
  811 CONTINUE
      RETURN
  830 DO 831 KA=1,NA
      IF(MOD(KA,4).EQ.1) THEN
      A=EXP(X(KA))-X(KA+1)
      FA=A**2
      G(KA)=G(KA)+2.0D 0*A*EXP(X(KA))*FA
      G(KA+1)=G(KA+1)-2.0D 0*A*FA
      ELSEIF (MOD(KA,4).EQ.2) THEN
      FA=1.0D 1*(X(KA)-X(KA+1))**3
      A=3.0D 1*(X(KA)-X(KA+1))**2*FA
      G(KA)=G(KA)+A
      G(KA+1)=G(KA+1)-A
      ELSEIF (MOD(KA,4).EQ.3) THEN
      A=X(KA)-X(KA+1)
      FA=(SIN(A)/COS(A))**2
      B=2.0D 0*SIN(A)/(COS(A))**3*FA
      G(KA)=G(KA)+B
      G(KA+1)=G(KA+1)-B
      ELSE
      FA=X(KA)-1.0D 0
      G(KA)=G(KA)+FA
      ENDIF
  831 CONTINUE
      RETURN
  840 DO 841 KA=1,NA
      IF(KA.LT.2) THEN
      FA=X(KA)*(0.5D 0*X(KA)-3.0D 0)-1.0D 0+2.0D 0*X(KA+1)
      G(KA)=G(KA)+(X(KA)-3.0D 0)*FA
      G(KA+1)=G(KA+1)+2.0D 0*FA
      ELSEIF (KA.LT.N) THEN
      FA=X(KA-1)+X(KA)*(0.5D 0*X(KA)-3.0D 0)-1.0D 0+2.0D 0*X(KA+1)
      G(KA-1)=G(KA-1)+FA
      G(KA)=G(KA)+(X(KA)-3.0D 0)*FA
      G(KA+1)=G(KA+1)+2.0D 0*FA
      ELSE
      FA=X(KA-1)+X(KA)*(0.5D 0*X(KA)-3.0D 0)-1.0D 0
      G(KA-1)=G(KA-1)+FA
      G(KA)=G(KA)+(X(KA)-3.0D 0)*FA
      ENDIF
  841 CONTINUE
      RETURN
  860 DO 861 KA=1,NA
      IF(MOD(KA,2).EQ.1) THEN
      FA=1.0D 4*X(KA)*X(KA+1)-1.0D 0
      G(KA)=G(KA)+1.0D 4*X(KA+1)*FA
      G(KA+1)=G(KA+1)+1.0D 4*X(KA)*FA
      ELSE
      FA=EXP(-X(KA-1))+EXP(-X(KA))-1.0001D 0
      G(KA-1)=G(KA-1)-EXP(-X(KA-1))*FA
      G(KA)=G(KA)-EXP(-X(KA))*FA
      ENDIF
  861 CONTINUE
      RETURN
  870 DO 871 KA=1,NA
      IF(MOD(KA,4).EQ.1) THEN
      FA=-2.0D 2*X(KA)*(X(KA+1)-X(KA)**2)-(1.0D 0-X(KA))
      G(KA)=G(KA)-(2.0D 2*(X(KA+1)-3.0D 0*X(KA)**2)-1.0D 0)*FA
      G(KA+1)=G(KA+1)-2.0D 2*X(KA)*FA
      ELSEIF(MOD(KA,4).EQ.2) THEN
      FA=2.0D 2*(X(KA)-X(KA-1)**2)+2.02D 1*(X(KA)-1.0D 0)+
     &  1.98D 1*(X(KA+2)-1.0D 0)
      G(KA-1)=G(KA-1)-4.0D 2*X(KA-1)*FA
      G(KA)=G(KA)+2.202D 2*FA
      G(KA+2)=G(KA+2)+1.98D 1*FA
      ELSEIF(MOD(KA,4).EQ.3) THEN
      FA=-1.8D 2*X(KA)*(X(KA+1)-X(KA)**2)-(1.0D 0-X(KA))
      G(KA)=G(KA)-(1.8D 2*(X(KA+1)-3.0D 0*X(KA)**2)-1.0D 0)*FA
      G(KA+1)=G(KA+1)-1.8D 2*X(KA)*FA
      ELSE
      FA=1.8D 2*(X(KA)-X(KA-1)**2)+2.02D 1*(X(KA)-1.0D 0)+
     & 1.98D 1*(X(KA-2)-1.0D 0)
      G(KA-2)=G(KA-2)+1.98D 1*FA
      G(KA-1)=G(KA-1)-3.6D 2*X(KA-1)*FA
      G(KA)=G(KA)+2.002D 2*FA
      ENDIF
  871 CONTINUE
      RETURN
  880 DO 881 KA=1,NA
      IF (KA.LT.2) THEN
      A=EXP(COS(DBLE(KA)*(X(KA)+X(KA+1))))
      B=A*DBLE(KA)*SIN(DBLE(KA)*(X(KA)+X(KA+1)))
      FA=X(KA)-A
      G(KA+1)=G(KA+1)+B*FA
      G(KA)=G(KA)+(B+1.0D 0)*FA
      ELSEIF (KA.LT.N) THEN
      A=EXP(COS(DBLE(KA)*(X(KA-1)+X(KA)+X(KA+1))))
      B=A*SIN(DBLE(KA)*(X(KA-1)+X(KA)+X(KA+1)))*DBLE(KA)
      FA=X(KA)-A
      G(KA-1)=G(KA-1)+B*FA
      G(KA+1)=G(KA+1)+B*FA
      G(KA)=G(KA)+(B+1.0D 0)*FA
      ELSE
      A=EXP(COS(DBLE(KA)*(X(KA-1)+X(KA))))
      B=A*SIN(DBLE(KA)*(X(KA-1)+X(KA)))*DBLE(KA)
      FA=X(KA)-A
      G(KA-1)=G(KA-1)+B*FA
      G(KA)=G(KA)+(B+1.0D 0)*FA
      ENDIF
  881 CONTINUE
      RETURN
  900 DO 901 KA=1,NA
      IF(KA.EQ.1) THEN
      FA=3.0D 0*X(KA)*(X(KA+1)-2.0D 0*X(KA))+0.25D 0*X(KA+1)**2
      G(KA)=G(KA)+3.0D 0*(X(KA+1)-4.0D 0*X(KA))*FA
      G(KA+1)=G(KA+1)+(3.0D 0*X(KA)+0.5D 0*X(KA+1))*FA
      ELSEIF(KA.EQ.N) THEN
      FA=3.0D 0*X(KA)*(2.0D 1-2.0D 0*X(KA)+X(KA-1))+
     & 0.25D 0*(2.0D 1-X(KA-1))**2
      G(KA-1)=G(KA-1)+(3.0D 0*X(KA)-0.5D 0*(2.0D 1-X(KA-1)))*FA
      G(KA)=G(KA)+3.0D 0*(2.0D 1-4.0D 0*X(KA)+X(KA-1))*FA
      ELSE
      FA=3.0D 0*X(KA)*(X(KA+1)-2.0D 0*X(KA)+X(KA-1))+
     & 0.25D 0*(X(KA+1)-X(KA-1))**2
      G(KA-1)=G(KA-1)+(3.0D 0*X(KA)-0.5D 0*(X(KA+1)-X(KA-1)))*FA
      G(KA)=G(KA)+3.0D 0*(X(KA+1)-4.0D 0*X(KA)+X(KA-1))*FA
      G(KA+1)=G(KA+1)+(3.0D 0*X(KA)+0.5D 0*(X(KA+1)-X(KA-1)))*FA
      ENDIF
  901 CONTINUE
      RETURN
  910 DO 911 KA=1,NA
      H=1.0D 0/DBLE(N+1)
      IF (KA.LT.2) THEN
      FA=2.0D 0*X(KA)+PAR*H**2*SINH(PAR*X(KA))-X(KA+1)
      G(KA)=G(KA)+(2.0D 0+PAR**2*H**2*COSH(PAR*X(KA)))*FA
      G(KA+1)=G(KA+1)-FA
      ELSE IF (KA.LT.N) THEN
      FA=2.0D 0*X(KA)+PAR*H**2*SINH(PAR*X(KA))-X(KA-1)-X(KA+1)
      G(KA-1)=G(KA-1)-FA
      G(KA)=G(KA)+(2.0D 0+PAR**2*H**2*COSH(PAR*X(KA)))*FA
      G(KA+1)=G(KA+1)-FA
      ELSE
      FA=2.0D 0*X(KA)+PAR*H**2*SINH(PAR*X(KA))-X(KA-1)-1.0D 0
      G(KA)=G(KA)+(2.0D 0+PAR**2*H**2*COSH(PAR*X(KA)))*FA
      G(KA-1)=G(KA-1)-FA
      ENDIF
  911 CONTINUE
      RETURN
  920 DO 921 KA=1,NA
      FA=6.0D 0*X(KA)
      A1=0.0D 0
      A2=0.0D 0
      A3=0.0D 0
      IF (KA.GT.1) THEN
      FA=FA-4.0D 0*X(KA-1)
      A1=A1-X(KA-1)
      A2=A2+X(KA-1)
      A3=A3+2.0D 0*X(KA-1)
      ENDIF
      IF (KA.GT.2) THEN
      FA=FA+X(KA-2)
      A3=A3-X(KA-2)
      ENDIF
      IF (KA.LT.N-1) THEN
      FA=FA+X(KA+2)
      A3=A3+X(KA+2)
      ENDIF
      IF (KA.LT.N) THEN
      FA=FA-4.0D 0*X(KA+1)
      A1=A1+X(KA+1)
      A2=A2+X(KA+1)
      A3=A3-2.0D 0*X(KA+1)
      ENDIF
      IF (KA.GE.N-1) THEN
      FA=FA+1.0D 0
      A3=A3+1.0D 0
      ENDIF
      IF (KA.GE.N) THEN
      FA=FA-4.0D 0
      A1=A1+1.0D 0
      A2=A2+1.0D 0
      A3=A3-2.0D 0
      ENDIF
      FA=FA-0.5D 0*PAR*(A1*A2-X(KA)*A3)
      G(KA)=G(KA)+6.0D 0*FA
      GA1(1)=0.0D 0
      GA1(2)=0.0D 0
      GA2(1)=0.0D 0
      GA2(2)=0.0D 0
      IF (KA.GT.1) THEN
      G(KA-1)=G(KA-1)-(4.0D 0-PAR*X(KA))*FA
      GA1(1)=-1.0D 0
      GA2(1)= 1.0D 0
      ENDIF
      IF (KA.GT.2) THEN
      G(KA-2)=G(KA-2)+(1.0D 0-0.5D 0*PAR*X(KA))*FA
      ENDIF
      IF (KA.LT.N-1) THEN
      G(KA+2)=G(KA+2)+(1.0D 0+0.5D 0*PAR*X(KA))*FA
      ENDIF
      IF (KA.LT.N) THEN
      G(KA+1)=G(KA+1)-(4.0D 0+PAR*X(KA))*FA
      GA1(2)= 1.0D 0
      GA2(2)= 1.0D 0
      ENDIF
      G(KA)=G(KA)+0.5D 0*PAR*A3*FA
      IF (KA.GT.1)
     & G(KA-1)=G(KA-1)-0.5D 0*PAR*(GA1(1)*A2+A1*GA2(1))*FA
      IF (KA.LT.N)
     & G(KA+1)=G(KA+1)-0.5D 0*PAR*(GA1(2)*A2+A1*GA2(2))*FA
  921 CONTINUE
      RETURN
  930 DO 931 KA=1,NA
      H=1.0D 0/DBLE(M+1)
      IF(KA.LE.M) THEN
      J=KA+M
      FA=6.0D 0*X(KA)
      A1=0.0D 0
      A2=0.0D 0
      IF (KA.EQ.1) THEN
      A1=A1+1.0D 0
      ENDIF
      IF (KA.GT.1) THEN
      FA=FA-4.0D 0*X(KA-1)
      A1=A1-X(J-1)
      A2=A2+2.0D 0*X(KA-1)
      ENDIF
      IF (KA.GT.2) THEN
      FA=FA+X(KA-2)
      A2=A2-X(KA-2)
      ENDIF
      IF (KA.LT.M-1) THEN
      FA=FA+X(KA+2)
      A2=A2+X(KA+2)
      ENDIF
      IF (KA.LT.M) THEN
      FA=FA-4.0D 0*X(KA+1)
      A1=A1+X(J+1)
      A2=A2-2.0D 0*X(KA+1)
      ENDIF
      IF (KA.EQ.M) THEN
      A1=A1+1.0D 0
      ENDIF
      FA=FA+0.5D 0*PAR*H*(X(KA)*A2+X(J)*A1*H**2)
      ELSE
      J=KA-M
      FA=-2.0D 0*X(KA)
      A1=0.0D 0
      A2=0.0D 0
      IF (J.EQ.1) THEN
      A2=A2+1.0D 0
      ENDIF
      IF (J.GT.1) THEN
      FA=FA+X(KA-1)
      A1=A1-X(J-1)
      A2=A2-X(KA-1)
      ENDIF
      IF (J.LT.M) THEN
      FA=FA+X(KA+1)
      A1=A1+X(J+1)
      A2=A2+X(KA+1)
      ENDIF
      IF (J.EQ.M) THEN
      A2=A2+1.0D 0
      ENDIF
      FA=FA+0.5D 0*PAR*H*(X(KA)*A1+X(J)*A2)
      ENDIF
      IF(KA.LE.M) THEN
      G(KA)=G(KA)+6.0D 0*FA
      IF (KA.GT.1) THEN
      G(KA-1)=G(KA-1)-(4.0D 0-PAR*H*X(KA))*FA
      G(J-1)=G(J-1)-0.5D 0*PAR*H**3*X(J)*FA
      ENDIF
      IF (KA.GT.2) THEN
      G(KA-2)=G(KA-2)+(1.0D 0-0.5D 0*PAR*H*X(KA))*FA
      ENDIF
      IF (KA.LT.M-1) THEN
      G(KA+2)=G(KA+2)+(1.0D 0+0.5D 0*PAR*H*X(KA))*FA
      ENDIF
      IF (KA.LT.M) THEN
      G(KA+1)=G(KA+1)-(4.0D 0+PAR*H*X(KA))*FA
      G(J+1)=G(J+1)+0.5D 0*PAR*H**3*X(J)*FA
      ENDIF
      G(KA)=G(KA)+0.5D 0*PAR*H*A2*FA
      G(J)=G(J)+0.5D 0*PAR*H**3*A1*FA
      ELSE
      G(KA)=G(KA)-2.0D 0*FA
      IF (J.GT.1) THEN
      G(KA-1)=G(KA-1)+(1.0D 0-0.5D 0*PAR*H*X(J))*FA
      G(J-1)=G(J-1)-0.5D 0*PAR*H*X(KA)*FA
      ENDIF
      IF (J.LT.M) THEN
      G(KA+1)=G(KA+1)+(1.0D 0+0.5D 0*PAR*H*X(J))*FA
      G(J+1)=G(J+1)+0.5D 0*PAR*H*X(KA)*FA
      ENDIF
      G(KA)=G(KA)+0.5D 0*PAR*H*A1*FA
      G(J)=G(J)+0.5D 0*PAR*H*A2*FA
      ENDIF
  931 CONTINUE
      RETURN
  940 DO 941 KA=1,NA
      FA=4.0D 0*X(KA)-PAR*EXP(X(KA))
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      IF(I.GT.1) FA=FA-X(KA-1)
      IF(I.LT.M) FA=FA-X(KA+1)
      IF(J.GT.1) FA=FA-X(KA-M)
      IF(J.LT.M) FA=FA-X(KA+M)
      G(KA)=G(KA)+(4.0D 0-PAR*EXP(X(KA)))*FA
      IF(J.GT.1) G(KA-M)=G(KA-M)-FA
      IF(I.GT.1) G(KA-1)=G(KA-1)-FA
      IF(I.LT.M) G(KA+1)=G(KA+1)-FA
      IF(J.LT.M) G(KA+M)=G(KA+M)-FA
  941 CONTINUE
      RETURN
  950 DO 951 KA=1,NA
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      FA=4.0D 0*X(KA)+PAR*X(KA)**3/(1.0D 0+PAR*DBLE(I)**2+
     & PAR*DBLE(J)**2)
      IF(I.EQ.1) FA=FA-1.0D 0
      IF(I.GT.1) FA=FA-X(KA-1)
      IF(I.LT.M) FA=FA-X(KA+1)
      IF(I.EQ.M) FA=FA-2.0D 0+EXP(DBLE(J)/DBLE(M+1))
      IF(J.EQ.1) FA=FA-1.0D 0
      IF(J.GT.1) FA=FA-X(KA-M)
      IF(J.LT.M) FA=FA-X(KA+M)
      IF(J.EQ.M) FA=FA-2.0D 0+EXP(DBLE(I)/DBLE(M+1))
      G(KA)=G(KA)+(4.0D 0+3.0D 0*PAR*X(KA)**2/(1.0D 0+PAR*DBLE(I)**2+
     & PAR*DBLE(J)**2))*FA
      IF(J.GT.1) G(KA-M)=G(KA-M)-FA
      IF(I.GT.1) G(KA-1)=G(KA-1)-FA
      IF(I.LT.M) G(KA+1)=G(KA+1)-FA
      IF(J.LT.M) G(KA+M)=G(KA+M)-FA
  951 CONTINUE
      RETURN
  960 DO 961 KA=1,NA
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      A1=DBLE(I)/DBLE(M+1)
      A2=DBLE(J)/DBLE(M+1)
      FA=4.0D 0*X(KA)-PAR*SIN(2.0D 0*PI*X(KA))-
     & 1.0D 4*((A1-0.25D 0)**2+(A2-0.75D 0)**2)*PAR
      IF(I.EQ.1) FA=FA-X(KA+1)-PAR*SIN(PI*X(KA+1)*DBLE(M+1))
      IF(I.GT.1.AND.I.LT.M) FA=FA-X(KA+1)-X(KA-1)-
     & PAR*SIN(PI*(X(KA+1)-X(KA-1))*DBLE(M+1))
      IF(I.EQ.M) FA=FA-X(KA-1)+PAR*SIN(PI*X(KA-1)*DBLE(M+1))
      IF(J.EQ.1) FA=FA-X(KA+M)-PAR*SIN(PI*X(KA+M)*DBLE(M+1))
      IF(J.GT.1.AND.J.LT.M) FA=FA-X(KA+M)-X(KA-M)-
     & PAR*SIN(PI*(X(KA+M)-X(KA-M))*DBLE(M+1))
      IF(J.EQ.M) FA=FA-X(KA-M)+PAR*SIN(PI*X(KA-M)*DBLE(M+1))
      G(KA)=G(KA)+(4.0D 0-2.0D 0*PI*PAR*COS(2.0D 0*PI*X(KA)))*FA
      IF(I.EQ.1) G(KA+1)=G(KA+1)-
     & (1.0D 0+PI*DBLE(M+1)*PAR*COS(PI*X(KA+1)*DBLE(M+1)))*FA
      IF(I.GT.1.AND.I.LT.M) THEN
      G(KA-1)=G(KA-1)-
     & (1.0D 0-PI*DBLE(M+1)*PAR*COS(PI*(X(KA+1)-X(KA-1))*DBLE(M+1)))*FA
      G(KA+1)=G(KA+1)-
     & (1.0D 0+PI*DBLE(M+1)*PAR*COS(PI*(X(KA+1)-X(KA-1))*DBLE(M+1)))*FA
      ENDIF
      IF(I.EQ.M) G(KA-1)=G(KA-1)-
     & (1.0D 0-PI*DBLE(M+1)*PAR*COS(PI*X(KA-1)*DBLE(M+1)))*FA
      IF(J.EQ.1) G(KA+M)=G(KA+M)-
     & (1.0D 0+PI*DBLE(M+1)*PAR*COS(PI*X(KA+M)*DBLE(M+1)))*FA
      IF(J.GT.1.AND.J.LT.M) THEN
      G(KA-M)=G(KA-M)-
     & (1.0D 0-PI*DBLE(M+1)*PAR*COS(PI*(X(KA+M)-X(KA-M))*DBLE(M+1)))*FA
      G(KA+M)=G(KA+M)-
     & (1.0D 0+PI*DBLE(M+1)*PAR*COS(PI*(X(KA+M)-X(KA-M))*DBLE(M+1)))*FA
      ENDIF
      IF(J.EQ.M) G(KA-M)=G(KA-M)-
     & (1.0D 0-PI*DBLE(M+1)*PAR*COS(PI*X(KA-M)*DBLE(M+1)))*FA
  961 CONTINUE
      RETURN
  970 DO 971 KA=1,NA
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      FA=8.0D 0*X(KA)**2
      IF(I.EQ.1) FA=FA-2.0D 0*X(KA)*(X(KA+1)+1.0D 0)-
     & 0.5D 0*(X(KA+1)-1.0D 0)**2-
     & 1.5D 0*X(KA)**2*(X(KA+1)-1.0D 0)*PAR
      IF(I.GT.1.AND.I.LT.M) FA=FA-2.0D 0*X(KA)*(X(KA+1)+X(KA-1))-
     & 0.5D 0*(X(KA+1)-X(KA-1))**2-
     & 1.5D 0*X(KA)**2*(X(KA+1)-X(KA-1))*PAR
      IF(I.EQ.M) FA=FA-2.0D 0*X(KA)*X(KA-1)-
     & 0.5D 0*X(KA-1)**2+
     & 1.5D 0*X(KA)**2*X(KA-1)*PAR
      IF(J.EQ.1) FA=FA-2.0D 0*X(KA)*(X(KA+M)+1.0D 0)-
     & 0.5D 0*(X(KA+M)-1.0D 0)**2
      IF(J.GT.1.AND.J.LT.M) FA=FA-2.0D 0*X(KA)*(X(KA+M)+X(KA-M))-
     & 0.5D 0*(X(KA+M)-X(KA-M))**2
      IF(J.EQ.M) FA=FA-2.0D 0*X(KA)*X(KA-M)-
     & 0.5D 0*X(KA-M)**2
      IF (I.EQ.1.AND.J.EQ.1) FA=FA-PAR/DBLE(M+1)
      G(KA)=G(KA)+1.6D 1*X(KA)*FA
      IF(I.EQ.1) THEN
      G(KA)=G(KA)-(2.0D 0*(X(KA+1)+1.0D 0)+3.0D 0*X(KA)*
     & (X(KA+1)-1.0D 0)*PAR)*FA
      G(KA+1)=G(KA+1)-(2.0D 0*X(KA)+(X(KA+1)-1.0D 0)+
     & 1.5D 0*X(KA)**2*PAR)*FA
      ENDIF
      IF(I.GT.1.AND.I.LT.M) THEN
      G(KA)=G(KA)-(2.0D 0*(X(KA+1)+X(KA-1))+3.0D 0*X(KA)*
     & (X(KA+1)-X(KA-1))*PAR)*FA
      G(KA-1)=G(KA-1)-(2.0D 0*X(KA)-(X(KA+1)-X(KA-1))-
     & 1.5D 0*X(KA)**2*PAR)*FA
      G(KA+1)=G(KA+1)-(2.0D 0*X(KA)+(X(KA+1)-X(KA-1))+
     & 1.5D 0*X(KA)**2*PAR)*FA
      ENDIF
      IF(I.EQ.M) THEN
      G(KA)=G(KA)-(2.0D 0*X(KA-1)-3.0D 0*X(KA)*X(KA-1)*PAR)*FA
      G(KA-1)=G(KA-1)-(2.0D 0*X(KA)+X(KA-1)-1.5D 0*X(KA)**2*PAR)*FA
      ENDIF
      IF(J.EQ.1) THEN
      G(KA)=G(KA)-2.0D 0*(X(KA+M)+1.0D 0)*FA
      G(KA+M)=G(KA+M)-(2.0D 0*X(KA)+(X(KA+M)-1.0D 0))*FA
      ENDIF
      IF(J.GT.1.AND.J.LT.M) THEN
      G(KA)=G(KA)-2.0D 0*(X(KA+M)+X(KA-M))*FA
      G(KA-M)=G(KA-M)-(2.0D 0*X(KA)-(X(KA+M)-X(KA-M)))*FA
      G(KA+M)=G(KA+M)-(2.0D 0*X(KA)+(X(KA+M)-X(KA-M)))*FA
      ENDIF
      IF(J.EQ.M) THEN
      G(KA)=G(KA)-2.0D 0*X(KA-M)*FA
      G(KA-M)=G(KA-M)-(2.0D 0*X(KA)+X(KA-M))*FA
      ENDIF
  971 CONTINUE
      RETURN
  980 DO 981 KA=1,NA
      A3=0.0D 0
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      A1=PAR*DBLE(I)
      A2=PAR*DBLE(J)
      FA=4.0D 0*X(KA)-2.0D 3*A1*A2*(1.0D 0-A1)*(1.0D 0-A2)*PAR**2
      IF(I.GT.1) THEN
      FA=FA-X(KA-1)
      A3=A3-X(KA-1)
      ENDIF
      IF(I.LT.M) THEN
      FA=FA-X(KA+1)
      A3=A3+X(KA+1)
      ENDIF
      IF(J.GT.1) THEN
      FA=FA-X(KA-M)
      A3=A3-X(KA-M)
      ENDIF
      IF(J.LT.M) THEN
      FA=FA-X(KA+M)
      A3=A3+X(KA+M)
      ENDIF
      FA=FA+2.0D 1*PAR*A3*X(KA)
      G(KA)=G(KA)+4.0D 0*FA
      IF(I.GT.1) THEN
      G(KA-1)=G(KA-1)-(1.0D 0+2.0D 1*PAR*X(KA))*FA
      ENDIF
      IF(I.LT.M) THEN
      G(KA+1)=G(KA+1)-(1.0D 0-2.0D 1*PAR*X(KA))*FA
      ENDIF
      IF(J.GT.1) THEN
      G(KA-M)=G(KA-M)-(1.0D 0+2.0D 1*PAR*X(KA))*FA
      ENDIF
      IF(J.LT.M) THEN
      G(KA+M)=G(KA+M)-(1.0D 0-2.0D 1*PAR*X(KA))*FA
      ENDIF
      G(KA)=G(KA)+2.0D 1*PAR*A3*FA
  981 CONTINUE
      RETURN
  990 DO 991 KA=1,NA
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      FA=2.0D 1*X(KA)-PAR*MAX(0.0D 0,X(KA))-
     & SIGN(PAR,(DBLE(I)/DBLE(M+2)-0.5D 0))
      IF (J.GT.2) THEN
        FA=FA+X(KA-M-M)
      ENDIF
      IF (J.GT.1) THEN
        IF (I.GT.1) THEN
          FA=FA+2.0D 0*X(KA-M-1)
        ENDIF
        FA=FA-8.0D 0*X(KA-M)
        IF (I.LT.M) THEN
          FA=FA+2.0D 0*X(KA-M+1)
        ENDIF
      ENDIF
      IF (I.GT.1) THEN
        IF (I.GT.2) THEN
          FA=FA+X(KA-2)
        ENDIF
        FA=FA-8.0D 0*X(KA-1)
      ENDIF
      IF (I.LT.M) THEN
        FA=FA-8.0D 0*X(KA+1)
        IF (I.LT.M-1) THEN
          FA=FA+X(KA+2)
        ENDIF
      ENDIF
      IF (J.LT.M) THEN
        IF (I.GT.1) THEN
          FA=FA+2.0D 0*X(KA+M-1)
        ENDIF
        FA=FA-8.0D 0*X(KA+M)
        IF (I.LT.M) THEN
          FA=FA+2.0D 0*X(KA+M+1)
        ENDIF
      ENDIF
      IF (J.LT.M-1) THEN
        FA=FA+X(KA+M+M)
      ENDIF
      G(KA)=G(KA)+(2.0D 1-PAR)*FA
      IF (J.GT.2) THEN
        G(KA-M-M)=G(KA-M-M)+FA
      ENDIF
      IF (J.GT.1) THEN
        IF (I.GT.1) THEN
          G(KA-M-1)=G(KA-M-1)+2.0D 0*FA
        ENDIF
        G(KA-M)=G(KA-M)-8.0D 0*FA
        IF (I.LT.M) THEN
          G(KA-M+1)=G(KA-M+1)+2.0D 0*FA
        ENDIF
      ENDIF
      IF (I.GT.1) THEN
        IF (I.GT.2) THEN
          G(KA-2)=G(KA-2)+FA
        ENDIF
        G(KA-1)=G(KA-1)-8.0D 0*FA
      ENDIF
      IF (I.LT.M) THEN
        G(KA+1)=G(KA+1)-8.0D 0*FA
        IF (I.LT.M-1) THEN
          G(KA+2)=G(KA+2)+FA
        ENDIF
      ENDIF
      IF (J.LT.M) THEN
        IF (I.GT.1) THEN
          G(KA+M-1)=G(KA+M-1)+2.0D 0*FA
        ENDIF
        G(KA+M)=G(KA+M)-8.0D 0*FA
        IF (I.LT.M) THEN
          G(KA+M+1)=G(KA+M+1)+2.0D 0*FA
        ENDIF
      ENDIF
      IF (J.LT.M-1) THEN
        G(KA+M+M)=G(KA+M+M)+FA
      ENDIF
  991 CONTINUE
      RETURN
  800 DO 802 KA=1,NA
      H=0.5D 0/DBLE(M+2)
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      FA=2.0D 1*X(KA)
      A1=0.0D 0
      A2=0.0D 0
      A3=0.0D 0
      A4=0.0D 0
      IF (J.GT.2) THEN
        FA=FA+X(KA-M-M)
        A4=A4+X(KA-M-M)
      ENDIF
      IF (J.GT.1) THEN
        IF (I.GT.1) THEN
          FA=FA+2.0D 0*X(KA-M-1)
          A3=A3+X(KA-M-1)
          A4=A4+X(KA-M-1)
        ENDIF
        FA=FA-8.0D 0*X(KA-M)
        A1=A1-X(KA-M)
        A4=A4-4.0D 0*X(KA-M)
        IF (I.LT.M) THEN
          FA=FA+2.0D 0*X(KA-M+1)
          A3=A3-X(KA-M+1)
          A4=A4+X(KA-M+1)
        ENDIF
      ENDIF
      IF (I.GT.1) THEN
        IF (I.GT.2) THEN
          FA=FA+X(KA-2)
          A3=A3+X(KA-2)
        ENDIF
        FA=FA-8.0D 0*X(KA-1)
        A2=A2-X(KA-1)
        A3=A3-4.0D 0*X(KA-1)
      ENDIF
      IF (I.LT.M) THEN
        FA=FA-8.0D 0*X(KA+1)
        A2=A2+X(KA+1)
        A3=A3+4.0D 0*X(KA+1)
        IF (I.LT.M-1) THEN
          FA=FA+X(KA+2)
          A3=A3-X(KA+2)
        ENDIF
      ENDIF
      IF (J.LT.M) THEN
        IF (I.GT.1) THEN
          FA=FA+2.0D 0*X(KA+M-1)
          A3=A3+X(KA+M-1)
          A4=A4-X(KA+M-1)
        ENDIF
        FA=FA-8.0D 0*X(KA+M)
        A1=A1+X(KA+M)
        A4=A4+4.0D 0*X(KA+M)
        IF (I.LT.M) THEN
          FA=FA+2.0D 0*X(KA+M+1)
          A3=A3-X(KA+M+1)
          A4=A4-X(KA+M+1)
        ENDIF
      ENDIF
      IF (J.LT.M-1) THEN
        FA=FA+X(KA+M+M)
        A4=A4-X(KA+M+M)
      ENDIF
      IF (J.EQ.M) THEN
        IF (I.GT.1) THEN
          FA=FA-H-H
          A3=A3-H
          A4=A4+H
        ENDIF
        FA=FA+8.0D 0*H
        A1=A1-H
        A4=A4-4.0D 0*H
        IF (I.LT.M) THEN
          FA=FA-2.0D 0*H
          A3=A3+H
          A4=A4+H
        ENDIF
        FA=FA+H
        A4=A4-H
      ENDIF
      IF (J.EQ.M-1) THEN
        FA=FA-H
        A4=A4+H
      ENDIF
      FA=FA+0.25D 0*PAR*(A1*A3-A2*A4)
      G(KA)=G(KA)+2.0D 1*FA
      A1=0.0D 0
      A2=0.0D 0
      A3=0.0D 0
      A4=0.0D 0
      GA1(1)=0.0D 0
      GA1(2)=0.0D 0
      GA2(1)=0.0D 0
      GA2(2)=0.0D 0
      DO 801 K=1,6
      GA3(K)=0.0D 0
      GA4(K)=0.0D 0
  801 CONTINUE
      IF (J.GT.2) THEN
        G(KA-M-M)=G(KA-M-M)+FA
        GA4(1)=GA4(1)+1.0D 0
        A4=A4+X(KA-M-M)
      ENDIF
      IF (J.GT.1) THEN
        IF (I.GT.1) THEN
          G(KA-M-1)=G(KA-M-1)+2.0D 0*FA
          GA3(1)=GA3(1)+1.0D 0
          GA4(2)=GA4(2)+1.0D 0
          A3=A3+X(KA-M-1)
          A4=A4+X(KA-M-1)
        ENDIF
        G(KA-M)=G(KA-M)-8.0D 0*FA
        GA1(1)=GA1(1)-1.0D 0
        A1=A1-X(KA-M)
        IF (I.LT.M) THEN
          G(KA-M+1)=G(KA-M+1)+2.0D 0*FA
          GA3(2)=GA3(2)-1.0D 0
          GA4(3)=GA4(3)+1.0D 0
          A3=A3-X(KA-M+1)
          A4=A4+X(KA-M+1)
        ENDIF
      ENDIF
      IF (I.GT.1) THEN
        IF (I.GT.2) THEN
          G(KA-2)=G(KA-2)+FA
          GA3(3)=GA3(3)+1.0D 0
          A3=A3+X(KA-2)
        ENDIF
        G(KA-1)=G(KA-1)-8.0D 0*FA
        GA2(1)=GA2(1)-1.0D 0
        A2=A2-X(KA-1)
      ENDIF
      IF (I.LT.M) THEN
        G(KA+1)=G(KA+1)-8.0D 0*FA
        GA2(2)=GA2(2)+1.0D 0
        A2=A2+X(KA+1)
        IF (I.LT.M-1) THEN
          G(KA+2)=G(KA+2)+FA
          GA3(4)=GA3(4)-1.0D 0
          A3=A3-X(KA+2)
        ENDIF
      ENDIF
      IF (J.LT.M) THEN
        IF (I.GT.1) THEN
          G(KA+M-1)=G(KA+M-1)+2.0D 0*FA
          GA3(5)=GA3(5)+1.0D 0
          GA4(4)=GA4(4)-1.0D 0
          A3=A3+X(KA+M-1)
          A4=A4-X(KA+M-1)
        ENDIF
        G(KA+M)=G(KA+M)-8.0D 0*FA
        GA1(2)=GA1(2)+1.0D 0
        A1=A1+X(KA+M)
        IF (I.LT.M) THEN
          G(KA+M+1)=G(KA+M+1)+2.0D 0*FA
          GA3(6)=GA3(6)-1.0D 0
          GA4(5)=GA4(5)-1.0D 0
          A3=A3-X(KA+M+1)
          A4=A4-X(KA+M+1)
        ENDIF
      ENDIF
      IF (J.LT.M-1) THEN
        G(KA+M+M)=G(KA+M+M)+FA
        GA4(6)=GA4(6)-1.0D 0
        A4=A4-X(KA+M+M)
      ENDIF
      IF (J.EQ.M) THEN
        IF (I.GT.1) THEN
          A3=A3-H
          A4=A4+H
        ENDIF
        A1=A1-H
        IF (I.LT.M) THEN
          A3=A3+H
          A4=A4+H
        ENDIF
        A4=A4-H
      ENDIF
      IF (J.EQ.M-1) THEN
        A4=A4+H
      ENDIF
      IF (KA.GT.M+M)
     & G(KA-M-M)=G(KA-M-M)+0.25D 0*PAR*(-A2*GA4(1))*FA
      IF (KA.GT.M+1)
     & G(KA-M-1)=G(KA-M-1)+0.25D 0*PAR*(+A1*GA3(1)-A2*GA4(2))*FA
      IF (KA.GT.M)
     & G(KA-M)=G(KA-M)+0.25D 0*PAR*(GA1(1)*A3)*FA
      IF (KA.GT.M-1)
     & G(KA-M+1)=G(KA-M+1)+0.25D 0*PAR*(+A1*GA3(2)-A2*GA4(3))*FA
      IF (KA.GT.2)
     & G(KA-2)=G(KA-2)+0.25D 0*PAR*(+A1*GA3(3))*FA
      IF (KA.GT.1)
     & G(KA-1)=G(KA-1)+0.25D 0*PAR*(-GA2(1)*A4)*FA
      IF (KA.LE.N-1)
     & G(KA+1)=G(KA+1)+0.25D 0*PAR*(-GA2(2)*A4)*FA
      IF (KA.LE.N-2)
     & G(KA+2)=G(KA+2)+0.25D 0*PAR*(+A1*GA3(4))*FA
      IF (KA.LE.N-M+1)
     & G(KA+M-1)=G(KA+M-1)+0.25D 0*PAR*(+A1*GA3(5)-A2*GA4(4))*FA
      IF (KA.LE.N-M)
     & G(KA+M)=G(KA+M)+0.25D 0*PAR*(GA1(2)*A3)*FA
      IF (KA.LE.N-M-1)
     & G(KA+M+1)=G(KA+M+1)+0.25D 0*PAR*(+A1*GA3(6)-A2*GA4(5))*FA
      IF (KA.LE.N-M-M)
     & G(KA+M+M)=G(KA+M+M)+0.25D 0*PAR*(-A2*GA4(6))*FA
  802 CONTINUE
      RETURN
  240 DO 243 KA=1,NA
      W=0.0D 0
      DO 241 I=1,N-1
      W=W+(DBLE(KA)/DBLE(KA+I))*X(I)
  241 CONTINUE
      FA=X(KA)-(1.0D 0+(0.4D 0/DBLE(N))*X(KA)*(0.5D 0+W+
     & 0.5D 0*(DBLE(KA)/DBLE(KA+N))*X(N)))
      W=W+0.5D 0+0.5D 0*DBLE(KA)/DBLE(KA+N)*X(N)
      DO 242 I=1,N-1
      G(I)=G(I)-0.4D 0/DBLE(N)*X(KA)*DBLE(KA)/DBLE(KA+I)*FA
  242 CONTINUE
      G(N)=G(N)-0.2D 0/DBLE(N)*X(KA)*DBLE(KA)/DBLE(KA+N)*FA
      G(KA)=G(KA)+(1.0D 0-0.4D 0*W/DBLE(N))*FA
  243 CONTINUE
      RETURN
  410 DO 411 KA=1,NA
      IF(KA.EQ.1) THEN
        FA=1.0D 0-X(1)
      G(1)=G(1)-FA
      ELSE
        FA=10.0D 0*DBLE(KA-1)*(X(KA)-X(KA-1))**2
        G(KA)=G(KA)+20.0D 0*DBLE(KA-1)*(X(KA)-X(KA-1))*FA
        G(KA-1)=G(KA-1)-20.0D 0*DBLE(KA-1)*(X(KA)-X(KA-1))*FA
      ENDIF
  411 CONTINUE
      RETURN
  420 DO 421 KA=1,NA
      IF(KA.EQ.N) THEN
        FA=X(KA)-0.1D 0*X(1)**2
        G(1)=G(1)-0.20D 0*X(1)*FA
        G(N)=G(N)+FA
      ELSE
        FA=X(KA)-0.1D 0*X(KA+1)**2
        G(KA)=G(KA)+FA
        G(KA+1)=G(KA+1)-0.2D 0*X(KA+1)*FA
      ENDIF
  421 CONTINUE
      RETURN
  650 DO 653 KA=1,NA
      S=0.0D 0
      DO 651 J=1,N
        S=S+X(J)**3
  651 CONTINUE
      FA=X(KA)-1.0D 0/DBLE(2*N)*(S+DBLE(KA))
      DO 652 J=1,N
        IF(J.EQ.KA) THEN
           G(J)=G(J)+(1.0D 0-3.0D 0*X(J)**2/(2.0D 0*DBLE(N)))*FA
        ELSE
           G(J)=G(J)-3.0D 0*X(J)**2/(2.0D 0*DBLE(N))*FA
        ENDIF
  652 CONTINUE
  653 CONTINUE
      RETURN
  660 DO 661 KA=1,NA
      S=(1.0D 0/DBLE(N+1))**2*EXP(X(KA))
      IF(N.EQ.1) THEN
        FA=-2.0D 0*X(KA)-S
        G(KA)=G(KA)-(2.0D 0+S)*FA
      ELSE IF(KA.EQ.1) THEN
        FA=-2.0D 0*X(KA)+X(KA+1)-S
        G(KA)=G(KA)-(2.0D 0+S)*FA
        G(KA+1)=G(KA+1)+FA
      ELSE IF(KA.EQ.N) THEN
        FA=X(KA-1)-2.0D 0*X(KA)-S
        G(KA)=G(KA)-(2.0D 0+S)*FA
        G(KA-1)=G(KA-1)+FA
      ELSE
        FA=X(KA-1)-2.0D 0*X(KA)+X(KA+1)-S
        G(KA)=G(KA)-(2.0D 0+S)*FA
        G(KA-1)=G(KA-1)+FA
        G(KA+1)=G(KA+1)+FA
      ENDIF
  661 CONTINUE
      RETURN
  670 DO 671 KA=1,NA
      S=0.1D 0
      IF(N.EQ.1) THEN
        FA=(3.0D 0-S*X(KA))*X(KA)+1.0D 0
        G(KA)=G(KA)+(3.0D 0-2.0D 0*S*X(KA))*FA
      ELSE IF(KA.EQ.1) THEN
        FA=(3.0D 0-S*X(KA))*X(KA)+1.0D 0-2.0D 0*X(KA+1)
        G(KA)=G(KA)+(3.0D 0-2.0D 0*S*X(KA))*FA
        G(KA+1)=G(KA+1)-2.0D 0*FA
      ELSE IF(KA.EQ.N) THEN
        FA=(3.0D 0-S*X(KA))*X(KA)+1.0D 0-X(KA-1)
        G(KA)=G(KA)+(3.0D 0-2.0D 0*S*X(KA))*FA
        G(KA-1)=G(KA-1)-FA
      ELSE
        FA=(3.0D 0-S*X(KA))*X(KA)+1.0D 0-X(KA-1)-2.0D 0*X(KA+1)
        G(KA)=G(KA)+(3.0D 0-2.0D 0*S*X(KA))*FA
        G(KA-1)=G(KA-1)-FA
        G(KA+1)=G(KA+1)-2.0D 0*FA
      ENDIF
  671 CONTINUE
      RETURN
  680 DO 683 KA=1,NA
      S1=1.0D 0
      S2=1.0D 0
      S3=1.0D 0
      J1=3
      J2=3
      IF(KA-J1.GT.1) THEN
        I1=KA-J1
      ELSE
        I1=1
      ENDIF
      IF(KA+J2.LT.N) THEN
        I2=KA+J2
      ELSE
        I2=N
      ENDIF
      S=0.0D 0
      DO 681 J=I1,I2
        IF(J.NE.KA) S=S+X(J)+X(J)**2
  681 CONTINUE
      FA=(S1+S2*X(KA)**2)*X(KA)+1.D 0-S3*S
      G(KA)=G(KA)+(S1+3.0D 0*S2*X(KA)**2)*FA
      DO 682 J=I1,I2
        G(J)=G(J)-S3*(1.0D 0+2.0D 0*X(J))*FA
  682 CONTINUE
  683 CONTINUE
      RETURN
  690 DO 691 KA=1,NA
      IF(KA.EQ.1) THEN
        FA=X(1)**2-1.0D 0
        G(1)=G(1)+2.0D 0*X(1)*FA
      ELSE
        FA=X(KA-1)**2+LOG(X(KA))-1.0D 0
        G(KA-1)=G(KA-1)+2.0D 0*X(KA-1)*FA
        G(KA)=G(KA)+1.0D 0/X(KA)*FA
      ENDIF
  691 CONTINUE
      RETURN
  340 DO 341 KA=1,NA
      IF(KA.EQ.1) THEN
        FA=X(1)
        G(1)=G(1)+FA
      ELSE
        FA=COS(X(KA-1))+X(KA)-1.0D 0
        G(KA)=G(KA)+FA
        G(KA-1)=G(KA-1)-SIN(X(KA-1))*FA
      ENDIF
  341 CONTINUE
      RETURN
  360 DO 361 KA=1,NA
      S=(1.0D 0/DBLE(N+1))**2
      IF(N.EQ.1) THEN
        FA=2.0D 0*X(KA)-1.0D 0+S*(X(KA)+SIN(X(KA)))
        G(KA)=G(KA)+(2.0D 0+S*(1.0D 0+COS(X(KA))))*FA
      ELSE IF(KA.EQ.1) THEN
        FA=2.0D 0*X(KA)-X(KA+1)+S*(X(KA)+SIN(X(KA)))
        G(KA)=G(KA)+(2.0D 0+S*(1.0D 0+COS(X(KA))))*FA
        G(KA+1)=G(KA+1)-FA
      ELSE IF(KA.EQ.N) THEN
        FA=-X(KA-1)+2.0D 0*X(KA)-1.0D 0+S*(X(KA)+SIN(X(KA)))
        G(KA)=G(KA)+(2.0D 0+S*(1.0D 0+COS(X(KA))))*FA
        G(KA-1)=G(KA-1)-FA
      ELSE
        FA=-X(KA-1)+2.0D 0*X(KA)-X(KA+1)+S*(X(KA)+SIN(X(KA)))
        G(KA)=G(KA)+(2.0D 0+S*(1.0D 0+COS(X(KA))))*FA
        G(KA-1)=G(KA-1)-FA
        G(KA+1)=G(KA+1)-FA
      ENDIF
  361 CONTINUE
      RETURN
  380 DO 383 KA=1,NA
      IF(KA-5.GT.1) THEN
        I1=KA-5
      ELSE
        I1=1
      ENDIF
      IF(KA+1.LT.N) THEN
        I2=KA+1
      ELSE
        I2=N
      ENDIF
      S=0.0D 0
      DO 381 J=I1,I2
        IF(J.NE.KA) S=S+X(J)*(1.0D 0+X(J))
  381 CONTINUE
      FA=X(KA)*(2.0D 0+5.0D 0*X(KA)**2)+1.0D 0-S
      G(KA)=G(KA)+(2.0D 0+15.0D 0*X(KA)**2)*FA
      DO 382 J=I1,I2
      IF(J.NE.KA) G(J)=G(J)-(1.0D 0+2.0D 0*X(J))*FA
  382 CONTINUE
  383 CONTINUE
      RETURN
  430 DO 433 KA=1,NA
      ALF=5
      BET=14
      GAM=3
      FA=DBLE(BET*N)*X(KA)+(DBLE(KA)-DBLE(N)/2.0D 0)**GAM
      DO 431 J=1,N
        IF(J.NE.KA) THEN
        T=SQRT(X(J)**2+DBLE(KA)/DBLE(J))
        S1=LOG(T)
        FA=FA+T*(SIN(S1)**ALF+COS(S1)**ALF)
      ENDIF
  431 CONTINUE
      DO 432 J=1,N
        IF(J.NE.KA) THEN
        T=SQRT(X(J)**2+DBLE(KA)/DBLE(J))
        S1=LOG(T)
        G(J)=G(J)+(X(J)*(SIN(S1)**ALF+COS(S1)**ALF+
     +     ALF*SIN(S1)**(ALF-1)*COS(S1)-
     +     ALF*SIN(S1)*COS(S1)**(ALF-1))/T)*FA
        ELSE
          G(J)=G(J)+DBLE(BET*N)*FA
        ENDIF
  432 CONTINUE
  433 CONTINUE
      RETURN
  440 DO 445 KA=1,NA
      C=0.5D 0
      H=1.0D 0/DBLE(N)
      FA=(1.0D 0-C*H/4.0D 0)
      DO 441 J=1,N
        S=C*H*DBLE(KA)/DBLE(2*(KA+J))
        IF(J.EQ.N) S=S/2.0D 0
        FA=FA-S*X(J)
  441 CONTINUE
      FA=-1.0D 0+X(KA)*FA
      DO 442 J=1,N
        SX(J)=C*H*DBLE(KA)/DBLE(2*(KA+J))
  442 CONTINUE
      SX(N)=0.5D 0*SX(N)
      DO 444 J=1,N
        IF(KA.NE.J) THEN
           G(J)=G(J)-SX(J)*X(KA)*FA
        ELSE
           T=1.0D 0-C*H/4.0D 0
           DO 443 L=1,N
             IF(L.EQ.KA) THEN
               T=T-2.0D 0*SX(KA)*X(KA)
             ELSE
               T=T-SX(L)*X(L)
             ENDIF
  443      CONTINUE
           G(J)=G(J)+T*FA
        ENDIF
  444 CONTINUE
  445 CONTINUE
      RETURN
  270 DO 271 KA=1,NA
      H=1.0D 0/DBLE(N+1)
      T=2.0D 0*H**2
      IF(KA.EQ.1) THEN
      FA=2.0D 0*X(KA)-X(KA+1)-T*X(KA)**2-H*X(KA+1)
      G(KA)=G(KA)+2.0D 0*(1.0D 0-T*X(KA))*FA
      G(KA+1)=G(KA+1)-(1.0D 0+H)*FA
      ELSE IF(1.LT.KA.AND.KA.LT.N) THEN
      FA=-X(KA-1)+2.0D 0*X(KA)-X(KA+1)-T*X(KA)**2-H*(X(KA+1)-X(KA-1))
      G(KA)=G(KA)+2.0D 0*(1.0D 0-T*X(KA))*FA
      G(KA-1)=G(KA-1)-(1.0D 0-H)*FA
      G(KA+1)=G(KA+1)-(1.0D 0+H)*FA
      ELSE IF(KA.EQ.N) THEN
      FA=-X(KA-1)+2.0D 0*X(KA)-0.5D 0-T*X(KA)**2-H*(0.5D 0-X(KA-1))
      G(KA)=G(KA)+2.0D 0*(1.0D 0-T*X(KA))*FA
      G(KA-1)=G(KA-1)-(1.0D 0-H)*FA
      ENDIF
  271 CONTINUE
      RETURN
  280 DO 288 KA=1,NA
      S=0.5D 0
      H=1.0D 0/DBLE(N+1)
      T=H**2/S
      T1=2.0D 0*H
      AL=0.0D 0
      BE=0.5D 0
      S1=0.0D 0
      DO 281 J=1,KA
        IF(J.EQ.1) THEN
           S1=S1+DBLE(J)*(X(J)**2+(X(J+1)-AL)/T1)
        ENDIF
        IF(1.LT.J.AND.J.LT.N) THEN
           S1=S1+DBLE(J)*(X(J)**2+(X(J+1)-X(J-1))/T1)
        ENDIF
        IF(J.EQ.N) THEN
           S1=S1+DBLE(J)*(X(J)**2+(BE-X(J-1))/T1)
        ENDIF
  281 CONTINUE
      S1=(1.0D 0-DBLE(KA)*H)*S1
      IF(KA.EQ.N) GO TO 283
      S2=0.0D 0
      DO 282 J=KA+1,N
        IF(J.LT.N) THEN
           S2=S2+(1.0D 0-DBLE(J)*H)*(X(J)**2+(X(J+1)-X(J-1))/T1)
        ELSE
           S2=S2+(1.0D 0-DBLE(J)*H)*(X(J)**2+(BE-X(J-1))/T1)
        ENDIF
  282 CONTINUE
      S1=S1+DBLE(KA)*S2
  283 FA=X(KA)-0.5D 0*DBLE(KA)*H-T*S1
      S1=H**2/S
      S2=1.0D 0-DBLE(KA)*H
      DO 284 J=1,KA
        SX(J)=DBLE(J)*S2
  284 CONTINUE
      IF(KA.EQ.N) GOTO 286
      DO 285 J=KA+1,N
        SX(J)=DBLE(KA)*(1.0D 0-DBLE(J)*H)
  285 CONTINUE
  286 G(1)=G(1)-S1*(SX(1)*2.0D 0*X(1)-SX(2)/T1)*FA
      G(N)=G(N)-S1*(SX(N-1)/T1+SX(N)*2.0D 0*X(N))*FA
      DO 287 J=2,N-1
        G(J)=G(J)-S1*((SX(J-1)-SX(J+1))/T1+SX(J)*2.0D 0*X(J))*FA
  287 CONTINUE
      G(KA)=G(KA)+FA
      RETURN
  288 CONTINUE
      RETURN
  290 DO 291 KA=1,NA
      A=-9.0D-3
      B=1.0D-3
      AL=0.0D 0
      BE=25.0D 0
      GA=20.0D 0
      CA=0.3D 0
      CB=0.3D 0
      H=(B-A)/DBLE(N+1)
      T=A+DBLE(KA)*H
      H=H**2
      S=DBLE(KA)/DBLE(N+1)
      U=AL*(1.0D 0-S)+BE*S+X(KA)
      FF=CB*EXP(GA*(U-BE))-CA*EXP(GA*(AL-U))
      FG=GA*(CB*EXP(GA*(U-BE))+CA*EXP(GA*(AL-U)))
      IF(T.LE.0) THEN
        FF=FF+CA
      ELSE
        FF=FF-CB
      ENDIF
      IF(N.EQ.1) THEN
        FA=-AL+2.0D 0*X(KA)-BE+H*FF
        G(KA)=G(KA)+(2.0D 0+H*FG)*FA
      ELSEIF(KA.EQ.1) THEN
        FA=-AL+2.0D 0*X(KA)-X(KA+1)+H*FF
        G(KA)=G(KA)+(2.0D 0+H*FG)*FA
        G(KA+1)=G(KA+1)-FA
      ELSEIF(KA.LT.N) THEN
        FA=-X(KA-1)+2.0D 0*X(KA)-X(KA+1)+H*FF
        G(KA)=G(KA)+(2.0D 0+H*FG)*FA
        G(KA-1)=G(KA-1)-FA
        G(KA+1)=G(KA+1)-FA
      ELSE
        FA=-X(KA-1)+2.0D 0*X(KA)-BE+H*FF
        G(KA)=G(KA)+(2.0D 0+H*FG)*FA
        G(KA-1)=G(KA-1)-FA
      ENDIF
  291 CONTINUE
      RETURN
  300 DO 301 KA=1,NA
      AL1=0.0D 0
      AL2=0.0D 0
      BE1=0.0D 0
      BE2=0.0D 0
      N1=N/2
      H=1.0D 0/DBLE(N1+1)
      T=DBLE(KA)*H
      IF(KA.EQ.1) THEN
        S1=2.0D 0*X(KA)-X(KA+1)
        B=AL1
      ELSE IF(KA.EQ.N1+1) THEN
        S1=2.0D 0*X(KA)-X(KA+1)
        B=AL2
      ELSE IF(KA.EQ.N1) THEN
        S1=-X(KA-1)+2.0D 0*X(KA)
        B=BE1
      ELSE IF(KA.EQ.N) THEN
        S1=-X(KA-1)+2.0D 0*X(KA)
        B=BE2
      ELSE
        S1=-X(KA-1)+2.0D 0*X(KA)-X(KA+1)
        B=0.0D 0
      ENDIF
      IF(KA.LE.N1) THEN
        S2=X(KA)**2+X(KA)+0.1D 0*X(N1+KA)**2-1.2D 0
      ELSE
        S2=0.2D 0*X(KA-N1)**2+X(KA)**2+2.0D 0*X(KA)-0.6D 0
      ENDIF
      FA=S1+H**2*S2-B
      H=1.0D 0/DBLE(N1+1)**2
      IF(KA.EQ.1) THEN
        G(KA)=G(KA)+(2.0D 0+H*(2.0D 0*X(KA)+1.0D 0))*FA
        G(KA+1)=G(KA+1)-FA
        G(N1+KA)=G(N1+KA)+H*0.2D 0*X(N1+KA)*FA
      ELSE IF(KA.EQ.N1+1) THEN
        G(1)=G(1)+H*0.4D 0*X(1)*FA
        G(KA)=G(KA)+(2.0D 0+H*(2.0D 0*X(KA)+2.0D 0))*FA
        G(KA+1)=G(KA+1)-FA
      ELSE IF(KA.EQ.N1) THEN
        G(KA-1)=G(KA-1)-FA
        G(KA)=G(KA)+(2.0D 0+H*(2.0D 0*X(KA)+1.0D 0))*FA
        G(N1+KA)=G(N1+KA)+H*0.2D 0*X(N1+KA)*FA
      ELSE IF(KA.EQ.N) THEN
        G(N1)=G(N1)+H*0.4D 0*X(N1)*FA
        G(KA-1)=G(KA-1)-FA
        G(KA)=G(KA)+(2.0D 0+H*(2.0D 0*X(KA)+2.0D 0))*FA
      ELSE IF(KA.LT.N1) THEN
        G(KA-1)=G(KA-1)-FA
        G(KA)=G(KA)+(2.0D 0+H*(2.0D 0*X(KA)+1.0D 0))*FA
        G(KA+1)=G(KA+1)-FA
        G(N1+KA)=G(N1+KA)+H*0.2D 0*X(N1+KA)*FA
      ELSE
         G(KA-N1)=G(KA-N1)+H*0.4D 0*X(KA-N1)*FA
         G(KA-1)=G(KA-1)-FA
         G(KA)=G(KA)+(2.0D 0+H*(2.0D 0*X(KA)+2.0D 0))*FA
         G(KA+1)=G(KA+1)-FA
      ENDIF
  301 CONTINUE
      RETURN
  710 DO 711 KA=1,NA
      ND=INT(SQRT(DBLE(N)))
      L=MOD(KA,ND)
      IF(L.EQ.0) THEN
         K=KA/ND
         L=ND
      ELSE
         K=INT(KA/ND)+1
      ENDIF
      LA=1.0D 0
      H=1.0D 0/DBLE(ND+1)
      H2=LA*H*H
      IF(L.EQ.1.AND.K.EQ.1) THEN
         FA=4.0D 0*X(1)-X(2)-X(ND+1)+H2*EXP(X(1))
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.K.EQ.1) THEN
         FA=4.0D 0*X(L)-X(L-1)-X(L+1)-X(L+ND)+H2*EXP(X(L))
      ENDIF
      IF(L.EQ.ND.AND.K.EQ.1) THEN
         FA=4.0D 0*X(ND)-X(ND-1)-X(ND+ND)+H2*EXP(X(ND))
      ENDIF
      IF(L.EQ.1.AND.1.LT.K.AND.K.LT.ND) THEN
         FA=4.0D 0*X(KA)-X(KA+1)-X(KA-ND)-X(KA+ND)+H2*EXP(X(KA))
      ENDIF
      IF(L.EQ.ND.AND.1.LT.K.AND.K.LT.ND) THEN
         FA=4.0D 0*X(KA)-X(KA-ND)-X(KA-1)-X(KA+ND)+H2*EXP(X(KA))
      ENDIF
      IF(L.EQ.1.AND.K.EQ.ND) THEN
         FA=4.0D 0*X(KA)-X(KA+1)-X(KA-ND)+H2*EXP(X(KA))
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.K.EQ.ND) THEN
         FA=4.0D 0*X(KA)-X(KA-1)-X(KA+1)-X(KA-ND)+H2*EXP(X(KA))
      ENDIF
      IF(L.EQ.ND.AND.K.EQ.ND) THEN
        FA=4.0D 0*X(KA)-X(KA-1)-X(KA-ND)+H2*EXP(X(KA))
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.1.LT.K.AND.K.LT.ND) THEN
      FA=4.0D 0*X(KA)-X(KA-1)-X(KA+1)-X(KA-ND)-X(KA+ND)+H2*EXP(X(KA))
      ENDIF
      IF(L.EQ.1.AND.K.EQ.1) THEN
         G(1)=G(1)+(4.0D 0+H2*EXP(X(1)))*FA
         G(2)=G(2)-FA
         G(ND+1)=G(ND+1)-FA
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.K.EQ.1) THEN
         G(L)=G(L)+(4.0D 0+H2*EXP(X(L)))*FA
         G(L-1)=G(L-1)-FA
         G(L+1)=G(L+1)-FA
         G(L+ND)=G(L+ND)-FA
      ENDIF
      IF(L.EQ.ND.AND.K.EQ.1) THEN
         G(ND)=G(ND)+(4.0D 0+H2*EXP(X(ND)))*FA
         G(ND-1)=G(ND-1)-FA
         G(ND+ND)=G(ND+ND)-FA
      ENDIF
      IF(L.EQ.1.AND.1.LT.K.AND.K.LT.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*EXP(X(KA)))*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA+1)=G(KA+1)-FA
         G(KA+ND)=G(KA+ND)-FA
      ENDIF
      IF(L.EQ.ND.AND.1.LT.K.AND.K.LT.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*EXP(X(KA)))*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA-1)=G(KA-1)-FA
         G(KA+ND)=G(KA+ND)-FA
      ENDIF
      IF(L.EQ.1.AND.K.EQ.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*EXP(X(KA)))*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA+1)=G(KA+1)-FA
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.K.EQ.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*EXP(X(KA)))*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA-1)=G(KA-1)-FA
         G(KA+1)=G(KA+1)-FA
      ENDIF
      IF(L.EQ.ND.AND.K.EQ.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*EXP(X(KA)))*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA-1)=G(KA-1)-FA
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.1.LT.K.AND.K.LT.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*EXP(X(KA)))*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA-1)=G(KA-1)-FA
         G(KA+1)=G(KA+1)-FA
         G(KA+ND)=G(KA+ND)-FA
      ENDIF
  711 CONTINUE
      RETURN
  820 DO 821 KA=1,NA
      ND=INT(SQRT(DBLE(N)))
      L=MOD(KA,ND)
      IF(L.EQ.0) THEN
         K=KA/ND
         L=ND
      ELSE
         K=INT(KA/ND)+1
      ENDIF
      H=1.0D 0/DBLE(ND+1)
      H2=H*H
      IF(L.EQ.1.AND.K.EQ.1) THEN
         FA=4.0D 0*X(1)-X(2)-X(ND+1)+H2*X(1)**2-24.0D 0/(H+1.0D 0)**2
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.K.EQ.1) THEN
         FA=4.0D 0*X(L)-X(L-1)-X(L+1)-X(L+ND)+H2*X(L)**2
     *-12.0D 0/(DBLE(L)*H+1.0D 0)**2
      ENDIF
      IF(L.EQ.ND.AND.K.EQ.1) THEN
         FA=4.0D 0*X(ND)-X(ND-1)-X(ND+ND)+H2*X(ND)**2
     *-12.0D 0/(DBLE(ND)*H+1.0D 0)**2-12.0D 0/(H+2.0D 0)**2
      ENDIF
      IF(L.EQ.1.AND.1.LT.K.AND.K.LT.ND) THEN
         FA=4.0D 0*X(KA)-X(KA+1)-X(KA-ND)-X(KA+ND)+H2*X(KA)**2
     *-12.0D 0/(DBLE(K)*H+1.0D 0)**2
      ENDIF
      IF(L.EQ.ND.AND.1.LT.K.AND.K.LT.ND) THEN
         FA=4.0D 0*X(KA)-X(KA-ND)-X(KA-1)-X(KA+ND)+H2*X(KA)**2
     *-12.0D 0/(DBLE(K)*H+2.0D 0)**2
      ENDIF
      IF(L.EQ.1.AND.K.EQ.ND) THEN
         FA=4.0D 0*X(KA)-X(KA+1)-X(KA-ND)+H2*X(KA)**2
     *-12.0D 0/(DBLE(ND)*H+1.0D 0)**2-12.0D 0/(H+2.0D 0)**2
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.K.EQ.ND) THEN
         FA=4.0D 0*X(KA)-X(KA-1)-X(KA+1)-X(KA-ND)+H2*X(KA)**2
     *-12.0D 0/(DBLE(L)*H+2.0D 0)**2
      ENDIF
      IF(L.EQ.ND.AND.K.EQ.ND) THEN
        FA=4.0D 0*X(KA)-X(KA-1)-X(KA-ND)+H2*X(KA)**2
     *-24.0D 0/(DBLE(ND)*H+2.0D 0)**2
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.1.LT.K.AND.K.LT.ND) THEN
         FA=4.0D 0*X(KA)-X(KA-1)-X(KA+1)-X(KA-ND)-X(KA+ND)+H2*X(KA)**2
      ENDIF
      IF(L.EQ.1.AND.K.EQ.1) THEN
         G(1)=G(1)+(4.0D 0+H2*X(1)*2.0D 0)*FA
         G(2)=G(2)-FA
         G(ND+1)=G(ND+1)-FA
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.K.EQ.1) THEN
         G(L)=G(L)+(4.0D 0+H2*X(L)*2.0D 0)*FA
         G(L-1)=G(L-1)-FA
         G(L+1)=G(L+1)-FA
         G(L+ND)=G(L+ND)-FA
      ENDIF
      IF(L.EQ.ND.AND.K.EQ.1) THEN
         G(ND)=G(ND)+(4.0D 0+H2*X(ND)*2.0D 0)*FA
         G(ND-1)=G(ND-1)-FA
         G(ND+ND)=G(ND+ND)-FA
      ENDIF
      IF(L.EQ.1.AND.1.LT.K.AND.K.LT.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*X(KA)*2.0D 0)*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA+1)=G(KA+1)-FA
         G(KA+ND)=G(KA+ND)-FA
      ENDIF
      IF(L.EQ.ND.AND.1.LT.K.AND.K.LT.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*X(KA)*2.0D 0)*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA-1)=G(KA-1)-FA
         G(KA+ND)=G(KA+ND)-FA
      ENDIF
      IF(L.EQ.1.AND.K.EQ.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*X(KA)*2.0D 0)*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA+1)=G(KA+1)-FA
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.K.EQ.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*X(KA)*2.0D 0)*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA-1)=G(KA-1)-FA
         G(KA+1)=G(KA+1)-FA
      ENDIF
      IF(L.EQ.ND.AND.K.EQ.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*X(KA)*2.0D 0)*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA-1)=G(KA-1)-FA
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.1.LT.K.AND.K.LT.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*X(KA)*2.0D 0)*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA-1)=G(KA-1)-FA
         G(KA+1)=G(KA+1)-FA
         G(KA+ND)=G(KA+ND)-FA
      ENDIF
  821 CONTINUE
      RETURN
      END
* SUBROUTINE TFBU28                ALL SYSTEMS                92/12/01
C PORTABILITY : ALL SYSTEMS
C 92/12/01 LU : ORIGINAL VERSION
*
* PURPOSE :
*  VALUES AND GRADIENTS OF MODEL FUNCTIONS FOR UNCONSTRAINED
*  MINIMIZATION. UNIVERSAL VERSION.
*
* PARAMETERS :
*  II  N  NUMBER OF VARIABLES.
*  RI  X(N)  VECTOR OF VARIABLES.
*  RO  F  VALUE OF THE MODEL FUNCTION.
*  RI  G(N)  GRADIENG OF THE MODEL FUNCTION.
*  II  NEXT  NUMBER OF THE TEST PROBLEM.
*
      SUBROUTINE TFBU28(N,X,F,G,NEXT)
      INTEGER N,NA,NEXT
      REAL*8 X(N),G(N),F
      REAL*8 FA
      REAL*8 A,B,C,D,E,P,Q,R,U,V,W,ALFA,SX(1000)
      REAL*8 A1,A2,A3,A4,EX,D1S,D2S,H,PI
      REAL*8 GA1(2),GA2(2),GA3(6),GA4(6)
      REAL*8 AL,AL1,AL2,ALF,BE,BE1,BE2,BET,CA,CB,FF,FG,GA,GAM,H2,S,
     & S1,S2,S3,T,T1
      INTEGER I,J,K,L,M,IA,IB,IC,I1,I2,J1,J2,KA,LA,N1,ND
      REAL*8 Y(20),PAR
      COMMON /EMPR28/ Y,PAR,NA,M
      PI=3.14159265358979323846D 0
      F=0.0D 0
      CALL UXVSET(N,0.0D 0,G)
      GO TO (10,20,30,40,50,60,70,80,90,100,110,120,130,140,150,160,
     &  170,180,190,200,210,220,230,250,310,320,330,350,370,390,400,
     &  450,460,470,480,490,500,510,520,530,540,550,560,570,580,590,
     &  600,610,620,630,720,740,750,760,780,790,810,830,840,860,870,
     &  880,900,910,920,930,940,950,960,970,980,990,800,240,410,420,
     &  650,660,670,680,690,340,360,380,430,440,270,280,290,300,710,
     &  820),NEXT
   10 DO 11 J=2,N
      A=X(J-1)**2-X(J)
      B=X(J-1)-1.0D 0
      F=F+1.0D 2*A**2+B**2
      G(J-1)=G(J-1)+4.0D 2*X(J-1)*A+2.0D 0*B
      G(J)=G(J)-2.0D 2*A
   11 CONTINUE
      RETURN
   20 DO 21 J=2,N-2,2
      A=X(J-1)**2-X(J)
      B=X(J-1)-1.0D 0
      C=X(J+1)**2-X(J+2)
      D=X(J+1)-1.0D 0
      U=X(J)+X(J+2)-2.0D 0
      V=X(J)-X(J+2)
      F=F+1.0D 2*A**2+B**2+9.0D 1*C**2+D**2+
     &  1.0D 1*U**2+0.1D 0*V**2
      G(J-1)=G(J-1)+4.0D 2*X(J-1)*A+2.0D 0*B
      G(J)=G(J)-2.0D 2*A+2.0D 1*U+0.2D 0*V
      G(J+1)=G(J+1)+3.6D 2*X(J+1)*C+2.0D 0*D
      G(J+2)=G(J+2)-1.8D 2*C+2.0D 1*U-0.2D 0*V
   21 CONTINUE
      RETURN
   30 DO 31 J=2,N-2,2
      A=X(J-1)+1.0D 1*X(J)
      B=X(J+1)-X(J+2)
      C=X(J)-2.0D 0*X(J+1)
      D=X(J-1)-X(J+2)
      F=F+A**2+5.0D 0*B**2+C**4+1.0D 1*D**4
      G(J-1)=G(J-1)+2.0D 0*A+4.0D 1*D**3
      G(J)=G(J)+2.0D 1*A+4.0D 0*C**3
      G(J+1)=G(J+1)-8.0D 0*C**3+1.0D 1*B
      G(J+2)=G(J+2)-4.0D 1*D**3-1.0D 1*B
   31 CONTINUE
      RETURN
   40 DO 41 J=2,N-2,2
      A=EXP(X(J-1))
      B=A-X(J)
      D=X(J)-X(J+1)
      P=X(J+1)-X(J+2)
      C=COS(P)
      Q=SIN(P)/COS(P)
      U=X(J-1)
      V=X(J+2)-1.0D 0
      F=F+B**4+1.0D 2*D**6+Q**4+U**8+V**2
      B=4.0D 0*B**3
      D=6.0D 2*D**5
      Q=4.0D 0*Q**3/C**2
      G(J-1)=G(J-1)+A*B+8.0D 0*U**7
      G(J)=G(J)+D-B
      G(J+1)=G(J+1)+Q-D
      G(J+2)=G(J+2)+2.0D 0*V-Q
   41 CONTINUE
      RETURN
   50 P=7.0D 0/3.0D 0
      DO 51 J=1,N
      A=(3.0D 0-2.0D 0*X(J))*X(J)+1.0D 0
      IF (J.GT.1) A=A-X(J-1)
      IF (J.LT.N) A=A-X(J+1)
      F=F+ABS(A)**P
      B=P*ABS(A)**(P-1.0D 0)*SIGN(1.0D 0,A)
      G(J)=G(J)+B*(3.0D 0-4.0D 0*X(J))
      IF (J.GT.1) G(J-1)=G(J-1)-B
      IF (J.LT.N) G(J+1)=G(J+1)-B
   51 CONTINUE
      RETURN
   60 P=7.0D 0/3.0D 0
      DO 63 J=1,N
      A=(2.0D 0+5.0D 0*X(J)**2)*X(J)+1.0D 0
      DO 61 I=MAX(1,J-5),MIN(N,J+1)
      IF (I.NE.J) A=A+X(I)*(1.0D 0+X(I))
   61 CONTINUE
      F=F+ABS(A)**P
      B=P*ABS(A)**(P-1.0D 0)*SIGN(1.0D 0,A)
      G(J)=G(J)+B*(2.0D 0+1.5D 1*X(J)**2)
      DO 62 I=MAX(1,J-5),MIN(N,J+1)
      IF (I.NE.J) G(I)=G(I)+B*(1.0D 0+2.0D 0*X(I))
   62 CONTINUE
   63 CONTINUE
      RETURN
   70 P=7.0D 0/3.0D 0
      K=N/2
      DO 71 J=1,N
      A=(3.0D 0-2.0D 0*X(J))*X(J)+1.0D 0
      IF (J.GT.1) A=A-X(J-1)
      IF (J.LT.N) A=A-X(J+1)
      F=F+ABS(A)**P
      B=P*ABS(A)**(P-1.0D 0)*SIGN(1.0D 0,A)
      G(J)=G(J)+B*(3.0D 0-4.0D 0*X(J))
      IF (J.GT.1) G(J-1)=G(J-1)-B
      IF (J.LT.N) G(J+1)=G(J+1)-B
      IF (J.LE.K) THEN
      A=X(J)+X(J+K)
      F=F+ABS(A)**P
      B=P*ABS(A)**(P-1.0D 0)*SIGN(1.0D 0,A)
      G(J)=G(J)+B
      G(J+K)=G(J+K)+B
      ENDIF
   71 CONTINUE
      RETURN
   80 K=N/2
      DO 83 J=1,N
      P=0.0D 0
      DO 81 I=J-2,J+2
      IF (I.LT.1.OR.I.GT.N) GO TO 81
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      P=P+A*SIN(X(I))+B*COS(X(I))
   81 CONTINUE
      IF (J.GT.K) THEN
      I=J-K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      P=P+A*SIN(X(I))+B*COS(X(I))
      ELSE
      I=J+K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      P=P+A*SIN(X(I))+B*COS(X(I))
      ENDIF
      F=F+(DBLE(N+J)-P)**2/DBLE(N)
      P=2.0D 0*(DBLE(N+J)-P)/DBLE(N)
      DO 82 I=J-2,J+2
      IF (I.LT.1.OR.I.GT.N) GO TO 82
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      G(I)=G(I)-P*(A*COS(X(I))-B*SIN(X(I)))
   82 CONTINUE
      IF (J.GT.K) THEN
      I=J-K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      G(I)=G(I)-P*(A*COS(X(I))-B*SIN(X(I)))
      ELSE
      I=J+K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      G(I)=G(I)-P*(A*COS(X(I))-B*SIN(X(I)))
      ENDIF
   83 CONTINUE
      RETURN
   90 K=N/2
      Q=1.0D 0/DBLE(N)
      DO 92 J=1,N
      P=0.0D 0
      DO 91 I=J-2,J+2
      IF (I.LT.1.OR.I.GT.N) GO TO 91
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      P=P+A*SIN(X(I))+B*COS(X(I))
      G(I)=G(I)+Q*(A*COS(X(I))-B*SIN(X(I)))
   91 CONTINUE
      IF (J.GT.K) THEN
      I=J-K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      P=P+A*SIN(X(I))+B*COS(X(I))
      G(I)=G(I)+Q*(A*COS(X(I))-B*SIN(X(I)))
      ELSE
      I=J+K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=DBLE(I+J)/1.0D 1
      P=P+A*SIN(X(I))+B*COS(X(I))
      G(I)=G(I)+Q*(A*COS(X(I))-B*SIN(X(I)))
      ENDIF
      F=F+(P+DBLE(J)*(1.0D 0-COS(X(J))))*Q
      G(J)=G(J)+Q*DBLE(J)*SIN(X(J))
   92 CONTINUE
      RETURN
  100 K=N/2
      DO 102 J=1,N
      P=0.0D 0
      Q=1.0D 0+DBLE(J)/1.0D 1
      DO 101 I=J-2,J+2
      IF (I.LT.1.OR.I.GT.N) GO TO 101
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=1.0D 0+DBLE(I)/1.0D 1
      C=DBLE(I+J)/1.0D 1
      P=P+A*SIN(Q*X(J)+B*X(I)+C)
      R=A*COS(Q*X(J)+B*X(I)+C)/DBLE(N)
      G(J)=G(J)+R*Q
      G(I)=G(I)+R*B
  101 CONTINUE
      IF (J.GT.K) THEN
      I=J-K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=1.0D 0+DBLE(I)/1.0D 1
      C=DBLE(I+J)/1.0D 1
      P=P+A*SIN(Q*X(J)+B*X(I)+C)
      R=A*COS(Q*X(J)+B*X(I)+C)/DBLE(N)
      G(J)=G(J)+R*Q
      G(I)=G(I)+R*B
      ELSE
      I=J+K
      A=5.0D 0*(1.0D 0+MOD(I,5)+MOD(J,5))
      B=1.0D 0+DBLE(I)/1.0D 1
      C=DBLE(I+J)/1.0D 1
      P=P+A*SIN(Q*X(J)+B*X(I)+C)
      R=A*COS(Q*X(J)+B*X(I)+C)/DBLE(N)
      G(J)=G(J)+R*Q
      G(I)=G(I)+R*B
      ENDIF
      F=F+P
  102 CONTINUE
      F=F/DBLE(N)
      RETURN
  110 P=-0.2008D-2
      Q=-0.1900D-2
      R=-0.0261D-2
      DO 112 I=0,N-5,5
      A=1.0D 0
      B=0.0D 0
      DO 111 J=1,5
      A=A*X(I+J)
      B=B+X(I+J)**2
  111 CONTINUE
      W=EXP(A)
      A=A*W
      B=B-1.0D 1-P
      C=X(I+2)*X(I+3)-5.0D 0*X(I+4)*X(I+5)-Q
      D=X(I+1)**3+X(I+2)**3+1.0D 0-R
      F=F+W+1.0D 1*(B**2+C**2+D**2)
      G(I+1)=G(I+1)+A/X(I+1)+2.0D 1*(2.0D 0*B*X(I+1)+
     &  3.0D 0*D*X(I+1)**2)
      G(I+2)=G(I+2)+A/X(I+2)+2.0D 1*(2.0D 0*B*X(I+2)+
     &  C*X(I+3)+3.0D 0*D*X(I+2)**2)
      G(I+3)=G(I+3)+A/X(I+3)+2.0D 1*(2.0D 0*B*X(I+3)+C*X(I+2))
      G(I+4)=G(I+4)+A/X(I+4)+2.0D 1*(2.0D 0*B*X(I+4)-
     &  5.0D 0*C*X(I+5))
      G(I+5)=G(I+5)+A/X(I+5)+2.0D 1*(2.0D 0*B*X(I+5)-5.0D 0*C*X(I+4))
  112 CONTINUE
      RETURN
  120 C=0.0D 0
      DO 121 J=2,N,2
      A=X(J-1)-3.0D 0
      B=X(J-1)-X(J)
      C=C+A
      F=F+1.0D-4*A**2-B+EXP(2.0D 1*B)
      G(J-1)=G(J-1)+2.0D-4*A-1.0D 0+2.0D 1*EXP(2.0D 1*B)
      G(J)=G(J)+1.0D 0-2.0D 1*EXP(2.0D 1*B)
  121 CONTINUE
      F=F+C**2
      DO 122 J=2,N,2
      G(J-1)=G(J-1)+2.0D 0*C
  122 CONTINUE
      RETURN
  130 DO 131 J=2,N,2
      A=X(J)**2
      IF (A.EQ.0.0D 0) A=1.0D-60
      B=X(J-1)**2
      IF (B.EQ.0.0D 0) B=1.0D-60
      C=A+1.0D 0
      D=B+1.0D 0
      F=F+B**C+A**D
      P=0.0D 0
      IF (A.GT.P) P=LOG(A)
      Q=0.0D 0
      IF (B.GT.Q) Q=LOG(B)
      G(J-1)=G(J-1)+2.0D 0*X(J-1)*(C*B**A+P*A**D)
      G(J)=G(J)+2.0D 0*X(J)*(D*A**B+Q*B**C)
  131 CONTINUE
      RETURN
  140 P=1.0D 0/DBLE(N+1)
      Q=0.5D 0*P**2
      DO 141 J=1,N
      A=2.0D 0*X(J)+Q*(X(J)+DBLE(J)*P+1.0D 0)**3
      IF(J.GT.1) A=A-X(J-1)
      IF(J.LT.N) A=A-X(J+1)
      F=F+A**2
      G(J)=G(J)+A*(4.0D 0+6.0D 0*Q*(X(J)+DBLE(J)*P+1.0D 0)**2.0D 0)
      IF(J.GT.1) G(J-1)=G(J-1)-2.0D 0*A
      IF(J.LT.N) G(J+1)=G(J+1)-2.0D 0*A
  141 CONTINUE
      RETURN
  150 P=1.0D 0/DBLE(N+1)
      Q=2.0D 0/P
      R=2.0D 0*P
      DO 151 J=2,N
      A=X(J-1)-X(J)
      F=F+Q*X(J-1)*A
      G(J-1)=G(J-1)+Q*(2.0D 0*X(J-1)-X(J))
      G(J)=G(J)-Q*X(J-1)
      IF (ABS(A).LE.1.0D-6) THEN
      F=F+R*EXP(X(J))*(1.0D 0+A/2.0D 0*(1.0D 0+A/3.0D 0*(1.0D 0+
     &  A/4.0D 0)))
      G(J-1)=G(J-1)+R*EXP(X(J))*(1.0D 0/2.0D 0+A*(1.0D 0/3.0D 0+
     &  A/8.0D 0))
      G(J)=G(J)+R*EXP(X(J))*(1.0D 0/2.0D 0+A*(1.0D 0/6.0D 0+
     &  A/24.0D 0))
      ELSE
      B=EXP(X(J-1))-EXP(X(J))
      F=F+R*B/A
      G(J-1)=G(J-1)+R*(EXP(X(J-1))*A-B)/A**2
      G(J)=G(J)-R*(EXP(X(J))*A-B)/A**2
      ENDIF
  151 CONTINUE
      F=F+Q*X(N)**2+R*(EXP(X(1))-1.0D 0)/X(1)
     &             +R*(EXP(X(N))-1.0D 0)/X(N)
      G(1)=G(1)+R*(EXP(X(1))*(X(1)-1.0D 0)+1.0D 0)/X(1)**2
      G(N)=G(N)+2.0D 0*Q*X(N)
     &         +R*(EXP(X(N))*(X(N)-1.0D 0)+1.0D 0)/X(N)**2
      RETURN
  160 DO 161 J=1,N
      A=DBLE(J)*(1.0D 0-COS(X(J)))
      IF(J.GT.1) A=A+DBLE(J)*SIN(X(J-1))
      IF(J.LT.N) A=A-DBLE(J)*SIN(X(J+1))
      F=F+A
      A=DBLE(J)*SIN(X(J))
      G(J)=G(J)+A
      IF(J.GT.1) G(J-1)=G(J-1)+DBLE(J)*COS(X(J-1))
      IF(J.LT.N) G(J+1)=G(J+1)-DBLE(J)*COS(X(J+1))
  161 CONTINUE
      RETURN
  170 P=1.0D 0/DBLE(N+1)
      DO 171 J=1,N
      IF (J.EQ.1) THEN
      F=F+0.25D 0*X(J)**2/P+1.25D-1*X(J+1)**2/P+
     & P*(EXP(X(J))-1.0D 0)
      G(J)=G(J)+0.5D 0*X(J)/P+P*EXP(X(J))
      G(J+1)=G(J+1)+0.25D 0*X(J+1)/P
      ELSE IF (J.EQ.N) THEN
      F=F+0.25D 0*X(J)**2/P+1.25D-1*X(J-1)**2/P+
     & P*(EXP(X(J))-1.0D 0)
      G(J)=G(J)+0.5D 0*X(J)/P+P*EXP(X(J))
      G(J-1)=G(J-1)+0.25D 0*X(J-1)/P
      ELSE
      F=F+1.25D-1*(X(J+1)-X(J-1))**2/P+P*(EXP(X(J))-1.0D 0)
      A=0.25D 0*(X(J+1)-X(J-1))/P
      G(J)=G(J)+P*EXP(X(J))
      G(J-1)=G(J-1)-A
      G(J+1)=G(J+1)+A
      ENDIF
  171 CONTINUE
      RETURN
  180 P=1.0D 0/DBLE(N+1)
      DO 181 J=1,N
      Q=DBLE(J)*P
      IF (J.EQ.1) THEN
      F=F+0.5D 0*X(J)**2/P+0.25D 0*X(J+1)**2/P-
     & P*(X(J)**2+2.0D 0*X(J)*Q)
      G(J)=G(J)+X(J)/P-2.0D 0*P*(X(J)+Q)
      G(J+1)=G(J+1)+0.5D 0*X(J+1)/P
      ELSE IF (J.EQ.N) THEN
      F=F+0.5D 0*X(J)**2/P+0.25D 0*X(J-1)**2/P-
     & P*(X(J)**2+2.0D 0*X(J)*Q)
      G(J)=G(J)+X(J)/P-2.0D 0*P*(X(J)+Q)
      G(J-1)=G(J-1)+0.5D 0*X(J-1)/P
      ELSE
      F=F+2.5D-1*(X(J+1)-X(J-1))**2/P-P*(X(J)**2+
     & 2.0D 0*X(J)*Q)
      A=0.5D 0*(X(J+1)-X(J-1))/P
      G(J)=G(J)-2.0D 0*P*(X(J)+Q)
      G(J-1)=G(J-1)-A
      G(J+1)=G(J+1)+A
      ENDIF
  181 CONTINUE
      RETURN
  190 P=1.0D 0/DBLE(N+1)
      DO 191 J=1,N
      Q=EXP(2.0D 0*DBLE(J)*P)
      IF (J.EQ.1) THEN
      R=1.0D 0/3.0D 0
      F=F+0.5D 0*(X(J)-R)**2/P+7.0D 0*R**2+
     & 2.5D-1*(X(J+1)-R)**2/P+P*(X(J)**2+2.0D 0*X(J)*Q)
      A=0.5D 0*(X(J+1)-R)/P
      G(J)=G(J)+2.0D 0*P*(X(J)+Q)+(X(J)-R)/P
      G(J+1)=G(J+1)+A
      ELSE IF (J.EQ.N) THEN
      R=EXP(2.0D 0)/3.0D 0
      F=F+0.5D 0*(X(J)-R)**2/P+7.0D 0*R**2+
     & 2.5D-1*(X(J-1)-R)**2/P+P*(X(J)**2+2.0D 0*X(J)*Q)
      A=0.5D 0*(X(J-1)-R)/P
      G(J)=G(J)+2.0D 0*P*(X(J)+Q)+(X(J)-R)/P
      G(J-1)=G(J-1)+A
      ELSE
      F=F+2.5D-1*(X(J+1)-X(J-1))**2/P+P*(X(J)**2+
     & 2.0D 0*X(J)*Q)
      A=0.5D 0*(X(J+1)-X(J-1))/P
      G(J)=G(J)+2.0D 0*P*(X(J)+Q)
      G(J-1)=G(J-1)-A
      G(J+1)=G(J+1)+A
      ENDIF
  191 CONTINUE
      RETURN
  200 P=1.0D 0/DBLE(N+1)
      DO 201 J=1,N
      A=EXP(-2.0D 0*X(J)**2)
      IF (J.EQ.1) THEN
      F=F+(0.5D 0*X(J)**2/P-P)+
     & (2.5D-1*X(J+1)**2/P-P)*A
      B=0.5D 0*X(J+1)/P
      G(J)=G(J)+X(J)/P-4.0D 0*X(J)*A*P*(B**2-1.0D 0)
      G(J+1)=G(J+1)+A*B
      ELSE IF (J.EQ.N) THEN
      F=F+(0.5D 0*X(J)**2/P-P)*EXP(-2.0D 0)+
     & (2.5D-1*X(J-1)**2/P-P)*A
      B=0.5D 0*X(J-1)/P
      G(J)=G(J)+X(J)/P*EXP(-2.0D 0)-4.0D 0*X(J)*A*P*(B**2-1.0D 0)
      G(J-1)=G(J-1)+A*B
      ELSE
      F=F+(2.5D-1*(X(J+1)-X(J-1))**2/P-P)*A
      B=0.5D 0*(X(J+1)-X(J-1))/P
      G(J)=G(J)-4.0D 0*X(J)*A*P*(B**2-1.0D 0)
      G(J-1)=G(J-1)-A*B
      G(J+1)=G(J+1)+A*B
      ENDIF
  201 CONTINUE
      RETURN
  210 P=1.0D 0/DBLE(N+1)
      DO 211 J=1,N
      IF (J.EQ.1) THEN
      A=0.5D 0*(X(J+1)-1.0D 0)/P
      B=(X(J)-1.0D 0)/P
      U=ATAN(A)
      V=ATAN(B)
      F=F+P*(X(J)**2+A*U-LOG(SQRT(1.0D 0+A**2)))+
     &   0.5D 0*P*(1.0D 0+B*V-LOG(SQRT(1.0D 0+B**2)))
      G(J)=G(J)+2.0D 0*P*X(J)+0.5D 0*V
      G(J+1)=G(J+1)+0.5D 0*U
      ELSE IF (J.EQ.N) THEN
      A=0.5D 0*(2.0D 0-X(J-1))/P
      B=(2.0D 0-X(J))/P
      U=ATAN(A)
      V=ATAN(B)
      F=F+P*(X(J)**2+A*U-LOG(SQRT(1.0D 0+A**2)))+
     &   0.5D 0*P*(4.0D 0+B*V-LOG(SQRT(1.0D 0+B**2)))
      G(J)=G(J)+2.0D 0*P*X(J)-0.5D 0*V
      G(J-1)=G(J-1)-0.5D 0*U
      ELSE
      A=0.5D 0*(X(J+1)-X(J-1))/P
      U=ATAN(A)
      F=F+P*(X(J)**2+A*U-LOG(SQRT(1.0D 0+A**2)))
      G(J)=G(J)+2.0D 0*P*X(J)
      G(J-1)=G(J-1)-0.5D 0*U
      G(J+1)=G(J+1)+0.5D 0*U
      ENDIF
  211 CONTINUE
      RETURN
  220 P=1.0D 0/DBLE(N+1)
      DO 221 J=1,N
      IF (J.EQ.1) THEN
      A= 0.5D 0*X(J+1)/P
      B= X(J)/P
      F=F+P*(1.0D 2*(X(J)-A**2)**2+(1.0D 0-A)**2)+
     &   0.5D 0*P*(1.0D 2*B**4+(1.0D 0-B)**2)
      G(J)=G(J)+2.0D 2*P*(X(J)-A**2)+2.0D 2*B**3-(1.0D 0-B)
      G(J+1)=G(J+1)-2.0D 2*(X(J)-A**2)*A-(1.0D 0-A)
      ELSE IF (J.EQ.N) THEN
      A=-0.5D 0*X(J-1)/P
      B=-X(J)/P
      F=F+P*(1.0D 2*(X(J)-A**2)**2+(1.0D 0-A)**2)+
     &   0.5D 0*P*(1.0D 2*B**4+(1.0D 0-B)**2)
      G(J)=G(J)+2.0D 2*P*(X(J)-A**2)-2.0D 2*B**3+(1.0D 0-B)
      G(J-1)=G(J-1)+2.0D 2*(X(J)-A**2)*A+(1.0D 0-A)
      ELSE
      A=0.5D 0*(X(J+1)-X(J-1))/P
      F=F+P*(1.0D 2*(X(J)-A**2)**2+(1.0D 0-A)**2)
      G(J)=G(J)+2.0D 2*P*(X(J)-A**2)
      G(J-1)=G(J-1)+2.0D 2*(X(J)-A**2)*A+(1.0D 0-A)
      G(J+1)=G(J+1)-2.0D 2*(X(J)-A**2)*A-(1.0D 0-A)
      ENDIF
  221 CONTINUE
      RETURN
  230 A1=-1.0D 0
      A2=0.0D 0
      A3=0.0D 0
      D1S=EXP(1.0D-2)
      D2S=1.0D 0
      DO 231 J=1,N
      A1=A1+DBLE(N-J+1)*X(J)**2
  231 CONTINUE
      A=4.0D 0*A1
      DO 232 J=1,N
      G(J)=A*DBLE(N-J+1)*X(J)
      S1=EXP(X(J)/1.0D 2)
      IF (J.GT.1) THEN
      S3=S1+S2-D2S*(D1S-1.0D 0)
      A2=A2+S3**2
      A3=A3+(S1-1.0D 0/D1S)**2
      G(J)=G(J)+1.0D-5*S1*(S3+S1-1.0D 0/D1S)/5.0D 1
      G(J-1)=G(J-1)+1.0D-5*S2*S3/5.0D 1
      ENDIF
      S2=S1
      D2S=D1S*D2S
  232 CONTINUE
      F=1.0D-5*(A2+A3)+A1**2+(X(1)-2.0D-1)**2
      G(1)=G(1)+2.0D 0*(X(1)-2.0D-1)
      RETURN
  250 A=1.0D 0
      B=0.0D 0
      C=0.0D 0
      D=0.0D 0
      F=0.0D 0
      U=EXP(X(N))
      V=EXP(X(N-1))
      DO 251 J=1,N
      IF (J.LE.N/2) F=F+(X(J)-1.0D 0)**2
      IF (J.LE.N-2) THEN
      B=B+(X(J)+2.0D 0*X(J+1)+1.0D 1*X(J+2)-1.0D 0)**2
      C=C+(2.0D 0*X(J)+X(J+1)-3.0D 0)**2
      ENDIF
      D=D+X(J)**2-DBLE(N)
  251 CONTINUE
      F=F+A*(1.0D 0+U*B+B*C+V*C)+D**2
      DO 252 J=1,N
      IF (J.LE.N/2) G(J)=G(J)+2.0D 0*(X(J)-1.0D 0)
      IF (J.LE.N-2) THEN
      P=A*(U+C)*(X(J)+2.0D 0*X(J+1)+1.0D 1*X(J+2)-1.0D 0)
      Q=A*(V+B)*(2.0D 0*X(J)+X(J+1)-3.0D 0)
      G(J)=G(J)+2.0D 0*P+4.0D 0*Q
      G(J+1)=G(J+1)+4.0D 0*P+2.0D 0*Q
      G(J+2)=G(J+2)+2.0D 1*P
      ENDIF
      G(J)=G(J)+4.0D 0*D*X(J)
  252 CONTINUE
      G(N-1)=G(N-1)+A*V*C
      G(N)=G(N)+A*U*B
      RETURN
  310 DO 311 KA=1,NA
      IF(MOD(KA,2).EQ.1) THEN
      FA=1.0D 1*(X(KA+1)-X(KA)**2)
      G(KA)=G(KA)-2.0D 1*X(KA)*FA
      G(KA+1)=G(KA+1)+1.0D 1*FA
      ELSE
      FA=1.0D 0-X(KA-1)
      G(KA-1)=G(KA-1)-FA
      ENDIF
      F=F+FA**2
  311 CONTINUE
      F=0.5D 0*F
      RETURN
  320 DO 321 KA=1,NA
      IF(MOD(KA,4).EQ.1) THEN
      FA=X(KA)+1.0D 1*X(KA+1)
      G(KA)=G(KA)+FA
      G(KA+1)=G(KA+1)+1.0D 1*FA
      ELSEIF(MOD(KA,4).EQ.2) THEN
      FA=2.23606797749979D 0*(X(KA+1)-X(KA+2))
      G(KA+1)=G(KA+1)+2.23606797749979D 0*FA
      G(KA+2)=G(KA+2)-2.23606797749979D 0*FA
      ELSEIF(MOD(KA,4).EQ.3) THEN
      A=X(KA-1)-2.0D 0*X(KA)
      FA=A**2
      G(KA-1)=G(KA-1)+2.0D 0*A*FA
      G(KA)=G(KA)-4.0D 0*A*FA
      ELSE
      FA=3.16227766016838D 0*(X(KA-3)-X(KA))**2
      A=2.0D 0*(X(KA-3)-X(KA))
      G(KA-3)=G(KA-3)+3.16227766016838D 0*A*FA
      G(KA)=G(KA)-3.16227766016838D 0*A*FA
      ENDIF
      F=F+FA**2
  321 CONTINUE
      F=0.5D 0*F
      RETURN
  330 DO 333 KA=1,NA
      IF(KA.LE.N) THEN
      FA=(X(KA)-1.0D 0)/3.16227766016838D 0**5
      G(KA)=G(KA)+1.0D 0/3.16227766016838D 0**5*FA
      ELSE
      FA=-0.25D 0
      DO 331 J=1,N
      FA=FA+X(J)**2
  331 CONTINUE
      DO 332 J=1,N
      G(J)=G(J)+2.0D 0*X(J)*FA
  332 CONTINUE
      ENDIF
      F=F+FA**2
  333 CONTINUE
      F=0.5D 0*F
      RETURN
  350 DO 354 KA=1,NA
      IF(KA.LE.N) THEN
      FA=X(KA)-1.0D 0
      G(KA)=G(KA)+FA
      ELSE
      FA=0.0D 0
      DO 351 J=1,N
      FA=FA+DBLE(J)*(X(J)-1.0D 0)
  351 CONTINUE
      IF(KA.EQ.N+1) THEN
      DO 352 J=1,N
      G(J)=G(J)+DBLE(J)*FA
  352 CONTINUE
      ELSE IF(KA.EQ.N+2) THEN
      DO 353 J=1,N
      G(J)=G(J)+2.0D 0*DBLE(J)*FA**3
  353 CONTINUE
      FA=FA**2
      ENDIF
      ENDIF
      F=F+FA**2
  354 CONTINUE
      F=0.5D 0*F
      RETURN
  370 DO 376 KA=1,NA
      IF(KA.LT.N) THEN
      A=0.0D 0
      DO 371 J=1,N
      A=A+X(J)
  371 CONTINUE
      FA=X(KA)+A-DBLE(N+1)
      DO 372 J=1,N
      G(J)=G(J)+FA
  372 CONTINUE
      G(KA)=G(KA)+FA
      ELSE
      A=1.0D 0
      DO 373 J=1,N
      A=A*X(J)
  373 CONTINUE
      FA=A-1.0D 0
      I=0
      DO 374 J=1,N
      B=X(J)
      IF(B.EQ.0.0D 0.AND.I.EQ.0) I=J
      IF(I.NE.J) A=A*B
  374 CONTINUE
      IF(I.EQ.0) THEN
      DO 375 J=1,N
      G(J)=G(J)+A/X(J)*FA
  375 CONTINUE
      ELSE
      G(I)=G(I)+A*FA
      ENDIF
      ENDIF
      F=F+FA**2
  376 CONTINUE
      F=0.5D 0*F
      RETURN
  390 DO 393 KA=1,NA
      U=1.0D 0/DBLE(N+1)
      V=DBLE(KA)*U
      A=0.0D 0
      B=0.0D 0
      DO 391 J=1,N
      W=DBLE(J)*U
      IF(J.LE.KA) THEN
      A=A+W*(X(J)+W+1.0D 0)**3
      ELSE
      B=B+(1.0D 0-W)*(X(J)+W+1.0D 0)**3
      ENDIF
  391 CONTINUE
      FA=X(KA)+U*((1.0D 0-V)*A+V*B)/2.0D 0
      F=F+FA**2
      DO 392 J=1,N
      W=DBLE(J)*U
      A=(X(J)+W+1.0D 0)**2
      IF(J.LE.KA) THEN
      G(J)=G(J)+1.5D 0*U*(1.0D 0-V)*W*A*FA
      ELSE
      G(J)=G(J)+1.5D 0*U*(1.0D 0-W)*V*A*FA
      ENDIF
  392 CONTINUE
      G(KA)=G(KA)+FA
  393 CONTINUE
      F=0.5D 0*F
      RETURN
  400 DO 401 KA=1,NA
      FA=(3.0D 0-2.0D 0*X(KA))*X(KA)+1.0D 0
      IF(KA.GT.1) FA=FA-X(KA-1)
      IF(KA.LT.N) FA=FA-2.0D 0*X(KA+1)
      F=F+FA**2
      G(KA)=G(KA)+(3.0D 0-4.0D 0*X(KA))*FA
      IF(KA.GT.1) G(KA-1)=G(KA-1)-FA
      IF(KA.LT.N) G(KA+1)=G(KA+1)-2.0D 0*FA
  401 CONTINUE
      F=0.5D 0*F
      RETURN
  450 DO 451 KA=1,NA
      I=KA
      FA=(3.0D 0-2.0D 0*X(I))*X(I)+1.0D 0
      IF (I.GT.1) FA=FA-X(I-1)
      IF (I.LT.N) FA=FA-X(I+1)
      F=F+FA**2
      G(I)=G(I)+(3.0D 0-4.0D 0*X(I))*FA
      IF (I.GT.1) G(I-1)=G(I-1)-FA
      IF (I.LT.N) G(I+1)=G(I+1)-FA
  451 CONTINUE
      F=0.5D 0*F
      RETURN
  460 DO 463 KA=1,NA
      I=KA
      FA=(2.0D 0+5.0D 0*X(I)**2)*X(I)+1.0D 0
      DO 461 J=MAX(1,I-5),MIN(N,I+1)
      IF (I.NE.J) FA=FA+X(J)*(1.0D 0+X(J))
  461 CONTINUE
      F=F+FA**2
      DO 462 J=MAX(1,I-5),MIN(N,I+1)
      IF (I.NE.J) G(J)=G(J)+(1.0D 0+2.0D 0*X(J))*FA
  462 CONTINUE
      G(I)=G(I)+(2.0D 0+1.5D 1*X(I)**2)*FA
  463 CONTINUE
      F=0.5D 0*F
      RETURN
  470 DO 471 KA=1,NA
      I=(KA+1)/2
      IF (MOD(KA,2).EQ.1) THEN
      FA=X(I)+X(I+1)*((5.0D 0-X(I+1))*X(I+1)-2.0D 0)-1.3D 1
      G(I)=G(I)+FA
      G(I+1)=G(I+1)+(1.0D 1*X(I+1)-3.0D 0*X(I+1)**2-2.0D 0)*FA
      ELSE
      FA=X(I)+X(I+1)*((1.0D 0+X(I+1))*X(I+1)-1.4D 1)-2.9D 1
      G(I)=G(I)+FA
      G(I+1)=G(I+1)+(2.0D 0*X(I+1)+3.0D 0*X(I+1)**2-1.4D 1)*FA
      ENDIF
      F=F+FA**2
  471 CONTINUE
      F=0.5D 0*F
      RETURN
  480 DO 481 KA=1,NA
      I=MOD(KA,N/2)+1
      J=I+N/2
      M=5*N
      IF (KA.LE.M/2) THEN
      IA=1
      ELSE
      IA=2
      ENDIF
      IB=5-KA/(M/4)
      IC=MOD(KA,5)+1
      FA=(X(I)**IA-X(J)**IB)**IC
      F=F+FA**2
      A=DBLE(IA)
      B=DBLE(IB)
      C=DBLE(IC)
      D=X(I)**IA-X(J)**IB
      IF (D.NE.0.0D 0) THEN
      E=C*D**(IC-1)
      IF (X(I).EQ.0.0D 0.AND.IA.LE.1) THEN
      ELSE
      G(I)=G(I)+E*A*X(I)**(IA-1)*FA
      ENDIF
      IF (X(J).EQ.0.0D 0.AND.IB.LE.1) THEN
      ELSE
      G(J)=G(J)-E*B*X(J)**(IB-1)*FA
      ENDIF
      ENDIF
  481 CONTINUE
      F=0.5D 0*F
      RETURN
  490 DO 491 KA=1,NA
      I=2*((KA+5)/6)-1
      IF (MOD(KA,6).EQ.1) THEN
      FA=X(I)+3.0D 0*X(I+1)*(X(I+2)-1.0D 0)+X(I+3)**2-1.0D 0
      G(I)=G(I)+FA
      G(I+1)=G(I+1)+3.0D 0*(X(I+2)-1.0D 0)*FA
      G(I+2)=G(I+2)+3.0D 0*X(I+1)*FA
      G(I+3)=G(I+3)+2.0D 0*X(I+3)*FA
      ELSEIF (MOD(KA,6).EQ.2) THEN
      FA=(X(I)+X(I+1))**2+(X(I+2)-1.0D 0)**2-X(I+3)-3.0D 0
      G(I)=G(I)+2.0D 0*(X(I)+X(I+1))*FA
      G(I+1)=G(I+1)+2.0D 0*(X(I)+X(I+1))*FA
      G(I+2)=G(I+2)+2.0D 0*(X(I+2)-1.0D 0)*FA
      G(I+3)=G(I+3)-FA
      ELSEIF (MOD(KA,6).EQ.3) THEN
      FA=X(I)*X(I+1)-X(I+2)*X(I+3)
      G(I)=G(I)+X(I+1)*FA
      G(I+1)=G(I+1)+X(I)*FA
      G(I+2)=G(I+2)-X(I+3)*FA
      G(I+3)=G(I+3)-X(I+2)*FA
      ELSEIF (MOD(KA,6).EQ.4) THEN
      FA=2.0D 0*X(I)*X(I+2)+X(I+1)*X(I+3)-3.0D 0
      G(I)=G(I)+2.0D 0*X(I+2)*FA
      G(I+1)=G(I+1)+X(I+3)*FA
      G(I+2)=G(I+2)+2.0D 0*X(I)*FA
      G(I+3)=G(I+3)+X(I+1)*FA
      ELSEIF (MOD(KA,6).EQ.5) THEN
      FA=(X(I)+X(I+1)+X(I+2)+X(I+3))**2+(X(I)-1.0D 0)**2
      G(I)=G(I)+(2.0D 0*(X(I)+X(I+1)+X(I+2)+X(I+3))+
     & 2.0D 0*(X(I)-1.0D 0))*FA
      G(I+1)=G(I+1)+2.0D 0*(X(I)+X(I+1)+X(I+2)+X(I+3))*FA
      G(I+2)=G(I+2)+2.0D 0*(X(I)+X(I+1)+X(I+2)+X(I+3))*FA
      G(I+3)=G(I+3)+2.0D 0*(X(I)+X(I+1)+X(I+2)+X(I+3))*FA
      ELSE
      FA=X(I)*X(I+1)*X(I+2)*X(I+3)+(X(I+3)-1.0D 0)**2-1.0D 0
      G(I)=G(I)+X(I+1)*X(I+2)*X(I+3)*FA
      G(I+1)=G(I+1)+X(I)*X(I+2)*X(I+3)*FA
      G(I+2)=G(I+2)+X(I)*X(I+1)*X(I+3)*FA
      G(I+3)=G(I+3)+(X(I)*X(I+1)*X(I+2)+2.0D 0*(X(I+3)-1.0D 0))*FA
      ENDIF
      F=F+FA**2
  491 CONTINUE
      F=0.5D 0*F
      RETURN
  500 DO 501 KA=1,NA
      I=(KA+1)/2
      J=MOD(KA,2)
      IF (J.EQ.0) THEN
      FA=6.0D 0-EXP(2.0D 0*X(I))-EXP(2.0D 0*X(I+1))
      G(I)=G(I)-2.0D 0*EXP(2.0D 0*X(I))*FA
      G(I+1)=G(I+1)-2.0D 0*EXP(2.0D 0*X(I+1))*FA
      ELSEIF (I.EQ.1) THEN
      FA=4.0D 0-EXP(X(I))-EXP(X(I+1))
      G(I)=G(I)-EXP(X(I))*FA
      G(I+1)=G(I+1)-EXP(X(I+1))*FA
      ELSEIF (I.EQ.N) THEN
      FA=8.0D 0-EXP(3.0D 0*X(I-1))-EXP(3.0D 0*X(I))
      G(I-1)=G(I-1)-3.0D 0*EXP(3.0D 0*X(I-1))*FA
      G(I)=G(I)-3.0D 0*EXP(3.0D 0*X(I))*FA
      ELSE
      FA=8.0D 0-EXP(3.0D 0*X(I-1))-EXP(3.0D 0*X(I))+
     & 4.0D 0-EXP(X(I))-EXP(X(I+1))
      G(I-1)=G(I-1)-3.0D 0*EXP(3.0D 0*X(I-1))*FA
      G(I)=G(I)-(3.0D 0*EXP(3.0D 0*X(I))+EXP(X(I)))*FA
      G(I+1)=G(I+1)-EXP(X(I+1))*FA
      ENDIF
      F=F+FA**2
  501 CONTINUE
      F=0.5D 0*F
      RETURN
  510 DO 511 KA=1,NA
      I=(KA+1)/2
      IF (MOD(KA,2).EQ.1) THEN
      FA=1.0D 1*(2.0D 0*X(I)/(1.0D 0+X(I)**2)-X(I+1))
      G(I)=G(I)+2.0D 1*(1.0D 0-X(I)**2)/(1.0D 0+X(I)**2)**2*FA
      G(I+1)=G(I+1)-1.0D 1*FA
      ELSE
      FA=X(I)-1.0D 0
      G(I)=G(I)+FA
      ENDIF
      F=F+FA**2
  511 CONTINUE
      F=0.5D 0*F
      RETURN
  520 DO 521 KA=1,NA
      I=3*((KA+5)/6)-2
      IF (MOD(KA,6).EQ.1) THEN
      FA=1.0D 1*(X(I)**2-X(I+1))
      G(I)=G(I)+2.0D 1*X(I)*FA
      G(I+1)=G(I+1)-1.0D 1*FA
      ELSEIF (MOD(KA,6).EQ.2) THEN
      FA=X(I+2)-1.0D 0
      G(I+2)=G(I+2)+FA
      ELSEIF (MOD(KA,6).EQ.3) THEN
      FA=(X(I+3)-1.0D 0)**2
      G(I+3)=G(I+3)+2.0D 0*(X(I+3)-1.0D 0)*FA
      ELSEIF (MOD(KA,6).EQ.4) THEN
      FA=(X(I+4)-1.0D 0)**3
      G(I+4)=G(I+4)+3.0D 0*(X(I+4)-1.0D 0)**2*FA
      ELSEIF (MOD(KA,6).EQ.5) THEN
      FA=X(I)**2*X(I+3)+SIN(X(I+3)-X(I+4))-1.0D 1
      G(I)=G(I)+2.0D 0*X(I)*X(I+3)*FA
      G(I+3)=G(I+3)+(X(I)**2+COS(X(I+3)-X(I+4)))*FA
      G(I+4)=G(I+4)-COS(X(I+3)-X(I+4))*FA
      ELSE
      FA=X(I+1)+(X(I+2)**2*X(I+3))**2-2.0D 1
      G(I+1)=G(I+1)+FA
      G(I+2)=G(I+2)+4.0D 0*X(I+2)*(X(I+2)*X(I+3))**2*FA
      G(I+3)=G(I+3)+2.0D 0*X(I+2)**4*X(I+3)*FA
      ENDIF
      F=F+FA**2
  521 CONTINUE
      F=0.5D 0*F
      RETURN
  530 DO 531 KA=1,NA
      I=3*((KA+6)/7)-2
      IF (MOD(KA,7).EQ.1) THEN
      FA=1.0D 1*(X(I)**2-X(I+1))
      G(I)=G(I)+2.0D 1*X(I)*FA
      G(I+1)=G(I+1)-1.0D 1*FA
      ELSEIF (MOD(KA,7).EQ.2) THEN
      FA=1.0D 1*(X(I+1)**2-X(I+2))
      G(I+1)=G(I+1)+2.0D 1*X(I+1)*FA
      G(I+2)=G(I+2)-1.0D 1*FA
      ELSEIF (MOD(KA,7).EQ.3) THEN
      FA=(X(I+2)-X(I+3))**2
      G(I+2)=G(I+2)+2.0D 0*(X(I+2)-X(I+3))*FA
      G(I+3)=G(I+3)-2.0D 0*(X(I+2)-X(I+3))*FA
      ELSEIF (MOD(KA,7).EQ.4) THEN
      FA=(X(I+3)-X(I+4))**2
      G(I+3)=G(I+3)+2.0D 0*(X(I+3)-X(I+4))*FA
      G(I+4)=G(I+4)-2.0D 0*(X(I+3)-X(I+4))*FA
      ELSEIF (MOD(KA,7).EQ.5) THEN
      FA=X(I)+X(I+1)**2+X(I+2)-3.0D 1
      G(I)=G(I)+FA
      G(I+1)=G(I+1)+2.0D 0*X(I+1)*FA
      G(I+2)=G(I+2)+FA
      ELSEIF (MOD(KA,7).EQ.6) THEN
      FA=X(I+1)-X(I+2)**2+X(I+3)-1.0D 1
      G(I+1)=G(I+1)+FA
      G(I+2)=G(I+2)-2.0D 0*X(I+2)*FA
      G(I+3)=G(I+3)+FA
      ELSE
      FA=X(I)*X(I+4)-1.0D 1
      G(I)=G(I)+X(I+4)*FA
      G(I+4)=G(I+4)+X(I)*FA
      ENDIF
      F=F+FA**2
  531 CONTINUE
      F=0.5D 0*F
      RETURN
  540 DO 546 KA=1,NA
      I=2*((KA+3)/4)-2
      L=MOD((KA-1),4)+1
      FA=-Y(L)
      DO 542 K=1,3
      A=DBLE(K*K)/DBLE(L)
      DO 541 J=1,4
      IF (X(I+J).EQ.0) X(I+J)=1.0D-16
      A=A*SIGN(1.0D 0,X(I+J))*ABS(X(I+J))**(DBLE(J)/DBLE(K*L))
  541 CONTINUE
      FA=FA+A
  542 CONTINUE
      F=F+FA**2
      DO 545 K=1,3
      A=DBLE(K*K)/DBLE(L)
      DO 543 J=1,4
      A=A*SIGN(1.0D 0,X(I+J))*ABS(X(I+J))**(DBLE(J)/DBLE(K*L))
  543 CONTINUE
      DO 544 J=1,4
      G(I+J)=G(I+J)+(DBLE(J)/DBLE(K*L))*A/X(I+J)*FA
  544 CONTINUE
  545 CONTINUE
  546 CONTINUE
      F=0.5D 0*F
      RETURN
  550 DO 556 KA=1,NA
      I=2*((KA+3)/4)-2
      L=MOD((KA-1),4)+1
      FA=-Y(L)
      DO 552 K=1,3
      A=0.0D 0
      DO 551 J=1,4
      A=A+X(I+J)*(DBLE(J)/DBLE(K*L))
  551 CONTINUE
      FA=FA+EXP(A)*DBLE(K*K)/DBLE(L)
  552 CONTINUE
      F=F+FA**2
      DO 555 K=1,3
      A=0.0D 0
      DO 553 J=1,4
      A=A+X(I+J)*(DBLE(J)/DBLE(K*L))
  553 CONTINUE
      A=EXP(A)*DBLE(K*K)/DBLE(L)
      DO 554 J=1,4
      G(I+J)=G(I+J)+A*(DBLE(J)/DBLE(K*L))*FA
  554 CONTINUE
  555 CONTINUE
  556 CONTINUE
      F=0.5D 0*F
      RETURN
  560 DO 563 KA=1,NA
      I=2*((KA+3)/4)-2
      L=MOD((KA-1),4)+1
      FA=-Y(L)
      DO 561 J=1,4
      FA=FA+DBLE((1-2*MOD(J,2))*L*J*J)*SIN(X(I+J))+
     & DBLE(L*L*J)*COS(X(I+J))
  561 CONTINUE
      F=F+FA**2
      DO 562 J=1,4
      G(I+J)=G(I+J)+(DBLE((1-2*MOD(J,2))*L*J*J)*COS(X(I+J))-
     & DBLE(L*L*J)*SIN(X(I+J)))*FA
  562 CONTINUE
  563 CONTINUE
      F=0.5D 0*F
      RETURN
  570 DO 571 KA=1,NA
      ALFA=0.5D 0
      IF (KA.EQ.1) THEN
      FA=ALFA-(1.0D 0-ALFA)*X(3)-X(1)*(1.0D 0+4.0D 0*X(2))
      G(1)=G(1)-(1.0D 0+4.0D 0*X(2))*FA
      G(2)=G(2)-4.0D 0*X(1)*FA
      G(3)=G(3)+(ALFA-1.0D 0)*FA
      ELSEIF(KA.EQ.2) THEN
      FA=-(2.0D 0-ALFA)*X(4)-X(2)*(1.0D 0+4.0D 0*X(1))
      G(1)=G(1)-4.0D 0*X(2)*FA
      G(2)=G(2)-(1.0D 0+4.0D 0*X(1))*FA
      G(4)=G(4)+(ALFA-2.0D 0)*FA
      ELSEIF(KA.EQ.N-1) THEN
      FA=ALFA*X(N-3)-X(N-1)*(1.0D 0+4.0D 0*X(N))
      G(N-3)=G(N-3)+ALFA*FA
      G(N-1)=G(N-1)-(1.0D 0+4.0D 0*X(N))*FA
      G(N)=G(N)-4.0D 0*X(N-1)*FA
      ELSEIF (KA.EQ.N) THEN
      FA=ALFA*X(N-2)-(2.0D 0-ALFA)-X(N)*(1.0D 0+4.0D 0*X(N-1))
      G(N-2)=G(N-2)+ALFA*FA
      G(N-1)=G(N-1)-4.0D 0*X(N)*FA
      G(N)=G(N)-(1.0D 0+4.0D 0*X(N-1))*FA
      ELSEIF (MOD(KA,2).EQ.1) THEN
      FA=ALFA*X(KA-2)-(1.0D 0-ALFA)*X(KA+2)-
     & X(KA)*(1.0D 0+4.0D 0*X(KA+1))
      G(KA-2)=G(KA-2)+ALFA*FA
      G(KA)=G(KA)-(1.0D 0+4.0D 0*X(KA+1))*FA
      G(KA+1)=G(KA+1)-4.0D 0*X(KA)*FA
      G(KA+2)=G(KA+2)+(ALFA-1.0D 0)*FA
      ELSE
      FA=ALFA*X(KA-2)-(2.0D 0-ALFA)*X(KA+2)-
     & X(KA)*(1.0D 0+4.0D 0*X(KA-1))
      G(KA-2)=G(KA-2)+ALFA*FA
      G(KA-1)=G(KA-1)-4.0D 0*X(KA)*FA
      G(KA)=G(KA)-(1.0D 0+4.0D 0*X(KA-1))*FA
      G(KA+2)=G(KA+2)+(ALFA-2.0D 0)*FA
      ENDIF
      F=F+FA**2
  571 CONTINUE
      F=0.5D 0*F
      RETURN
  580 DO 581 KA=1,NA
      IF (KA.LT.2) THEN
      FA=4.0D 0*(X(KA)-X(KA+1)**2)
      G(KA)=G(KA)+4.0D 0*FA
      G(KA+1)=G(KA+1)-8.0D 0*X(KA+1)*FA
      ELSEIF (KA.LT.N) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)
      G(KA-1)=G(KA-1)-8.0D 0*X(KA)*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+6.0D 0)*FA
      G(KA+1)=G(KA+1)-8.0D 0*X(KA+1)*FA
      ELSE
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))
      G(KA-1)=G(KA-1)-8.0D 0*X(KA)*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+2.0D 0)*FA
      ENDIF
      F=F+FA**2
  581 CONTINUE
      F=0.5D 0*F
      RETURN
  590 DO 591 KA=1,NA
      IF (KA.EQ.1) THEN
      FA=-2.0D 0*X(KA)**2+3.0D 0*X(KA)-2.0D 0*X(KA+1)+
     & 3.0D 0*X(N-4)-X(N-3)-X(N-2)+0.5D 0*X(N-1)-X(N)+1.0D 0
      G(N-4)=G(N-4)+3.0D 0*FA
      G(N-3)=G(N-3)-FA
      G(N-2)=G(N-2)-FA
      G(N-1)=G(N-1)+0.50D 0*FA
      G(N)=G(N)-FA
      G(KA)=G(KA)-(4.0D 0*X(KA)-3.0D 0)*FA
      G(KA+1)=G(KA+1)-2.0D 0*FA
      ELSEIF (KA.LE.N-1) THEN
      FA=-2.0D 0*X(KA)**2+3.0D 0*X(KA)-X(KA-1)-2.0D 0*X(KA+1)+
     & 3.0D 0*X(N-4)-X(N-3)-X(N-2)+0.5D 0*X(N-1)-X(N)+1.0D 0
      G(N-4)=G(N-4)+3.0D 0*FA
      G(N-3)=G(N-3)-FA
      G(N-2)=G(N-2)-FA
      G(N-1)=G(N-1)+0.50D 0*FA
      G(N)=G(N)-FA
      G(KA-1)=G(KA-1)-FA
      G(KA)=G(KA)-(4.0D 0*X(KA)-3.0D 0)*FA
      G(KA+1)=G(KA+1)-2.0D 0*FA
      ELSE
      FA=-2.0D 0*X(N)**2+3.0D 0*X(N)-X(N-1)+
     & 3.0D 0*X(N-4)-X(N-3)-X(N-2)+0.5D 0*X(N-1)-X(N)+1.0D 0
      G(N-4)=G(N-4)+3.0D 0*FA
      G(N-3)=G(N-3)-FA
      G(N-2)=G(N-2)-FA
      G(N-1)=G(N-1)-0.50D 0*FA
      G(N)=G(N)-(4.0D 0*X(N)-2.0D 0)*FA
      ENDIF
      F=F+FA**2
  591 CONTINUE
      F=0.5D 0*F
      RETURN
  600 DO 601 KA=1,NA
      U=1.0D 0/DBLE(N+1)
      V=DBLE(KA)*U
      FA=2.0D 0*X(KA)+0.5D 0*U*U*(X(KA)+V+1.0D 0)**3+1.0D 0
      IF(KA.GT.1) FA=FA-X(KA-1)
      IF(KA.LT.N) FA=FA-X(KA+1)
      F=F+FA**2
      G(KA)=G(KA)+(2.0D 0+1.5D 0*U**2*(X(KA)+V+1.0D 0)**2)*FA
      IF(KA.GT.1) G(KA-1)=G(KA-1)-FA
      IF(KA.LT.N) G(KA+1)=G(KA+1)-FA
  601 CONTINUE
      F=0.5D 0*F
      RETURN
  610 DO 611 KA=1,NA
      I=3*((KA+6)/7)-2
      IF (MOD(KA,7).EQ.1) THEN
      FA=1.0D 1*(X(I)**2-X(I+1))
      G(I)=G(I)+2.0D 1*X(I)*FA
      G(I+1)=G(I+1)-1.0D 1*FA
      ELSEIF (MOD(KA,7).EQ.2) THEN
      FA=X(I+1)+X(I+2)-2.0D 0
      G(I+1)=G(I+1)+FA
      G(I+2)=G(I+2)+FA
      ELSEIF (MOD(KA,7).EQ.3) THEN
      FA=X(I+3)-1.0D 0
      G(I+3)=G(I+3)+FA
      ELSEIF (MOD(KA,7).EQ.4) THEN
      FA=X(I+4)-1.0D 0
      G(I+4)=G(I+4)+FA
      ELSEIF (MOD(KA,7).EQ.5) THEN
      FA=X(I)+3.0D 0*X(I+1)
      G(I)=G(I)+FA
      G(I+1)=G(I+1)+3.0D 0*FA
      ELSEIF (MOD(KA,7).EQ.6) THEN
      FA=X(I+2)+X(I+3)-2.0D 0*X(I+4)
      G(I+2)=G(I+2)+FA
      G(I+3)=G(I+3)+FA
      G(I+4)=G(I+4)-2.0D 0*FA
      ELSE
      FA=1.0D 1*(X(I+1)**2-X(I+4))
      G(I+1)=G(I+1)+2.0D 1*X(I+1)*FA
      G(I+4)=G(I+4)-1.0D 1*FA
      ENDIF
      F=F+FA**2
  611 CONTINUE
      F=0.5D 0*F
      RETURN
  620 DO 621 KA=1,NA
      I=KA/2
      IF (KA.EQ.1) THEN
      FA=X(KA)-1.0D 0
      G(KA)=G(KA)+FA
      ELSE IF (MOD(KA,2).EQ.0) THEN
      FA=1.0D 1*(X(I)**2-X(I+1))
      G(I)=G(I)+2.0D 1*X(I)*FA
      G(I+1)=G(I+1)-1.0D 1*FA
      ELSE
      A=2.0D 0*EXP(-(X(I)-X(I+1))**2)
      B=EXP(-2.0D 0*(X(I+1)-X(I+2))**2)
      FA=A+B
      G(I)=G(I)-2.0D 0*(X(I)-X(I+1))*A*FA
      G(I+1)=G(I+1)+(2.0D 0*(X(I)-X(I+1))*A-4.0D 0*(X(I+1)-X(I+2))*B)*FA
      G(I+2)=G(I+2)+4.0D 0*(X(I+1)-X(I+2))*B*FA
      ENDIF
      F=F+FA**2
  621 CONTINUE
      F=0.5D 0*F
      RETURN
  630 DO 633 KA=1,NA
      IA=MIN(MAX(MOD(KA,13)-2,1),7)
      IB=(KA+12)/13
      I=IA+IB-1
      IF (IA.EQ.7) THEN
      J=IB
      ELSE
      J=IA+IB
      ENDIF
      C=3.0D 0*DBLE(IA)/1.0D 1
      A=0.0D 0
      B=EXP(SIN(C)*X(J))
      D=X(J)-SIN(X(I))-1.0D 0+Y(1)
      E=1.0D 0+COS(C)
      DO 631 L=0,6
      IF (IB+L.NE.I.AND.IB+L.NE.J) A=A+SIN(X(IB+L))-Y(1)
  631 CONTINUE
      FA=E*D**2+5.0D 0*(X(I)-1.0D 0)*B+0.5D 0*A
      F=F+FA**2
      G(I)=G(I)-(2.0D 0*D*E*COS(X(I))-5.0D 0*B)*FA
      G(J)=G(J)+(2.0D 0*D*E+5.0D 0*(X(I)-1.0D 0)*B*SIN(C))*FA
      DO 632 L=0,6
      IF (IB+L.NE.I.AND.IB+L.NE.J)
     & G(IB+L)=G(IB+L)+0.5D 0*COS(X(IB+L))*FA
  632 CONTINUE
  633 CONTINUE
      F=0.5D 0*F
      RETURN
  720 DO 721 KA=1,NA
      A1=0.414214D 0
      IF (KA.EQ.1) THEN
      FA=X(1)-(1.0D 0-X(1))*X(3)-A1*(1.0D 0+4.0D 0*X(2))
      G(1)=G(1)+(1.0D 0+X(3))*FA
      G(2)=G(2)-4.0D 0*A1*FA
      G(3)=G(3)-(1.0D 0-X(1))*FA
      ELSEIF (KA.EQ.2) THEN
      FA=-(1.0D 0-X(1))*X(4)-A1*(1.0D 0+4.0D 0*X(2))
      G(1)=G(1)+X(4)*FA
      G(2)=G(2)-4.0D 0*A1*FA
      G(4)=G(4)-(1.0D 0-X(1))*FA
      ELSEIF (KA.EQ.3) THEN
      FA=A1*X(1)-(1.0D 0-X(1))*X(5)-X(3)*(1.0D 0+4.0D 0*X(2))
      G(1)=G(1)+(A1+X(5))*FA
      G(2)=G(2)-4.0D 0*X(3)*FA
      G(3)=G(3)-(1.0D 0+4.0D 0*X(2))*FA
      G(5)=G(5)-(1.0D 0-X(1))*FA
      ELSEIF (KA.LE.N-2) THEN
      FA=X(1)*X(KA-2)-(1.0D 0-X(1))*X(KA+2)-
     & X(KA)*(1.0D 0+4.0D 0*X(KA-1))
      G(1)=G(1)+(X(KA-2)+X(KA+2))*FA
      G(KA-2)=G(KA-2)+X(1)*FA
      G(KA-1)=G(KA-1)-4.0D 0*X(KA)*FA
      G(KA)=G(KA)-(1.0D 0+4.0D 0*X(KA-1))*FA
      G(KA+2)=G(KA+2)-(1.0D 0-X(1))*FA
      ELSEIF (KA.EQ.N-1) THEN
      FA=X(1)*X(N-3)-X(N-1)*(1.0D 0+4.0D 0*X(N-2))
      G(1)=G(1)+X(N-3)*FA
      G(N-3)=G(N-3)+X(1)*FA
      G(N-2)=G(N-2)-4.0D 0*X(N-1)*FA
      G(N-1)=G(N-1)-(1.0D 0+4.0D 0*X(N-2))*FA
      ELSE
      FA=X(1)*X(N-2)-(1.0D 0-X(1))-X(N)*(1.0D 0+4.0D 0*X(N-1))
      G(1)=G(1)+(X(N-2)+1.0D 0)*FA
      G(N-2)=G(N-2)+X(1)*FA
      G(N-1)=G(N-1)-4.0D 0*X(N)*FA
      G(N)=G(N)-(1.0D 0+4.0D 0*X(N-1))*FA
      ENDIF
      F=F+FA**2
  721 CONTINUE
      F=0.5D 0*F
      RETURN
  740 DO 741 KA=1,NA
      IF (KA.LT.2) THEN
      FA=3.0D 0*X(KA)**3+2.0D 0*X(KA+1)-5.0D 0+
     & SIN(X(KA)-X(KA+1))*SIN(X(KA)+X(KA+1))
      D1S=COS(X(KA)-X(KA+1))*SIN(X(KA)+X(KA+1))
      D2S=SIN(X(KA)-X(KA+1))*COS(X(KA)+X(KA+1))
      G(KA)=G(KA)+(9.0D 0*X(KA)**2+D1S+D2S)*FA
      G(KA+1)=G(KA+1)+(2.0D 0-D1S+D2S)*FA
      ELSEIF (KA.LT.N) THEN
      FA=3.0D 0*X(KA)**3+2.0D 0*X(KA+1)-5.0D 0+
     & SIN(X(KA)-X(KA+1))*SIN(X(KA)+X(KA+1))+4.0D 0*X(KA)-
     & X(KA-1)*EXP(X(KA-1)-X(KA))-3.0D 0
      D1S=COS(X(KA)-X(KA+1))*SIN(X(KA)+X(KA+1))
      D2S=SIN(X(KA)-X(KA+1))*COS(X(KA)+X(KA+1))
      EX=EXP(X(KA-1)-X(KA))
      G(KA-1)=G(KA-1)-(EX+X(KA-1)*EX)*FA
      G(KA)=G(KA)+(9.0D 0*X(KA)**2+D1S+D2S+4.0D 0+X(KA-1)*EX)*FA
      G(KA+1)=G(KA+1)+(2.0D 0-D1S+D2S)*FA
      ELSE
      FA=4.0D 0*X(KA)-X(KA-1)*EXP(X(KA-1)-X(KA))-3.0D 0
      EX=EXP(X(KA-1)-X(KA))
      G(KA-1)=G(KA-1)-(EX+X(KA-1)*EX)*FA
      G(KA)=G(KA)+(4.0D 0+X(KA-1)*EX)*FA
      ENDIF
      F=F+FA**2
  741 CONTINUE
      F=0.5D 0*F
      RETURN
  750 DO 751 KA=1,NA
      IF (MOD(KA,2).EQ.1) THEN
      FA=0.0D 0
      IF (KA.NE.1) FA=FA-6.0D 0*(X(KA-2)-X(KA))**3+1.0D 1-
     & 4.0D 0*X(KA-1)-2.0D 0*SIN(X(KA-2)-X(KA-1)-X(KA))*
     & SIN(X(KA-2)+X(KA-1)-X(KA))
      IF (KA.NE.N) FA=FA+3.0D 0*(X(KA)-X(KA+2))**3-5.0D 0+
     & 2.0D 0*X(KA+1)+SIN(X(KA)-X(KA+1)-X(KA+2))*
     & SIN(X(KA)+X(KA+1)-X(KA+2))
      IF (KA.NE.1) THEN
      D1S=COS(X(KA-2)-X(KA-1)-X(KA))*SIN(X(KA-2)+X(KA-1)-X(KA))
      D2S=SIN(X(KA-2)-X(KA-1)-X(KA))*COS(X(KA-2)+X(KA-1)-X(KA))
      G(KA-2)=G(KA-2)-(18.0D 0*(X(KA-2)-X(KA))**2+2.0D 0*(D1S+D2S))*FA
      G(KA-1)=G(KA-1)-(4.0D 0-2.0D 0*(D1S-D2S))*FA
      G(KA)=G(KA)+(18.0D 0*(X(KA-2)-X(KA))**2+2.0D 0*(D1S+D2S))*FA
      ENDIF
      IF (KA.NE.N) THEN
      D1S=COS(X(KA)-X(KA+1)-X(KA+2))*SIN(X(KA)+X(KA+1)-X(KA+2))
      D2S=SIN(X(KA)-X(KA+1)-X(KA+2))*COS(X(KA)+X(KA+1)-X(KA+2))
      G(KA)=G(KA)+(9.0D 0*(X(KA)-X(KA+2))**2+D1S+D2S)*FA
      G(KA+1)=G(KA+1)+(2.0D 0-D1S+D2S)*FA
      G(KA+2)=G(KA+2)-(9.0D 0*(X(KA)-X(KA+2))**2+D1S+D2S)*FA
      ENDIF
      ELSE
      EX=EXP(X(KA-1)-X(KA)-X(KA+1))
      FA=4.0D 0*X(KA)-(X(KA-1)-X(KA+1))*EX-3.0D 0
      W=X(KA-1)-X(KA+1)
      G(KA-1)=G(KA-1)-(EX+W*EX)*FA
      G(KA)=G(KA)+(4.0D 0+W*EX)*FA
      G(KA+1)=G(KA+1)+(EX+W*EX)*FA
      ENDIF
      F=F+FA**2
  751 CONTINUE
      F=0.5D 0*F
      RETURN
  760 DO 761 KA=1,NA
      H=2.0D 0
      IF (KA.EQ.1) THEN
      FA=((3.0D 0-H*X(1))*X(1)-2.0D 0*X(2)+1.0D 0)**2
      G(1)=G(1)+2.0D 0*((3.0D 0-H*X(1))*X(1)-2.0D 0*X(2)+1.0D 0)*
     & (3.0D 0-2.0D 0*H*X(1))*FA
      G(2)=G(2)-4.0D 0*((3.0D 0-H*X(1))*X(1)-2.0D 0*X(2)+1.0D 0)*FA
      ELSEIF (KA.LE.N-1) THEN
      FA=((3.0D 0-H*X(KA))*X(KA)-X(KA-1)-2.0D 0*X(KA+1)+1.0D 0)**2
      G(KA-1)=G(KA-1)-2.0D 0*
     & ((3.0D 0-H*X(KA))*X(KA)-X(KA-1)-2.0D 0*X(KA+1)+1.0D 0)*FA
      G(KA)=G(KA)+2.0D 0*
     & ((3.0D 0-H*X(KA))*X(KA)-X(KA-1)-2.0D 0*X(KA+1)+1.0D 0)*
     & (3.0D 0-2.0D 0*H*X(KA))*FA
      G(KA+1)=G(KA+1)-4.0D 0*
     & ((3.0D 0-H*X(KA))*X(KA)-X(KA-1)-2.0D 0*X(KA+1)+1.0D 0)*FA
      ELSE
      FA=((3.0D 0-H*X(N))*X(N)-X(N-1)+1.0D 0)**2
      G(N-1)=G(N-1)-2.0D 0*((3.0D 0-H*X(N))*X(N)-X(N-1)+1.0D 0)*FA
      G(N)=G(N)+2.0D 0*((3.0D 0-H*X(N))*X(N)-X(N-1)+1.0D 0)*
     & (3.0D 0-2.0D 0*H*X(N))*FA
      ENDIF
      F=F+FA**2
  761 CONTINUE
      F=0.5D 0*F
      RETURN
  780 DO 781 KA=1,NA
      IF (KA.LT.2) THEN
      FA=4.0D 0*(X(KA)-X(KA+1)**2)+X(KA+1)-X(KA+2)**2
      G(KA)=G(KA)+4.0D 0*FA
      G(KA+1)=G(KA+1)-(8.0D 0*X(KA+1)-1.0D 0)*FA
      G(KA+2)=G(KA+2)-2.0D 0*X(KA+2)*FA
      ELSEIF (KA.LT.3) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA+1)-X(KA+2)**2
      G(KA-1)=G(KA-1)-8.0D 0*X(KA)*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+6.0D 0)*FA
      G(KA+1)=G(KA+1)-(8.0D 0*X(KA+1)-1.0D 0)*FA
      G(KA+2)=G(KA+2)-2.0D 0*X(KA+2)*FA
      ELSEIF (KA.LT.N-1) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2-X(KA-2)+X(KA+1)-
     & X(KA+2)**2
      G(KA-2)=G(KA-2)-FA
      G(KA-1)=G(KA-1)-(8.0D 0*X(KA)-2.0D 0*X(KA-1))*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+6.0D 0)*FA
      G(KA+1)=G(KA+1)-(8.0D 0*X(KA+1)-1.0D 0)*FA
      G(KA+2)=G(KA+2)-2.0D 0*X(KA+2)*FA
      ELSEIF (KA.LT.N) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2-X(KA-2)
      G(KA-2)=G(KA-2)-FA
      G(KA-1)=G(KA-1)-(8.0D 0*X(KA)-2.0D 0*X(KA-1))*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+6.0D 0)*FA
      G(KA+1)=G(KA+1)-8.0D 0*X(KA+1)*FA
      ELSE
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))
     & +X(KA-1)**2-X(KA-2)
      G(KA-2)=G(KA-2)-FA
      G(KA-1)=G(KA-1)-(8.0D 0*X(KA)-2.0D 0*X(KA-1))*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+2.0D 0)*FA
      ENDIF
      F=F+FA**2
  781 CONTINUE
      F=0.5D 0*F
      RETURN
  790 DO 791 KA=1,NA
      IF (KA.LT.2) THEN
      FA=4.0D 0*(X(KA)-X(KA+1)**2)+X(KA+1)-X(KA+2)**2+
     & X(KA+2)-X(KA+3)**2
      G(KA)=G(KA)+4.0D 0*FA
      G(KA+1)=G(KA+1)-(8.0D 0*X(KA+1)-1.0D 0)*FA
      G(KA+2)=G(KA+2)-(2.0D 0*X(KA+2)-1.0D 0)*FA
      G(KA+3)=G(KA+3)-2.0D 0*X(KA+3)*FA
      ELSEIF (KA.LT.3) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2+X(KA+1)-X(KA+2)**2+
     & X(KA+2)-X(KA+3)**2
      G(KA-1)=G(KA-1)-(8.0D 0*X(KA)-2.0D 0*X(KA-1))*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+6.0D 0)*FA
      G(KA+1)=G(KA+1)-(8.0D 0*X(KA+1)-1.0D 0)*FA
      G(KA+2)=G(KA+2)-(2.0D 0*X(KA+2)-1.0D 0)*FA
      G(KA+3)=G(KA+3)-2.0D 0*X(KA+3)*FA
      ELSEIF (KA.LT.4) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2-X(KA-2)+
     & X(KA+1)-X(KA+2)**2+X(KA-2)**2+X(KA+2)-X(KA+3)**2
      G(KA-2)=G(KA-2)+(2.0D 0*X(KA-2)-1.0D 0)*FA
      G(KA-1)=G(KA-1)-(8.0D 0*X(KA)-2.0D 0*X(KA-1))*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+6.0D 0)*FA
      G(KA+1)=G(KA+1)-(8.0D 0*X(KA+1)-1.0D 0)*FA
      G(KA+2)=G(KA+2)-(2.0D 0*X(KA+2)-1.0D 0)*FA
      G(KA+3)=G(KA+3)-2.0D 0*X(KA+3)*FA
      ELSEIF (KA.LT.N-2) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2-X(KA-2)+
     & X(KA+1)-X(KA+2)**2+X(KA-2)**2-X(KA-3)+X(KA+2)-X(KA+3)**2
      G(KA-3)=G(KA-3)-FA
      G(KA-2)=G(KA-2)+(2.0D 0*X(KA-2)-1.0D 0)*FA
      G(KA-1)=G(KA-1)-(8.0D 0*X(KA)-2.0D 0*X(KA-1))*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+6.0D 0)*FA
      G(KA+1)=G(KA+1)-(8.0D 0*X(KA+1)-1.0D 0)*FA
      G(KA+2)=G(KA+2)-(2.0D 0*X(KA+2)-1.0D 0)*FA
      G(KA+3)=G(KA+3)-2.0D 0*X(KA+3)*FA
      ELSEIF (KA.LT.N-1) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2-X(KA-2)+
     & X(KA+1)-X(KA+2)**2+X(KA-2)**2-X(KA-3)+X(KA+2)
      G(KA-3)=G(KA-3)-FA
      G(KA-2)=G(KA-2)+(2.0D 0*X(KA-2)-1.0D 0)*FA
      G(KA-1)=G(KA-1)-(8.0D 0*X(KA)-2.0D 0*X(KA-1))*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+6.0D 0)*FA
      G(KA+1)=G(KA+1)-(8.0D 0*X(KA+1)-1.0D 0)*FA
      G(KA+2)=G(KA+2)-(2.0D 0*X(KA+2)-1.0D 0)*FA
      ELSEIF (KA.LT.N) THEN
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))+
     & 4.0D 0*(X(KA)-X(KA+1)**2)+X(KA-1)**2-X(KA-2)+
     & X(KA+1)+X(KA-2)**2-X(KA-3)
      G(KA-3)=G(KA-3)-FA
      G(KA-2)=G(KA-2)+(2.0D 0*X(KA-2)-1.0D 0)*FA
      G(KA-1)=G(KA-1)-(8.0D 0*X(KA)-2.0D 0*X(KA-1))*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+6.0D 0)*FA
      G(KA+1)=G(KA+1)-(8.0D 0*X(KA+1)-1.0D 0)*FA
      ELSE
      FA=8.0D 0*X(KA)*(X(KA)**2-X(KA-1))-2.0D 0*(1.0D 0-X(KA))
     & +X(KA-1)**2-X(KA-2)+X(KA-2)**2-X(KA-3)
      G(KA-3)=G(KA-3)-FA
      G(KA-2)=G(KA-2)+(2.0D 0*X(KA-2)-1.0D 0)*FA
      G(KA-1)=G(KA-1)-(8.0D 0*X(KA)-2.0D 0*X(KA-1))*FA
      G(KA)=G(KA)+(24.0D 0*X(KA)**2-8.0D 0*X(KA-1)+2.0D 0)*FA
      ENDIF
      F=F+FA**2
  791 CONTINUE
      F=0.5D 0*F
      RETURN
  810 DO 811 KA=1,NA
      IF(MOD(KA,2).EQ.1) THEN
      FA=X(KA)+((5.0D 0-X(KA+1))*X(KA+1)-2.0D 0)*X(KA+1)-1.3D 1
      G(KA)=G(KA)+FA
      G(KA+1)=G(KA+1)+(10.0D 0*X(KA+1)-3.0D 0*X(KA+1)**2-2.0D 0)*FA
      ELSE
      FA=X(KA-1)+((X(KA)+1.0D 0)*X(KA)-1.4D 1)*X(KA)-2.9D 1
      G(KA-1)=G(KA-1)+FA
      G(KA)=G(KA)+(3.0D 0*X(KA)**2+2.0D 0*X(KA)-1.4D 1)*FA
      ENDIF
      F=F+FA**2
  811 CONTINUE
      F=0.5D 0*F
      RETURN
  830 DO 831 KA=1,NA
      IF(MOD(KA,4).EQ.1) THEN
      A=EXP(X(KA))-X(KA+1)
      FA=A**2
      G(KA)=G(KA)+2.0D 0*A*EXP(X(KA))*FA
      G(KA+1)=G(KA+1)-2.0D 0*A*FA
      ELSEIF (MOD(KA,4).EQ.2) THEN
      FA=1.0D 1*(X(KA)-X(KA+1))**3
      A=3.0D 1*(X(KA)-X(KA+1))**2*FA
      G(KA)=G(KA)+A
      G(KA+1)=G(KA+1)-A
      ELSEIF (MOD(KA,4).EQ.3) THEN
      A=X(KA)-X(KA+1)
      FA=(SIN(A)/COS(A))**2
      B=2.0D 0*SIN(A)/(COS(A))**3*FA
      G(KA)=G(KA)+B
      G(KA+1)=G(KA+1)-B
      ELSE
      FA=X(KA)-1.0D 0
      G(KA)=G(KA)+FA
      ENDIF
      F=F+FA**2
  831 CONTINUE
      F=0.5D 0*F
      RETURN
  840 DO 841 KA=1,NA
      IF(KA.LT.2) THEN
      FA=X(KA)*(0.5D 0*X(KA)-3.0D 0)-1.0D 0+2.0D 0*X(KA+1)
      G(KA)=G(KA)+(X(KA)-3.0D 0)*FA
      G(KA+1)=G(KA+1)+2.0D 0*FA
      ELSEIF (KA.LT.N) THEN
      FA=X(KA-1)+X(KA)*(0.5D 0*X(KA)-3.0D 0)-1.0D 0+2.0D 0*X(KA+1)
      G(KA-1)=G(KA-1)+FA
      G(KA)=G(KA)+(X(KA)-3.0D 0)*FA
      G(KA+1)=G(KA+1)+2.0D 0*FA
      ELSE
      FA=X(KA-1)+X(KA)*(0.5D 0*X(KA)-3.0D 0)-1.0D 0
      G(KA-1)=G(KA-1)+FA
      G(KA)=G(KA)+(X(KA)-3.0D 0)*FA
      ENDIF
      F=F+FA**2
  841 CONTINUE
      F=0.5D 0*F
      RETURN
  860 DO 861 KA=1,NA
      IF(MOD(KA,2).EQ.1) THEN
      FA=1.0D 4*X(KA)*X(KA+1)-1.0D 0
      G(KA)=G(KA)+1.0D 4*X(KA+1)*FA
      G(KA+1)=G(KA+1)+1.0D 4*X(KA)*FA
      ELSE
      FA=EXP(-X(KA-1))+EXP(-X(KA))-1.0001D 0
      G(KA-1)=G(KA-1)-EXP(-X(KA-1))*FA
      G(KA)=G(KA)-EXP(-X(KA))*FA
      ENDIF
      F=F+FA**2
  861 CONTINUE
      F=0.5D 0*F
      RETURN
  870 DO 871 KA=1,NA
      IF(MOD(KA,4).EQ.1) THEN
      FA=-2.0D 2*X(KA)*(X(KA+1)-X(KA)**2)-(1.0D 0-X(KA))
      G(KA)=G(KA)-(2.0D 2*(X(KA+1)-3.0D 0*X(KA)**2)-1.0D 0)*FA
      G(KA+1)=G(KA+1)-2.0D 2*X(KA)*FA
      ELSEIF(MOD(KA,4).EQ.2) THEN
      FA=2.0D 2*(X(KA)-X(KA-1)**2)+2.02D 1*(X(KA)-1.0D 0)+
     &  1.98D 1*(X(KA+2)-1.0D 0)
      G(KA-1)=G(KA-1)-4.0D 2*X(KA-1)*FA
      G(KA)=G(KA)+2.202D 2*FA
      G(KA+2)=G(KA+2)+1.98D 1*FA
      ELSEIF(MOD(KA,4).EQ.3) THEN
      FA=-1.8D 2*X(KA)*(X(KA+1)-X(KA)**2)-(1.0D 0-X(KA))
      G(KA)=G(KA)-(1.8D 2*(X(KA+1)-3.0D 0*X(KA)**2)-1.0D 0)*FA
      G(KA+1)=G(KA+1)-1.8D 2*X(KA)*FA
      ELSE
      FA=1.8D 2*(X(KA)-X(KA-1)**2)+2.02D 1*(X(KA)-1.0D 0)+
     & 1.98D 1*(X(KA-2)-1.0D 0)
      G(KA-2)=G(KA-2)+1.98D 1*FA
      G(KA-1)=G(KA-1)-3.6D 2*X(KA-1)*FA
      G(KA)=G(KA)+2.002D 2*FA
      ENDIF
      F=F+FA**2
  871 CONTINUE
      F=0.5D 0*F
      RETURN
  880 DO 881 KA=1,NA
      IF (KA.LT.2) THEN
      A=EXP(COS(DBLE(KA)*(X(KA)+X(KA+1))))
      B=A*DBLE(KA)*SIN(DBLE(KA)*(X(KA)+X(KA+1)))
      FA=X(KA)-A
      G(KA+1)=G(KA+1)+B*FA
      G(KA)=G(KA)+(B+1.0D 0)*FA
      ELSEIF (KA.LT.N) THEN
      A=EXP(COS(DBLE(KA)*(X(KA-1)+X(KA)+X(KA+1))))
      B=A*SIN(DBLE(KA)*(X(KA-1)+X(KA)+X(KA+1)))*DBLE(KA)
      FA=X(KA)-A
      G(KA-1)=G(KA-1)+B*FA
      G(KA+1)=G(KA+1)+B*FA
      G(KA)=G(KA)+(B+1.0D 0)*FA
      ELSE
      A=EXP(COS(DBLE(KA)*(X(KA-1)+X(KA))))
      B=A*SIN(DBLE(KA)*(X(KA-1)+X(KA)))*DBLE(KA)
      FA=X(KA)-A
      G(KA-1)=G(KA-1)+B*FA
      G(KA)=G(KA)+(B+1.0D 0)*FA
      ENDIF
      F=F+FA**2
  881 CONTINUE
      F=0.5D 0*F
      RETURN
  900 DO 901 KA=1,NA
      IF(KA.EQ.1) THEN
      FA=3.0D 0*X(KA)*(X(KA+1)-2.0D 0*X(KA))+0.25D 0*X(KA+1)**2
      G(KA)=G(KA)+3.0D 0*(X(KA+1)-4.0D 0*X(KA))*FA
      G(KA+1)=G(KA+1)+(3.0D 0*X(KA)+0.5D 0*X(KA+1))*FA
      ELSEIF(KA.EQ.N) THEN
      FA=3.0D 0*X(KA)*(2.0D 1-2.0D 0*X(KA)+X(KA-1))+
     & 0.25D 0*(2.0D 1-X(KA-1))**2
      G(KA-1)=G(KA-1)+(3.0D 0*X(KA)-0.5D 0*(2.0D 1-X(KA-1)))*FA
      G(KA)=G(KA)+3.0D 0*(2.0D 1-4.0D 0*X(KA)+X(KA-1))*FA
      ELSE
      FA=3.0D 0*X(KA)*(X(KA+1)-2.0D 0*X(KA)+X(KA-1))+
     & 0.25D 0*(X(KA+1)-X(KA-1))**2
      G(KA-1)=G(KA-1)+(3.0D 0*X(KA)-0.5D 0*(X(KA+1)-X(KA-1)))*FA
      G(KA)=G(KA)+3.0D 0*(X(KA+1)-4.0D 0*X(KA)+X(KA-1))*FA
      G(KA+1)=G(KA+1)+(3.0D 0*X(KA)+0.5D 0*(X(KA+1)-X(KA-1)))*FA
      ENDIF
      F=F+FA**2
  901 CONTINUE
      F=0.5D 0*F
      RETURN
  910 DO 911 KA=1,NA
      H=1.0D 0/DBLE(N+1)
      IF (KA.LT.2) THEN
      FA=2.0D 0*X(KA)+PAR*H**2*SINH(PAR*X(KA))-X(KA+1)
      G(KA)=G(KA)+(2.0D 0+PAR**2*H**2*COSH(PAR*X(KA)))*FA
      G(KA+1)=G(KA+1)-FA
      ELSE IF (KA.LT.N) THEN
      FA=2.0D 0*X(KA)+PAR*H**2*SINH(PAR*X(KA))-X(KA-1)-X(KA+1)
      G(KA-1)=G(KA-1)-FA
      G(KA)=G(KA)+(2.0D 0+PAR**2*H**2*COSH(PAR*X(KA)))*FA
      G(KA+1)=G(KA+1)-FA
      ELSE
      FA=2.0D 0*X(KA)+PAR*H**2*SINH(PAR*X(KA))-X(KA-1)-1.0D 0
      G(KA)=G(KA)+(2.0D 0+PAR**2*H**2*COSH(PAR*X(KA)))*FA
      G(KA-1)=G(KA-1)-FA
      ENDIF
      F=F+FA**2
  911 CONTINUE
      F=0.5D 0*F
      RETURN
  920 DO 921 KA=1,NA
      FA=6.0D 0*X(KA)
      A1=0.0D 0
      A2=0.0D 0
      A3=0.0D 0
      IF (KA.GT.1) THEN
      FA=FA-4.0D 0*X(KA-1)
      A1=A1-X(KA-1)
      A2=A2+X(KA-1)
      A3=A3+2.0D 0*X(KA-1)
      ENDIF
      IF (KA.GT.2) THEN
      FA=FA+X(KA-2)
      A3=A3-X(KA-2)
      ENDIF
      IF (KA.LT.N-1) THEN
      FA=FA+X(KA+2)
      A3=A3+X(KA+2)
      ENDIF
      IF (KA.LT.N) THEN
      FA=FA-4.0D 0*X(KA+1)
      A1=A1+X(KA+1)
      A2=A2+X(KA+1)
      A3=A3-2.0D 0*X(KA+1)
      ENDIF
      IF (KA.GE.N-1) THEN
      FA=FA+1.0D 0
      A3=A3+1.0D 0
      ENDIF
      IF (KA.GE.N) THEN
      FA=FA-4.0D 0
      A1=A1+1.0D 0
      A2=A2+1.0D 0
      A3=A3-2.0D 0
      ENDIF
      FA=FA-0.5D 0*PAR*(A1*A2-X(KA)*A3)
      F=F+FA**2
      G(KA)=G(KA)+6.0D 0*FA
      GA1(1)=0.0D 0
      GA1(2)=0.0D 0
      GA2(1)=0.0D 0
      GA2(2)=0.0D 0
      IF (KA.GT.1) THEN
      G(KA-1)=G(KA-1)-(4.0D 0-PAR*X(KA))*FA
      GA1(1)=-1.0D 0
      GA2(1)= 1.0D 0
      ENDIF
      IF (KA.GT.2) THEN
      G(KA-2)=G(KA-2)+(1.0D 0-0.5D 0*PAR*X(KA))*FA
      ENDIF
      IF (KA.LT.N-1) THEN
      G(KA+2)=G(KA+2)+(1.0D 0+0.5D 0*PAR*X(KA))*FA
      ENDIF
      IF (KA.LT.N) THEN
      G(KA+1)=G(KA+1)-(4.0D 0+PAR*X(KA))*FA
      GA1(2)= 1.0D 0
      GA2(2)= 1.0D 0
      ENDIF
      G(KA)=G(KA)+0.5D 0*PAR*A3*FA
      IF (KA.GT.1)
     & G(KA-1)=G(KA-1)-0.5D 0*PAR*(GA1(1)*A2+A1*GA2(1))*FA
      IF (KA.LT.N)
     & G(KA+1)=G(KA+1)-0.5D 0*PAR*(GA1(2)*A2+A1*GA2(2))*FA
  921 CONTINUE
      F=0.5D 0*F
      RETURN
  930 DO 931 KA=1,NA
      H=1.0D 0/DBLE(M+1)
      IF(KA.LE.M) THEN
      J=KA+M
      FA=6.0D 0*X(KA)
      A1=0.0D 0
      A2=0.0D 0
      IF (KA.EQ.1) THEN
      A1=A1+1.0D 0
      ENDIF
      IF (KA.GT.1) THEN
      FA=FA-4.0D 0*X(KA-1)
      A1=A1-X(J-1)
      A2=A2+2.0D 0*X(KA-1)
      ENDIF
      IF (KA.GT.2) THEN
      FA=FA+X(KA-2)
      A2=A2-X(KA-2)
      ENDIF
      IF (KA.LT.M-1) THEN
      FA=FA+X(KA+2)
      A2=A2+X(KA+2)
      ENDIF
      IF (KA.LT.M) THEN
      FA=FA-4.0D 0*X(KA+1)
      A1=A1+X(J+1)
      A2=A2-2.0D 0*X(KA+1)
      ENDIF
      IF (KA.EQ.M) THEN
      A1=A1+1.0D 0
      ENDIF
      FA=FA+0.5D 0*PAR*H*(X(KA)*A2+X(J)*A1*H**2)
      ELSE
      J=KA-M
      FA=-2.0D 0*X(KA)
      A1=0.0D 0
      A2=0.0D 0
      IF (J.EQ.1) THEN
      A2=A2+1.0D 0
      ENDIF
      IF (J.GT.1) THEN
      FA=FA+X(KA-1)
      A1=A1-X(J-1)
      A2=A2-X(KA-1)
      ENDIF
      IF (J.LT.M) THEN
      FA=FA+X(KA+1)
      A1=A1+X(J+1)
      A2=A2+X(KA+1)
      ENDIF
      IF (J.EQ.M) THEN
      A2=A2+1.0D 0
      ENDIF
      FA=FA+0.5D 0*PAR*H*(X(KA)*A1+X(J)*A2)
      ENDIF
      F=F+FA**2
      IF(KA.LE.M) THEN
      G(KA)=G(KA)+6.0D 0*FA
      IF (KA.GT.1) THEN
      G(KA-1)=G(KA-1)-(4.0D 0-PAR*H*X(KA))*FA
      G(J-1)=G(J-1)-0.5D 0*PAR*H**3*X(J)*FA
      ENDIF
      IF (KA.GT.2) THEN
      G(KA-2)=G(KA-2)+(1.0D 0-0.5D 0*PAR*H*X(KA))*FA
      ENDIF
      IF (KA.LT.M-1) THEN
      G(KA+2)=G(KA+2)+(1.0D 0+0.5D 0*PAR*H*X(KA))*FA
      ENDIF
      IF (KA.LT.M) THEN
      G(KA+1)=G(KA+1)-(4.0D 0+PAR*H*X(KA))*FA
      G(J+1)=G(J+1)+0.5D 0*PAR*H**3*X(J)*FA
      ENDIF
      G(KA)=G(KA)+0.5D 0*PAR*H*A2*FA
      G(J)=G(J)+0.5D 0*PAR*H**3*A1*FA
      ELSE
      G(KA)=G(KA)-2.0D 0*FA
      IF (J.GT.1) THEN
      G(KA-1)=G(KA-1)+(1.0D 0-0.5D 0*PAR*H*X(J))*FA
      G(J-1)=G(J-1)-0.5D 0*PAR*H*X(KA)*FA
      ENDIF
      IF (J.LT.M) THEN
      G(KA+1)=G(KA+1)+(1.0D 0+0.5D 0*PAR*H*X(J))*FA
      G(J+1)=G(J+1)+0.5D 0*PAR*H*X(KA)*FA
      ENDIF
      G(KA)=G(KA)+0.5D 0*PAR*H*A1*FA
      G(J)=G(J)+0.5D 0*PAR*H*A2*FA
      ENDIF
  931 CONTINUE
      F=0.5D 0*F
      RETURN
  940 DO 941 KA=1,NA
      FA=4.0D 0*X(KA)-PAR*EXP(X(KA))
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      IF(I.GT.1) FA=FA-X(KA-1)
      IF(I.LT.M) FA=FA-X(KA+1)
      IF(J.GT.1) FA=FA-X(KA-M)
      IF(J.LT.M) FA=FA-X(KA+M)
      F=F+FA**2
      G(KA)=G(KA)+(4.0D 0-PAR*EXP(X(KA)))*FA
      IF(J.GT.1) G(KA-M)=G(KA-M)-FA
      IF(I.GT.1) G(KA-1)=G(KA-1)-FA
      IF(I.LT.M) G(KA+1)=G(KA+1)-FA
      IF(J.LT.M) G(KA+M)=G(KA+M)-FA
  941 CONTINUE
      F=0.5D 0*F
      RETURN
  950 DO 951 KA=1,NA
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      FA=4.0D 0*X(KA)+PAR*X(KA)**3/(1.0D 0+PAR*DBLE(I)**2+
     & PAR*DBLE(J)**2)
      IF(I.EQ.1) FA=FA-1.0D 0
      IF(I.GT.1) FA=FA-X(KA-1)
      IF(I.LT.M) FA=FA-X(KA+1)
      IF(I.EQ.M) FA=FA-2.0D 0+EXP(DBLE(J)/DBLE(M+1))
      IF(J.EQ.1) FA=FA-1.0D 0
      IF(J.GT.1) FA=FA-X(KA-M)
      IF(J.LT.M) FA=FA-X(KA+M)
      IF(J.EQ.M) FA=FA-2.0D 0+EXP(DBLE(I)/DBLE(M+1))
      F=F+FA**2
      G(KA)=G(KA)+(4.0D 0+3.0D 0*PAR*X(KA)**2/(1.0D 0+PAR*DBLE(I)**2+
     & PAR*DBLE(J)**2))*FA
      IF(J.GT.1) G(KA-M)=G(KA-M)-FA
      IF(I.GT.1) G(KA-1)=G(KA-1)-FA
      IF(I.LT.M) G(KA+1)=G(KA+1)-FA
      IF(J.LT.M) G(KA+M)=G(KA+M)-FA
  951 CONTINUE
      F=0.5D 0*F
      RETURN
  960 DO 961 KA=1,NA
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      A1=DBLE(I)/DBLE(M+1)
      A2=DBLE(J)/DBLE(M+1)
      FA=4.0D 0*X(KA)-PAR*SIN(2.0D 0*PI*X(KA))-
     & 1.0D 4*((A1-0.25D 0)**2+(A2-0.75D 0)**2)*PAR
      IF(I.EQ.1) FA=FA-X(KA+1)-PAR*SIN(PI*X(KA+1)*DBLE(M+1))
      IF(I.GT.1.AND.I.LT.M) FA=FA-X(KA+1)-X(KA-1)-
     & PAR*SIN(PI*(X(KA+1)-X(KA-1))*DBLE(M+1))
      IF(I.EQ.M) FA=FA-X(KA-1)+PAR*SIN(PI*X(KA-1)*DBLE(M+1))
      IF(J.EQ.1) FA=FA-X(KA+M)-PAR*SIN(PI*X(KA+M)*DBLE(M+1))
      IF(J.GT.1.AND.J.LT.M) FA=FA-X(KA+M)-X(KA-M)-
     & PAR*SIN(PI*(X(KA+M)-X(KA-M))*DBLE(M+1))
      IF(J.EQ.M) FA=FA-X(KA-M)+PAR*SIN(PI*X(KA-M)*DBLE(M+1))
      F=F+FA**2
      G(KA)=G(KA)+(4.0D 0-2.0D 0*PI*PAR*COS(2.0D 0*PI*X(KA)))*FA
      IF(I.EQ.1) G(KA+1)=G(KA+1)-
     & (1.0D 0+PI*DBLE(M+1)*PAR*COS(PI*X(KA+1)*DBLE(M+1)))*FA
      IF(I.GT.1.AND.I.LT.M) THEN
      G(KA-1)=G(KA-1)-
     & (1.0D 0-PI*DBLE(M+1)*PAR*COS(PI*(X(KA+1)-X(KA-1))*DBLE(M+1)))*FA
      G(KA+1)=G(KA+1)-
     & (1.0D 0+PI*DBLE(M+1)*PAR*COS(PI*(X(KA+1)-X(KA-1))*DBLE(M+1)))*FA
      ENDIF
      IF(I.EQ.M) G(KA-1)=G(KA-1)-
     & (1.0D 0-PI*DBLE(M+1)*PAR*COS(PI*X(KA-1)*DBLE(M+1)))*FA
      IF(J.EQ.1) G(KA+M)=G(KA+M)-
     & (1.0D 0+PI*DBLE(M+1)*PAR*COS(PI*X(KA+M)*DBLE(M+1)))*FA
      IF(J.GT.1.AND.J.LT.M) THEN
      G(KA-M)=G(KA-M)-
     & (1.0D 0-PI*DBLE(M+1)*PAR*COS(PI*(X(KA+M)-X(KA-M))*DBLE(M+1)))*FA
      G(KA+M)=G(KA+M)-
     & (1.0D 0+PI*DBLE(M+1)*PAR*COS(PI*(X(KA+M)-X(KA-M))*DBLE(M+1)))*FA
      ENDIF
      IF(J.EQ.M) G(KA-M)=G(KA-M)-
     & (1.0D 0-PI*DBLE(M+1)*PAR*COS(PI*X(KA-M)*DBLE(M+1)))*FA
  961 CONTINUE
      F=0.5D 0*F
      RETURN
  970 DO 971 KA=1,NA
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      FA=8.0D 0*X(KA)**2
      IF(I.EQ.1) FA=FA-2.0D 0*X(KA)*(X(KA+1)+1.0D 0)-
     & 0.5D 0*(X(KA+1)-1.0D 0)**2-
     & 1.5D 0*X(KA)**2*(X(KA+1)-1.0D 0)*PAR
      IF(I.GT.1.AND.I.LT.M) FA=FA-2.0D 0*X(KA)*(X(KA+1)+X(KA-1))-
     & 0.5D 0*(X(KA+1)-X(KA-1))**2-
     & 1.5D 0*X(KA)**2*(X(KA+1)-X(KA-1))*PAR
      IF(I.EQ.M) FA=FA-2.0D 0*X(KA)*X(KA-1)-
     & 0.5D 0*X(KA-1)**2+
     & 1.5D 0*X(KA)**2*X(KA-1)*PAR
      IF(J.EQ.1) FA=FA-2.0D 0*X(KA)*(X(KA+M)+1.0D 0)-
     & 0.5D 0*(X(KA+M)-1.0D 0)**2
      IF(J.GT.1.AND.J.LT.M) FA=FA-2.0D 0*X(KA)*(X(KA+M)+X(KA-M))-
     & 0.5D 0*(X(KA+M)-X(KA-M))**2
      IF(J.EQ.M) FA=FA-2.0D 0*X(KA)*X(KA-M)-
     & 0.5D 0*X(KA-M)**2
      IF (I.EQ.1.AND.J.EQ.1) FA=FA-PAR/DBLE(M+1)
      F=F+FA**2
      G(KA)=G(KA)+1.6D 1*X(KA)*FA
      IF(I.EQ.1) THEN
      G(KA)=G(KA)-(2.0D 0*(X(KA+1)+1.0D 0)+3.0D 0*X(KA)*
     & (X(KA+1)-1.0D 0)*PAR)*FA
      G(KA+1)=G(KA+1)-(2.0D 0*X(KA)+(X(KA+1)-1.0D 0)+
     & 1.5D 0*X(KA)**2*PAR)*FA
      ENDIF
      IF(I.GT.1.AND.I.LT.M) THEN
      G(KA)=G(KA)-(2.0D 0*(X(KA+1)+X(KA-1))+3.0D 0*X(KA)*
     & (X(KA+1)-X(KA-1))*PAR)*FA
      G(KA-1)=G(KA-1)-(2.0D 0*X(KA)-(X(KA+1)-X(KA-1))-
     & 1.5D 0*X(KA)**2*PAR)*FA
      G(KA+1)=G(KA+1)-(2.0D 0*X(KA)+(X(KA+1)-X(KA-1))+
     & 1.5D 0*X(KA)**2*PAR)*FA
      ENDIF
      IF(I.EQ.M) THEN
      G(KA)=G(KA)-(2.0D 0*X(KA-1)-3.0D 0*X(KA)*X(KA-1)*PAR)*FA
      G(KA-1)=G(KA-1)-(2.0D 0*X(KA)+X(KA-1)-1.5D 0*X(KA)**2*PAR)*FA
      ENDIF
      IF(J.EQ.1) THEN
      G(KA)=G(KA)-2.0D 0*(X(KA+M)+1.0D 0)*FA
      G(KA+M)=G(KA+M)-(2.0D 0*X(KA)+(X(KA+M)-1.0D 0))*FA
      ENDIF
      IF(J.GT.1.AND.J.LT.M) THEN
      G(KA)=G(KA)-2.0D 0*(X(KA+M)+X(KA-M))*FA
      G(KA-M)=G(KA-M)-(2.0D 0*X(KA)-(X(KA+M)-X(KA-M)))*FA
      G(KA+M)=G(KA+M)-(2.0D 0*X(KA)+(X(KA+M)-X(KA-M)))*FA
      ENDIF
      IF(J.EQ.M) THEN
      G(KA)=G(KA)-2.0D 0*X(KA-M)*FA
      G(KA-M)=G(KA-M)-(2.0D 0*X(KA)+X(KA-M))*FA
      ENDIF
  971 CONTINUE
      F=0.5D 0*F
      RETURN
  980 DO 981 KA=1,NA
      A3=0.0D 0
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      A1=PAR*DBLE(I)
      A2=PAR*DBLE(J)
      FA=4.0D 0*X(KA)-2.0D 3*A1*A2*(1.0D 0-A1)*(1.0D 0-A2)*PAR**2
      IF(I.GT.1) THEN
      FA=FA-X(KA-1)
      A3=A3-X(KA-1)
      ENDIF
      IF(I.LT.M) THEN
      FA=FA-X(KA+1)
      A3=A3+X(KA+1)
      ENDIF
      IF(J.GT.1) THEN
      FA=FA-X(KA-M)
      A3=A3-X(KA-M)
      ENDIF
      IF(J.LT.M) THEN
      FA=FA-X(KA+M)
      A3=A3+X(KA+M)
      ENDIF
      FA=FA+2.0D 1*PAR*A3*X(KA)
      F=F+FA**2
      G(KA)=G(KA)+4.0D 0*FA
      IF(I.GT.1) THEN
      G(KA-1)=G(KA-1)-(1.0D 0+2.0D 1*PAR*X(KA))*FA
      ENDIF
      IF(I.LT.M) THEN
      G(KA+1)=G(KA+1)-(1.0D 0-2.0D 1*PAR*X(KA))*FA
      ENDIF
      IF(J.GT.1) THEN
      G(KA-M)=G(KA-M)-(1.0D 0+2.0D 1*PAR*X(KA))*FA
      ENDIF
      IF(J.LT.M) THEN
      G(KA+M)=G(KA+M)-(1.0D 0-2.0D 1*PAR*X(KA))*FA
      ENDIF
      G(KA)=G(KA)+2.0D 1*PAR*A3*FA
  981 CONTINUE
      F=0.5D 0*F
      RETURN
  990 DO 991 KA=1,NA
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      FA=2.0D 1*X(KA)-PAR*MAX(0.0D 0,X(KA))-
     & SIGN(PAR,(DBLE(I)/DBLE(M+2)-0.5D 0))
      IF (J.GT.2) THEN
        FA=FA+X(KA-M-M)
      ENDIF
      IF (J.GT.1) THEN
        IF (I.GT.1) THEN
          FA=FA+2.0D 0*X(KA-M-1)
        ENDIF
        FA=FA-8.0D 0*X(KA-M)
        IF (I.LT.M) THEN
          FA=FA+2.0D 0*X(KA-M+1)
        ENDIF
      ENDIF
      IF (I.GT.1) THEN
        IF (I.GT.2) THEN
          FA=FA+X(KA-2)
        ENDIF
        FA=FA-8.0D 0*X(KA-1)
      ENDIF
      IF (I.LT.M) THEN
        FA=FA-8.0D 0*X(KA+1)
        IF (I.LT.M-1) THEN
          FA=FA+X(KA+2)
        ENDIF
      ENDIF
      IF (J.LT.M) THEN
        IF (I.GT.1) THEN
          FA=FA+2.0D 0*X(KA+M-1)
        ENDIF
        FA=FA-8.0D 0*X(KA+M)
        IF (I.LT.M) THEN
          FA=FA+2.0D 0*X(KA+M+1)
        ENDIF
      ENDIF
      IF (J.LT.M-1) THEN
        FA=FA+X(KA+M+M)
      ENDIF
      F=F+FA**2
      G(KA)=G(KA)+(2.0D 1-PAR)*FA
      IF (J.GT.2) THEN
        G(KA-M-M)=G(KA-M-M)+FA
      ENDIF
      IF (J.GT.1) THEN
        IF (I.GT.1) THEN
          G(KA-M-1)=G(KA-M-1)+2.0D 0*FA
        ENDIF
        G(KA-M)=G(KA-M)-8.0D 0*FA
        IF (I.LT.M) THEN
          G(KA-M+1)=G(KA-M+1)+2.0D 0*FA
        ENDIF
      ENDIF
      IF (I.GT.1) THEN
        IF (I.GT.2) THEN
          G(KA-2)=G(KA-2)+FA
        ENDIF
        G(KA-1)=G(KA-1)-8.0D 0*FA
      ENDIF
      IF (I.LT.M) THEN
        G(KA+1)=G(KA+1)-8.0D 0*FA
        IF (I.LT.M-1) THEN
          G(KA+2)=G(KA+2)+FA
        ENDIF
      ENDIF
      IF (J.LT.M) THEN
        IF (I.GT.1) THEN
          G(KA+M-1)=G(KA+M-1)+2.0D 0*FA
        ENDIF
        G(KA+M)=G(KA+M)-8.0D 0*FA
        IF (I.LT.M) THEN
          G(KA+M+1)=G(KA+M+1)+2.0D 0*FA
        ENDIF
      ENDIF
      IF (J.LT.M-1) THEN
        G(KA+M+M)=G(KA+M+M)+FA
      ENDIF
  991 CONTINUE
      F=0.5D 0*F
      RETURN
  800 DO 802 KA=1,NA
      H=0.5D 0/DBLE(M+2)
      J=(KA-1)/M+1
      I=KA-(J-1)*M
      FA=2.0D 1*X(KA)
      A1=0.0D 0
      A2=0.0D 0
      A3=0.0D 0
      A4=0.0D 0
      IF (J.GT.2) THEN
        FA=FA+X(KA-M-M)
        A4=A4+X(KA-M-M)
      ENDIF
      IF (J.GT.1) THEN
        IF (I.GT.1) THEN
          FA=FA+2.0D 0*X(KA-M-1)
          A3=A3+X(KA-M-1)
          A4=A4+X(KA-M-1)
        ENDIF
        FA=FA-8.0D 0*X(KA-M)
        A1=A1-X(KA-M)
        A4=A4-4.0D 0*X(KA-M)
        IF (I.LT.M) THEN
          FA=FA+2.0D 0*X(KA-M+1)
          A3=A3-X(KA-M+1)
          A4=A4+X(KA-M+1)
        ENDIF
      ENDIF
      IF (I.GT.1) THEN
        IF (I.GT.2) THEN
          FA=FA+X(KA-2)
          A3=A3+X(KA-2)
        ENDIF
        FA=FA-8.0D 0*X(KA-1)
        A2=A2-X(KA-1)
        A3=A3-4.0D 0*X(KA-1)
      ENDIF
      IF (I.LT.M) THEN
        FA=FA-8.0D 0*X(KA+1)
        A2=A2+X(KA+1)
        A3=A3+4.0D 0*X(KA+1)
        IF (I.LT.M-1) THEN
          FA=FA+X(KA+2)
          A3=A3-X(KA+2)
        ENDIF
      ENDIF
      IF (J.LT.M) THEN
        IF (I.GT.1) THEN
          FA=FA+2.0D 0*X(KA+M-1)
          A3=A3+X(KA+M-1)
          A4=A4-X(KA+M-1)
        ENDIF
        FA=FA-8.0D 0*X(KA+M)
        A1=A1+X(KA+M)
        A4=A4+4.0D 0*X(KA+M)
        IF (I.LT.M) THEN
          FA=FA+2.0D 0*X(KA+M+1)
          A3=A3-X(KA+M+1)
          A4=A4-X(KA+M+1)
        ENDIF
      ENDIF
      IF (J.LT.M-1) THEN
        FA=FA+X(KA+M+M)
        A4=A4-X(KA+M+M)
      ENDIF
      IF (J.EQ.M) THEN
        IF (I.GT.1) THEN
          FA=FA-H-H
          A3=A3-H
          A4=A4+H
        ENDIF
        FA=FA+8.0D 0*H
        A1=A1-H
        A4=A4-4.0D 0*H
        IF (I.LT.M) THEN
          FA=FA-2.0D 0*H
          A3=A3+H
          A4=A4+H
        ENDIF
        FA=FA+H
        A4=A4-H
      ENDIF
      IF (J.EQ.M-1) THEN
        FA=FA-H
        A4=A4+H
      ENDIF
      FA=FA+0.25D 0*PAR*(A1*A3-A2*A4)
      F=F+FA**2
      G(KA)=G(KA)+2.0D 1*FA
      A1=0.0D 0
      A2=0.0D 0
      A3=0.0D 0
      A4=0.0D 0
      GA1(1)=0.0D 0
      GA1(2)=0.0D 0
      GA2(1)=0.0D 0
      GA2(2)=0.0D 0
      DO 801 K=1,6
      GA3(K)=0.0D 0
      GA4(K)=0.0D 0
  801 CONTINUE
      IF (J.GT.2) THEN
        G(KA-M-M)=G(KA-M-M)+FA
        GA4(1)=GA4(1)+1.0D 0
        A4=A4+X(KA-M-M)
      ENDIF
      IF (J.GT.1) THEN
        IF (I.GT.1) THEN
          G(KA-M-1)=G(KA-M-1)+2.0D 0*FA
          GA3(1)=GA3(1)+1.0D 0
          GA4(2)=GA4(2)+1.0D 0
          A3=A3+X(KA-M-1)
          A4=A4+X(KA-M-1)
        ENDIF
        G(KA-M)=G(KA-M)-8.0D 0*FA
        GA1(1)=GA1(1)-1.0D 0
        A1=A1-X(KA-M)
        IF (I.LT.M) THEN
          G(KA-M+1)=G(KA-M+1)+2.0D 0*FA
          GA3(2)=GA3(2)-1.0D 0
          GA4(3)=GA4(3)+1.0D 0
          A3=A3-X(KA-M+1)
          A4=A4+X(KA-M+1)
        ENDIF
      ENDIF
      IF (I.GT.1) THEN
        IF (I.GT.2) THEN
          G(KA-2)=G(KA-2)+FA
          GA3(3)=GA3(3)+1.0D 0
          A3=A3+X(KA-2)
        ENDIF
        G(KA-1)=G(KA-1)-8.0D 0*FA
        GA2(1)=GA2(1)-1.0D 0
        A2=A2-X(KA-1)
      ENDIF
      IF (I.LT.M) THEN
        G(KA+1)=G(KA+1)-8.0D 0*FA
        GA2(2)=GA2(2)+1.0D 0
        A2=A2+X(KA+1)
        IF (I.LT.M-1) THEN
          G(KA+2)=G(KA+2)+FA
          GA3(4)=GA3(4)-1.0D 0
          A3=A3-X(KA+2)
        ENDIF
      ENDIF
      IF (J.LT.M) THEN
        IF (I.GT.1) THEN
          G(KA+M-1)=G(KA+M-1)+2.0D 0*FA
          GA3(5)=GA3(5)+1.0D 0
          GA4(4)=GA4(4)-1.0D 0
          A3=A3+X(KA+M-1)
          A4=A4-X(KA+M-1)
        ENDIF
        G(KA+M)=G(KA+M)-8.0D 0*FA
        GA1(2)=GA1(2)+1.0D 0
        A1=A1+X(KA+M)
        IF (I.LT.M) THEN
          G(KA+M+1)=G(KA+M+1)+2.0D 0*FA
          GA3(6)=GA3(6)-1.0D 0
          GA4(5)=GA4(5)-1.0D 0
          A3=A3-X(KA+M+1)
          A4=A4-X(KA+M+1)
        ENDIF
      ENDIF
      IF (J.LT.M-1) THEN
        G(KA+M+M)=G(KA+M+M)+FA
        GA4(6)=GA4(6)-1.0D 0
        A4=A4-X(KA+M+M)
      ENDIF
      IF (J.EQ.M) THEN
        IF (I.GT.1) THEN
          A3=A3-H
          A4=A4+H
        ENDIF
        A1=A1-H
        IF (I.LT.M) THEN
          A3=A3+H
          A4=A4+H
        ENDIF
        A4=A4-H
      ENDIF
      IF (J.EQ.M-1) THEN
        A4=A4+H
      ENDIF
      IF (KA.GT.M+M)
     & G(KA-M-M)=G(KA-M-M)+0.25D 0*PAR*(-A2*GA4(1))*FA
      IF (KA.GT.M+1)
     & G(KA-M-1)=G(KA-M-1)+0.25D 0*PAR*(+A1*GA3(1)-A2*GA4(2))*FA
      IF (KA.GT.M)
     & G(KA-M)=G(KA-M)+0.25D 0*PAR*(GA1(1)*A3)*FA
      IF (KA.GT.M-1)
     & G(KA-M+1)=G(KA-M+1)+0.25D 0*PAR*(+A1*GA3(2)-A2*GA4(3))*FA
      IF (KA.GT.2)
     & G(KA-2)=G(KA-2)+0.25D 0*PAR*(+A1*GA3(3))*FA
      IF (KA.GT.1)
     & G(KA-1)=G(KA-1)+0.25D 0*PAR*(-GA2(1)*A4)*FA
      IF (KA.LE.N-1)
     & G(KA+1)=G(KA+1)+0.25D 0*PAR*(-GA2(2)*A4)*FA
      IF (KA.LE.N-2)
     & G(KA+2)=G(KA+2)+0.25D 0*PAR*(+A1*GA3(4))*FA
      IF (KA.LE.N-M+1)
     & G(KA+M-1)=G(KA+M-1)+0.25D 0*PAR*(+A1*GA3(5)-A2*GA4(4))*FA
      IF (KA.LE.N-M)
     & G(KA+M)=G(KA+M)+0.25D 0*PAR*(GA1(2)*A3)*FA
      IF (KA.LE.N-M-1)
     & G(KA+M+1)=G(KA+M+1)+0.25D 0*PAR*(+A1*GA3(6)-A2*GA4(5))*FA
      IF (KA.LE.N-M-M)
     & G(KA+M+M)=G(KA+M+M)+0.25D 0*PAR*(-A2*GA4(6))*FA
  802 CONTINUE
      F=0.5D 0*F
      RETURN
  240 DO 243 KA=1,NA
      W=0.0D 0
      DO 241 I=1,N-1
      W=W+(DBLE(KA)/DBLE(KA+I))*X(I)
  241 CONTINUE
      FA=X(KA)-(1.0D 0+(0.4D 0/DBLE(N))*X(KA)*(0.5D 0+W+
     & 0.5D 0*(DBLE(KA)/DBLE(KA+N))*X(N)))
      F=F+FA**2
      W=W+0.5D 0+0.5D 0*DBLE(KA)/DBLE(KA+N)*X(N)
      DO 242 I=1,N-1
      G(I)=G(I)-0.4D 0/DBLE(N)*X(KA)*DBLE(KA)/DBLE(KA+I)*FA
  242 CONTINUE
      G(N)=G(N)-0.2D 0/DBLE(N)*X(KA)*DBLE(KA)/DBLE(KA+N)*FA
      G(KA)=G(KA)+(1.0D 0-0.4D 0*W/DBLE(N))*FA
  243 CONTINUE
      F=0.5D 0*F
      RETURN
  410 DO 411 KA=1,NA
      IF(KA.EQ.1) THEN
        FA=1.0D 0-X(1)
      G(1)=G(1)-FA
      ELSE
        FA=10.0D 0*DBLE(KA-1)*(X(KA)-X(KA-1))**2
        G(KA)=G(KA)+20.0D 0*DBLE(KA-1)*(X(KA)-X(KA-1))*FA
        G(KA-1)=G(KA-1)-20.0D 0*DBLE(KA-1)*(X(KA)-X(KA-1))*FA
      ENDIF
      F=F+FA**2
  411 CONTINUE
      F=0.5D 0*F
      RETURN
  420 DO 421 KA=1,NA
      IF(KA.EQ.N) THEN
        FA=X(KA)-0.1D 0*X(1)**2
        G(1)=G(1)-0.20D 0*X(1)*FA
        G(N)=G(N)+FA
      ELSE
        FA=X(KA)-0.1D 0*X(KA+1)**2
        G(KA)=G(KA)+FA
        G(KA+1)=G(KA+1)-0.2D 0*X(KA+1)*FA
      ENDIF
      F=F+FA**2
  421 CONTINUE
      F=0.5D 0*F
      RETURN
  650 DO 653 KA=1,NA
      S=0.0D 0
      DO 651 J=1,N
        S=S+X(J)**3
  651 CONTINUE
      FA=X(KA)-1.0D 0/DBLE(2*N)*(S+DBLE(KA))
      F=F+FA**2
      DO 652 J=1,N
        IF(J.EQ.KA) THEN
           G(J)=G(J)+(1.0D 0-3.0D 0*X(J)**2/(2.0D 0*DBLE(N)))*FA
        ELSE
           G(J)=G(J)-3.0D 0*X(J)**2/(2.0D 0*DBLE(N))*FA
        ENDIF
  652 CONTINUE
  653 CONTINUE
      F=0.5D 0*F
      RETURN
  660 DO 661 KA=1,NA
      S=(1.0D 0/DBLE(N+1))**2*EXP(X(KA))
      IF(N.EQ.1) THEN
        FA=-2.0D 0*X(KA)-S
        G(KA)=G(KA)-(2.0D 0+S)*FA
      ELSE IF(KA.EQ.1) THEN
        FA=-2.0D 0*X(KA)+X(KA+1)-S
        G(KA)=G(KA)-(2.0D 0+S)*FA
        G(KA+1)=G(KA+1)+FA
      ELSE IF(KA.EQ.N) THEN
        FA=X(KA-1)-2.0D 0*X(KA)-S
        G(KA)=G(KA)-(2.0D 0+S)*FA
        G(KA-1)=G(KA-1)+FA
      ELSE
        FA=X(KA-1)-2.0D 0*X(KA)+X(KA+1)-S
        G(KA)=G(KA)-(2.0D 0+S)*FA
        G(KA-1)=G(KA-1)+FA
        G(KA+1)=G(KA+1)+FA
      ENDIF
      F=F+FA**2
  661 CONTINUE
      F=0.5D 0*F
      RETURN
  670 DO 671 KA=1,NA
      S=0.1D 0
      IF(N.EQ.1) THEN
        FA=(3.0D 0-S*X(KA))*X(KA)+1.0D 0
        G(KA)=G(KA)+(3.0D 0-2.0D 0*S*X(KA))*FA
      ELSE IF(KA.EQ.1) THEN
        FA=(3.0D 0-S*X(KA))*X(KA)+1.0D 0-2.0D 0*X(KA+1)
        G(KA)=G(KA)+(3.0D 0-2.0D 0*S*X(KA))*FA
        G(KA+1)=G(KA+1)-2.0D 0*FA
      ELSE IF(KA.EQ.N) THEN
        FA=(3.0D 0-S*X(KA))*X(KA)+1.0D 0-X(KA-1)
        G(KA)=G(KA)+(3.0D 0-2.0D 0*S*X(KA))*FA
        G(KA-1)=G(KA-1)-FA
      ELSE
        FA=(3.0D 0-S*X(KA))*X(KA)+1.0D 0-X(KA-1)-2.0D 0*X(KA+1)
        G(KA)=G(KA)+(3.0D 0-2.0D 0*S*X(KA))*FA
        G(KA-1)=G(KA-1)-FA
        G(KA+1)=G(KA+1)-2.0D 0*FA
      ENDIF
      F=F+FA**2
  671 CONTINUE
      F=0.5D 0*F
      RETURN
  680 DO 683 KA=1,NA
      S1=1.0D 0
      S2=1.0D 0
      S3=1.0D 0
      J1=3
      J2=3
      IF(KA-J1.GT.1) THEN
        I1=KA-J1
      ELSE
        I1=1
      ENDIF
      IF(KA+J2.LT.N) THEN
        I2=KA+J2
      ELSE
        I2=N
      ENDIF
      S=0.0D 0
      DO 681 J=I1,I2
        IF(J.NE.KA) S=S+X(J)+X(J)**2
  681 CONTINUE
      FA=(S1+S2*X(KA)**2)*X(KA)+1.D 0-S3*S
      G(KA)=G(KA)+(S1+3.0D 0*S2*X(KA)**2)*FA
      DO 682 J=I1,I2
        G(J)=G(J)-S3*(1.0D 0+2.0D 0*X(J))*FA
  682 CONTINUE
      F=F+FA**2
  683 CONTINUE
      F=0.5D 0*F
      RETURN
  690 DO 691 KA=1,NA
      IF(KA.EQ.1) THEN
        FA=X(1)**2-1.0D 0
        G(1)=G(1)+2.0D 0*X(1)*FA
      ELSE
        FA=X(KA-1)**2+LOG(X(KA))-1.0D 0
        G(KA-1)=G(KA-1)+2.0D 0*X(KA-1)*FA
        G(KA)=G(KA)+1.0D 0/X(KA)*FA
      ENDIF
      F=F+FA**2
  691 CONTINUE
      F=0.5D 0*F
      RETURN
  340 DO 341 KA=1,NA
      IF(KA.EQ.1) THEN
        FA=X(1)
        G(1)=G(1)+FA
      ELSE
        FA=COS(X(KA-1))+X(KA)-1.0D 0
        G(KA)=G(KA)+FA
        G(KA-1)=G(KA-1)-SIN(X(KA-1))*FA
      ENDIF
      F=F+FA**2
  341 CONTINUE
      F=0.5D 0*F
      RETURN
  360 DO 361 KA=1,NA
      S=(1.0D 0/DBLE(N+1))**2
      IF(N.EQ.1) THEN
        FA=2.0D 0*X(KA)-1.0D 0+S*(X(KA)+SIN(X(KA)))
        G(KA)=G(KA)+(2.0D 0+S*(1.0D 0+COS(X(KA))))*FA
      ELSE IF(KA.EQ.1) THEN
        FA=2.0D 0*X(KA)-X(KA+1)+S*(X(KA)+SIN(X(KA)))
        G(KA)=G(KA)+(2.0D 0+S*(1.0D 0+COS(X(KA))))*FA
        G(KA+1)=G(KA+1)-FA
      ELSE IF(KA.EQ.N) THEN
        FA=-X(KA-1)+2.0D 0*X(KA)-1.0D 0+S*(X(KA)+SIN(X(KA)))
        G(KA)=G(KA)+(2.0D 0+S*(1.0D 0+COS(X(KA))))*FA
        G(KA-1)=G(KA-1)-FA
      ELSE
        FA=-X(KA-1)+2.0D 0*X(KA)-X(KA+1)+S*(X(KA)+SIN(X(KA)))
        G(KA)=G(KA)+(2.0D 0+S*(1.0D 0+COS(X(KA))))*FA
        G(KA-1)=G(KA-1)-FA
        G(KA+1)=G(KA+1)-FA
      ENDIF
      F=F+FA**2
  361 CONTINUE
      F=0.5D 0*F
      RETURN
  380 DO 383 KA=1,NA
      IF(KA-5.GT.1) THEN
        I1=KA-5
      ELSE
        I1=1
      ENDIF
      IF(KA+1.LT.N) THEN
        I2=KA+1
      ELSE
        I2=N
      ENDIF
      S=0.0D 0
      DO 381 J=I1,I2
        IF(J.NE.KA) S=S+X(J)*(1.0D 0+X(J))
  381 CONTINUE
      FA=X(KA)*(2.0D 0+5.0D 0*X(KA)**2)+1.0D 0-S
      F=F+FA**2
      G(KA)=G(KA)+(2.0D 0+15.0D 0*X(KA)**2)*FA
      DO 382 J=I1,I2
      IF(J.NE.KA) G(J)=G(J)-(1.0D 0+2.0D 0*X(J))*FA
  382 CONTINUE
  383 CONTINUE
      F=0.5D 0*F
      RETURN
  430 DO 433 KA=1,NA
      ALF=5
      BET=14
      GAM=3
      FA=DBLE(BET*N)*X(KA)+(DBLE(KA)-DBLE(N)/2.0D 0)**GAM
      DO 431 J=1,N
        IF(J.NE.KA) THEN
        T=SQRT(X(J)**2+DBLE(KA)/DBLE(J))
        S1=LOG(T)
        FA=FA+T*(SIN(S1)**ALF+COS(S1)**ALF)
      ENDIF
  431 CONTINUE
      F=F+FA**2
      DO 432 J=1,N
        IF(J.NE.KA) THEN
        T=SQRT(X(J)**2+DBLE(KA)/DBLE(J))
        S1=LOG(T)
        G(J)=G(J)+(X(J)*(SIN(S1)**ALF+COS(S1)**ALF+
     +     ALF*SIN(S1)**(ALF-1)*COS(S1)-
     +     ALF*SIN(S1)*COS(S1)**(ALF-1))/T)*FA
        ELSE
          G(J)=G(J)+DBLE(BET*N)*FA
        ENDIF
  432 CONTINUE
  433 CONTINUE
      F=0.5D 0*F
      RETURN
  440 DO 445 KA=1,NA
      C=0.5D 0
      H=1.0D 0/DBLE(N)
      FA=(1.0D 0-C*H/4.0D 0)
      DO 441 J=1,N
        S=C*H*DBLE(KA)/DBLE(2*(KA+J))
        IF(J.EQ.N) S=S/2.0D 0
        FA=FA-S*X(J)
  441 CONTINUE
      FA=-1.0D 0+X(KA)*FA
      F=F+FA**2
      DO 442 J=1,N
        SX(J)=C*H*DBLE(KA)/DBLE(2*(KA+J))
  442 CONTINUE
      SX(N)=0.5D 0*SX(N)
      DO 444 J=1,N
        IF(KA.NE.J) THEN
           G(J)=G(J)-SX(J)*X(KA)*FA
        ELSE
           T=1.0D 0-C*H/4.0D 0
           DO 443 L=1,N
             IF(L.EQ.KA) THEN
               T=T-2.0D 0*SX(KA)*X(KA)
             ELSE
               T=T-SX(L)*X(L)
             ENDIF
  443      CONTINUE
           G(J)=G(J)+T*FA
        ENDIF
  444 CONTINUE
  445 CONTINUE
      F=0.5D 0*F
      RETURN
  270 DO 271 KA=1,NA
      H=1.0D 0/DBLE(N+1)
      T=2.0D 0*H**2
      IF(KA.EQ.1) THEN
      FA=2.0D 0*X(KA)-X(KA+1)-T*X(KA)**2-H*X(KA+1)
      G(KA)=G(KA)+2.0D 0*(1.0D 0-T*X(KA))*FA
      G(KA+1)=G(KA+1)-(1.0D 0+H)*FA
      ELSE IF(1.LT.KA.AND.KA.LT.N) THEN
      FA=-X(KA-1)+2.0D 0*X(KA)-X(KA+1)-T*X(KA)**2-H*(X(KA+1)-X(KA-1))
      G(KA)=G(KA)+2.0D 0*(1.0D 0-T*X(KA))*FA
      G(KA-1)=G(KA-1)-(1.0D 0-H)*FA
      G(KA+1)=G(KA+1)-(1.0D 0+H)*FA
      ELSE IF(KA.EQ.N) THEN
      FA=-X(KA-1)+2.0D 0*X(KA)-0.5D 0-T*X(KA)**2-H*(0.5D 0-X(KA-1))
      G(KA)=G(KA)+2.0D 0*(1.0D 0-T*X(KA))*FA
      G(KA-1)=G(KA-1)-(1.0D 0-H)*FA
      ENDIF
      F=F+FA**2
  271 CONTINUE
      F=0.5D 0*F
      RETURN
  280 DO 288 KA=1,NA
      S=0.5D 0
      H=1.0D 0/DBLE(N+1)
      T=H**2/S
      T1=2.0D 0*H
      AL=0.0D 0
      BE=0.5D 0
      S1=0.0D 0
      DO 281 J=1,KA
        IF(J.EQ.1) THEN
           S1=S1+DBLE(J)*(X(J)**2+(X(J+1)-AL)/T1)
        ENDIF
        IF(1.LT.J.AND.J.LT.N) THEN
           S1=S1+DBLE(J)*(X(J)**2+(X(J+1)-X(J-1))/T1)
        ENDIF
        IF(J.EQ.N) THEN
           S1=S1+DBLE(J)*(X(J)**2+(BE-X(J-1))/T1)
        ENDIF
  281 CONTINUE
      S1=(1.0D 0-DBLE(KA)*H)*S1
      IF(KA.EQ.N) GO TO 283
      S2=0.0D 0
      DO 282 J=KA+1,N
        IF(J.LT.N) THEN
           S2=S2+(1.0D 0-DBLE(J)*H)*(X(J)**2+(X(J+1)-X(J-1))/T1)
        ELSE
           S2=S2+(1.0D 0-DBLE(J)*H)*(X(J)**2+(BE-X(J-1))/T1)
        ENDIF
  282 CONTINUE
      S1=S1+DBLE(KA)*S2
  283 FA=X(KA)-0.5D 0*DBLE(KA)*H-T*S1
      F=F+FA**2
      S1=H**2/S
      S2=1.0D 0-DBLE(KA)*H
      DO 284 J=1,KA
        SX(J)=DBLE(J)*S2
  284 CONTINUE
      IF(KA.EQ.N) GOTO 286
      DO 285 J=KA+1,N
        SX(J)=DBLE(KA)*(1.0D 0-DBLE(J)*H)
  285 CONTINUE
  286 G(1)=G(1)-S1*(SX(1)*2.0D 0*X(1)-SX(2)/T1)*FA
      G(N)=G(N)-S1*(SX(N-1)/T1+SX(N)*2.0D 0*X(N))*FA
      DO 287 J=2,N-1
        G(J)=G(J)-S1*((SX(J-1)-SX(J+1))/T1+SX(J)*2.0D 0*X(J))*FA
  287 CONTINUE
      G(KA)=G(KA)+FA
      RETURN
  288 CONTINUE
      F=0.5D 0*F
      RETURN
  290 DO 291 KA=1,NA
      A=-9.0D-3
      B=1.0D-3
      AL=0.0D 0
      BE=25.0D 0
      GA=20.0D 0
      CA=0.3D 0
      CB=0.3D 0
      H=(B-A)/DBLE(N+1)
      T=A+DBLE(KA)*H
      H=H**2
      S=DBLE(KA)/DBLE(N+1)
      U=AL*(1.0D 0-S)+BE*S+X(KA)
      FF=CB*EXP(GA*(U-BE))-CA*EXP(GA*(AL-U))
      FG=GA*(CB*EXP(GA*(U-BE))+CA*EXP(GA*(AL-U)))
      IF(T.LE.0) THEN
        FF=FF+CA
      ELSE
        FF=FF-CB
      ENDIF
      IF(N.EQ.1) THEN
        FA=-AL+2.0D 0*X(KA)-BE+H*FF
        G(KA)=G(KA)+(2.0D 0+H*FG)*FA
      ELSEIF(KA.EQ.1) THEN
        FA=-AL+2.0D 0*X(KA)-X(KA+1)+H*FF
        G(KA)=G(KA)+(2.0D 0+H*FG)*FA
        G(KA+1)=G(KA+1)-FA
      ELSEIF(KA.LT.N) THEN
        FA=-X(KA-1)+2.0D 0*X(KA)-X(KA+1)+H*FF
        G(KA)=G(KA)+(2.0D 0+H*FG)*FA
        G(KA-1)=G(KA-1)-FA
        G(KA+1)=G(KA+1)-FA
      ELSE
        FA=-X(KA-1)+2.0D 0*X(KA)-BE+H*FF
        G(KA)=G(KA)+(2.0D 0+H*FG)*FA
        G(KA-1)=G(KA-1)-FA
      ENDIF
      F=F+FA**2
  291 CONTINUE
      F=0.5D 0*F
      RETURN
  300 DO 301 KA=1,NA
      AL1=0.0D 0
      AL2=0.0D 0
      BE1=0.0D 0
      BE2=0.0D 0
      N1=N/2
      H=1.0D 0/DBLE(N1+1)
      T=DBLE(KA)*H
      IF(KA.EQ.1) THEN
        S1=2.0D 0*X(KA)-X(KA+1)
        B=AL1
      ELSE IF(KA.EQ.N1+1) THEN
        S1=2.0D 0*X(KA)-X(KA+1)
        B=AL2
      ELSE IF(KA.EQ.N1) THEN
        S1=-X(KA-1)+2.0D 0*X(KA)
        B=BE1
      ELSE IF(KA.EQ.N) THEN
        S1=-X(KA-1)+2.0D 0*X(KA)
        B=BE2
      ELSE
        S1=-X(KA-1)+2.0D 0*X(KA)-X(KA+1)
        B=0.0D 0
      ENDIF
      IF(KA.LE.N1) THEN
        S2=X(KA)**2+X(KA)+0.1D 0*X(N1+KA)**2-1.2D 0
      ELSE
        S2=0.2D 0*X(KA-N1)**2+X(KA)**2+2.0D 0*X(KA)-0.6D 0
      ENDIF
      FA=S1+H**2*S2-B
      F=F+FA**2
      H=1.0D 0/DBLE(N1+1)**2
      IF(KA.EQ.1) THEN
        G(KA)=G(KA)+(2.0D 0+H*(2.0D 0*X(KA)+1.0D 0))*FA
        G(KA+1)=G(KA+1)-FA
        G(N1+KA)=G(N1+KA)+H*0.2D 0*X(N1+KA)*FA
      ELSE IF(KA.EQ.N1+1) THEN
        G(1)=G(1)+H*0.4D 0*X(1)*FA
        G(KA)=G(KA)+(2.0D 0+H*(2.0D 0*X(KA)+2.0D 0))*FA
        G(KA+1)=G(KA+1)-FA
      ELSE IF(KA.EQ.N1) THEN
        G(KA-1)=G(KA-1)-FA
        G(KA)=G(KA)+(2.0D 0+H*(2.0D 0*X(KA)+1.0D 0))*FA
        G(N1+KA)=G(N1+KA)+H*0.2D 0*X(N1+KA)*FA
      ELSE IF(KA.EQ.N) THEN
        G(N1)=G(N1)+H*0.4D 0*X(N1)*FA
        G(KA-1)=G(KA-1)-FA
        G(KA)=G(KA)+(2.0D 0+H*(2.0D 0*X(KA)+2.0D 0))*FA
      ELSE IF(KA.LT.N1) THEN
        G(KA-1)=G(KA-1)-FA
        G(KA)=G(KA)+(2.0D 0+H*(2.0D 0*X(KA)+1.0D 0))*FA
        G(KA+1)=G(KA+1)-FA
        G(N1+KA)=G(N1+KA)+H*0.2D 0*X(N1+KA)*FA
      ELSE
         G(KA-N1)=G(KA-N1)+H*0.4D 0*X(KA-N1)*FA
         G(KA-1)=G(KA-1)-FA
         G(KA)=G(KA)+(2.0D 0+H*(2.0D 0*X(KA)+2.0D 0))*FA
         G(KA+1)=G(KA+1)-FA
      ENDIF
  301 CONTINUE
      F=0.5D 0*F
      RETURN
  710 DO 711 KA=1,NA
      ND=INT(SQRT(DBLE(N)))
      L=MOD(KA,ND)
      IF(L.EQ.0) THEN
         K=KA/ND
         L=ND
      ELSE
         K=INT(KA/ND)+1
      ENDIF
      LA=1.0D 0
      H=1.0D 0/DBLE(ND+1)
      H2=LA*H*H
      IF(L.EQ.1.AND.K.EQ.1) THEN
         FA=4.0D 0*X(1)-X(2)-X(ND+1)+H2*EXP(X(1))
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.K.EQ.1) THEN
         FA=4.0D 0*X(L)-X(L-1)-X(L+1)-X(L+ND)+H2*EXP(X(L))
      ENDIF
      IF(L.EQ.ND.AND.K.EQ.1) THEN
         FA=4.0D 0*X(ND)-X(ND-1)-X(ND+ND)+H2*EXP(X(ND))
      ENDIF
      IF(L.EQ.1.AND.1.LT.K.AND.K.LT.ND) THEN
         FA=4.0D 0*X(KA)-X(KA+1)-X(KA-ND)-X(KA+ND)+H2*EXP(X(KA))
      ENDIF
      IF(L.EQ.ND.AND.1.LT.K.AND.K.LT.ND) THEN
         FA=4.0D 0*X(KA)-X(KA-ND)-X(KA-1)-X(KA+ND)+H2*EXP(X(KA))
      ENDIF
      IF(L.EQ.1.AND.K.EQ.ND) THEN
         FA=4.0D 0*X(KA)-X(KA+1)-X(KA-ND)+H2*EXP(X(KA))
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.K.EQ.ND) THEN
         FA=4.0D 0*X(KA)-X(KA-1)-X(KA+1)-X(KA-ND)+H2*EXP(X(KA))
      ENDIF
      IF(L.EQ.ND.AND.K.EQ.ND) THEN
        FA=4.0D 0*X(KA)-X(KA-1)-X(KA-ND)+H2*EXP(X(KA))
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.1.LT.K.AND.K.LT.ND) THEN
      FA=4.0D 0*X(KA)-X(KA-1)-X(KA+1)-X(KA-ND)-X(KA+ND)+H2*EXP(X(KA))
      ENDIF
      F=F+FA**2
      IF(L.EQ.1.AND.K.EQ.1) THEN
         G(1)=G(1)+(4.0D 0+H2*EXP(X(1)))*FA
         G(2)=G(2)-FA
         G(ND+1)=G(ND+1)-FA
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.K.EQ.1) THEN
         G(L)=G(L)+(4.0D 0+H2*EXP(X(L)))*FA
         G(L-1)=G(L-1)-FA
         G(L+1)=G(L+1)-FA
         G(L+ND)=G(L+ND)-FA
      ENDIF
      IF(L.EQ.ND.AND.K.EQ.1) THEN
         G(ND)=G(ND)+(4.0D 0+H2*EXP(X(ND)))*FA
         G(ND-1)=G(ND-1)-FA
         G(ND+ND)=G(ND+ND)-FA
      ENDIF
      IF(L.EQ.1.AND.1.LT.K.AND.K.LT.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*EXP(X(KA)))*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA+1)=G(KA+1)-FA
         G(KA+ND)=G(KA+ND)-FA
      ENDIF
      IF(L.EQ.ND.AND.1.LT.K.AND.K.LT.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*EXP(X(KA)))*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA-1)=G(KA-1)-FA
         G(KA+ND)=G(KA+ND)-FA
      ENDIF
      IF(L.EQ.1.AND.K.EQ.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*EXP(X(KA)))*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA+1)=G(KA+1)-FA
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.K.EQ.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*EXP(X(KA)))*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA-1)=G(KA-1)-FA
         G(KA+1)=G(KA+1)-FA
      ENDIF
      IF(L.EQ.ND.AND.K.EQ.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*EXP(X(KA)))*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA-1)=G(KA-1)-FA
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.1.LT.K.AND.K.LT.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*EXP(X(KA)))*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA-1)=G(KA-1)-FA
         G(KA+1)=G(KA+1)-FA
         G(KA+ND)=G(KA+ND)-FA
      ENDIF
  711 CONTINUE
      F=0.5D 0*F
      RETURN
  820 DO 821 KA=1,NA
      ND=INT(SQRT(DBLE(N)))
      L=MOD(KA,ND)
      IF(L.EQ.0) THEN
         K=KA/ND
         L=ND
      ELSE
         K=INT(KA/ND)+1
      ENDIF
      H=1.0D 0/DBLE(ND+1)
      H2=H*H
      IF(L.EQ.1.AND.K.EQ.1) THEN
         FA=4.0D 0*X(1)-X(2)-X(ND+1)+H2*X(1)**2-24.0D 0/(H+1.0D 0)**2
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.K.EQ.1) THEN
         FA=4.0D 0*X(L)-X(L-1)-X(L+1)-X(L+ND)+H2*X(L)**2
     *-12.0D 0/(DBLE(L)*H+1.0D 0)**2
      ENDIF
      IF(L.EQ.ND.AND.K.EQ.1) THEN
         FA=4.0D 0*X(ND)-X(ND-1)-X(ND+ND)+H2*X(ND)**2
     *-12.0D 0/(DBLE(ND)*H+1.0D 0)**2-12.0D 0/(H+2.0D 0)**2
      ENDIF
      IF(L.EQ.1.AND.1.LT.K.AND.K.LT.ND) THEN
         FA=4.0D 0*X(KA)-X(KA+1)-X(KA-ND)-X(KA+ND)+H2*X(KA)**2
     *-12.0D 0/(DBLE(K)*H+1.0D 0)**2
      ENDIF
      IF(L.EQ.ND.AND.1.LT.K.AND.K.LT.ND) THEN
         FA=4.0D 0*X(KA)-X(KA-ND)-X(KA-1)-X(KA+ND)+H2*X(KA)**2
     *-12.0D 0/(DBLE(K)*H+2.0D 0)**2
      ENDIF
      IF(L.EQ.1.AND.K.EQ.ND) THEN
         FA=4.0D 0*X(KA)-X(KA+1)-X(KA-ND)+H2*X(KA)**2
     *-12.0D 0/(DBLE(ND)*H+1.0D 0)**2-12.0D 0/(H+2.0D 0)**2
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.K.EQ.ND) THEN
         FA=4.0D 0*X(KA)-X(KA-1)-X(KA+1)-X(KA-ND)+H2*X(KA)**2
     *-12.0D 0/(DBLE(L)*H+2.0D 0)**2
      ENDIF
      IF(L.EQ.ND.AND.K.EQ.ND) THEN
        FA=4.0D 0*X(KA)-X(KA-1)-X(KA-ND)+H2*X(KA)**2
     *-24.0D 0/(DBLE(ND)*H+2.0D 0)**2
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.1.LT.K.AND.K.LT.ND) THEN
         FA=4.0D 0*X(KA)-X(KA-1)-X(KA+1)-X(KA-ND)-X(KA+ND)+H2*X(KA)**2
      ENDIF
      F=F+FA**2
      IF(L.EQ.1.AND.K.EQ.1) THEN
         G(1)=G(1)+(4.0D 0+H2*X(1)*2.0D 0)*FA
         G(2)=G(2)-FA
         G(ND+1)=G(ND+1)-FA
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.K.EQ.1) THEN
         G(L)=G(L)+(4.0D 0+H2*X(L)*2.0D 0)*FA
         G(L-1)=G(L-1)-FA
         G(L+1)=G(L+1)-FA
         G(L+ND)=G(L+ND)-FA
      ENDIF
      IF(L.EQ.ND.AND.K.EQ.1) THEN
         G(ND)=G(ND)+(4.0D 0+H2*X(ND)*2.0D 0)*FA
         G(ND-1)=G(ND-1)-FA
         G(ND+ND)=G(ND+ND)-FA
      ENDIF
      IF(L.EQ.1.AND.1.LT.K.AND.K.LT.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*X(KA)*2.0D 0)*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA+1)=G(KA+1)-FA
         G(KA+ND)=G(KA+ND)-FA
      ENDIF
      IF(L.EQ.ND.AND.1.LT.K.AND.K.LT.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*X(KA)*2.0D 0)*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA-1)=G(KA-1)-FA
         G(KA+ND)=G(KA+ND)-FA
      ENDIF
      IF(L.EQ.1.AND.K.EQ.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*X(KA)*2.0D 0)*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA+1)=G(KA+1)-FA
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.K.EQ.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*X(KA)*2.0D 0)*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA-1)=G(KA-1)-FA
         G(KA+1)=G(KA+1)-FA
      ENDIF
      IF(L.EQ.ND.AND.K.EQ.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*X(KA)*2.0D 0)*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA-1)=G(KA-1)-FA
      ENDIF
      IF(1.LT.L.AND.L.LT.ND.AND.1.LT.K.AND.K.LT.ND) THEN
         G(KA)=G(KA)+(4.0D 0+H2*X(KA)*2.0D 0)*FA
         G(KA-ND)=G(KA-ND)-FA
         G(KA-1)=G(KA-1)-FA
         G(KA+1)=G(KA+1)-FA
         G(KA+ND)=G(KA+ND)-FA
      ENDIF
  821 CONTINUE
      F=0.5D 0*F
      RETURN
      END

