/*------------------------------------------------------*/
/*   fichier               : bb.cpp                     */
/*   auteur                : Sebastien Le Digabel       */
/*   date                  : 22 aout 2006               */
/*   description           : Trefethen's problem 4      */
/*------------------------------------------------------*/
#include <iostream>
#include <cmath>
#include <fstream>
#include <iomanip>
using namespace std;

/*---------------------------------------------*/
/*              fonction principale            */
/*---------------------------------------------*/
int main ( int argc , char ** argv ) {

  // verification du nombre d'arguments :
  if (argc != 2) {
    cerr << "usage : bb.exe input_file\n";
    exit(0);
  }

  // les valeurs en input (fichier binaire) :
  ifstream in (argv[1]);
  if (in.fail()) {
    cerr << "could not open " << argv[1] << endl;
    return 1;
  }
  long double x , y;
  in >> x >> y;
  in.close();


  long double f = (x*x+y*y)/4 + exp(sin(50*x)) - sin(10*(x+y)) + sin(60*exp(y))
    + sin(70*sin(x)) + sin(sin(80*y));

  cout.setf(ios::fixed);
  cout << setprecision(20) << f;

  // sauvegarde de la meilleure solution realisable :
  // ------------------------------------------------
//   double best_z       = 1e+20;
//   char   file_name [] = "/home/sebld/DOCTORAT/GPS/NOMADr/problems/Trefethen4/black_box/best_x.txt";
//   in.open (file_name);
//   if (!in.fail()) {
//     in >> best_z;
//     in.close();
//   }

//   if ( f < best_z ) {

//     ofstream out (file_name);

//     if (!out.fail()) {

//       out << setiosflags(ios::fixed)
// 	  << setprecision(20)
// 	  << f << "\n\n"
// 	  << x << endl << y << endl;

//       out.close();
//     }
//   }
 

  return 0;
}
