#include <iostream>
#include <fstream>
#include <cmath>
#include <cstdlib>
using namespace std;
// Cst.
//norme :
const double ro = 1.0;
// Revenu 
//const double R[5] = {0.0212, 0.0142, 0.0232, 0.0182, 0.0112};
const double freer = 0.0058;
const double R[5] = {0.027, 0.020, 0.029, 0.024, 0.017};
const int dimension = 5;
const double evaluate1(const double coord[]);
const double evaluate2(const double coord[]);
double * poltocar(const double tab[]);
double max(double nombre1, double nombre2);
const double z( const double f1, const double f2, const double nadir[]);

int main ( int argc , char ** argv )
{


  if ( argc != 2 ) {
    cout << 1e20 << " " << 1e20 << endl;
    return 1;
  }
    

  double polar[dimension-1];
  ifstream input(argv[1]);

  for (unsigned int i = 0; i < dimension-1; i++)
    input >> polar[i];
  input.close();

  if ( input.fail() )  {
    cout << 1e20 << " " << 1e20 << endl;
    return 1;
  }
   
  double * y = poltocar(polar);

  double coord[dimension];




  double invp[dimension][dimension];

  //saisie  invp
  ifstream inv("PTinv.txt"); 
  for (unsigned int i = 0; i < dimension; i++)
    for (unsigned int j = 0; j < dimension; j++)
      inv >> invp[i][j];
  //for (unsigned int i = 0; i < dimension; i++)
  //	{
  //	for (unsigned int j = 0; j < dimension; j++)
  //		cout << " inv[" << i << "," << j << "]=" << invp[i][j] << "     ";
  //	cout << "\n";
  //	}
  
  inv.close();

  if ( inv.fail() )  {
    cout << 1e20 << " " << 1e20 << endl;
    delete [] y;
    return 1;
  }

  // Calcul x 

  for (unsigned int i = 0; i < dimension; i++)
    {
      coord[i] = 0;
      for (unsigned int j = 0; j < dimension; j++)
	coord[i] = coord[i] + invp[i][j]*y[j];
    }

  delete [] y;


  //  for (unsigned int i = 0; i < dimension; i++)
  //    cout << " x" << i+1 << "=" << coord[i] << "\n";


  // evaluer les fonctions objectifs
  double f1 = evaluate1(coord);
  double f2 = evaluate2(coord);

  cout << f1 << " " << f2 << endl;
 

//   double coord2[dimension];
//   double somme = 0;
//   for (unsigned int j = 0; j < dimension; j++)
//     somme = somme + coord[j];
//   for (unsigned int i = 0; i < dimension; i++)
//     coord2[i] = coord[i]/somme;

//   double obj1= evaluate1(coord2);
//   double obj2= 1/pow(somme,2);
 
//   cout << coord2[0] << "\t" << coord2[1] << "\t"
//        << coord2[2] << "\t" << coord2[3] << "\t"
//        << coord2[4] << "\t" << obj1 << "\t"<< obj2 << "\n";
  



  return 0;
}

// Polar to cartesian coordinates:
double * poltocar(const double tab[dimension-1])
{
double *res=new double[dimension];
res[0] = ro*sin(tab[0]) * sin(tab[1]) * sin(tab[2]) * sin(tab[3]);
res[1] = ro*sin(tab[0]) * sin(tab[1]) * sin(tab[2]) * cos(tab[3]);

res[2] = ro*sin(tab[0]) * sin(tab[1]) * cos(tab[2]);
res[3] = ro*sin(tab[0]) * cos(tab[1]);
res[4] = ro*cos(tab[0]);
return res;
}

// evaluate the first objectif function
const double evaluate1(const double coord[])
{
  double f=0;
  for(unsigned i=0; i < 5; i++)
	f = f + coord[i]*(R[i]-freer);
//cout << "f1 = " << f << "\n";
 f = - f - freer;
  return (f);
}
//evaluate the second objectif function
const double evaluate2(const double coord[])
{
  double f = 0;
  ifstream skew("skewness.prn");
  double s[5][5][6];
  for (unsigned i = 0; i<5; i++)
    for (unsigned j = 0; j<5; j++)
      for (unsigned k = 0; k<6; k++)
	{
	  skew >> s[i][j][k];
	  //	cout << "s["<<i<< "]" << j << "[" << k << "]=" << s[i][j][k] << "\n";
	}
  skew.close();
//for (unsigned i = 0; i<5; i++)
//	f = f + (s[i][i][i]*pow(coord[i],3));
//for (unsigned i = 0; i<5; i++)
//	for (unsigned j = 0; j<5; j++)
//		if (i!=j) f = f + (3*s[i][i][j]*pow(coord[i],2)*coord[j]);
//for (unsigned i = 0; i<5; i++)
//	for (unsigned j = 0; j<5; j++)
//		for (unsigned k = 0; k<5; k++)
//			if ((i!=j)&&(i!=k)&&(j!=k))f = f + 6*(s[i][j][k]*coord[i]*coord[j]*coord[k]);		
		
		
  if ( skew.fail() ) {
    exit(1);
  }
  
  for (unsigned i = 0; i<5; i++)
    for (unsigned j = 0; j<5; j++)
      for (unsigned k = 0; k<5; k++)
	f = f + (s[i][j][k]*coord[i]*coord[j]*coord[k]);
  //cout << "f2 = " << f << "\n";
  f = -f;
  return (f);
}

// compute the max of two numbers
double max(double nombre1, double nombre2)
{
if (nombre1 > nombre2) return nombre1;
else return nombre2;
}
// evaluate z 
const double z( const double f1, const double f2, const double nadir[])
{
//return(max((f1-nadir[0])/nadir[0],(f2-nadir[1])/nadir[1]));
//return(-(f1-nadir[0])*(f2-nadir[1]));
return(-pow(max((nadir[0]-f1),0),2)*pow(max((nadir[1]-f2),0),2));
}
